/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.product.service.desktop.DesktopServiceImplementor;
import com.installshield.product.service.desktop.PureJavaDesktopServiceImpl;
import com.installshield.util.FileAttributes;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.service.ServiceException;

public class Win32DesktopServiceImpl
extends PureJavaDesktopServiceImpl
implements DesktopServiceImplementor {
    public static final String ALL_USERS_START_MENU = "$AllUsersStartMenu$";
    public static final String ALL_USERS_PROGRAMS = "$AllUsersPrograms$";
    public static final String ALL_USERS_DESKTOP = "$AllUsersDesktop$";
    public static final String CURRENT_USER_START_MENU = "$UserStartMenu$";
    public static final String CURRENT_USER_PROGRAMS = "$UserPrograms$";
    public static final String CURRENT_USER_DESKTOP = "$UserDesktop$";

    public native void createDesktopFolder(String var1) throws ServiceException;

    public native void createDesktopItem(String var1, String var2, String var3, String var4, String var5, String var6) throws ServiceException;

    public native FileAttributes getDesktopFolderAttributes(String var1) throws ServiceException;

    public native String getDesktopFolderOwner(String var1) throws ServiceException;

    public native String getDesktopFolderOwnerGroup(String var1) throws ServiceException;

    public native FileAttributes getDesktopItemAttributes(String var1, String var2) throws ServiceException;

    public native String getDesktopItemOwner(String var1, String var2) throws ServiceException;

    public native String getDesktopItemOwnerGroup(String var1, String var2) throws ServiceException;

    public String getPlatformId() {
        return "win32ppk";
    }

    public int getSystemCompatibility() {
        int n = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                n = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    protected void initialized() {
        super.initialized();
        try {
            Win32Utils.loadDLL(this.getResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{"desktopService", Win32Utils.getJNIDLLName()}));
            exception.printStackTrace();
        }
    }

    public native void removeDesktopFolder(String var1) throws ServiceException;

    public native void removeDesktopItem(String var1, String var2) throws ServiceException;

    public native void setDesktopFolderAttributes(String var1, FileAttributes var2) throws ServiceException;

    public native void setDesktopFolderOwner(String var1, String var2) throws ServiceException;

    public native void setDesktopFolderOwnerGroup(String var1, String var2) throws ServiceException;

    public native void setDesktopItemAttributes(String var1, String var2, FileAttributes var3) throws ServiceException;

    public native void setDesktopItemOwner(String var1, String var2, String var3) throws ServiceException;

    public native void setDesktopItemOwnerGroup(String var1, String var2, String var3) throws ServiceException;
}

