/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.archive.ArchiveURLStreamHandler;
import com.installshield.util.CommandLineTokenizer;
import com.installshield.util.FileUtils;
import com.installshield.util.LogListener;
import com.installshield.util.StringResolver;
import com.installshield.util.StringResolverMethod;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.ServicesDependentStringResolverMethod;
import com.installshield.wizard.service.StringResolverMethodDef;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.WizardServicesImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractWizardServices
implements WizardServicesImpl {
    private String id;
    private String home;
    private ServicesDefinition servicesDef;
    private Hashtable values = new Hashtable();
    private StringResolver stringResolver = new StringResolver();
    private boolean initializedLog = false;
    private boolean errorsLogged = false;
    private boolean warningsLogged = false;
    private Vector logListeners = new Vector();
    private WizardLog log = new WizardLog();

    protected AbstractWizardServices(String string, String string2, ServicesDefinition servicesDefinition) {
        this.id = string;
        this.home = string2;
        this.servicesDef = servicesDefinition;
        this.createStringResolverMethods(servicesDefinition);
    }

    public void addLogListener(LogListener logListener) {
        this.logListeners.addElement(logListener);
    }

    public void addStringResolverMethod(StringResolverMethod stringResolverMethod) {
        if (stringResolverMethod instanceof ServicesDependentStringResolverMethod) {
            ((ServicesDependentStringResolverMethod)stringResolverMethod).initialize(this);
        }
        this.stringResolver.addMethod(stringResolverMethod);
    }

    protected abstract void addStringResolverMethod(StringResolverMethod var1, int var2);

    public void closeResourceArchive(String string) throws IOException {
        ArchiveURLStreamHandler.closeArchive(string);
    }

    protected void createStringResolverMethods(ServicesDefinition servicesDefinition) {
        int n = 0;
        while (n < servicesDefinition.getStringResolverMethodCount()) {
            StringResolverMethodDef stringResolverMethodDef = servicesDefinition.getStringResolverMethod(n);
            try {
                Class<?> clazz = Class.forName(stringResolverMethodDef.getClassName());
                StringResolverMethod stringResolverMethod = (StringResolverMethod)clazz.newInstance();
                this.addStringResolverMethod(stringResolverMethod, stringResolverMethodDef.getContext());
            }
            catch (Throwable throwable) {
                System.err.println("WARNING: cannot instantiate string resolver method " + stringResolverMethodDef.getClassName() + ": " + throwable);
            }
            ++n;
        }
    }

    public abstract void displayUserMessage(String var1, String var2, int var3) throws ServiceException;

    public void ensureResources(String string, String string2) throws ServiceException {
    }

    public String getHome() {
        return this.home;
    }

    public String getId() {
        return this.id;
    }

    public URL getResource(String string) throws IOException {
        return this.getResource(this.getId(), string);
    }

    public URL getResource(String string, String string2) throws IOException {
        Object object;
        URL uRL = null;
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        CommandLineTokenizer commandLineTokenizer = new CommandLineTokenizer(this.servicesDef.getResourcePath());
        while (uRL == null && commandLineTokenizer.hasMoreElements()) {
            try {
                object = FileUtils.createFileName(FileUtils.getParent(this.getHome()), (String)commandLineTokenizer.nextElement());
                uRL = new URL("archive", "", -1, String.valueOf(object) + "+/" + string + string2);
                InputStream inputStream = uRL.openStream();
                inputStream.close();
            }
            catch (IOException iOException) {
                uRL = null;
            }
        }
        if (uRL == null) {
            uRL = new URL("archive", "", -1, String.valueOf(this.getHome()) + "+/" + string + string2);
            object = uRL.openStream();
            ((InputStream)object).close();
        }
        return uRL;
    }

    public abstract Service getService(String var1) throws ServiceException;

    public ServicesDefinition getServicesDefinition() {
        return this.servicesDef;
    }

    public Object getUserInput(String string, String string2, Object[] objectArray, Object object) throws ServiceException {
        return null;
    }

    public Object getValue(String string) {
        return this.values.get(string);
    }

    public WizardLog getWizardLog() {
        return this.log;
    }

    public abstract WizardServices getWizardServices(String var1) throws ServiceException;

    private void initializeLog(WizardLog wizardLog) {
        try {
            if (this.isServiceAvailable("logService")) {
                wizardLog.setLogService(this.getService("logService"));
            }
        }
        catch (ServiceException serviceException) {
            System.err.println("WARNING: could not obtain log service -- defaulting to standard wizard logging");
        }
        this.initializedLog = true;
    }

    public abstract boolean isServiceAvailable(String var1) throws ServiceException;

    public void logEvent(Object object, String string, Object object2) {
        this.errorsLogged |= string.startsWith("err");
        this.warningsLogged |= string.startsWith("wrn");
        if (this.log != null) {
            if (!this.initializedLog) {
                this.initializeLog(this.log);
            }
            this.log.logEvent(object, string, object2);
        }
        int n = 0;
        while (n < this.logListeners.size()) {
            ((LogListener)this.logListeners.elementAt(n)).eventLogged(object, string, object2);
            ++n;
        }
    }

    public void putResourceLocation(String string) {
        this.servicesDef.putResourceLocation(string);
    }

    public void removeLogListener(LogListener logListener) {
        this.logListeners.removeElement(logListener);
    }

    public void removeResourceLocation(String string) {
        this.servicesDef.removeResourceLocation(string);
    }

    public void removeStringResolverMethod(StringResolverMethod stringResolverMethod) {
        this.stringResolver.removeMethod(stringResolverMethod);
    }

    public String resolveString(String string) {
        return this.stringResolver.resolve(string);
    }

    public abstract Enumeration services();

    public void setValue(String string, Object object) {
        if (string != null) {
            this.values.put(string, object);
        } else {
            this.values.remove(string);
        }
    }

    public void setValue(String string, Object object, boolean bl) throws ServiceException {
        this.setValue(string, object);
    }

    public void setWizardLog(WizardLog wizardLog) {
        this.log = wizardLog;
    }

    public abstract void setWizardServices(String var1, WizardServices var2) throws ServiceException;

    public void shutdown() {
        ArchiveURLStreamHandler.closeAllArchives();
    }
}

