/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.wizard.service.ImplementorProxy;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceImplementor;
import com.installshield.wizard.service.ServiceUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class LocalImplementorProxy
implements ImplementorProxy {
    private Class implementorType;
    private ServiceImplementor impl;

    LocalImplementorProxy(Class clazz, ServiceImplementor serviceImplementor) {
        this.implementorType = clazz;
        this.impl = serviceImplementor;
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("implementorType " + clazz + " is not an interface");
        }
        if (!clazz.isInstance(serviceImplementor)) {
            throw new IllegalArgumentException("impl " + serviceImplementor.getClass() + " does not implement " + clazz);
        }
    }

    public void close() throws ServiceException {
        if (this.impl != null) {
            this.impl.cleanup();
            this.impl = null;
        }
    }

    public String getImplementorType() {
        if (this.impl == null) {
            throw new IllegalStateException("proxy has been closed");
        }
        return this.impl.getClass().getName();
    }

    public Object invoke(String string, Class[] classArray, Object[] objectArray) throws ServiceException {
        Method method;
        if (this.impl == null) {
            throw new IllegalStateException("proxy has been closed");
        }
        try {
            method = this.implementorType.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ServiceException(311, String.valueOf(this.getImplementorType()) + "." + ServiceUtils.methodSignature(string, classArray));
        }
        try {
            return method.invoke((Object)this.impl, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error();
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof ServiceException) {
                throw (ServiceException)invocationTargetException.getTargetException();
            }
            throw new ServiceException(invocationTargetException.getTargetException());
        }
    }
}

