/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.util.CommandLineTokenizer;
import com.installshield.wizard.service.ServiceDef;
import com.installshield.wizard.service.ServiceImplementorDef;
import com.installshield.wizard.service.StringResolverMethodDef;
import java.util.Enumeration;
import java.util.Vector;

public class ServicesDefinition {
    private Vector services = new Vector();
    private Vector implementors = new Vector();
    private Vector stringResolverMethods = new Vector();
    private Vector resourceLocations = new Vector();

    public ServicesDefinition() {
    }

    public ServicesDefinition(ServicesDefinition servicesDefinition) {
        Enumeration enumeration = servicesDefinition.services.elements();
        while (enumeration.hasMoreElements()) {
            this.services.addElement(enumeration.nextElement());
        }
        Enumeration enumeration2 = servicesDefinition.implementors.elements();
        while (enumeration2.hasMoreElements()) {
            this.implementors.addElement(enumeration2.nextElement());
        }
        Enumeration enumeration3 = servicesDefinition.stringResolverMethods.elements();
        while (enumeration3.hasMoreElements()) {
            this.stringResolverMethods.addElement(enumeration3.nextElement());
        }
        Enumeration enumeration4 = servicesDefinition.resourceLocations.elements();
        while (enumeration4.hasMoreElements()) {
            this.resourceLocations.addElement(enumeration4.nextElement());
        }
    }

    public void addImplementor(ServiceImplementorDef serviceImplementorDef) {
        this.implementors.addElement(serviceImplementorDef);
    }

    public void addService(ServiceDef serviceDef) {
        this.services.addElement(serviceDef);
    }

    public void addStringResolverMethod(StringResolverMethodDef stringResolverMethodDef) {
        this.stringResolverMethods.addElement(stringResolverMethodDef);
    }

    public ServiceImplementorDef getImplementor(int n) {
        return (ServiceImplementorDef)this.implementors.elementAt(n);
    }

    public int getImplementorCount() {
        return this.implementors.size();
    }

    public String getResourcePath() {
        String[] stringArray = new String[this.resourceLocations.size()];
        int n = 0;
        while (n < this.resourceLocations.size()) {
            stringArray[n] = (String)this.resourceLocations.elementAt(n);
            ++n;
        }
        return CommandLineTokenizer.createSpaceDelimitedString(stringArray);
    }

    public ServiceDef getService(int n) {
        return (ServiceDef)this.services.elementAt(n);
    }

    public int getServiceCount() {
        return this.services.size();
    }

    public StringResolverMethodDef getStringResolverMethod(int n) {
        return (StringResolverMethodDef)this.stringResolverMethods.elementAt(n);
    }

    public int getStringResolverMethodCount() {
        return this.stringResolverMethods.size();
    }

    public Enumeration implementors() {
        return this.implementors.elements();
    }

    public void putResourceLocation(String string) {
        if (!this.resourceLocations.contains(string)) {
            this.resourceLocations.addElement(string);
        }
    }

    public void removeAllImplementors() {
        this.implementors.removeAllElements();
    }

    public void removeAllServices() {
        this.services.removeAllElements();
    }

    public void removeAllStringResolverMethods() {
        this.stringResolverMethods.removeAllElements();
    }

    public void removeImplementor(ServiceImplementorDef serviceImplementorDef) {
        this.implementors.removeElement(serviceImplementorDef);
    }

    public void removeResourceLocation(String string) {
        this.resourceLocations.removeElement(string);
    }

    public void removeService(ServiceDef serviceDef) {
        this.services.removeElement(serviceDef);
    }

    public void removeStringResolverMethod(StringResolverMethodDef stringResolverMethodDef) {
        this.stringResolverMethods.removeElement(stringResolverMethodDef);
    }

    public Enumeration services() {
        return this.services.elements();
    }

    public void setResourcePath(String string) {
        CommandLineTokenizer commandLineTokenizer = new CommandLineTokenizer(string);
        while (commandLineTokenizer.hasMoreElements()) {
            this.putResourceLocation((String)commandLineTokenizer.nextElement());
        }
    }

    public Enumeration stringResolverMethods() {
        return this.stringResolverMethods.elements();
    }
}

