/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.sea.wizardbean;

import com.installshield.product.service.desktop.DesktopService;
import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;

public class RemoveDesktopItems
extends WizardAction {
    private String deskItem = "";
    private String menuItem = "";

    public void build(WizardBuilderSupport support) {
        support.putRequiredService("desktopService");
    }

    public void execute(WizardBeanEvent event) {
        DesktopService ds = null;
        try {
            ds = (DesktopService)this.getService("desktopService");
        }
        catch (ServiceException se) {
            System.out.println(se.toString());
        }
        this.removeItemFromDesktop(ds, this.deskItem);
        this.removeItemFromStartMenu(ds, this.menuItem);
    }

    public String getDesktopIcon() {
        return this.deskItem;
    }

    public String getStartMenuIcon() {
        return this.menuItem;
    }

    private void removeItemFromDesktop(DesktopService theDs, String theDeskItem) {
        block2: {
            if (this.deskItem.equals("") || theDs == null) break block2;
            theDeskItem = this.resolveString(theDeskItem);
            theDeskItem = theDeskItem.replace('\\', '/');
            try {
                theDs.removeDesktopItem("$AllUsersDesktop$", theDeskItem);
            }
            catch (ServiceException se) {
                System.out.println(se.toString());
            }
        }
    }

    private void removeItemFromStartMenu(DesktopService theDs, String theMenuItem) {
        block4: {
            if (theMenuItem.equals("") || theDs == null) break block4;
            theMenuItem = this.resolveString(theMenuItem);
            theMenuItem = theMenuItem.replace('\\', '/');
            try {
                theDs.removeDesktopItem("$AllUsersPrograms$", theMenuItem);
            }
            catch (ServiceException se) {
                System.out.println(se.toString());
            }
            try {
                theDs.removeDesktopFolder("$AllUsersPrograms$/" + theMenuItem);
            }
            catch (ServiceException se) {
                System.out.println(se.toString());
            }
        }
    }

    public void setDesktopIcon(String theIcon) {
        this.deskItem = theIcon;
    }

    public void setStartMenuIcon(String theIcon) {
        this.menuItem = theIcon;
    }
}

