/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ResourceWriter;
import com.installshield.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public class FileResourceWriter
implements ResourceWriter {
    private String fileName;

    public FileResourceWriter(String string) {
        this.fileName = FileUtils.normalizeFileName(string);
    }

    public void close(OutputStream outputStream) throws IOException {
        outputStream.close();
    }

    public Date getDate() {
        File file = new File(this.fileName);
        if (file.isFile()) {
            return new Date(file.lastModified());
        }
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getId() {
        return this.fileName;
    }

    public OutputStream open() throws IOException {
        File file;
        File file2 = new File(this.fileName);
        if (this.fileName.endsWith(File.separator)) {
            file2.mkdirs();
            return new ByteArrayOutputStream();
        }
        String string = file2.getParent();
        if (string != null && !(file = new File(string)).isDirectory() && !file.mkdirs()) {
            throw new IOException("could not create directory " + file);
        }
        return new FileOutputStream(file2);
    }

    public String toString() {
        return "FileResourceWriter for " + this.fileName;
    }
}

