/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.product.BaseProductTreeIterator;
import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductTree;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.StandardProductTreeIterator;
import com.installshield.product.iterators.ActiveChildProductTreeIterator;
import com.installshield.product.iterators.ActiveProductTreeIterator;
import com.installshield.product.iterators.ChildrenProductTreeIterator;
import com.installshield.product.iterators.ConditionalProductTreeIterator;
import com.installshield.product.iterators.HasLocaleTreeIterator;
import com.installshield.product.iterators.InstallStatusProductTreeIterator;
import com.installshield.product.iterators.MultiProductTreeIterator;
import com.installshield.product.iterators.ProductComponentTreeIterator;
import com.installshield.product.iterators.ProductFeatureTreeIterator;
import com.installshield.product.iterators.ProductIterator;
import com.installshield.product.iterators.ProductTypeTreeIterator;
import com.installshield.product.iterators.PubliclySharedParentIterator;
import com.installshield.product.iterators.RequiredTreeIterator;
import com.installshield.product.iterators.RequiresTreeIterator;
import com.installshield.product.iterators.SelectedLocalesIterator;
import com.installshield.product.iterators.SoftwareObjectTreeIterator;
import com.installshield.product.iterators.VisitOnceComponentTreeIterator;
import com.installshield.product.iterators.VisitedComponentTreeIterator;
import com.installshield.product.service.product.ProductTreeSource;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.Log;
import java.util.StringTokenizer;

public class ProductTreeIteratorFactory {
    static /* synthetic */ Class class$com$installshield$product$ProductFeature;
    static /* synthetic */ Class class$com$installshield$product$Product;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static ProductTreeIterator createActiveSoftwareObjectIterator(ProductBean productBean) {
        FilteredProductTreeIterator filteredProductTreeIterator = new StandardProductTreeIterator(productBean);
        filteredProductTreeIterator = new ActiveChildProductTreeIterator(filteredProductTreeIterator);
        filteredProductTreeIterator = new InstallStatusProductTreeIterator(filteredProductTreeIterator, 3, true);
        return new ProductFeatureTreeIterator(filteredProductTreeIterator);
    }

    public static ProductTreeIterator createChildComponentIterator(ProductBean productBean, boolean bl) {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean, bl);
        ActiveProductTreeIterator activeProductTreeIterator = new ActiveProductTreeIterator(standardProductTreeIterator);
        ConditionalProductTreeIterator conditionalProductTreeIterator = new ConditionalProductTreeIterator(activeProductTreeIterator);
        SelectedLocalesIterator selectedLocalesIterator = new SelectedLocalesIterator(conditionalProductTreeIterator, ProductTreeIteratorFactory.getSelectedLocales(productBean));
        ChildrenProductTreeIterator childrenProductTreeIterator = new ChildrenProductTreeIterator(selectedLocalesIterator);
        SoftwareObjectTreeIterator softwareObjectTreeIterator = new SoftwareObjectTreeIterator(childrenProductTreeIterator);
        return softwareObjectTreeIterator;
    }

    public static ProductTreeIterator createChildIterator(ProductBean productBean) {
        return new ChildrenProductTreeIterator(new StandardProductTreeIterator(productBean));
    }

    public static ProductTreeIterator createFeaturesRequiredBySoftwareObjectIterator(GenericSoftwareObject genericSoftwareObject, boolean bl) {
        FilteredProductTreeIterator filteredProductTreeIterator = new RequiredTreeIterator(genericSoftwareObject);
        filteredProductTreeIterator = new ConditionalProductTreeIterator(filteredProductTreeIterator);
        filteredProductTreeIterator = new SelectedLocalesIterator(filteredProductTreeIterator, ProductTreeIteratorFactory.getSelectedLocales(genericSoftwareObject));
        filteredProductTreeIterator = new InstallStatusProductTreeIterator(filteredProductTreeIterator, 3, bl);
        return new ProductFeatureTreeIterator(filteredProductTreeIterator);
    }

    public static ProductTreeIterator createFindLocalesTreeIterator(ProductBean productBean) {
        FilteredProductTreeIterator filteredProductTreeIterator = new StandardProductTreeIterator(productBean, true);
        filteredProductTreeIterator = new ActiveChildProductTreeIterator(filteredProductTreeIterator);
        filteredProductTreeIterator = new ConditionalProductTreeIterator(filteredProductTreeIterator);
        return new HasLocaleTreeIterator(filteredProductTreeIterator);
    }

    public static ProductTreeIterator createInstallableComponentIterator(ProductBean productBean, RegistryService registryService, ProductTreeSource productTreeSource, Log log, boolean bl) {
        FilteredProductTreeIterator filteredProductTreeIterator = new StandardProductTreeIterator(productBean, true);
        if (bl) {
            filteredProductTreeIterator = new MultiProductTreeIterator((BaseProductTreeIterator)filteredProductTreeIterator, productTreeSource, log);
        }
        ActiveChildProductTreeIterator activeChildProductTreeIterator = new ActiveChildProductTreeIterator(filteredProductTreeIterator);
        ConditionalProductTreeIterator conditionalProductTreeIterator = new ConditionalProductTreeIterator(activeChildProductTreeIterator);
        SelectedLocalesIterator selectedLocalesIterator = new SelectedLocalesIterator(conditionalProductTreeIterator, ProductTreeIteratorFactory.getSelectedLocales(productBean));
        InstallStatusProductTreeIterator installStatusProductTreeIterator = new InstallStatusProductTreeIterator(selectedLocalesIterator, 5, false);
        VisitedComponentTreeIterator visitedComponentTreeIterator = new VisitedComponentTreeIterator(installStatusProductTreeIterator);
        PubliclySharedParentIterator publiclySharedParentIterator = new PubliclySharedParentIterator(visitedComponentTreeIterator, registryService);
        SoftwareObjectTreeIterator softwareObjectTreeIterator = new SoftwareObjectTreeIterator(publiclySharedParentIterator);
        return softwareObjectTreeIterator;
    }

    public static ProductTreeIterator createInstallableFeatureIterator(ProductBean productBean) {
        FilteredProductTreeIterator filteredProductTreeIterator = new StandardProductTreeIterator(productBean);
        filteredProductTreeIterator = new ActiveProductTreeIterator(filteredProductTreeIterator);
        filteredProductTreeIterator = new ConditionalProductTreeIterator(filteredProductTreeIterator);
        filteredProductTreeIterator = new SelectedLocalesIterator(filteredProductTreeIterator, ProductTreeIteratorFactory.getSelectedLocales(productBean));
        return new ProductTypeTreeIterator((ProductTreeIterator)filteredProductTreeIterator, class$com$installshield$product$ProductFeature != null ? class$com$installshield$product$ProductFeature : (class$com$installshield$product$ProductFeature = ProductTreeIteratorFactory.class$("com.installshield.product.ProductFeature")));
    }

    public static ProductTreeIterator createInstallableProductIterator(ProductBean productBean, ProductTreeSource productTreeSource, Log log) {
        FilteredProductTreeIterator filteredProductTreeIterator = new StandardProductTreeIterator(productBean);
        filteredProductTreeIterator = new MultiProductTreeIterator((BaseProductTreeIterator)filteredProductTreeIterator, productTreeSource, log);
        filteredProductTreeIterator = new ActiveProductTreeIterator(filteredProductTreeIterator);
        filteredProductTreeIterator = new ConditionalProductTreeIterator(filteredProductTreeIterator);
        return new ProductTypeTreeIterator((ProductTreeIterator)filteredProductTreeIterator, class$com$installshield$product$Product != null ? class$com$installshield$product$Product : (class$com$installshield$product$Product = ProductTreeIteratorFactory.class$("com.installshield.product.Product")), true);
    }

    public static ProductTreeIterator createInstalledFeatureIterator(ProductBean productBean) {
        FilteredProductTreeIterator filteredProductTreeIterator = new StandardProductTreeIterator(productBean);
        filteredProductTreeIterator = new InstallStatusProductTreeIterator(filteredProductTreeIterator, 3, true);
        return new ProductTypeTreeIterator((ProductTreeIterator)filteredProductTreeIterator, class$com$installshield$product$ProductFeature != null ? class$com$installshield$product$ProductFeature : (class$com$installshield$product$ProductFeature = ProductTreeIteratorFactory.class$("com.installshield.product.ProductFeature")));
    }

    public static ProductTreeIterator createProductComponentIterator(ProductBean productBean) {
        FilteredProductTreeIterator filteredProductTreeIterator = new StandardProductTreeIterator(productBean);
        filteredProductTreeIterator = new ActiveChildProductTreeIterator(filteredProductTreeIterator);
        filteredProductTreeIterator = new ConditionalProductTreeIterator(filteredProductTreeIterator);
        filteredProductTreeIterator = new SelectedLocalesIterator(filteredProductTreeIterator, ProductTreeIteratorFactory.getSelectedLocales(productBean));
        return new ProductComponentTreeIterator(filteredProductTreeIterator);
    }

    public static ProductTreeIterator createProductIterator(ProductTree productTree, ProductTreeSource productTreeSource, Log log) {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree);
        MultiProductTreeIterator multiProductTreeIterator = new MultiProductTreeIterator(standardProductTreeIterator, productTreeSource, log);
        ActiveChildProductTreeIterator activeChildProductTreeIterator = new ActiveChildProductTreeIterator(multiProductTreeIterator);
        return new ProductIterator(activeChildProductTreeIterator);
    }

    public static ProductTreeIterator createProductTypeIterator(ProductBean productBean, Class clazz) {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean);
        return new ProductTypeTreeIterator((ProductTreeIterator)standardProductTreeIterator, clazz);
    }

    public static ProductTreeIterator createRegisteredComponentIterator(ProductBean productBean) {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean, true);
        ActiveProductTreeIterator activeProductTreeIterator = new ActiveProductTreeIterator(standardProductTreeIterator);
        ConditionalProductTreeIterator conditionalProductTreeIterator = new ConditionalProductTreeIterator(activeProductTreeIterator);
        SelectedLocalesIterator selectedLocalesIterator = new SelectedLocalesIterator(conditionalProductTreeIterator, ProductTreeIteratorFactory.getSelectedLocales(productBean));
        InstallStatusProductTreeIterator installStatusProductTreeIterator = new InstallStatusProductTreeIterator(selectedLocalesIterator, 2, true);
        SoftwareObjectTreeIterator softwareObjectTreeIterator = new SoftwareObjectTreeIterator(installStatusProductTreeIterator);
        return softwareObjectTreeIterator;
    }

    public static ProductTreeIterator createRequiredComponentIterator(ProductBean productBean) {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean, true);
        ActiveProductTreeIterator activeProductTreeIterator = new ActiveProductTreeIterator(standardProductTreeIterator);
        ConditionalProductTreeIterator conditionalProductTreeIterator = new ConditionalProductTreeIterator(activeProductTreeIterator);
        SelectedLocalesIterator selectedLocalesIterator = new SelectedLocalesIterator(conditionalProductTreeIterator, ProductTreeIteratorFactory.getSelectedLocales(productBean));
        VisitOnceComponentTreeIterator visitOnceComponentTreeIterator = new VisitOnceComponentTreeIterator(selectedLocalesIterator);
        SoftwareObjectTreeIterator softwareObjectTreeIterator = new SoftwareObjectTreeIterator(visitOnceComponentTreeIterator);
        return softwareObjectTreeIterator;
    }

    public static ProductTreeIterator createRequiringSoftwareObjectIterator(ProductBean productBean, GenericSoftwareObject genericSoftwareObject, boolean bl) {
        FilteredProductTreeIterator filteredProductTreeIterator = new StandardProductTreeIterator(productBean);
        filteredProductTreeIterator = new ConditionalProductTreeIterator(filteredProductTreeIterator);
        filteredProductTreeIterator = new SelectedLocalesIterator(filteredProductTreeIterator, ProductTreeIteratorFactory.getSelectedLocales(productBean));
        filteredProductTreeIterator = new InstallStatusProductTreeIterator(filteredProductTreeIterator, 3, bl);
        return new RequiresTreeIterator(filteredProductTreeIterator, genericSoftwareObject);
    }

    public static ProductTreeIterator createSoftwareObjectIterator(ProductBean productBean) {
        FilteredProductTreeIterator filteredProductTreeIterator = new StandardProductTreeIterator(productBean);
        filteredProductTreeIterator = new ConditionalProductTreeIterator(filteredProductTreeIterator);
        filteredProductTreeIterator = new SelectedLocalesIterator(filteredProductTreeIterator, ProductTreeIteratorFactory.getSelectedLocales(productBean));
        return new SoftwareObjectTreeIterator(filteredProductTreeIterator);
    }

    public static ProductTreeIterator createUninstallableFeatureIterator(ProductBean productBean, int n) {
        FilteredProductTreeIterator filteredProductTreeIterator = new StandardProductTreeIterator(productBean);
        filteredProductTreeIterator = new ActiveChildProductTreeIterator(filteredProductTreeIterator);
        filteredProductTreeIterator = new InstallStatusProductTreeIterator(filteredProductTreeIterator, n, true);
        return new ProductTypeTreeIterator((ProductTreeIterator)filteredProductTreeIterator, class$com$installshield$product$ProductFeature != null ? class$com$installshield$product$ProductFeature : (class$com$installshield$product$ProductFeature = ProductTreeIteratorFactory.class$("com.installshield.product.ProductFeature")));
    }

    public static ProductTreeIterator createUninstallerComponentIterator(ProductBean productBean, int n) {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean, true);
        ActiveProductTreeIterator activeProductTreeIterator = new ActiveProductTreeIterator(standardProductTreeIterator);
        InstallStatusProductTreeIterator installStatusProductTreeIterator = new InstallStatusProductTreeIterator(activeProductTreeIterator, n, true);
        SoftwareObjectTreeIterator softwareObjectTreeIterator = new SoftwareObjectTreeIterator(installStatusProductTreeIterator);
        return softwareObjectTreeIterator;
    }

    private static String[] getSelectedLocales(ProductBean productBean) {
        ProductTree productTree = productBean.getProductTree();
        if (productTree != null && productTree.getSelectedLocales() != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(productTree.getSelectedLocales(), ",");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            return stringArray;
        }
        return new String[0];
    }
}

