/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanFilter;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectReference;

public class InstallStatusProductTreeIterator
implements FilteredProductTreeIterator,
ProductBeanFilter {
    private FilteredProductTreeIterator iter;
    private int installStatus;
    private boolean testEqual = true;

    public InstallStatusProductTreeIterator(FilteredProductTreeIterator filteredProductTreeIterator, int n) {
        this(filteredProductTreeIterator, n, true);
    }

    public InstallStatusProductTreeIterator(FilteredProductTreeIterator filteredProductTreeIterator, int n, boolean bl) {
        this.testEqual = bl;
        this.iter = filteredProductTreeIterator;
        this.installStatus = n;
        filteredProductTreeIterator.addFilter(this);
    }

    public boolean accept(ProductBean productBean) {
        SoftwareObject softwareObject = null;
        SoftwareObjectReference softwareObjectReference = null;
        if (productBean instanceof SoftwareObject) {
            softwareObject = (SoftwareObject)((Object)productBean);
        } else if (productBean instanceof SoftwareObjectReference) {
            softwareObjectReference = (SoftwareObjectReference)productBean;
            softwareObject = productBean.getProductTree().resolveKey(softwareObjectReference.getKey());
        }
        if (softwareObject != null) {
            if (this.testEqual) {
                return softwareObject.getInstallStatus() == this.installStatus;
            }
            return softwareObject.getInstallStatus() != this.installStatus;
        }
        return true;
    }

    public void addFilter(ProductBeanFilter productBeanFilter) {
        this.iter.addFilter(productBeanFilter);
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        return this.iter.getNext(productBean);
    }

    public ProductBean getPrevious(ProductBean productBean) {
        return this.iter.getPrevious(productBean);
    }

    public void removeFilter(ProductBeanFilter productBeanFilter) {
        this.iter.removeFilter(productBeanFilter);
    }
}

