/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.service.product;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductException;
import com.installshield.product.ProductTree;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.actions.UninstallerArchive;
import com.installshield.product.actions.UninstallerJVMResolution;
import com.installshield.product.actions.UninstallerLauncher;
import com.installshield.product.service.product.InstallableObjectVisitor;
import com.installshield.product.service.product.ProductTreeSource;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.Log;
import com.installshield.wizard.service.ServiceException;

public class RequiredBytes
extends InstallableObjectVisitor {
    static /* synthetic */ Class class$com$installshield$product$Product;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Object getDefaultResult() {
        return new RequiredBytesTable();
    }

    public RequiredBytesTable getEstimatedRequiredBytes(ProductBean productBean, ProductTree productTree, ProductTreeSource productTreeSource, RegistryService registryService, Log log) throws ServiceException {
        return (RequiredBytesTable)this.visitProductBean(productBean, productTreeSource, null, registryService, log);
    }

    boolean getResolveProductReferences() {
        return true;
    }

    Object getResultForProductAction(ProductAction productAction, ProductActionSupport productActionSupport) throws ServiceException {
        try {
            return productAction.getRequiredBytes();
        }
        catch (ProductException productException) {
            throw new ServiceException(productException);
        }
    }

    private RequiredBytesTable getUninstallerSize(ProductTree productTree) throws ProductException {
        UninstallerArchive uninstallerArchive = productTree.getUninstallerArchive();
        UninstallerJVMResolution uninstallerJVMResolution = productTree.getUninstallerJVMResolution();
        UninstallerLauncher uninstallerLauncher = productTree.getUninstallerLauncher();
        RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
        requiredBytesTable.addBytes(uninstallerArchive.getRequiredBytes());
        if (uninstallerJVMResolution.isActive() && uninstallerLauncher.isActive() && uninstallerLauncher.getInstalledFileName() == null) {
            requiredBytesTable.addBytes(uninstallerJVMResolution.getRequiredBytes());
            requiredBytesTable.addBytes(uninstallerLauncher.getRequiredBytes());
        }
        return requiredBytesTable;
    }

    Object processNewResult(Object object, Object object2) {
        RequiredBytesTable requiredBytesTable = (RequiredBytesTable)object;
        if (object2 != null) {
            requiredBytesTable.addBytes((RequiredBytesTable)object2);
        }
        return requiredBytesTable;
    }

    boolean reVisit(ProductBean productBean, ProductActionSupport productActionSupport) {
        return false;
    }

    Object visitSoftwareObject(ProductBean productBean, ProductTreeSource productTreeSource, ProductActionSupport productActionSupport, RegistryService registryService, Log log) throws ServiceException {
        Object object;
        block2: {
            object = super.visitSoftwareObject(productBean, productTreeSource, productActionSupport, registryService, log);
            if (productBean.getClass() != (class$com$installshield$product$Product != null ? class$com$installshield$product$Product : (class$com$installshield$product$Product = RequiredBytes.class$("com.installshield.product.Product")))) break block2;
            try {
                RequiredBytesTable requiredBytesTable = this.getUninstallerSize(productBean.getProductTree());
                ((RequiredBytesTable)object).addBytes(requiredBytesTable);
            }
            catch (ProductException productException) {
                log.logEvent(this, "err", productException);
                log.logEvent(this, "wrn", "unable to include required bytes for uninstaller");
            }
        }
        return object;
    }
}

