/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.wizardbeans.BillboardDisplayInfo;
import com.installshield.product.wizardbeans.BillboardProgressRenderer;
import com.installshield.util.PropertyUtils;
import com.installshield.wizard.awt.InsetsPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ImageObserver;

public class BillboardDisplayUI {
    private static final int TOP_MARGIN = 40;
    private static final int LEFT_MARGIN = 20;
    private static final int RIGHT_MARGIN = 20;
    private static final int BOTTOM_MARGIN = 20;
    private Frame billboardFrame = new Frame();
    private BillboardImageWindow imageWindow;
    private int currentImageIndex = 0;
    private Image[] images = null;
    private int[] atPercentage = null;
    private boolean imagesLoaded = false;
    private boolean startBillboardDisplay = false;
    private boolean displayComplete = false;
    private int progressComplete = 0;
    private Panel progressPane = new Panel();
    private BillboardProgressWindow progressWindow;
    private BillboardDisplayInfo billboards;

    public BillboardDisplayUI(BillboardDisplayInfo billboardDisplayInfo) {
        this.billboards = billboardDisplayInfo;
    }

    private void createImageWindow() {
        this.imageWindow = new BillboardImageWindow(this.billboardFrame, null);
        this.imageWindow.positionAt(new Point(20, 40));
    }

    private void createProgressWindow() {
        this.progressWindow = new BillboardProgressWindow(this.billboardFrame, this.billboardFrame.getTitle());
        Dimension dimension = this.billboardFrame.getSize();
        Dimension dimension2 = this.progressWindow.getSize();
        int n = dimension.width - (dimension2.width + 20);
        int n2 = dimension.height - (dimension2.height + 20);
        this.progressWindow.positionAt(new Point(n, n2));
    }

    private void createUI() {
        this.currentImageIndex = 0;
        this.startBillboardDisplay = false;
        if (this.billboardFrame != null) {
            this.billboardFrame = new Frame();
            this.billboardFrame.setResizable(false);
        }
        if (this.billboards != null && this.billboards.getBillboardsCount() > 0) {
            ((Component)this.billboardFrame).setBackground(PropertyUtils.createColor(this.billboards.getBackgroundColor(), Color.blue));
        }
        ((Component)this.billboardFrame).setSize(Toolkit.getDefaultToolkit().getScreenSize());
    }

    Frame getBillboardFrame() {
        return this.billboardFrame;
    }

    private int getImageIndexToShow() {
        if (this.imagesLoaded) {
            int n = this.atPercentage.length;
            int n2 = this.currentImageIndex;
            while (n2 <= n - 1) {
                if (this.progressComplete <= this.atPercentage[n2]) {
                    return n2;
                }
                ++n2;
            }
            return n - 1;
        }
        return -1;
    }

    private Panel getProgressPane() {
        return this.progressPane;
    }

    protected void hideBillboard() {
        if (!this.displayComplete) {
            this.progressWindow.dispose();
            this.imageWindow.dispose();
            ((Component)this.billboardFrame).setVisible(false);
            this.billboardFrame.dispose();
            this.billboardFrame = null;
            this.progressWindow = null;
            this.imageWindow = null;
            this.displayComplete = true;
        }
    }

    void initialize() {
        this.createUI();
        this.createProgressWindow();
        this.createImageWindow();
    }

    void setFrameProperties(Image image, String string) {
        if (image != null) {
            this.billboardFrame.setIconImage(image);
        }
        this.billboardFrame.setTitle(string);
        this.progressWindow.setTitle(string);
    }

    void setImages(Image[] imageArray) {
        this.images = imageArray;
        if (imageArray != null && imageArray.length > 0) {
            this.imagesLoaded = true;
        }
    }

    void setPercentages(int[] nArray) {
        this.atPercentage = nArray;
    }

    void setProgressPane(Panel panel) {
        this.progressPane = panel;
    }

    void showBillboard() {
        ((Component)this.billboardFrame).setVisible(true);
        ((Component)this.imageWindow).setVisible(true);
        ((Component)this.progressWindow).setVisible(true);
    }

    void updateProgress(int n) {
        int n2;
        this.progressComplete = n;
        if (!this.displayComplete && this.imageWindow != null && (n2 = this.getImageIndexToShow()) != -1) {
            if (this.currentImageIndex != n2) {
                this.currentImageIndex = n2;
            }
            this.imageWindow.setImage(this.images[n2]);
        }
    }

    private class BillboardProgressWindow
    extends Dialog {
        private Frame parentFrame;
        private String title = "";

        public BillboardProgressWindow(Frame frame, String string) {
            super(frame, false);
            this.parentFrame = frame;
            this.title = string;
            this.initialize();
            this.toFront();
        }

        private void initialize() {
            Panel panel = BillboardDisplayUI.this.getProgressPane();
            this.setCurrent(panel);
            this.setTitle(this.title);
            this.setResizable(false);
        }

        public void positionAt(Point point) {
            ((Component)this).setLocation(point);
        }

        private void setCurrent(Container container) {
            InsetsPanel insetsPanel = new InsetsPanel(10, 10, 0, 10);
            insetsPanel.setLayout(new BorderLayout(0, 2));
            if (container instanceof BillboardProgressRenderer) {
                Component component = ((BillboardProgressRenderer)((Object)container)).getCaption();
                Component component2 = ((BillboardProgressRenderer)((Object)container)).getProgressBar();
                Button button = ((BillboardProgressRenderer)((Object)container)).getCancelButton();
                if (component != null) {
                    insetsPanel.add(component, "North");
                }
                if (component2 != null) {
                    insetsPanel.add(component2, "Center");
                }
                if (button != null) {
                    Panel panel = new Panel();
                    panel.add(button);
                    insetsPanel.add((Component)panel, "South");
                }
                this.add((Component)insetsPanel, "Center");
            }
            this.pack();
        }
    }

    private class BillboardImageWindow
    extends Window
    implements ImageObserver {
        private Image image = null;
        private boolean isShown = true;
        private int imageWidth = -1;
        private int imageHeight = -1;
        private int windowWidth = 1;
        private int windowHeight = 1;
        private Dimension screenSize = null;
        private Frame parentFrame = null;
        private Object imageLoadLock = new Object();
        private boolean loaded = false;
        private int xPosition = 20;
        private int yPosition = 40;

        public BillboardImageWindow(Frame frame, Image image) {
            super(frame);
            this.image = image;
            this.parentFrame = frame;
            this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setSize(this.windowWidth + this.xPosition, this.windowHeight + this.yPosition);
            this.show();
        }

        private void calculateWindowSize() {
            int n = this.image.getWidth(this);
            int n2 = this.image.getHeight(this);
            if (n > 0 && n2 > 0 && this.isShown) {
                if (n > this.screenSize.width) {
                    n = this.screenSize.width - this.yPosition;
                }
                if (n2 > this.screenSize.height) {
                    n2 = this.screenSize.height - this.xPosition;
                }
                this.windowWidth = n;
                this.windowHeight = n2;
                this.isShown = false;
                ((Component)this).setSize(this.windowWidth, this.windowHeight);
            }
        }

        public Image getImage() {
            return this.image;
        }

        public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0x20) != 0) {
                Object object = this.imageLoadLock;
                synchronized (object) {
                    this.loaded = true;
                }
                this.repaint();
                return false;
            }
            return true;
        }

        private boolean isImageLoaded() {
            Object object = this.imageLoadLock;
            synchronized (object) {
                boolean bl = this.loaded;
                Object var3_3 = null;
                return bl;
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.image != null && this.isImageLoaded()) {
                graphics.drawImage(this.image, 0, 0, this);
                this.calculateWindowSize();
            }
        }

        public void positionAt(Point point) {
            ((Component)this).setLocation(point);
        }

        public void setImage(Image image) {
            this.image = image;
            this.prepareImage(image, this);
            this.isShown = true;
            this.repaint();
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

