/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.service.product.ProductService;
import com.installshield.product.wizardbeans.BillboardDisplayInfo;
import com.installshield.product.wizardbeans.BillboardDisplayUI;
import com.installshield.product.wizardbeans.BillboardProgressRenderer;
import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.OperationRejectedException;
import com.installshield.util.Progress;
import com.installshield.wizard.AbstractCancelableProgressRenderer;
import com.installshield.wizard.ProgressRenderer;
import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.awt.AWTProgressRenderer;
import com.installshield.wizard.awt.AWTWizardUI;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.FlowLabel;
import com.installshield.wizard.awt.ISProgressBar;
import com.installshield.wizard.awt.InsetsPanel;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.ServiceException;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class InstallAction
extends WizardAction {
    private String productURL = "/product.xml";
    private OperationKey key = null;
    private WizardUI ui = null;
    private BillboardDisplayInfo billboards = new BillboardDisplayInfo();
    private static String billboardKey = "BillboardImage";
    private BillboardDisplayUI billboardUI = null;
    private boolean wizardHidden = false;
    private Frame parentFrame = null;
    private Image[] images = new Image[0];
    private int[] percentages = new int[0];
    static /* synthetic */ Class class$com$installshield$wizard$awt$AWTProgressRenderer;
    static /* synthetic */ Class class$com$installshield$product$wizardbeans$BillboardDisplayInfo;
    static /* synthetic */ Class class$com$installshield$product$wizardbeans$BillboardDisplayUI;
    static /* synthetic */ Class class$com$installshield$product$wizardbeans$BillboardProgressRenderer;
    static /* synthetic */ Class class$com$installshield$product$wizardbeans$BillboardInfo;

    public InstallAction() {
        this.setCancelable(true);
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        block6: {
            try {
                wizardBuilderSupport.putRequiredService("productService");
                wizardBuilderSupport.putClass((class$com$installshield$product$wizardbeans$BillboardDisplayInfo != null ? class$com$installshield$product$wizardbeans$BillboardDisplayInfo : (class$com$installshield$product$wizardbeans$BillboardDisplayInfo = InstallAction.class$("com.installshield.product.wizardbeans.BillboardDisplayInfo"))).getName());
                wizardBuilderSupport.putClass((class$com$installshield$product$wizardbeans$BillboardDisplayUI != null ? class$com$installshield$product$wizardbeans$BillboardDisplayUI : (class$com$installshield$product$wizardbeans$BillboardDisplayUI = InstallAction.class$("com.installshield.product.wizardbeans.BillboardDisplayUI"))).getName());
                wizardBuilderSupport.putClass((class$com$installshield$product$wizardbeans$BillboardProgressRenderer != null ? class$com$installshield$product$wizardbeans$BillboardProgressRenderer : (class$com$installshield$product$wizardbeans$BillboardProgressRenderer = InstallAction.class$("com.installshield.product.wizardbeans.BillboardProgressRenderer"))).getName());
                wizardBuilderSupport.putClass("com.installshield.product.wizardbeans.BillboardDisplayUI$BillboardImageWindow");
                wizardBuilderSupport.putClass("com.installshield.product.wizardbeans.BillboardDisplayUI$BillboardProgressWindow");
                wizardBuilderSupport.putClass((class$com$installshield$product$wizardbeans$BillboardInfo != null ? class$com$installshield$product$wizardbeans$BillboardInfo : (class$com$installshield$product$wizardbeans$BillboardInfo = InstallAction.class$("com.installshield.product.wizardbeans.BillboardInfo"))).getName());
                wizardBuilderSupport.putClass("com.installshield.product.wizardbeans.InstallAction$InstallActionProgressRenderer");
                wizardBuilderSupport.putClass("com.installshield.product.wizardbeans.InstallAction$InstallActionProgressRenderer$InstallActionProgressPanel");
                if (this.billboards == null || this.billboards.getBillboardsCount() <= 0) break block6;
                int n = 0;
                while (n < this.billboards.getBillboardsCount()) {
                    Serializable serializable;
                    String string = String.valueOf(billboardKey) + n;
                    String string2 = this.billboards.getBillboardAt(n).getImageSource();
                    try {
                        serializable = new URL(string2);
                        wizardBuilderSupport.putResource((URL)serializable, string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        serializable = new File(string2.replace('/', File.separatorChar));
                        if (((File)serializable).isFile()) {
                            wizardBuilderSupport.putResource(((File)serializable).getAbsolutePath(), string);
                        }
                        wizardBuilderSupport.logEvent(this, "err", "Cannot build wizard image: file does not exist or is not a valid URL");
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                wizardBuilderSupport.logEvent(this, "err", iOException);
            }
        }
    }

    public void cancel() throws OperationRejectedException {
        block2: {
            super.cancel();
            if (this.key == null) break block2;
            try {
                ProductService productService = (ProductService)this.getService("productService");
                productService.cancelOperation(this.key);
                this.hideBillboards();
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void createBillboardUI() {
        boolean bl;
        if (this.billboards.isEnabled() && (bl = this.retrieveImages())) {
            this.parentFrame = ((AWTWizardUI)this.ui).getFrame();
            this.billboardUI.setImages(this.images);
            this.percentages = new int[this.billboards.getBillboardsCount()];
            int n = 0;
            while (n < this.percentages.length) {
                this.percentages[n] = this.billboards.getBillboardAt(n).getPercentage();
                ++n;
            }
            this.billboardUI.setPercentages(this.percentages);
            if (!this.wizardHidden) {
                ((Component)this.parentFrame).setVisible(false);
                this.billboardUI.showBillboard();
                this.billboardUI.setFrameProperties(this.parentFrame.getIconImage(), this.resolveString(this.parentFrame.getTitle()));
                ((AWTWizardUI)this.ui).setFrame(this.billboardUI.getBillboardFrame());
                this.wizardHidden = true;
            }
            this.billboardUI.showBillboard();
        }
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        this.ui = wizardBeanEvent.getUserInterface();
        if (this.ui != null && this.ui instanceof AWTWizardUI) {
            this.createBillboardUI();
        }
        try {
            ProductService productService = (ProductService)this.getService("productService");
            this.key = productService.installProduct(this.productURL);
            while (!productService.isOperationEnded(this.key)) {
                PropertyAccessible propertyAccessible;
                if (this.getState().isSuspended()) {
                    this.getState().setStatusDescription(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "UninstallAction.operationSuspended"));
                    PropertyAccessible propertyAccessible2 = propertyAccessible = this.getState();
                    synchronized (propertyAccessible2) {
                        try {
                            propertyAccessible.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.getState().update(productService.getOperationProgress(this.key));
                propertyAccessible = this;
                synchronized (propertyAccessible) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new Error();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }

    public BillboardDisplayInfo getBillboards() {
        return this.billboards;
    }

    public ProgressRenderer getProgressRendererImpl(Class clazz) {
        if (clazz.isAssignableFrom(class$com$installshield$wizard$awt$AWTProgressRenderer != null ? class$com$installshield$wizard$awt$AWTProgressRenderer : (class$com$installshield$wizard$awt$AWTProgressRenderer = InstallAction.class$("com.installshield.wizard.awt.AWTProgressRenderer")))) {
            return new InstallActionProgressRenderer();
        }
        return null;
    }

    private void hideBillboards() {
        if (this.ui != null && this.ui instanceof AWTWizardUI && this.billboards.isEnabled() && this.wizardHidden) {
            this.billboardUI.hideBillboard();
            ((AWTWizardUI)this.ui).setFrame(this.parentFrame);
            ((Component)this.parentFrame).setVisible(true);
            this.wizardHidden = false;
        }
    }

    protected String resolveString(String string) {
        return super.resolveString(string);
    }

    public void resume() {
        block2: {
            super.resume();
            if (this.key == null) break block2;
            try {
                ProductService productService = (ProductService)this.getService("productService");
                productService.resumeOperation(this.key);
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    private boolean retrieveImages() {
        try {
            this.images = new Image[this.billboards.getBillboardsCount()];
            int n = 0;
            while (n < this.images.length) {
                String string = String.valueOf(billboardKey) + n;
                URL uRL = this.getWizard().getResource(string);
                this.images[n] = Toolkit.getDefaultToolkit().getImage(uRL);
                ++n;
            }
            return true;
        }
        catch (IOException iOException) {
            this.logEvent(this, "err", iOException);
            return false;
        }
    }

    public void setBillboards(BillboardDisplayInfo billboardDisplayInfo) {
        this.billboards = billboardDisplayInfo;
    }

    public void suspend() throws OperationRejectedException {
        block2: {
            super.suspend();
            if (this.key == null) break block2;
            try {
                ProductService productService = (ProductService)this.getService("productService");
                productService.suspendOperation(this.key);
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    class InstallActionProgressRenderer
    extends AbstractCancelableProgressRenderer
    implements AWTProgressRenderer,
    ActionListener {
        private boolean cancelable = false;
        private Container content = null;
        private FlowLabel caption = null;
        private FlowLabel detail = null;
        private Button cancelButton = null;
        private Cursor saveCursor = null;
        private ISProgressBar progressBar = null;
        private boolean isProgressHidden = false;
        private boolean isCancelButtonHidden = false;
        private Panel cancelPane = null;
        private String tempUninstallerDescription = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.Installer.createUninstaller");

        InstallActionProgressRenderer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fireCancelPerformed();
        }

        private GridBagConstraints constrain(int n, int n2, double d) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n2;
            gridBagConstraints.gridy = n;
            gridBagConstraints.weightx = d;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            return gridBagConstraints;
        }

        private void createUI() {
            this.content = new InstallActionProgressPanel(0, 10, 0, 10);
            this.content.setLayout(new ColumnLayout());
            this.content.add((Component)new Panel(), ColumnConstraints.createVerticalFill());
            this.caption = new FlowLabel(" ");
            this.content.add((Component)this.caption, ColumnConstraints.createHorizontalFill());
            this.content.add(Spacing.createVerticalSpacing(4));
            this.detail = new FlowLabel(" ");
            this.content.add((Component)this.detail, ColumnConstraints.createHorizontalFill());
            this.content.add(Spacing.createVerticalSpacing(4));
            this.progressBar = new ISProgressBar();
            this.content.add((Component)this.progressBar, ColumnConstraints.createHorizontalFill());
            this.content.add(Spacing.createVerticalSpacing(4));
            this.cancelButton = new Button(this.pad(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "cancel"), 12));
            this.content.add((Component)this.cancelButton, ColumnConstraints.createCenterAlign());
            this.cancelButton.addActionListener(this);
            this.cancelButton.setCursor(Cursor.getDefaultCursor());
            this.cancelButton.setVisible(this.cancelable);
            this.content.add((Component)new Panel(), ColumnConstraints.createVerticalFill());
            if (InstallAction.this.billboards.isEnabled()) {
                InstallAction.this.billboardUI = new BillboardDisplayUI(InstallAction.this.billboards);
                InstallAction.this.billboardUI.setProgressPane((Panel)this.content);
                InstallAction.this.billboardUI.initialize();
            }
        }

        public void endProgress() {
        }

        public Component getComponent() {
            return this.content;
        }

        private void hideProgress() {
            if (!this.isProgressHidden) {
                this.progressBar.setVisible(false);
                this.isProgressHidden = true;
                this.content.invalidate();
                this.content.validate();
            }
        }

        public boolean isCancelable() {
            return this.cancelable;
        }

        private String pad(String string, int n) {
            int n2 = n - string.length();
            if (n2 > 0) {
                n2 /= 2;
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                while (n3 < n2) {
                    stringBuffer.append(' ');
                    ++n3;
                }
                stringBuffer.append(string);
                int n4 = 0;
                while (n4 < n2) {
                    stringBuffer.append(' ');
                    ++n4;
                }
                return stringBuffer.toString();
            }
            return string;
        }

        public void setCancelable(boolean bl) {
            this.cancelable = bl;
            if (this.content == null) {
                this.createUI();
            }
            this.cancelButton.setVisible(bl);
        }

        private void showProgress(int n) {
            if (this.isProgressHidden) {
                this.progressBar.setVisible(true);
                this.isProgressHidden = false;
                this.content.invalidate();
                this.content.validate();
            }
            this.progressBar.setProgress(n);
        }

        public void startProgress() {
        }

        public void updateProgress(Progress progress) {
            String string;
            String string2;
            if (this.content == null) {
                this.createUI();
            }
            if (!(string2 = InstallAction.this.resolveString(progress.getStatusDescription())).equals(this.caption.getText())) {
                if (string2.length() > 0) {
                    this.caption.setText(string2);
                } else {
                    this.caption.setText(" ");
                }
            }
            if (!(string = InstallAction.this.resolveString(progress.getStatusDetail())).equals(this.detail.getText())) {
                if (string.length() > 0) {
                    this.detail.setText(string);
                } else {
                    this.detail.setText(" ");
                }
            }
            int n = progress.getPercentComplete();
            this.progressBar.setProgress(n);
            if (InstallAction.this.billboards.isEnabled() && InstallAction.this.wizardHidden) {
                InstallAction.this.billboardUI.updateProgress(n);
            }
            if (n == 100) {
                InstallAction.this.hideBillboards();
                this.setCancelable(false);
            } else {
                this.setCancelable(true);
            }
        }

        class InstallActionProgressPanel
        extends InsetsPanel
        implements BillboardProgressRenderer {
            public InstallActionProgressPanel() {
                this(0, 0, 0, 0);
            }

            public InstallActionProgressPanel(int n, int n2, int n3, int n4) {
                super(n, n2, n3, n4);
            }

            public Button getCancelButton() {
                return InstallActionProgressRenderer.this.cancelButton;
            }

            public Component getCaption() {
                return InstallActionProgressRenderer.this.caption;
            }

            public Component getProgressBar() {
                return InstallActionProgressRenderer.this.progressBar;
            }
        }
    }
}

