/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.service.product.ProductService;
import com.installshield.product.wizardbeans.SetupType;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.ImagePanel;
import com.installshield.wizard.awt.InsetsPanel;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizardx.panels.ExtendedWizardPanel;
import com.installshield.wizardx.ui.TextDisplayComponent;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class SetupTypePanel
extends ExtendedWizardPanel
implements ItemListener {
    private String productURL = "/product.xml";
    private Vector setupTypes = new Vector();
    private String selectedSetupTypeId = null;
    private SetupType selectedSetupType = null;
    private Checkbox[] setupTypeCheckbox = null;
    private String setupTypeImage = "```!70``1TE&.#EA(``@`+,``````(````\"``(\"`````@(``@`\"`@(\"`@,#`P/\\```#_`/__````__\\`_P#______R'Y!`$```T`+``````@`\"````3^L,E)C[TX7\\HK^F`H(L\\!=-SQK&SKKM:)2NIHA_%,/XCFUSE=#4`L&HL$7G`V9#B?4&>R9](UFHYH=+I$8;50;K5#O/(`X*UR3`%43<:T=\"V;N!\\G-P:=%M<;=PA$*BR\"!'UT=D\"\"A\"N&B%1UBQ]Z%T0$F)F9B30](!8D*T0?+X5+H!FD``1Z(PJOD197%BX`AJP_`KHQH\">T+9>81\\-%J#*'4*N9E3\\7D1+(3YH!MJ&E+);06Y@!C`<W.$'14@3=WE0^']D-XPSE('K$1>I!C3`AK45X\\_1C]B7X8A`+)\\G%-W5N`)32\\.??03CRB*4PV../%28&V:\"0ET*$1C(+1$05X2!11T0*$0``.P``";
    private Image image = null;
    static /* synthetic */ Class class$com$installshield$product$ProductFeature;
    static /* synthetic */ Class class$com$installshield$product$wizardbeans$SetupType;

    public SetupTypePanel() {
        this.setDescription("$L(com.installshield.product.i18n.ProductResources, SetupTypePanel.description)");
    }

    public void addSetupType(SetupType setupType) {
        this.setupTypes.addElement(setupType);
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putClass((class$com$installshield$product$wizardbeans$SetupType != null ? class$com$installshield$product$wizardbeans$SetupType : (class$com$installshield$product$wizardbeans$SetupType = SetupTypePanel.class$("com.installshield.product.wizardbeans.SetupType"))).getName());
            wizardBuilderSupport.putRequiredService("productService");
        }
        catch (IOException iOException) {
            this.logEvent(this, "err", iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void consoleInteraction(WizardBeanEvent wizardBeanEvent) {
        String string = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "SetupTypePanel.descriptionHelp");
        String string2 = "";
        String string3 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "SetupTypePanel.promptSelect");
        String[] stringArray = null;
        TTYDisplay.showNewline();
        stringArray = new String[this.setupTypeCheckbox.length];
        int n = -1;
        int n2 = 0;
        while (n2 < this.setupTypes.size()) {
            string = String.valueOf(string) + "\t " + this.resolveString(((SetupType)this.setupTypes.elementAt(n2)).getDescription());
            if (n2 != this.setupTypes.size() - 1) {
                string = String.valueOf(string) + "\n";
            }
            stringArray[n2] = this.setupTypeCheckbox[n2].getLabel();
            if (this.setupTypeCheckbox[n2].getState()) {
                n = n2;
            }
            ++n2;
        }
        int n3 = TTYDisplay.queryValue(string3, string2, stringArray, n, string);
        if (n3 >= 0 && n3 < this.setupTypeCheckbox.length) {
            this.setupTypeCheckbox[n3].setState(true);
            ItemEvent itemEvent = new ItemEvent(this.setupTypeCheckbox[n3], 1, this, 1);
            this.itemStateChanged(itemEvent);
        }
    }

    protected void createUI(WizardBeanEvent wizardBeanEvent) {
        super.createUI(wizardBeanEvent);
        this.selectedSetupType = this.getSelectedSetupType();
        InsetsPanel insetsPanel = new InsetsPanel(new Insets(10, 0, 0, 0));
        insetsPanel.setLayout(new ColumnLayout());
        ScrollPane scrollPane = new ScrollPane(0);
        if (scrollPane.getVAdjustable().getUnitIncrement() < 5) {
            scrollPane.getVAdjustable().setUnitIncrement(15);
        }
        scrollPane.add(insetsPanel);
        this.getContentPane().add((Component)scrollPane, "Center");
        int n = 0;
        while (n < this.setupTypes.size()) {
            Panel panel;
            SetupType setupType = (SetupType)this.setupTypes.elementAt(n);
            if (n > 0) {
                insetsPanel.add(Spacing.createVerticalSpacing(15));
            }
            Panel panel2 = new Panel(new BorderLayout(20, 0));
            if (this.getSetupTypeImage() != null) {
                panel = new ImagePanel();
                ((ImagePanel)panel).setImage(this.getSetupTypeImage());
                panel2.add((Component)panel, "West");
            }
            panel2.add(this.setupTypeCheckbox[n]);
            insetsPanel.add((Component)panel2, new ColumnConstraints(1, 1));
            insetsPanel.add(Spacing.createVerticalSpacing(10));
            panel = new TextDisplayComponent(this.resolveString(setupType.getDescription()), true);
            ((TextDisplayComponent)panel).createComponentUI();
            insetsPanel.add((Component)panel, ColumnConstraints.createHorizontalFill());
            ++n;
        }
    }

    private SetupType getSelectedSetupType() {
        int n = 0;
        while (n < this.setupTypes.size()) {
            if (((SetupType)this.setupTypes.elementAt(n)).getId().equals(this.resolveString(this.getSelectedSetupTypeId()))) {
                return (SetupType)this.setupTypes.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    public String getSelectedSetupTypeId() {
        return this.selectedSetupTypeId;
    }

    private Image getSetupTypeImage() {
        if (this.image != null) {
            return this.image;
        }
        try {
            byte[] byArray = FileUtils.decodeBytes(this.setupTypeImage);
            String string = null;
            if (string == null) {
                string = FileUtils.createTempFile();
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    FileUtils.copy(new ByteArrayInputStream(byArray), fileOutputStream);
                    fileOutputStream.close();
                    this.image = Toolkit.getDefaultToolkit().getImage(string);
                }
                catch (IOException iOException) {
                    this.logEvent(this, "err", iOException);
                }
            }
            return this.image;
        }
        catch (IOException iOException) {
            this.logEvent(this, "wrn", iOException);
            return null;
        }
    }

    public SetupType[] getSetupTypes() {
        Object[] objectArray = new SetupType[this.setupTypes.size()];
        this.setupTypes.copyInto(objectArray);
        return objectArray;
    }

    protected void initialize() {
        super.initialize();
        this.selectedSetupType = this.getSelectedSetupType();
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.setupTypeCheckbox = new Checkbox[this.setupTypes.size()];
        int n = 0;
        while (n < this.setupTypes.size()) {
            SetupType setupType = (SetupType)this.setupTypes.elementAt(n);
            boolean bl = this.selectedSetupType != null && this.selectedSetupType.equals(setupType);
            this.setupTypeCheckbox[n] = new Checkbox(this.resolveString(setupType.getDisplayName()), checkboxGroup, bl);
            this.setupTypeCheckbox[n].addItemListener(this);
            ++n;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            String string = ((Checkbox)object).getLabel();
            int n = 0;
            while (n < this.setupTypes.size()) {
                if (this.resolveString(((SetupType)this.setupTypes.elementAt(n)).getDisplayName()).equals(string)) {
                    this.setSelectedSetupTypeId(((SetupType)this.setupTypes.elementAt(n)).getId());
                    break;
                }
                ++n;
            }
            this.updateProductTree();
        }
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        if (this.getSelectedSetupType() == null) {
            return false;
        }
        this.updateProductTree();
        return true;
    }

    public void removeSetupType(SetupType setupType) {
        this.setupTypes.removeElement(setupType);
    }

    public void removeSetupTypeAt(int n) {
        this.setupTypes.removeElementAt(n);
    }

    public void setSelectedSetupTypeId(String string) {
        this.selectedSetupTypeId = string;
    }

    public void setSetupTypes(SetupType[] setupTypeArray) {
        if (setupTypeArray == null) {
            throw new IllegalArgumentException("setup types cannot be null");
        }
        this.setupTypes.removeAllElements();
        int n = 0;
        while (n < setupTypeArray.length) {
            this.setupTypes.addElement(setupTypeArray[n]);
            ++n;
        }
    }

    public void updateProductTree() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("filter.condition", new Boolean(true));
        ((Hashtable)properties).put("filter.class", (class$com$installshield$product$ProductFeature != null ? class$com$installshield$product$ProductFeature : (class$com$installshield$product$ProductFeature = SetupTypePanel.class$("com.installshield.product.ProductFeature"))).getName());
        try {
            ProductService productService = (ProductService)this.getService("productService");
            Properties[] propertiesArray = productService.getProductBeanChildren(this.productURL, null, new String[]{"beanId"}, properties);
            this.selectedSetupType = this.getSelectedSetupType();
            String[] stringArray = this.selectedSetupType.getFeatures();
            int n = 0;
            while (n < propertiesArray.length) {
                boolean bl = false;
                int n2 = 0;
                while (!bl && n2 < stringArray.length) {
                    if (propertiesArray[n].getProperty("beanId").equals(stringArray[n2])) {
                        bl = true;
                    }
                    ++n2;
                }
                productService.setProductBeanProperty(this.productURL, propertiesArray[n].getProperty("beanId"), "active", new Boolean(bl));
                ++n;
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }
}

