/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.FunctionToken;
import com.installshield.util.PlainTextToken;
import com.installshield.util.StringResolutionToken;
import com.installshield.util.StringResolverMethod;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;

public class StringResolver {
    private Hashtable methods = new Hashtable();

    public void addMethod(StringResolverMethod stringResolverMethod) {
        this.methods.put(stringResolverMethod.getName(), stringResolverMethod);
    }

    public StringResolverMethod getMethod(String string) {
        return (StringResolverMethod)this.methods.get(string);
    }

    String mergeTokens(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append(((StringResolutionToken)vector.elementAt(n)).getValue());
            ++n;
        }
        return stringBuffer.toString();
    }

    private Vector parseString(String string) {
        Vector<StringResolutionToken> vector = new Vector<StringResolutionToken>();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        StringResolver.setNormal(streamTokenizer);
        try {
            int n;
            while ((n = streamTokenizer.nextToken()) != -1) {
                switch (n) {
                    case -3: {
                        vector.addElement(new PlainTextToken(streamTokenizer.sval));
                        break;
                    }
                    default: {
                        if ((char)n == '$') {
                            if ((char)streamTokenizer.nextToken() == '$') {
                                vector.addElement(new PlainTextToken("$"));
                                break;
                            }
                            streamTokenizer.pushBack();
                            vector.addElement(new FunctionToken(this, streamTokenizer));
                            break;
                        }
                        vector.addElement(new PlainTextToken(String.valueOf((char)n)));
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new Error();
        }
        return vector;
    }

    public void removeMethod(StringResolverMethod stringResolverMethod) {
        this.methods.remove(stringResolverMethod.getName());
    }

    public String resolve(String string) {
        return string != null ? this.mergeTokens(this.parseString(string)) : null;
    }

    static void setNormal(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.ordinaryChar(36);
        streamTokenizer.ordinaryChar(40);
        streamTokenizer.ordinaryChar(41);
        streamTokenizer.ordinaryChar(44);
    }

    static void setWhitespaceReader(StreamTokenizer streamTokenizer) {
        streamTokenizer.whitespaceChars(0, 32);
    }
}

