/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;

public class ButtonPanel
extends Panel {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private int orientation;
    private Panel c = new Panel(new GridLayout());
    private int gap;

    public ButtonPanel(int n) {
        this(n, 4);
    }

    public ButtonPanel(int n, int n2) {
        this.setOrientation(n);
        this.setGap(n2);
    }

    public void addButton(Button button) {
        this.c.add(button);
        this.refreshLayout();
    }

    public Button getButton(int n) {
        return (Button)this.c.getComponent(n);
    }

    public int getButtonCount() {
        return this.c.getComponentCount();
    }

    public int getGap() {
        return this.gap;
    }

    public int getOrientation() {
        return this.orientation;
    }

    private void refreshLayout() {
        int n = this.c.getComponentCount();
        GridLayout gridLayout = (GridLayout)this.c.getLayout();
        if (this.orientation == 1) {
            gridLayout.setColumns(n);
            gridLayout.setRows(1);
            gridLayout.setVgap(0);
            gridLayout.setHgap(this.gap);
        } else if (this.orientation == 2) {
            gridLayout.setColumns(1);
            gridLayout.setRows(n);
            gridLayout.setVgap(this.gap);
            gridLayout.setHgap(0);
        } else {
            throw new Error();
        }
    }

    public void removeAllButtons() {
        this.c.removeAll();
    }

    public void removeButton(Button button) {
        this.c.remove(button);
        this.refreshLayout();
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.removeAll();
        if (n == 1) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.c, "East");
        } else if (n == 2) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.c, "North");
        } else {
            throw new IllegalArgumentException("illegal orientation: " + n);
        }
    }
}

