/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.Progress;
import com.installshield.wizard.AbstractCancelableProgressRenderer;
import com.installshield.wizard.RunnableWizardBean;
import com.installshield.wizard.awt.AWTProgressRenderer;
import com.installshield.wizard.awt.FlowLabel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class StandardAWTProgressRenderer
extends AbstractCancelableProgressRenderer
implements AWTProgressRenderer,
MouseListener,
ActionListener {
    private boolean cancelable = true;
    private RunnableWizardBean bean;
    private Container content = null;
    private FlowLabel caption = null;
    private Button cancelButton = null;
    private Cursor saveCursor = null;
    private boolean isProgressHidden = false;
    private boolean isCancelButtonHidden = false;
    private String captionText = "";

    public void actionPerformed(ActionEvent actionEvent) {
        this.fireCancelPerformed();
    }

    private GridBagConstraints constrain(int n, int n2, double d) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = d;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        return gridBagConstraints;
    }

    private void createUI() {
        this.content = new Panel();
        this.content.setLayout(new GridBagLayout());
        int n = 1;
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        this.content.add((Component)new Panel(), this.constrain(n, 0, 0.25));
        this.content.add((Component)panel, this.constrain(n, 1, 0.5));
        this.content.add((Component)new Panel(), this.constrain(n, 2, 0.25));
        this.caption = new FlowLabel(" ");
        panel.add((Component)this.caption, "North");
        Panel panel2 = new Panel(new FlowLayout(1));
        panel.add((Component)panel2, "South");
        this.cancelButton = new Button(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "cancel"));
        this.cancelButton.addActionListener(this);
        panel2.add(this.cancelButton);
        this.cancelButton.setVisible(this.cancelable);
    }

    public void endProgress() {
    }

    public Component getComponent() {
        if (this.content == null) {
            this.createUI();
        }
        return this.content;
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.saveCursor = this.cancelButton.getCursor();
        this.cancelButton.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.cancelButton.setCursor(this.saveCursor);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setCancelable(boolean bl) {
        this.cancelable = bl;
        if (this.content == null) {
            this.createUI();
        }
        this.cancelButton.setVisible(bl);
    }

    public void startProgress() {
    }

    public void updateProgress(Progress progress) {
        String string;
        if (this.content == null) {
            this.createUI();
        }
        if (!(string = progress.getStatusDescription()).equals(this.captionText)) {
            this.caption.setText(string);
            this.captionText = string;
        }
    }
}

