/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.LockedFilesHandler;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.PureJavaSystemUtilServiceImpl;
import com.installshield.wizard.service.system.SystemUtilServiceImplementor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class Win32SystemUtilServiceImpl
extends PureJavaSystemUtilServiceImpl
implements SystemUtilServiceImplementor,
LockedFilesHandler {
    String cleanupEXE = "";

    public native void addSystemStartupCommand(String var1) throws ServiceException;

    public void deleteEnvironmentVariable(String string) throws ServiceException {
        this.setEnvironmentVariable(string, null);
    }

    protected void deleteFilesAfterExit() {
        super.deleteFilesAfterExit();
        try {
            String string;
            this.nativeDeleteFilesAfterExit(this.filesToDeleteOnExit(), this.directoriesToRecursivelyDeleteOnExit(), this.getRebootOnExit(), this.cleanupEXE);
            Enumeration enumeration = this.filesToDeleteOnExit();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                super.removeFileToDeleteOnExit(string);
            }
            enumeration = this.directoriesToRecursivelyDeleteOnExit();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                super.removeDirectoryToRecursivelyDeleteOnExit(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public native String getEnvironmentVariable(String var1) throws ServiceException;

    public native String getOSServiceLevel() throws ServiceException;

    public int getSystemCompatibility() {
        int n = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                n = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    protected void initialized() {
        super.initialized();
        FileUtils.setLockedFilesHandler(this);
        try {
            Win32Utils.loadDLL(this.getResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
            this.cleanupEXE = this.writeNativeCleanupEXE();
            FileUtils.clearTempFile(this.cleanupEXE);
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{"systemUtilService", Win32Utils.getJNIDLLName()}));
            exception.printStackTrace();
        }
    }

    private native void nativeDeleteFilesAfterExit(Enumeration var1, Enumeration var2, boolean var3, String var4) throws ServiceException;

    public native void removeSystemStartupCommand(String var1) throws ServiceException;

    public native void setEnvironmentVariable(String var1, String var2) throws ServiceException;

    public native Enumeration systemStartupCommands() throws ServiceException;

    private String writeNativeCleanupEXE() throws IOException {
        do {
            this.cleanupEXE = FileUtils.createFileName(FileUtils.getTempDir(), FileUtils.createTempFileName());
        } while (new File(this.cleanupEXE).exists());
        InputStream inputStream = this.getResource(String.valueOf(Win32Utils.getWin32PPKSubdir()) + "/isjecln.exe").openStream();
        FileOutputStream fileOutputStream = new FileOutputStream(this.cleanupEXE);
        FileUtils.copy(inputStream, fileOutputStream);
        inputStream.close();
        fileOutputStream.close();
        return this.cleanupEXE;
    }
}

