/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service.jvm;

import com.installshield.util.FileUtils;
import com.installshield.util.jvm.JVMFile;
import com.installshield.wizard.service.AbstractServiceImplementor;
import com.installshield.wizard.service.AsynchronousOperation;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.jvm.JVMServiceImplementor;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Hashtable;

public class PureJavaJVMServiceImpl
extends AbstractServiceImplementor
implements JVMServiceImplementor {
    private Hashtable jvmEntries = new Hashtable();
    private String verifyClassName = null;
    private String verifyClassDir = null;
    private String launcherFileName = null;

    public void associateCurrentJVM(String string) throws ServiceException {
        if (!this.isCurrentJVMDefined()) {
            throw new ServiceException(399, "current JVM is not defined");
        }
        this.jvmEntries.put(string, this.getCurrentJVMFile());
    }

    public void associateJVM(String string, String string2) throws ServiceException {
        this.jvmEntries.put(string, string2);
    }

    public void copyCurrentJVM(String string, String string2) throws ServiceException {
        String string3 = this.getCurrentJVMFile();
        String string4 = this.getCurrentJVMHome();
        if (string4 == null) {
            if (string3 != null) {
                throw new ServiceException(315, "current JVM file " + string3 + " does not exist or does not contain a JVM_HOME entry");
            }
            throw new ServiceException(315, "no current JVM");
        }
        this.logDebugEvent("copying directory " + string4 + " to " + string2);
        FileService fileService = (FileService)this.getServices().getService("fileService");
        fileService.copyDirectory(string4, string2, true, true);
        String string5 = FileUtils.getName(string3);
        File file = new File(string2, string5);
        if (!file.exists()) {
            throw new ServiceException(315, "expected JVM file to be " + file.getAbsolutePath());
        }
        String string6 = FileUtils.normalizeFileName(file.getAbsolutePath());
        String string7 = FileUtils.normalizeFileName(string2);
        this.updateJVMHome(string6, string7);
        this.jvmEntries.put(string, string6);
    }

    private String createInstallInput(String string, String string2, String string3) throws ServiceException {
        try {
            String string4 = FileUtils.createTempFile();
            FileOutputStream fileOutputStream = new FileOutputStream(string4);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            bufferedWriter.write("ACTION: INSTALL_JVM");
            bufferedWriter.newLine();
            bufferedWriter.write("INSTALL_JVM_EXE: " + string + " " + string2);
            bufferedWriter.newLine();
            bufferedWriter.write("INSTALL_JVM_DEST: " + string3);
            bufferedWriter.newLine();
            bufferedWriter.write("SHOW_PROGRESS: 0");
            bufferedWriter.newLine();
            bufferedWriter.write("SHOW_FAIL_MSG: 0");
            bufferedWriter.newLine();
            if (System.getProperty("is.debug") != null) {
                bufferedWriter.write("LOGFILE: jvminst.log");
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            fileOutputStream.close();
            return string4;
        }
        catch (IOException iOException) {
            throw new ServiceException(315, "could not write JVM search input file: " + iOException);
        }
    }

    private String createSearchInput(String[] stringArray) throws ServiceException {
        String string;
        try {
            string = FileUtils.createTempFile();
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("JVM:");
            bufferedWriter.newLine();
            int n = 0;
            while (n < stringArray.length) {
                try {
                    URL uRL = this.getResource(stringArray[n]);
                    bufferedWriter.write(FileUtils.createTempFile(uRL));
                    bufferedWriter.newLine();
                }
                catch (IOException iOException) {
                    throw new ServiceException(315, "cannot find JVMFile resource " + stringArray[n]);
                }
                ++n;
            }
            bufferedWriter.write("/:");
            bufferedWriter.newLine();
            bufferedWriter.write("ACTION: SEARCH");
            bufferedWriter.newLine();
            bufferedWriter.write("SHOW_PROGRESS: 0");
            bufferedWriter.newLine();
            bufferedWriter.write("SHOW_FAIL_MSG: 0");
            bufferedWriter.newLine();
            bufferedWriter.write("VERIFY_CLASS_DIR: \"\"\"" + this.verifyClassDir + "\"\"\"");
            bufferedWriter.newLine();
            bufferedWriter.write("VERIFY_CLASS_NAME: " + this.verifyClassName);
            bufferedWriter.newLine();
            if (System.getProperty("is.debug") != null) {
                bufferedWriter.write("LOGFILE: jvmfind.log");
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new ServiceException(315, "could not write JVM search input file: " + iOException);
        }
        return string;
    }

    public OperationKey findJVM(String string, String[] stringArray) throws ServiceException {
        this.verifyLauncher();
        this.verifyVerifyClass();
        String string2 = this.createSearchInput(stringArray);
        JVMFinder jVMFinder = new JVMFinder(string, string2, this);
        this.startOperation(jVMFinder);
        return jVMFinder.getKey();
    }

    public String getCurrentJVMFile() throws ServiceException {
        String string = System.getProperty("is.jvm.file");
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    public String getCurrentJVMHome() throws ServiceException {
        String string = this.getCurrentJVMFile();
        return new JVMFile(string).getHome();
    }

    public String getJVMFile(String string) throws ServiceException {
        return (String)this.jvmEntries.get(string);
    }

    public String getJVMHome(String string) throws ServiceException {
        String string2 = this.getJVMFile(string);
        return string2 != null ? new JVMFile(string2).getHome() : null;
    }

    public String getPlatformId() throws ServiceException {
        return "";
    }

    protected String getPlatformLauncherResource() throws ServiceException {
        throw new ServiceException(305);
    }

    public int getSystemCompatibility() {
        return 1;
    }

    protected String getVerifyClassResource() throws ServiceException {
        throw new ServiceException(305);
    }

    public OperationKey installJVM(String string, String string2, String string3, String string4) throws ServiceException {
        Object object;
        String string5;
        try {
            string5 = FileUtils.createTempFile(this.getResource(string2), FileUtils.getName(string2));
            object = (FileService)this.getServices().getService("fileService");
            object.setFileExecutable(string5);
        }
        catch (IOException iOException) {
            throw new ServiceException(315, "cannot write JVM installer resource " + string2);
        }
        this.verifyLauncher();
        object = this.createInstallInput(string5, string3, string4);
        JVMInstaller jVMInstaller = new JVMInstaller(string, string4, (String)object, this);
        this.startOperation(jVMInstaller);
        return jVMInstaller.getKey();
    }

    public boolean isCurrentJVMDefined() throws ServiceException {
        return this.getCurrentJVMFile() != null && this.getCurrentJVMHome() != null;
    }

    public boolean isCurrentJVMTemporary() throws ServiceException {
        String string = System.getProperty("is.jvm.temp");
        return (string == null || string.equals("0")) ^ true;
    }

    public boolean isJVMDefined(String string) throws ServiceException {
        return this.getJVMFile(string) != null && this.getJVMHome(string) != null;
    }

    private void logDebugEvent(String string) {
        this.logEvent(this, WizardLog.subclassEvent("dbg", "jvm"), string);
    }

    protected void logEvent(Object object, String string, Object object2) {
        super.logEvent(object, string, object2);
    }

    public int uninstallJVM(String string) throws ServiceException {
        FileService fileService = (FileService)this.getServices().getService("fileService");
        this.logDebugEvent("uninstalling JVM from " + string);
        return fileService.deleteDirectory(string, false, true);
    }

    private void updateJVMHome(String string, String string2) throws ServiceException {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(byteArrayOutputStream));
            this.logDebugEvent("JVM_HOME = " + string2);
            bufferedWriter.write("JVM_HOME: " + string2);
            bufferedWriter.newLine();
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                if (!string3.trim().startsWith("JVM_HOME:")) {
                    bufferedWriter.write(string3);
                    bufferedWriter.newLine();
                }
                string3 = bufferedReader.readLine();
            }
            fileReader.close();
            bufferedWriter.flush();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new ServiceException(315, "cannot update JVM_HOME in " + string + ": " + iOException);
        }
    }

    private void verifyLauncher() throws ServiceException {
        if (this.launcherFileName == null) {
            String string = this.getPlatformLauncherResource();
            try {
                this.launcherFileName = FileUtils.createTempFile(this.getResource(string), FileUtils.getName(string));
                FileService fileService = (FileService)this.getServices().getService("fileService");
                fileService.setFileExecutable(this.launcherFileName);
            }
            catch (IOException iOException) {
                throw new ServiceException(315, "cannot write launcher resource " + string + ": " + iOException);
            }
        }
    }

    private void verifyVerifyClass() throws ServiceException {
        if (this.verifyClassName == null) {
            String string = this.getVerifyClassResource();
            try {
                String string2 = FileUtils.getName(string);
                String string3 = FileUtils.createTempFile(this.getResource(string), string2);
                File file = new File(string3);
                this.verifyClassDir = file.getParent();
                this.verifyClassName = string2.lastIndexOf(46) >= 0 ? string2.substring(0, string2.lastIndexOf(46)) : string2;
            }
            catch (IOException iOException) {
                throw new ServiceException(315, "cannot write verify class resource " + string + ": " + iOException);
            }
        }
    }

    private class JVMInstaller
    extends AsynchronousOperation {
        private String jvmId;
        private String targetDirectory;
        private String inputFile;

        JVMInstaller(String string, String string2, String string3, AbstractServiceImplementor abstractServiceImplementor) {
            super("JVM installer for " + string, abstractServiceImplementor);
            this.jvmId = string;
            this.targetDirectory = string2;
            this.inputFile = string3;
        }

        public void execute() {
            block5: {
                File file = new File(this.targetDirectory);
                if (!file.exists() && !file.mkdirs()) {
                    PureJavaJVMServiceImpl.this.logEvent(this, "err", "cannot create JVM target directory");
                }
                if (!file.exists()) break block5;
                try {
                    PureJavaJVMServiceImpl.this.logDebugEvent("installing JVM to " + file.getAbsolutePath());
                    Process process = Runtime.getRuntime().exec(new String[]{PureJavaJVMServiceImpl.this.launcherFileName, "-is:in", this.inputFile});
                    InputStream inputStream = process.getInputStream();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    String string = null;
                    String string2 = null;
                    do {
                        if ((string2 = bufferedReader.readLine()) == null || string2.length() <= 0) continue;
                        string = string2;
                    } while (string2 != null);
                    if (string != null) {
                        PureJavaJVMServiceImpl.this.jvmEntries.put(this.jvmId, string);
                    }
                }
                catch (IOException iOException) {
                    PureJavaJVMServiceImpl.this.logEvent(iOException, "err", iOException);
                }
            }
        }
    }

    private class JVMFinder
    extends AsynchronousOperation {
        private String jvmId;
        private String inputFile;

        JVMFinder(String string, String string2, AbstractServiceImplementor abstractServiceImplementor) {
            super("JVM finder for " + string, abstractServiceImplementor);
            this.jvmId = string;
            this.inputFile = string2;
        }

        public void execute() {
            if (PureJavaJVMServiceImpl.this.jvmEntries.containsKey(this.jvmId)) {
                PureJavaJVMServiceImpl.this.jvmEntries.remove(this.jvmId);
            }
            try {
                PureJavaJVMServiceImpl.this.logDebugEvent("executing launcher to resolve JVM");
                Process process = Runtime.getRuntime().exec(new String[]{PureJavaJVMServiceImpl.this.launcherFileName, "-is:in", this.inputFile});
                InputStream inputStream = process.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                PureJavaJVMServiceImpl.this.logDebugEvent("waiting to read output from the launcher");
                String string = bufferedReader.readLine();
                PureJavaJVMServiceImpl.this.logDebugEvent("got output from launcher. First line = " + string);
                if (string != null && !string.equals("0")) {
                    PureJavaJVMServiceImpl.this.logDebugEvent("found matching JVM");
                    String string2 = bufferedReader.readLine();
                    if (string2 != null) {
                        PureJavaJVMServiceImpl.this.logDebugEvent("matching JVM HOME is " + string2);
                        String string3 = bufferedReader.readLine();
                        if (string3 != null) {
                            PureJavaJVMServiceImpl.this.logDebugEvent("matching JVM file is " + string3);
                            PureJavaJVMServiceImpl.this.jvmEntries.put(this.jvmId, string3);
                            try {
                                SystemUtilService systemUtilService = (SystemUtilService)PureJavaJVMServiceImpl.this.getServices().getService("systemUtilService");
                                systemUtilService.deleteFileOnExit(string3);
                            }
                            catch (ServiceException serviceException) {
                                PureJavaJVMServiceImpl.this.logEvent(this, "wrn", serviceException);
                            }
                        }
                    }
                } else {
                    PureJavaJVMServiceImpl.this.logDebugEvent("unable to find matching JVM");
                }
            }
            catch (IOException iOException) {
                PureJavaJVMServiceImpl.this.logEvent(this, "err", iOException);
            }
        }
    }
}

