/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.actions;

import com.installshield.util.FileUtils;
import com.installshield.wizard.RunnableWizardBeanState;
import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ExecWizardAction
extends WizardAction
implements Runnable {
    public final int NOT_STARTED = 0;
    public final int STARTED = 1;
    public final int FINISHED = 2;
    private String command;
    private String[] arguments = new String[0];
    private String stdoutDestination;
    private String stderrDestination;
    private boolean waitForCompletion = true;
    private String description;
    private transient int returnValue;
    private transient int status = 0;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        if (!new File(this.command).exists()) {
            wizardBuilderSupport.logEvent(this, "err", "Executable: " + this.command + " does not exist.  " + "Unable to build" + this.getClass().getName());
            return;
        }
        try {
            String string = String.valueOf(this.getBeanId()) + File.separator + new File(FileUtils.normalizeFileName(this.command)).getName();
            wizardBuilderSupport.putClass(this.getClass().getName());
            wizardBuilderSupport.putResource(this.command, string);
            wizardBuilderSupport.putRequiredService("fileService");
        }
        catch (Exception exception) {
            wizardBuilderSupport.logEvent(this, "err", "Unable to build " + this.getClass().getName());
        }
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        RunnableWizardBeanState runnableWizardBeanState = this.getState();
        runnableWizardBeanState.setTitle("Exec Action");
        if (this.description.equals("")) {
            this.description = " ";
        }
        runnableWizardBeanState.setStatusDescription(this.description);
        this.status = 0;
        if (!this.waitForCompletion) {
            Thread thread = new Thread(this);
            thread.setPriority(1);
            thread.start();
        } else {
            this.executeProcess();
        }
    }

    private void executeProcess() {
        try {
            String[] stringArray = new String[this.arguments.length + 1];
            stringArray[0] = this.getProcessRuntimeLocation();
            int n = 1;
            while (n < stringArray.length) {
                stringArray[n] = this.resolveString(this.arguments[n - 1]);
                ++n;
            }
            Process process = Runtime.getRuntime().exec(stringArray);
            this.status = 1;
            process.waitFor();
            this.returnValue = process.exitValue();
            this.status = 2;
            this.processOutputData(process.getInputStream());
            this.processErrorData(process.getErrorStream());
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDescription() {
        return this.description;
    }

    private String getProcessRuntimeLocation() throws ServiceException {
        String string = null;
        String string2 = FileUtils.normalizeFileName(this.command);
        String string3 = new File(string2).getName();
        try {
            string = FileUtils.createTempFile(this.getResource(String.valueOf(this.getBeanId()) + File.separator + string3), FileUtils.getName(string3));
            FileService fileService = (FileService)this.getServices().getService("fileService");
            fileService.setFileExecutable(string);
        }
        catch (IOException iOException) {
            throw new ServiceException(315, "cannot extract executable " + string3 + ": " + iOException);
        }
        return string;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStderrDestination() {
        return this.stderrDestination;
    }

    public String getStdoutDestination() {
        return this.stdoutDestination;
    }

    public boolean isWaitForCompletion() {
        return this.waitForCompletion;
    }

    protected void processErrorData(InputStream inputStream) {
        this.writeData(inputStream, this.resolveString(this.stderrDestination));
    }

    protected void processOutputData(InputStream inputStream) {
        this.writeData(inputStream, this.resolveString(this.stdoutDestination));
    }

    public void run() {
        this.executeProcess();
    }

    public void setArguments(String[] stringArray) {
        this.arguments = stringArray;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setStderrDestination(String string) {
        this.stderrDestination = string;
    }

    public void setStdoutDestination(String string) {
        this.stdoutDestination = string;
    }

    public void setWaitForCompletion(boolean bl) {
        this.waitForCompletion = bl;
    }

    private void writeData(InputStream inputStream, String string) {
        try {
            if (string != null && string.length() > 0) {
                String string2;
                Object object;
                int n = string.lastIndexOf(File.separator);
                if (n != -1 && !((File)(object = new File(string.substring(0, n + 1)))).isDirectory()) {
                    ((File)object).mkdir();
                }
                object = new BufferedWriter(new FileWriter(new File(string)));
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string2 = bufferedReader.readLine()) != null) {
                    ((BufferedWriter)object).write(string2, 0, string2.length());
                    ((BufferedWriter)object).newLine();
                }
                ((BufferedWriter)object).close();
                bufferedReader.close();
                inputStream.close();
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }
}

