/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.wizard.WizardException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.SearchResult;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ModifyFile {
    static final int NONE = -1;
    static final int BEGINNING = 0;
    static final int END = 1;
    static final int BEFOREFIRST = 2;
    static final int BEFORELAST = 3;
    static final int BEFOREEVERY = 4;
    static final int AFTERFIRST = 5;
    static final int AFTERLAST = 6;
    static final int AFTEREVERY = 7;
    static final int DONOTHING = 8;
    static final int ALWAYS = 0;
    static final int NEVER = 1;
    static final int IFGREATER = 2;
    public static final int FIRST = 0;
    public static final int LAST = 1;
    public static final int EVERY = 2;
    public static final int BEG_LINE = 0;
    public static final int END_LINE = 1;
    public static final int BEG_TOKEN = 2;
    public static final int END_TOKEN = 3;
    public static final int LAST_TOKEN = 4;
    public static final int BEG_FILE = 0;
    public static final int END_FILE = 1;
    public static final int NO_ACTION = 2;
    public static final int APPEND = 0;
    public static final int PREPEND = 1;
    public static final int REPLACE = 2;
    public static final int DELETE = 3;
    private AsciiFileUpdateSupport support;
    private String fieldFile = new String();
    private boolean caseSensitive = false;
    private int occurrenceFrequency = 0;
    private int returnPosition = 2;
    private int tokensNotFound = 2;
    private Vector match = new Vector();
    private Vector logAdd = new Vector();
    private SearchResult[] results = null;
    private Vector allLines = new Vector();
    private String backUpFile = null;
    private String commentChar = null;
    private FileService fileService = null;
    private int location = 0;
    private boolean includeSearchLines = true;
    private boolean ignoreCommentLines = true;
    private boolean overwriteExisting = false;

    public ModifyFile(AsciiFileUpdateSupport asciiFileUpdateSupport) {
        this.support = asciiFileUpdateSupport;
    }

    public void addComment() {
        SearchResult[] searchResultArray = this.getASCIISearchResults();
        if (searchResultArray != null) {
            int n = 0;
            while (n < searchResultArray.length) {
                int n2 = searchResultArray[n].getLineNum();
                int n3 = searchResultArray[n].getPosition();
                String string = (String)this.getAllLines().elementAt(n2);
                String string2 = n3 == 0 ? this.getCommentChar().concat(string) : (n3 >= string.length() ? string.concat(this.getCommentChar()) : String.valueOf(string.substring(0, n3)) + this.getCommentChar() + string.substring(n3));
                this.getAllLines().setElementAt(string2, n2);
                this.getLogAdd().addElement("/ADD COMMENT/");
                ++n;
            }
        }
    }

    public void addCommentLine(String[] stringArray) {
        SearchResult[] searchResultArray = this.getASCIISearchResults();
        if (searchResultArray != null) {
            int n = searchResultArray.length - 1;
            while (n >= 0) {
                int n2 = searchResultArray[n].getLineNum();
                int n3 = searchResultArray[n].getPosition();
                String string = !this.getAllLines().isEmpty() ? (String)this.getAllLines().elementAt(n2) : new String();
                if (n3 == 0) {
                    this.addCommentLineAt(stringArray, n2);
                } else if (n3 >= string.length()) {
                    this.addCommentLineAt(stringArray, n2 + 1);
                } else {
                    String string2 = string.substring(0, n3);
                    String string3 = string.substring(n3);
                    this.getAllLines().setElementAt(string2, n2);
                    this.getAllLines().insertElementAt(string3, n2 + 1);
                    this.addCommentLineAt(stringArray, n2 + 1);
                }
                --n;
            }
        }
    }

    public void addCommentLineAt(String[] stringArray, int n) {
        String string = this.getCommentChar();
        if (string == null) {
            string = "";
        }
        if (string.length() > 0 && !string.endsWith(" ")) {
            string = String.valueOf(string) + " ";
        }
        if (stringArray.length > 1) {
            this.getLogAdd().addElement("/ADD COMMENT LINE AT LINE " + n + "/");
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.getLogAdd().addElement(String.valueOf(string) + stringArray[n2]);
                this.getAllLines().insertElementAt(String.valueOf(string) + stringArray[n2], n++);
                ++n2;
            }
        } else if (stringArray.length == 1) {
            this.getLogAdd().addElement("/ADD COMMENT LINE AT LINE " + n + "/");
            this.getLogAdd().addElement(String.valueOf(string) + stringArray[0]);
            this.getAllLines().insertElementAt(String.valueOf(string) + stringArray[0], n);
        }
    }

    public void addLine(String[] stringArray) {
        SearchResult[] searchResultArray = this.getASCIISearchResults();
        if (searchResultArray != null) {
            int n = searchResultArray.length - 1;
            while (n >= 0) {
                int n2 = searchResultArray[n].getLineNum();
                int n3 = searchResultArray[n].getPosition();
                String string = !this.getAllLines().isEmpty() ? (String)this.getAllLines().elementAt(n2) : new String();
                if (n3 == 0) {
                    this.addLineAt(stringArray, n2);
                } else if (n3 >= string.length()) {
                    this.addLineAt(stringArray, n2 + 1);
                } else {
                    String string2 = string.substring(0, n3);
                    String string3 = string.substring(n3);
                    this.getAllLines().setElementAt(string2, n2);
                    this.getAllLines().insertElementAt(string3, n2 + 1);
                    this.addLineAt(stringArray, n2 + 1);
                }
                --n;
            }
        }
    }

    public void addLineAt(String[] stringArray, int n) {
        if (stringArray.length > 1) {
            this.getLogAdd().addElement("/ADD LINES AT LINE " + n + "/");
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.getLogAdd().addElement(stringArray[n2]);
                this.getAllLines().insertElementAt(stringArray[n2], n++);
                ++n2;
            }
        } else if (stringArray.length == 1) {
            this.getLogAdd().addElement("/ADD LINE AT LINE " + n + "/");
            this.getLogAdd().addElement(stringArray[0]);
            this.getAllLines().insertElementAt(stringArray[0], n);
        }
    }

    public void addText(String[] stringArray) {
        SearchResult[] searchResultArray = this.getASCIISearchResults();
        if (searchResultArray != null) {
            int n = searchResultArray.length - 1;
            while (n >= 0) {
                int n2 = searchResultArray[n].getLineNum();
                int n3 = searchResultArray[n].getPosition();
                this.addTextAt(stringArray, n2, n3);
                --n;
            }
        }
    }

    public void addTextAt(String[] stringArray, int n, int n2) {
        if (stringArray.length > 0) {
            String string;
            boolean bl;
            String string2 = stringArray[0];
            String string3 = new String();
            this.getLogAdd().addElement("/ADD TEXT AT LINE: " + n + " POSITION: " + n2 + "/");
            this.getLogAdd().addElement(string2);
            String string4 = !this.getAllLines().isEmpty() ? (String)this.getAllLines().elementAt(n) : new String();
            boolean bl2 = bl = stringArray.length > 1;
            if (n2 == 0) {
                if (bl) {
                    string = string2;
                    string3 = string4;
                } else {
                    string = string2.concat(string4);
                }
            } else if (n2 >= string4.length()) {
                string = string4.concat(string2);
            } else if (bl) {
                string = String.valueOf(string4.substring(0, n2)) + string2;
                string3 = string4.substring(n2);
            } else {
                string = String.valueOf(string4.substring(0, n2)) + string2 + string4.substring(n2);
            }
            this.getLogAdd().addElement(string);
            if (!this.getAllLines().isEmpty()) {
                this.getAllLines().setElementAt(string, n);
            } else {
                this.getAllLines().addElement(string);
            }
            int n3 = 1;
            while (n3 < stringArray.length) {
                String string5 = stringArray[n3];
                if (n3 + 1 == stringArray.length) {
                    string5 = string5.concat(string3);
                }
                this.getLogAdd().addElement(string5);
                this.getAllLines().insertElementAt(string5, ++n);
                ++n3;
            }
        }
    }

    public boolean areMatches() {
        return this.getASCIISearchResults() != null && this.getASCIISearchResults().length > 0;
    }

    public void backupFile() throws WizardException {
        if (this.backUpFile == null) {
            this.backUpFile = this.getFile();
            int n = this.getFile().lastIndexOf(".");
            if (n > -1) {
                this.backUpFile = this.getFile().substring(0, n);
            }
            File file = null;
            boolean bl = false;
            int n2 = 0;
            while (n2 < 999 && !bl) {
                file = new File(String.valueOf(this.backUpFile) + "." + this.threeDigitExtension(n2));
                if (!file.exists()) {
                    bl = true;
                    this.backUpFile = String.valueOf(this.backUpFile) + "." + this.threeDigitExtension(n2);
                }
                ++n2;
            }
            if (!bl) {
                this.backUpFile = String.valueOf(this.backUpFile) + ".000";
            }
            try {
                this.fileService.copyFile(this.getFile(), this.backUpFile, true);
                this.getLogAdd().addElement("ASCII file backed up to " + this.backUpFile + ".");
            }
            catch (ServiceException serviceException) {
                this.support.logEvent(this, "wrn", "Could not backup the ASCII file " + this.getFile() + ".");
                throw new WizardException(serviceException);
            }
        }
    }

    public void deleteLine() {
        SearchResult[] searchResultArray = this.getASCIISearchResults();
        if (searchResultArray != null) {
            int n = searchResultArray.length - 1;
            while (n >= 0) {
                int n2 = searchResultArray[n].getLineNum();
                this.getLogAdd().addElement("/DELETE LINE: " + n2 + "/");
                this.getLogAdd().addElement(this.getAllLines().elementAt(n2));
                this.getAllLines().removeElementAt(n2);
                --n;
            }
        }
    }

    public void deleteLinesBetween(int n, int n2) {
        int n3;
        int n4;
        if (this.getIncludeSearchLines()) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = n + 1;
            n3 = n2 - 1;
        }
        if (n3 >= n4) {
            this.getLogAdd().addElement("/DELETE LINES BETWEEN LINE: " + n4 + " AND LINE: " + n3 + "/");
            int n5 = n4;
            while (n5 <= n3) {
                this.getLogAdd().addElement(this.getAllLines().elementAt(n4));
                this.getAllLines().removeElementAt(n4);
                ++n5;
            }
        }
    }

    public boolean deleteText(String string) {
        SearchResult[] searchResultArray = this.getASCIISearchResults();
        boolean bl = false;
        if (searchResultArray != null) {
            int n = 0;
            while (n < searchResultArray.length) {
                this.getLogAdd().addElement("/DELETE TEXT/");
                int n2 = searchResultArray[n].getLineNum();
                int n3 = searchResultArray[n].getPosition();
                String string2 = (String)this.getAllLines().elementAt(n2);
                int n4 = string2.indexOf(string, n3);
                if (n4 == -1) {
                    this.getLogAdd().addElement("Could not find text: " + string + " on line: " + n2 + " after position: " + n3);
                } else {
                    String string3 = n4 > 0 ? string2.substring(0, n4) : new String();
                    if (n4 + string.length() < string2.length()) {
                        string3 = string3.concat(string2.substring(n4 + string.length()));
                    }
                    this.getLogAdd().addElement("Deleted text: " + string + " on line: " + n2 + " at position: " + n4);
                    this.getAllLines().setElementAt(string3, n2);
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    public SearchResult endOfFile() {
        if (this.getAllLines().isEmpty()) {
            return this.startOfFile();
        }
        return new SearchResult(this.getAllLines().size() - 1, this.getAllLines().lastElement().toString().length());
    }

    public SearchResult[] getASCIISearchResults() {
        return this.results;
    }

    public Vector getAllLines() {
        return this.allLines;
    }

    public String getBackUpFile() {
        return this.backUpFile;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public String getCommentChar() {
        return this.commentChar;
    }

    public String getFile() {
        return this.fieldFile;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public boolean getIgnoreCommentLines() {
        return this.ignoreCommentLines;
    }

    public boolean getIncludeSearchLines() {
        return this.includeSearchLines;
    }

    public int getLocation() {
        return this.location;
    }

    public Vector getLogAdd() {
        return this.logAdd;
    }

    public Vector getMatch() {
        return this.match;
    }

    public int getOccurrenceFrequency() {
        return this.occurrenceFrequency;
    }

    public boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    public int getReturnPosition() {
        return this.returnPosition;
    }

    public int getTokensNotFound() {
        return this.tokensNotFound;
    }

    public boolean loadFile() throws WizardException {
        boolean bl = false;
        this.getAllLines().removeAllElements();
        try {
            bl = this.fileService.fileExists(this.getFile());
            String[] stringArray = new String[]{};
            if (bl && !this.overwriteExisting) {
                stringArray = this.fileService.readAsciiFile(this.getFile());
                this.getLogAdd().addElement("Reading in ASCII file " + this.getFile() + ".");
            } else if (!bl) {
                this.getLogAdd().addElement("ASCII file " + this.getFile() + " does not exist and will be created.");
            } else {
                this.getLogAdd().addElement("ASCII file " + this.getFile() + " will be overwritten.");
            }
            int n = 0;
            while (n < stringArray.length) {
                this.getAllLines().addElement(stringArray[n]);
                ++n;
            }
        }
        catch (ServiceException serviceException) {
            throw new WizardException(serviceException);
        }
        return bl;
    }

    public void logChanges() {
        Enumeration enumeration = this.getLogAdd().elements();
        while (enumeration.hasMoreElements()) {
            this.support.logEvent(this, "msg2", enumeration.nextElement());
        }
    }

    public void replaceLine(String[] stringArray) {
        SearchResult[] searchResultArray = this.getASCIISearchResults();
        if (searchResultArray != null) {
            int n = searchResultArray.length - 1;
            while (n >= 0) {
                int n2 = searchResultArray[n].getLineNum();
                this.replaceLineAt(stringArray, n2);
                --n;
            }
        }
    }

    public void replaceLineAt(String[] stringArray, int n) {
        if (stringArray.length > 0) {
            this.getLogAdd().addElement("/REPLACE LINE: " + n + "/");
            if (this.getAllLines().size() > 0) {
                this.getAllLines().removeElementAt(n);
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.getLogAdd().addElement(stringArray[n2]);
                this.getAllLines().insertElementAt(stringArray[n2], n++);
                ++n2;
            }
        }
    }

    public boolean replaceText(String string, String[] stringArray) {
        boolean bl = false;
        if (stringArray.length > 0) {
            SearchResult[] searchResultArray = this.getASCIISearchResults();
            String string2 = stringArray[0];
            if (searchResultArray != null) {
                int n = searchResultArray.length - 1;
                while (n >= 0) {
                    int n2 = searchResultArray[n].getLineNum();
                    int n3 = searchResultArray[n].getPosition();
                    String string3 = this.getAllLines().size() > 0 ? (String)this.getAllLines().elementAt(n2) : "";
                    this.getLogAdd().addElement("/REPLACE TEXT: " + string + " ON LINE: " + n2 + "/");
                    int n4 = string3.indexOf(string, n3);
                    if (n4 != -1) {
                        String string4;
                        if (stringArray.length == 1) {
                            string4 = n4 == 0 ? string2.concat(string3.substring(string.length())) : (n4 + string.length() >= string3.length() ? string3.substring(0, n4).concat(string2) : String.valueOf(string3.substring(0, n4)) + string2 + string3.substring(n4 + string.length()));
                            this.getLogAdd().addElement(string4);
                            this.getAllLines().setElementAt(string4, n2);
                        } else {
                            String string5 = null;
                            String string6 = stringArray[stringArray.length - 1];
                            if (n4 == 0) {
                                string4 = string2;
                                string5 = string3.substring(string.length()).concat(string6);
                            } else if (n4 + string.length() >= string3.length()) {
                                string4 = string3.substring(0, n4).concat(string2);
                                string5 = string6;
                            } else {
                                string4 = String.valueOf(string3.substring(0, n4)) + string2;
                                string5 = string3.substring(n4 + string.length()).concat(string6);
                            }
                            this.getLogAdd().addElement(string4);
                            this.getAllLines().setElementAt(string4, n2++);
                            int n5 = n;
                            while (n5 < stringArray.length - 1) {
                                this.getLogAdd().addElement(stringArray[n5]);
                                this.getAllLines().insertElementAt(stringArray[n5], n2++);
                                ++n5;
                            }
                            if (string5 != null) {
                                this.getLogAdd().addElement(string5);
                                this.getAllLines().insertElementAt(string5, n2);
                            }
                        }
                        bl = true;
                    } else {
                        this.getLogAdd().addElement("Could not find text: " + string + " after position: " + n3 + ".");
                    }
                    --n;
                }
            }
        }
        return bl;
    }

    public String resolveString(String string) {
        return this.support.resolveString(string);
    }

    public void searchMultipleStrings() {
        Object[] objectArray;
        Vector<SearchResult> vector = new Vector<SearchResult>();
        String string = new String();
        String string2 = new String();
        int n = 0;
        int n2 = -1;
        boolean bl = true;
        int n3 = 0;
        while (n3 < this.getAllLines().size()) {
            string = this.getAllLines().elementAt(n3).toString();
            if (!this.getIgnoreCommentLines() || this.getCommentChar().length() <= 0 || !string.trim().startsWith(this.getCommentChar())) {
                bl = true;
                n2 = -1;
                n = 0;
                int n4 = 0;
                int n5 = 0;
                while (n5 < this.getMatch().size() && bl) {
                    if (this.getCaseSensitive()) {
                        string2 = this.getMatch().elementAt(n5).toString();
                    } else {
                        string2 = this.getMatch().elementAt(n5).toString().toUpperCase();
                        string = string.toUpperCase();
                    }
                    int n6 = 0;
                    while (n6 != -1) {
                        n = string.indexOf(string2, n4);
                        n4 = n + string2.length();
                        n6 = n;
                        if (n != -1) {
                            if (n2 == -1) {
                                n2 = n;
                            }
                            if (n5 == this.getMatch().size() - 1) {
                                if (this.getReturnPosition() == 0) {
                                    n = 0;
                                } else if (this.getReturnPosition() == 1) {
                                    n = string.length();
                                } else if (this.getReturnPosition() == 3) {
                                    n += string2.length();
                                }
                                vector.addElement(new SearchResult(n3, n));
                                continue;
                            }
                            n += string2.length();
                            continue;
                        }
                        bl = false;
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        if (vector.isEmpty()) {
            if (this.getTokensNotFound() == 0) {
                vector.addElement(this.startOfFile());
            } else if (this.getTokensNotFound() == 1) {
                vector.addElement(this.endOfFile());
            }
        }
        if (vector.isEmpty()) {
            objectArray = null;
        } else if (this.getOccurrenceFrequency() == 0) {
            objectArray = new SearchResult[]{(SearchResult)vector.firstElement()};
        } else if (this.getOccurrenceFrequency() == 1) {
            objectArray = new SearchResult[]{(SearchResult)vector.lastElement()};
        } else {
            objectArray = new SearchResult[vector.size()];
            vector.copyInto(objectArray);
        }
        this.setASCIISearchResults((SearchResult[])objectArray);
    }

    public void searchStringsOnlyWhtSpc() {
        Object[] objectArray;
        Vector<SearchResult> vector = new Vector<SearchResult>();
        String string = new String();
        String string2 = new String();
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        boolean bl = true;
        int n4 = 0;
        while (n4 < this.getAllLines().size()) {
            string2 = this.getAllLines().elementAt(n4).toString();
            if (!this.getIgnoreCommentLines() || this.getCommentChar().length() <= 0 || !string2.trim().startsWith(this.getCommentChar())) {
                bl = true;
                n2 = -1;
                n3 = 0;
                n = 0;
                int n5 = 0;
                while (n5 < this.getMatch().size() && bl) {
                    if (this.getCaseSensitive()) {
                        string = this.getMatch().elementAt(n5).toString();
                    } else {
                        string = this.getMatch().elementAt(n5).toString().toUpperCase();
                        string2 = string2.toUpperCase();
                    }
                    n = string2.indexOf(string, n3);
                    if (n != -1) {
                        if (n2 == -1) {
                            n2 = n;
                        }
                        if (n > n3 && string2.substring(n3, n).trim().length() != 0) {
                            bl = false;
                        }
                        n3 = n + string.length();
                        if (bl && n5 == this.getMatch().size() - 1) {
                            if (this.getReturnPosition() == 0) {
                                n = 0;
                            } else if (this.getReturnPosition() == 1) {
                                n = string2.length();
                            } else if (this.getReturnPosition() == 3) {
                                n = n3;
                            } else if (this.getReturnPosition() == 2) {
                                n = n2;
                            }
                            vector.addElement(new SearchResult(n4, n));
                        }
                    } else {
                        bl = false;
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        if (vector.isEmpty()) {
            if (this.getTokensNotFound() == 0) {
                vector.addElement(this.startOfFile());
            } else if (this.getTokensNotFound() == 1) {
                vector.addElement(this.endOfFile());
            }
        }
        if (vector.isEmpty()) {
            objectArray = null;
        } else if (this.getOccurrenceFrequency() == 0) {
            objectArray = new SearchResult[]{(SearchResult)vector.firstElement()};
        } else if (this.getOccurrenceFrequency() == 1) {
            objectArray = new SearchResult[]{(SearchResult)vector.lastElement()};
        } else {
            objectArray = new SearchResult[vector.size()];
            vector.copyInto(objectArray);
        }
        this.setASCIISearchResults((SearchResult[])objectArray);
    }

    public void setASCIISearchResults(SearchResult[] searchResultArray) {
        this.results = searchResultArray;
    }

    public void setBackUpFile(String string) {
        this.backUpFile = string;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public void setCommentChar(String string) {
        this.commentChar = string;
    }

    public void setFile(String string) {
        this.fieldFile = string;
    }

    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    public void setIgnoreCommentLines(boolean bl) {
        this.ignoreCommentLines = bl;
    }

    public void setIncludeSearchLines(boolean bl) {
        this.includeSearchLines = bl;
    }

    public void setLocation(int n) {
        this.location = n;
    }

    public void setLogAdd(Vector vector) {
        this.logAdd = vector;
    }

    public void setMatch(Vector vector) {
        this.match = vector;
    }

    public void setOccurrenceFrequency(int n) {
        this.occurrenceFrequency = n;
    }

    public void setOverwriteExisting(boolean bl) {
        this.overwriteExisting = bl;
    }

    public void setReturnPosition(int n) {
        this.returnPosition = n;
    }

    public void setTokensNotFound(int n) {
        this.tokensNotFound = n;
    }

    public boolean setVariable(String string, String string2, String string3) {
        boolean bl = false;
        if (string3 == null || string3.length() == 0) {
            string3 = File.pathSeparator;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        vector.addElement("=");
        this.setMatch(vector);
        this.setOccurrenceFrequency(1);
        this.setReturnPosition(3);
        this.setTokensNotFound(2);
        this.setIgnoreCommentLines(true);
        this.searchStringsOnlyWhtSpc();
        SearchResult[] searchResultArray = this.getASCIISearchResults();
        if (searchResultArray != null && searchResultArray.length > 0) {
            StringTokenizer stringTokenizer2;
            String string4;
            int n = searchResultArray[0].getLineNum();
            int n2 = searchResultArray[0].getPosition();
            String string5 = (String)this.getAllLines().elementAt(n);
            String string6 = null;
            String string7 = string2.trim();
            boolean bl2 = true;
            if (this.getLocation() != 2) {
                while (bl2) {
                    bl2 = false;
                    if (string7.startsWith(string3)) {
                        string7 = string7.substring(1);
                        bl2 = true;
                    }
                    if (!string7.endsWith(string3)) continue;
                    string7 = string7.substring(0, string7.length() - 1);
                    bl2 = true;
                }
            }
            String string8 = " TO: ";
            if (this.getLocation() == 1) {
                string4 = "Prepend ";
            } else if (this.getLocation() == 0) {
                string4 = "Append ";
            } else if (this.getLocation() == 2) {
                string4 = "Replace ";
            } else {
                string8 = " FROM: ";
                string4 = "Delete ";
            }
            this.getLogAdd().addElement("/SET VARIABLE: " + string4 + string7 + string8 + string + "/");
            boolean bl3 = false;
            if (this.getLocation() == 2) {
                if (string7.equals(string5.substring(n2))) {
                    bl3 = true;
                }
            } else if (this.getLocation() == 3) {
                stringTokenizer2 = new StringTokenizer(string5.substring(n2), string3);
                boolean bl4 = false;
                while (stringTokenizer2.hasMoreTokens() && !bl4) {
                    String string9 = stringTokenizer2.nextToken();
                    if ((!this.getCaseSensitive() || !string9.trim().equals(string7)) && (this.getCaseSensitive() || !string9.trim().equalsIgnoreCase(string7))) continue;
                    bl4 = true;
                }
                bl3 = bl4 ^ true;
            } else {
                stringTokenizer2 = new StringTokenizer(string5.substring(n2), string3);
                while (stringTokenizer2.hasMoreTokens() && !bl3) {
                    String string10 = stringTokenizer2.nextToken();
                    if ((!this.getCaseSensitive() || !string10.trim().equals(string7)) && (this.getCaseSensitive() || !string10.trim().equalsIgnoreCase(string7))) continue;
                    bl3 = true;
                }
            }
            if (bl3) {
                this.getLogAdd().addElement("Variable is already set.");
            } else {
                if (this.getLocation() == 1) {
                    string6 = string5.substring(n2).trim().length() == 0 || string5.substring(n2).trim().startsWith(string3) ? String.valueOf(string5.substring(0, n2)) + string7 + string5.substring(n2).trim() : String.valueOf(string5.substring(0, n2)) + string7 + string3 + string5.substring(n2).trim();
                } else if (this.getLocation() == 0) {
                    string6 = string5.substring(n2).trim().length() == 0 || string5.trim().endsWith(string3) ? String.valueOf(string5.trim()) + string7 : String.valueOf(string5.trim()) + string3 + string7;
                } else if (this.getLocation() == 2) {
                    string6 = String.valueOf(string5.substring(0, n2)) + string7;
                } else {
                    string6 = string5.substring(0, n2);
                    stringTokenizer2 = new StringTokenizer(string5.substring(n2), string3);
                    while (stringTokenizer2.hasMoreTokens()) {
                        String string11 = stringTokenizer2.nextToken();
                        if (this.getCaseSensitive() && string11.trim().equals(string7) || !this.getCaseSensitive() && string11.trim().equalsIgnoreCase(string7)) continue;
                        string6 = string6.concat(String.valueOf(string11) + string3);
                    }
                }
                bl = true;
                this.getAllLines().setElementAt(string6, n);
            }
        } else {
            this.getLogAdd().addElement("/SET VARIABLE: " + string + "=" + string2.trim() + "/");
            this.getAllLines().addElement(String.valueOf(string) + "=" + string2.trim());
            bl = true;
        }
        return bl;
    }

    public SearchResult startOfFile() {
        return new SearchResult(0, 0);
    }

    private String threeDigitExtension(int n) {
        String string = Integer.toString(n);
        if (string.length() == 1) {
            string = "00" + string;
        } else if (string.length() == 2) {
            string = "0" + string;
        }
        return string;
    }

    public void writeFile() throws WizardException {
        Object[] objectArray = new String[this.getAllLines().size()];
        this.getAllLines().copyInto(objectArray);
        try {
            this.fileService.createAsciiFile(this.getFile(), (String[])objectArray);
        }
        catch (ServiceException serviceException) {
            this.support.logEvent(this, "err", "Could not write ASCII file " + this.getFile() + ".");
            throw new WizardException(serviceException);
        }
    }
}

