/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.BrowserAppletThreadGroup;
import ice.htmlbrowser.BrowserURLLoader;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class BrowserClassLoader
extends ClassLoader {
    BrowserAppletThreadGroup threadGroup;
    private URL codebase;
    private static Hashtable appletCache = new Hashtable();
    private static Hashtable loaderCache = new Hashtable();
    private Hashtable loadedJarFiles = new Hashtable();
    private Hashtable jarRAMDisk = new Hashtable();
    private String[] archiveList;

    BrowserClassLoader(String string) {
        if (string != null) {
            try {
                this.codebase = new URL(string);
                return;
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
        }
    }

    BrowserClassLoader(URL uRL) {
        this.codebase = uRL;
    }

    public static BrowserClassLoader getBrowserClassLoader(String string, String string2) {
        Hashtable hashtable = loaderCache;
        synchronized (hashtable) {
            Object v = loaderCache.get(string);
            if (v != null) {
                BrowserClassLoader browserClassLoader = (BrowserClassLoader)v;
                Object var4_6 = null;
                return browserClassLoader;
            }
            BrowserClassLoader browserClassLoader = new BrowserClassLoader(string2);
            loaderCache.put(string, browserClassLoader);
            BrowserClassLoader browserClassLoader2 = browserClassLoader;
            Object var4_7 = null;
            return browserClassLoader2;
        }
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        byte[] byArray;
        URL uRL = this.constructURL(string);
        String string2 = uRL != null ? new String(uRL.toString()) : new String(string);
        Class<?> clazz = (Class<?>)appletCache.get(string2);
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null && this.archiveList != null && (byArray = this.loadClassDataFromJAR(string)) != null) {
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            appletCache.put(string2, clazz);
        }
        if (clazz == null && uRL != null && (byArray = this.loadClassDataFromURL(string, uRL)) != null && (clazz = this.defineClass(string, byArray, 0, byArray.length)) != null) {
            appletCache.put(string2, clazz);
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class <" + string + "> not found anywhere");
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private synchronized byte[] loadClassDataFromJAR(String string) {
        URL uRL;
        String string2 = new String(string);
        if (string2.indexOf(".") >= 0) {
            string2 = string2.replace('.', '/');
        }
        string2 = String.valueOf(string2) + ".class";
        try {
            uRL = new URL(this.codebase, string2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        byte[] byArray = (byte[])this.jarRAMDisk.get(uRL);
        return byArray;
    }

    private synchronized byte[] loadClassDataFromURL(String string, URL uRL) throws ClassNotFoundException {
        BrowserURLLoader browserURLLoader = new BrowserURLLoader(uRL);
        byte[] byArray = null;
        try {
            byArray = browserURLLoader.loadURL();
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(iOException.getMessage());
        }
        return byArray;
    }

    Image getImage(URL uRL) {
        uRL.getProtocol();
        uRL.getFile();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = null;
        byte[] byArray = (byte[])this.jarRAMDisk.get(uRL);
        if (byArray != null && (image = toolkit.createImage(byArray)) != null) {
            return image;
        }
        BrowserURLLoader browserURLLoader = new BrowserURLLoader(uRL);
        image = browserURLLoader.getImage();
        return image;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadJar(URL uRL) {
        block18: {
            BufferedInputStream bufferedInputStream;
            InputStream inputStream;
            if (this.loadedJarFiles.get(uRL) != null) {
                return;
            }
            BrowserURLLoader browserURLLoader = new BrowserURLLoader(uRL);
            try {
                inputStream = browserURLLoader.getInputStream();
                bufferedInputStream = new BufferedInputStream(inputStream);
            }
            catch (Exception exception) {
                return;
            }
            inputStream = null;
            byte[] byArray = new byte[1024];
            try {
                try {
                    inputStream = new ZipInputStream(bufferedInputStream);
                    ZipEntry zipEntry = null;
                    while ((zipEntry = ((ZipInputStream)inputStream).getNextEntry()) != null) {
                        int n;
                        URL uRL2;
                        String string = zipEntry.getName();
                        try {
                            uRL2 = new URL(this.codebase, string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            malformedURLException.printStackTrace();
                            Object var8_13 = null;
                            if (inputStream == null) return;
                            try {
                                ((ZipInputStream)inputStream).close();
                                return;
                            }
                            catch (Exception exception) {}
                            return;
                        }
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        while ((n = ((FilterInputStream)inputStream).read(byArray)) >= 0) {
                            byteArrayOutputStream.write(byArray, 0, n);
                        }
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        this.jarRAMDisk.put(uRL2, byArray2);
                    }
                }
                catch (IOException iOException) {
                    Object var8_14 = null;
                    if (inputStream == null) return;
                    try {}
                    catch (Exception exception) {}
                    ((ZipInputStream)inputStream).close();
                    return;
                }
                catch (Throwable throwable) {
                    Object var8_15 = null;
                    if (inputStream == null) return;
                    try {}
                    catch (Exception exception) {}
                    ((ZipInputStream)inputStream).close();
                    return;
                }
                Object var8_16 = null;
                if (inputStream == null) break block18;
            }
            catch (Throwable throwable) {
                Object var8_17 = null;
                if (inputStream == null) throw throwable;
                try {}
                catch (Exception exception) {}
                ((ZipInputStream)inputStream).close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            ((ZipInputStream)inputStream).close();
        }
        this.loadedJarFiles.put(uRL, uRL);
    }

    private URL constructURL(String string) {
        URL uRL = null;
        if (string.indexOf(".") >= 0) {
            string = string.replace('.', '/');
        }
        if (this.codebase == null) {
            try {
                uRL = new URL(String.valueOf(string) + ".class");
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        try {
            uRL = new URL(this.codebase, String.valueOf(string) + ".class");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return uRL;
    }

    void setArchiveList(String[] stringArray) {
        this.archiveList = stringArray;
        int n = 0;
        while (n < stringArray.length) {
            try {
                URL uRL = new URL(this.codebase, stringArray[n]);
                this.loadJar(uRL);
            }
            catch (MalformedURLException malformedURLException) {}
            ++n;
        }
    }

    synchronized ThreadGroup getThreadGroup() {
        if (this.threadGroup == null || this.threadGroup.isDestroyed()) {
            this.threadGroup = new BrowserAppletThreadGroup(String.valueOf(this.codebase) + "-threadGroup");
            this.threadGroup.setDaemon(true);
        }
        return this.threadGroup;
    }

    public static synchronized Object getSecurityContext(ClassLoader classLoader) {
        if (classLoader instanceof BrowserClassLoader) {
            return ((BrowserClassLoader)classLoader).codebase;
        }
        return null;
    }

    public URL getResource(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            return uRL;
        }
        if (this.archiveList != null) {
            try {
                uRL = new URL("jam://" + URLEncoder.encode(this.codebase.toString()) + "/" + string);
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        inputStream = this.getResourceAsStreamFromJar(string);
        if (inputStream != null) {
            return inputStream;
        }
        inputStream = this.getResourceAsStreamFromURL(string);
        return inputStream;
    }

    private InputStream getResourceAsStreamFromJar(String string) {
        URL uRL;
        String string2 = new String(string);
        try {
            uRL = new URL(this.codebase, string2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        byte[] byArray = (byte[])this.jarRAMDisk.get(uRL);
        if (byArray != null) {
            return new BufferedInputStream(new ByteArrayInputStream(byArray));
        }
        return null;
    }

    private InputStream getResourceAsStreamFromURL(String string) {
        URL uRL;
        InputStream inputStream = null;
        try {
            uRL = new URL(this.codebase, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        try {
            HttpURLConnection httpURLConnection;
            int n;
            BrowserURLLoader browserURLLoader = new BrowserURLLoader(uRL);
            inputStream = browserURLLoader.getInputStream();
            if (browserURLLoader.getConnection() instanceof HttpURLConnection && (n = (httpURLConnection = (HttpURLConnection)browserURLLoader.getConnection()).getResponseCode()) >= 400) {
                inputStream = null;
            }
        }
        catch (Exception exception) {
            inputStream = null;
        }
        return inputStream;
    }

    public String toString() {
        if (this.codebase == null) {
            return String.valueOf(super.toString()) + "<null>";
        }
        return String.valueOf(super.toString()) + "<" + this.codebase.toString() + ">";
    }
}

