/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.sea.helpsys;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZIPElement {
    private Properties ids;
    private String file_name;
    private String lang;
    private String lang_vw;
    private String release;
    private String release_vw;
    private String subject;
    private String subject_vw;
    private String sys;
    private String sys_vw;
    private boolean full_created;
    private boolean default_vw;
    private Hashtable content;

    public ZIPElement(String sys, String sys_vw, String release, String release_vw, String subject, String subject_vw, String lang, String lang_vw, String file_name, Properties ids, Hashtable content) throws Exception {
        this.lang = lang;
        this.lang_vw = lang_vw;
        this.release = release;
        this.release_vw = release_vw;
        this.subject = subject;
        this.subject_vw = subject_vw;
        this.sys = sys;
        this.sys_vw = sys_vw;
        this.file_name = file_name;
        this.ids = ids;
        this.content = content;
        this.full_created = true;
    }

    public ZIPElement(String sys, String sys_vw, String release, String release_vw, String subject, String subject_vw, String lang, String lang_vw, String file_name, boolean default_vw) throws Exception {
        this.lang = lang;
        this.lang_vw = lang_vw;
        this.release = release;
        this.release_vw = release_vw;
        this.subject = subject;
        this.subject_vw = subject_vw;
        this.sys = sys;
        this.sys_vw = sys_vw;
        this.file_name = file_name;
        this.default_vw = default_vw;
        this.full_created = false;
    }

    private String getFileName(String id) {
        String str = this.ids.getProperty(id);
        if (str == null) {
            return null;
        }
        int index = str.indexOf(44);
        if (index < 0) {
            return null;
        }
        return str.substring(0, index);
    }

    public String getFilePath() {
        return this.file_name;
    }

    public byte[] getFileWithID(String file_id) {
        String name = this.getFileName(file_id);
        if (name == null) {
            return null;
        }
        byte[] buf = null;
        try {
            ZipFile zf = new ZipFile(this.file_name);
            ZipEntry zentry = (ZipEntry)this.content.get(name);
            if (zentry != null) {
                InputStream in = zf.getInputStream(zentry);
                int nLength = (int)zentry.getSize();
                buf = new byte[nLength];
                int nRead = 0;
                int nCount = 0;
                while (nLength > 0 && (nRead = in.read(buf, nCount, nLength)) != -1) {
                    nCount += nRead;
                    nLength -= nRead;
                }
                in.close();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf;
    }

    public byte[] getFileWithName(String name) {
        byte[] buf = null;
        try {
            ZipFile zf = new ZipFile(this.file_name);
            ZipEntry zentry = (ZipEntry)this.content.get(name);
            if (zentry != null) {
                InputStream in = zf.getInputStream(zentry);
                int nLength = (int)zentry.getSize();
                buf = new byte[nLength];
                int nRead = 0;
                int nCount = 0;
                while (nLength > 0 && (nRead = in.read(buf, nCount, nLength)) != -1) {
                    nCount += nRead;
                    nLength -= nRead;
                }
                in.close();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf;
    }

    public String getHTMLIDs(boolean linked, String ext) {
        StringBuffer file_ = new StringBuffer();
        if (linked) {
            file_.append("\"" + ext + this.sys + "-");
            file_.append(String.valueOf(this.release) + "-");
            file_.append(String.valueOf(this.subject_vw) + "-");
            file_.append(String.valueOf(this.lang) + "\",");
        } else {
            file_.append("'notdefined'");
        }
        return file_.toString();
    }

    public String getHTMLLink(boolean linked, String ext) {
        StringBuffer file_ = new StringBuffer();
        if (linked) {
            file_.append(String.valueOf(ext) + this.sys + "/");
            file_.append(String.valueOf(this.release) + "/");
            file_.append(String.valueOf(this.subject) + "/");
            file_.append(String.valueOf(this.lang) + "/ID_INDEX");
        } else {
            file_ = new StringBuffer(this.file_name);
        }
        return file_.toString();
    }

    public String getLanguage() {
        return this.lang;
    }

    public String getLanguageVW() {
        return this.lang_vw;
    }

    public String getRelease() {
        return this.release;
    }

    public String getReleaseVW() {
        return this.release_vw;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSubjectVW() {
        return this.subject_vw;
    }

    public String getSystem() {
        return this.sys;
    }

    public String getSystemVW() {
        return this.sys_vw;
    }

    public boolean isDefault() {
        return this.default_vw;
    }

    public boolean isFullCreated() {
        return this.full_created;
    }

    public boolean isLanguage(String lan) {
        return this.lang.toLowerCase().equals(lan);
    }

    public boolean isRelease(String rel) {
        return this.release.toLowerCase().equals(rel);
    }

    public boolean isSubject(String subj) {
        return this.subject.toLowerCase().equals(subj);
    }

    public boolean isSystem(String syst) {
        return this.sys.toLowerCase().equals(syst);
    }

    public void setContent(Hashtable content) {
        this.content = content;
    }

    public void setFIle(String value) {
        this.file_name = value;
    }

    public void setFullCreated() {
        this.full_created = true;
    }

    public void setIDS(Properties ids) {
        this.ids = ids;
    }

    public void setLanguage(String value) {
        this.lang = value;
    }

    public void setLanguageVw(String value) {
        this.lang_vw = value;
    }

    public void setRelease(String value) {
        this.release = value;
    }

    public void setReleaseVw(String value) {
        this.release_vw = value;
    }

    public void setSubject(String value) {
        this.subject = value;
    }

    public void setSubjectVw(String value) {
        this.subject_vw = value;
    }

    public void setSystem(String value) {
        this.sys = value;
    }

    public void setSystemVw(String value) {
        this.sys_vw = value;
    }

    public String toHTML(boolean linked, String ext) {
        StringBuffer file_ = new StringBuffer();
        if (linked) {
            file_.append("<A HREF=\"");
            file_.append(String.valueOf(ext) + this.sys + "/");
            file_.append(String.valueOf(this.release) + "/");
            file_.append(String.valueOf(this.subject) + "/");
            file_.append(String.valueOf(this.lang) + "/ID_INDEX\">");
        } else {
            file_ = new StringBuffer(this.file_name);
        }
        String str = new String("<TR>\n<TD NOWRAP WIDTH=\"12%\">" + ext + this.sys_vw + "</TD>\n" + "<TD NOWRAP WIDTH=\"7%\">" + this.release_vw + "</TD>\n" + "<TD NOWRAP WIDTH=\"29%\">" + file_ + this.subject_vw + "</A></TD>\n" + "<TD NOWRAP>" + this.lang_vw + "</TD>\n" + "</TR>");
        return str;
    }

    public String toString() {
        return new String("System=" + this.sys + " RELEASE=" + this.release + " SUBJECT=" + this.subject + " LANGUAGE=" + this.lang + " ZIP_FILE_NAME=" + this.file_name);
    }
}

