/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.sea.wizardbean;

import com.installshield.wizard.RunnableWizardBeanState;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizardx.actions.ExecWizardAction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ExecWizardActionHelper
extends ExecWizardAction
implements Runnable {
    private String command;
    private String[] arguments = new String[0];
    private String stdoutDestination;
    private String stderrDestination;
    private boolean waitForCompletion = true;
    private String description;
    private transient int returnValue;
    private transient int status = 0;

    public void build(WizardBuilderSupport wizardbuildersupport) {
    }

    public void execute(WizardBeanEvent wizardbeanevent) {
        RunnableWizardBeanState runnablewizardbeanstate = this.getState();
        runnablewizardbeanstate.setTitle("Exec Action");
        if (this.description.equals("")) {
            this.description = " ";
        }
        runnablewizardbeanstate.setStatusDescription(this.description);
        this.status = 0;
        if (!this.waitForCompletion) {
            Thread thread = new Thread(this);
            thread.setPriority(1);
            thread.start();
        } else {
            this.executeProcess();
        }
    }

    private void executeProcess() {
        try {
            int i = 0;
            while (i < this.arguments.length) {
                this.arguments[i] = this.resolveString(this.arguments[i]);
                ++i;
            }
            Process process = Runtime.getRuntime().exec(this.arguments);
            this.status = 1;
            process.waitFor();
            this.returnValue = process.exitValue();
            this.status = 2;
            this.processOutputData(process.getInputStream());
            this.processErrorData(process.getErrorStream());
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDescription() {
        return this.description;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStderrDestination() {
        return this.stderrDestination;
    }

    public String getStdoutDestination() {
        return this.stdoutDestination;
    }

    public boolean isWaitForCompletion() {
        return this.waitForCompletion;
    }

    protected void processErrorData(InputStream inputstream) {
        this.writeData(inputstream, this.resolveString(this.stderrDestination));
    }

    protected void processOutputData(InputStream inputstream) {
        this.writeData(inputstream, this.resolveString(this.stdoutDestination));
    }

    public void run() {
        this.executeProcess();
    }

    public void setArguments(String[] as) {
        this.arguments = as;
    }

    public void setCommand(String s) {
        this.command = s;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public void setStderrDestination(String s) {
        this.stderrDestination = s;
    }

    public void setStdoutDestination(String s) {
        this.stdoutDestination = s;
    }

    public void setWaitForCompletion(boolean flag) {
        this.waitForCompletion = flag;
    }

    private void writeData(InputStream inputstream, String s) {
        try {
            if (s != null && s.length() > 0) {
                String s1;
                File file;
                int i = s.lastIndexOf(File.separator);
                if (i != -1 && !(file = new File(s.substring(0, i + 1))).isDirectory()) {
                    file.mkdir();
                }
                BufferedWriter bufferedwriter = new BufferedWriter(new FileWriter(new File(s)));
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream));
                while ((s1 = bufferedreader.readLine()) != null) {
                    bufferedwriter.write(s1, 0, s1.length());
                    bufferedwriter.newLine();
                }
                bufferedwriter.close();
                bufferedreader.close();
                inputstream.close();
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }
}

