/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ArchiveFilter;
import com.installshield.archive.ArchiveWriter;
import com.installshield.archive.BuildEvent;
import com.installshield.archive.BuildListener;
import com.installshield.util.Log;
import com.installshield.util.LogListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;

public class ArchiveBuilderSupport
implements Log,
BuildListener {
    private ArchiveWriter writer;
    private Vector logListeners = new Vector();
    private Vector buildListeners = new Vector();
    private Locale[] selectedLocales = new Locale[0];
    private boolean buildCanceled = false;

    public ArchiveBuilderSupport(ArchiveBuilderSupport archiveBuilderSupport) {
        this.writer = archiveBuilderSupport.writer;
        this.logListeners = archiveBuilderSupport.logListeners;
        this.buildListeners = archiveBuilderSupport.buildListeners;
        this.selectedLocales = archiveBuilderSupport.selectedLocales;
    }

    public ArchiveBuilderSupport(ArchiveWriter archiveWriter, Locale[] localeArray) {
        if (archiveWriter == null) {
            throw new IllegalArgumentException("writer cannot be null");
        }
        this.writer = archiveWriter;
        this.selectedLocales = localeArray;
    }

    public void addBuildListener(BuildListener buildListener) {
        this.buildListeners.addElement(buildListener);
    }

    public void addLogListener(LogListener logListener) {
        this.logListeners.addElement(logListener);
    }

    public void buildFinished(BuildEvent buildEvent) {
        Vector vector = (Vector)this.buildListeners.clone();
        int n = 0;
        while (n < vector.size()) {
            ((BuildListener)vector.elementAt(n)).buildFinished(buildEvent);
            ++n;
        }
    }

    public void buildStarted(BuildEvent buildEvent) {
        Vector vector = (Vector)this.buildListeners.clone();
        int n = 0;
        while (n < vector.size()) {
            ((BuildListener)vector.elementAt(n)).buildStarted(buildEvent);
            ++n;
        }
    }

    public Locale[] getSelectedLocales() {
        return this.selectedLocales;
    }

    public ArchiveWriter getWriter() {
        return this.writer;
    }

    public boolean isBuildCanceled() {
        return this.buildCanceled;
    }

    public void logEvent(Object object, String string, Object object2) {
        this.notifyListeners(object, string, object2);
    }

    private void notifyListeners(Object object, String string, Object object2) {
        int n = 0;
        while (n < this.logListeners.size()) {
            ((LogListener)this.logListeners.elementAt(n)).eventLogged(object, string, object2);
            ++n;
        }
    }

    public void putArchive(String string, ArchiveFilter archiveFilter) throws IOException {
        this.writer.putArchive(string, archiveFilter);
    }

    public void putClass(String string) throws IOException {
        this.writer.putClass(string);
    }

    public void putClassResource(InputStream inputStream, String string) throws IOException {
        this.writer.putClassResource(inputStream, string);
    }

    public void putClassResource(String string) throws IOException {
        this.writer.putClassResource(string);
    }

    public void putDefinition(Object object, Class clazz, String string) throws IOException {
        this.writer.putDefinition(object, clazz, string);
    }

    public void putPackage(String string) throws IOException {
        this.writer.putPackage(string);
    }

    public void putPackage(String string, boolean bl) throws IOException {
        this.writer.putPackage(string, bl);
    }

    public void putResource(InputStream inputStream, String string) throws IOException {
        this.writer.putResource(inputStream, string);
    }

    public void putResource(String string, String string2) throws IOException {
        this.writer.putResource(string, string2);
    }

    public void putResource(URL uRL, String string) throws IOException {
        this.writer.putResource(uRL, string);
    }

    public void putResourceBundles(String string) throws IOException {
        this.putResourceBundles(string, this.selectedLocales);
    }

    public void putResourceBundles(String string, Locale[] localeArray) throws IOException {
        this.writer.putResourceBundles(string, localeArray);
    }

    public void removeBuildListener(BuildListener buildListener) {
        this.buildListeners.removeElement(buildListener);
    }

    public void removeLogListener(LogListener logListener) {
        this.logListeners.removeElement(logListener);
    }

    public void setBuildCanceled(boolean bl) {
        this.buildCanceled = bl;
    }

    public void writeFinished(BuildEvent buildEvent) {
        Vector vector = (Vector)this.buildListeners.clone();
        int n = 0;
        while (n < vector.size()) {
            ((BuildListener)vector.elementAt(n)).writeFinished(buildEvent);
            ++n;
        }
    }

    public void writeStarting(BuildEvent buildEvent) {
        Vector vector = (Vector)this.buildListeners.clone();
        int n = 0;
        while (n < vector.size()) {
            ((BuildListener)vector.elementAt(n)).writeStarting(buildEvent);
            ++n;
        }
    }
}

