/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.FileURLConnection;
import com.installshield.archive.ZipURLConnection;
import com.installshield.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.Hashtable;

public class ArchiveURLStreamHandler
extends URLStreamHandler {
    private static Hashtable openConnections = new Hashtable();

    public static void closeAllArchives() {
        Enumeration enumeration = openConnections.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                ArchiveURLStreamHandler.closeArchive(string);
            }
            catch (IOException iOException) {}
        }
    }

    public static void closeArchive(String string) throws IOException {
        Enumeration enumeration = openConnections.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!FileUtils.comparePaths(string, string2)) continue;
            Hashtable hashtable = (Hashtable)openConnections.get(string2);
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                URLConnection uRLConnection = (URLConnection)hashtable.get(enumeration2.nextElement());
                if (!(uRLConnection instanceof ZipURLConnection)) continue;
                ZipURLConnection zipURLConnection = (ZipURLConnection)uRLConnection;
                zipURLConnection.closeFile();
            }
        }
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        String string = uRL.getFile();
        int n = string.indexOf(43);
        String string2 = n != -1 ? string.substring(0, n) : "";
        String string3 = n != -1 ? string.substring(n + 1) : string;
        Hashtable<URL, URLConnection> hashtable = (Hashtable<URL, URLConnection>)openConnections.get(string2);
        if (hashtable == null) {
            hashtable = new Hashtable<URL, URLConnection>();
            openConnections.put(string2, hashtable);
        }
        if (hashtable.containsKey(uRL)) {
            return (URLConnection)hashtable.get(uRL);
        }
        File file = new File(string2);
        if (file.isFile()) {
            ZipURLConnection zipURLConnection = new ZipURLConnection(uRL, string2, string3);
            hashtable.put(uRL, zipURLConnection);
            return zipURLConnection;
        }
        if (file.isDirectory()) {
            FileURLConnection fileURLConnection = new FileURLConnection(uRL, new File(string2, string3));
            hashtable.put(uRL, fileURLConnection);
            return fileURLConnection;
        }
        throw new IOException("archive context " + file + " does not exist");
    }
}

