/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ResourceWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ZipResourceWriter
implements ResourceWriter {
    private ZipOutputStream out;
    private ZipEntry zipEntry;

    public ZipResourceWriter() {
        this(null, null);
    }

    public ZipResourceWriter(ZipOutputStream zipOutputStream, ZipEntry zipEntry) {
        if (zipOutputStream == null && zipEntry != null || zipOutputStream != null && zipEntry == null) {
            throw new IllegalArgumentException("out and zipEntry must either be both null or both not null");
        }
        this.out = zipOutputStream;
        this.zipEntry = zipEntry;
    }

    public void close(OutputStream outputStream) throws IOException {
        if (outputStream instanceof ZipOutputStream) {
            ((ZipOutputStream)outputStream).closeEntry();
        }
    }

    public Date getDate() {
        if (this.zipEntry == null) {
            return null;
        }
        long l = this.zipEntry.getTime();
        if (l >= 0L) {
            return new Date(l);
        }
        return null;
    }

    public String getId() {
        if (this.zipEntry == null) {
            return null;
        }
        return this.zipEntry.getName();
    }

    public OutputStream open() throws IOException {
        if (this.out != null) {
            try {
                this.out.putNextEntry(this.zipEntry);
            }
            catch (ZipException zipException) {
                if (zipException.getMessage().startsWith("duplicate entry")) {
                    return null;
                }
                throw zipException;
            }
            return this.out;
        }
        return new ByteArrayOutputStream();
    }
}

