/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.util.ZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipURLConnection
extends URLConnection {
    private static Hashtable openFiles = new Hashtable();
    private String fileName;
    private String entryName;
    private ZipFile zipFile = null;

    ZipURLConnection(URL uRL, String string, String string2) {
        super(uRL);
        this.fileName = string;
        this.entryName = ZipUtils.cleanZipEntry(string2);
    }

    public static void closeAllOpenFiles(String string) throws IOException {
        Enumeration enumeration = openFiles.elements();
        while (enumeration.hasMoreElements()) {
            ((ZipFile)enumeration.nextElement()).close();
        }
        openFiles.clear();
    }

    protected void closeFile() throws IOException {
        if (this.zipFile != null) {
            this.zipFile.close();
        }
    }

    public static void closeOpenFile(String string) throws IOException {
        ZipFile zipFile = (ZipFile)openFiles.get(string);
        if (zipFile != null) {
            zipFile.close();
            openFiles.remove(string);
        }
    }

    public void connect() {
    }

    public String getContentType() {
        String string = this.entryName.toUpperCase();
        if (string.endsWith(".GIF")) {
            return "image/gif";
        }
        if (string.endsWith(".JPG") || string.endsWith(".JPEG")) {
            return "image/jpg";
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        ZipEntry zipEntry;
        if (this.zipFile == null) {
            this.zipFile = ZipURLConnection.getZipFile(this.fileName);
        }
        if ((zipEntry = this.zipFile.getEntry(this.entryName)) == null) {
            throw new IOException("entry " + this.entryName + " does not exist in " + this.fileName);
        }
        return ZipUtils.createZipInputStream(this.zipFile.getInputStream(zipEntry));
    }

    private static ZipFile getZipFile(String string) throws IOException {
        ZipFile zipFile = (ZipFile)openFiles.get(string);
        if (zipFile == null) {
            zipFile = new ZipFile(string);
            openFiles.put(string, zipFile);
        }
        return zipFile;
    }
}

