/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive.ijar;

import com.installshield.archive.ijar.IJAREntry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;

class IJARIndexWriter {
    private Vector compressed;
    private Vector currentEntries;
    private int nextToken;
    private int packetSize;

    IJARIndexWriter() {
        this(1000);
    }

    IJARIndexWriter(int n) {
        this.packetSize = n;
        this.compressed = new Vector(20000 / n);
        this.currentEntries = new Vector(n);
        this.nextToken = 1;
    }

    synchronized void addEntry(IJAREntry iJAREntry) throws IOException {
        this.currentEntries.addElement(iJAREntry);
        if (this.currentEntries.size() == this.currentEntries.capacity()) {
            this.compressCurrent();
        }
    }

    private void compressCurrent() throws IOException {
        if (this.currentEntries.size() > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(200 * this.currentEntries.size());
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            DataOutputStream dataOutputStream = new DataOutputStream(deflaterOutputStream);
            int n = this.currentEntries.size();
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                IJAREntry iJAREntry = (IJAREntry)this.currentEntries.elementAt(n2);
                dataOutputStream.write(iJAREntry.digest);
                dataOutputStream.writeUTF(iJAREntry.fileName);
                dataOutputStream.writeInt(iJAREntry.type);
                dataOutputStream.writeLong(iJAREntry.size);
                dataOutputStream.writeBoolean(iJAREntry.attributes != null);
                if (iJAREntry.attributes != null) {
                    iJAREntry.attributes.write(dataOutputStream);
                }
                dataOutputStream.writeLong(iJAREntry.lastModified);
                dataOutputStream.writeInt(iJAREntry.extra.length);
                dataOutputStream.write(iJAREntry.extra);
                ++n2;
            }
            dataOutputStream.flush();
            deflaterOutputStream.finish();
            this.compressed.addElement(byteArrayOutputStream.toByteArray());
            this.currentEntries.removeAllElements();
        }
    }

    void write(OutputStream outputStream) throws IOException {
        this.compressCurrent();
        if (this.currentEntries.capacity() != this.packetSize) {
            throw new Error();
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this.packetSize);
        dataOutputStream.writeInt(this.compressed.size());
        int n = 0;
        while (n < this.compressed.size()) {
            byte[] byArray = (byte[])this.compressed.elementAt(n);
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
            ++n;
        }
        dataOutputStream.flush();
    }
}

