/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans;

import com.installshield.beans.BeanEditorEvent;
import com.installshield.beans.BeanEditorException;
import com.installshield.beans.BeanEditorListener;
import com.installshield.beans.ExtendedPropertiesManager;
import com.installshield.beans.ExtendedPropertiesNotSupported;
import com.installshield.beans.ISIntrospector;
import com.installshield.beans.NoSuchExtendedPropertiesException;
import com.installshield.beans.PropertiesExtendible;
import com.installshield.beans.editors.ExtendedPropertyEditor;
import com.installshield.beans.editors.StringEditor;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class BeanEditor
implements PropertyChangeListener {
    private Object bean = null;
    private BeanInfo beanInfo = null;
    private String titlePropertyName = null;
    private String defaultTitle = "Bean Editor";
    private ExtendedPropertiesManager epm;
    private Vector beanEditorListeners = new Vector();
    private Vector propertyListeners = new Vector();
    static /* synthetic */ Class class$com$installshield$beans$editors$StringArrayEditor;
    static /* synthetic */ Class class$com$installshield$beans$BeanEditor;
    static /* synthetic */ Class class$java$lang$Object;

    static {
        String[] stringArray = PropertyEditorManager.getEditorSearchPath();
        String[] stringArray2 = new String[stringArray != null ? stringArray.length + 1 : 1];
        stringArray2[0] = "com.installshield.beans.editors";
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        }
        PropertyEditorManager.setEditorSearchPath(stringArray2);
        PropertyEditorManager.registerEditor(new String[0].getClass(), class$com$installshield$beans$editors$StringArrayEditor != null ? class$com$installshield$beans$editors$StringArrayEditor : (class$com$installshield$beans$editors$StringArrayEditor = BeanEditor.class$("com.installshield.beans.editors.StringArrayEditor")));
    }

    public BeanEditor() {
        this(null);
    }

    public BeanEditor(ExtendedPropertiesManager extendedPropertiesManager) {
        this.epm = extendedPropertiesManager;
    }

    public void addBeanEditorListener(BeanEditorListener beanEditorListener) {
        this.beanEditorListeners.addElement(beanEditorListener);
    }

    public void addExtendedProperties(Object object) throws ExtendedPropertiesNotSupported, BeanEditorException, NoSuchExtendedPropertiesException {
        this.verifyEpm();
        if (!(this.bean instanceof PropertiesExtendible)) {
            throw new ExtendedPropertiesNotSupported();
        }
        Class clazz = this.epm.getExtendedPropertiesType(this.bean.getClass(), object);
        try {
            ((PropertiesExtendible)this.bean).getExtendedProperties().put(object, clazz.newInstance());
            this.fireBeanChangedEvent();
        }
        catch (Exception exception) {
            throw new BeanEditorException(109, exception.getMessage());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners.addElement(propertyChangeListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Enumeration extendedPropertiesKeys() throws ExtendedPropertiesNotSupported {
        this.verifyEpm();
        return this.epm.extendedPropertiesKeys(this.bean.getClass());
    }

    public void fireBeanChangedEvent() {
        BeanEditorEvent beanEditorEvent = new BeanEditorEvent(this, 1);
        Enumeration enumeration = this.beanEditorListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((BeanEditorListener)enumeration.nextElement()).beanChanged(beanEditorEvent);
        }
    }

    public Object getBean() {
        return this.bean;
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    public static String getClassDisplayName(Class clazz) {
        try {
            BeanInfo beanInfo = ISIntrospector.getBeanInfo(clazz);
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            if (beanDescriptor != null) {
                return beanDescriptor.getDisplayName();
            }
        }
        catch (Exception exception) {}
        return clazz.getName().substring(clazz.getName().lastIndexOf(46));
    }

    public Object getExtendedPropertiesBean(Object object) throws NoSuchExtendedPropertiesException, ExtendedPropertiesNotSupported {
        if (!(this.bean instanceof PropertiesExtendible)) {
            throw new ExtendedPropertiesNotSupported();
        }
        Dictionary dictionary = ((PropertiesExtendible)this.bean).getExtendedProperties();
        if (dictionary == null) {
            throw new ExtendedPropertiesNotSupported("object returned null value for extended properties");
        }
        Object v = dictionary.get(object);
        if (v == null) {
            this.verifyEpm();
            this.epm.getExtendedPropertiesType(this.bean.getClass(), object);
        }
        return v;
    }

    public BeanInfo getExtendedPropertiesBeanInfo(Object object) throws ExtendedPropertiesNotSupported, NoSuchExtendedPropertiesException, BeanEditorException {
        this.verifyEpm();
        Class clazz = this.epm.getExtendedPropertiesType(this.bean.getClass(), object);
        try {
            return ISIntrospector.getBeanInfo(clazz, class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = BeanEditor.class$("java.lang.Object")));
        }
        catch (IntrospectionException introspectionException) {
            throw new BeanEditorException(101, introspectionException.getMessage());
        }
    }

    public ExtendedPropertiesManager getExtendedPropertiesManager() throws ExtendedPropertiesNotSupported {
        return this.epm;
    }

    private static PropertyDescriptor getPropertyDescriptor(BeanInfo beanInfo, String string) {
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n].getName().equals(string)) {
                return propertyDescriptorArray[n];
            }
            ++n;
        }
        return null;
    }

    public static PropertyEditor getPropertyEditor(BeanInfo beanInfo, String string) {
        return BeanEditor.getPropertyEditor(beanInfo, string, null);
    }

    public static PropertyEditor getPropertyEditor(BeanInfo beanInfo, String string, PropertyEditor propertyEditor) {
        return BeanEditor.getPropertyEditor(BeanEditor.getPropertyDescriptor(beanInfo, string), propertyEditor);
    }

    public static PropertyEditor getPropertyEditor(PropertyDescriptor propertyDescriptor, PropertyEditor propertyEditor) {
        if (propertyDescriptor == null) {
            return null;
        }
        Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
        PropertyEditor propertyEditor2 = null;
        if (clazz == null) {
            propertyEditor2 = PropertyEditorManager.findEditor(propertyDescriptor.getPropertyType());
            if (propertyEditor2 == null) {
                if (propertyEditor == null) {
                    propertyEditor = new StringEditor();
                }
                propertyEditor2 = propertyEditor;
            }
        } else {
            try {
                propertyEditor2 = (PropertyEditor)clazz.newInstance();
            }
            catch (Throwable throwable) {}
        }
        if (propertyEditor2 instanceof ExtendedPropertyEditor) {
            BeanEditor.initializeExtendedPropertyEditor((ExtendedPropertyEditor)propertyEditor2, propertyDescriptor);
        }
        return propertyEditor2;
    }

    public static Object getPropertyValue(Object object, BeanInfo beanInfo, String string) throws BeanEditorException {
        PropertyDescriptor propertyDescriptor = BeanEditor.getPropertyDescriptor(beanInfo, string);
        if (propertyDescriptor == null) {
            throw new BeanEditorException(106, string);
        }
        return BeanEditor.getPropertyValue(object, propertyDescriptor);
    }

    public static Object getPropertyValue(Object object, PropertyDescriptor propertyDescriptor) throws BeanEditorException {
        Method method = propertyDescriptor.getReadMethod();
        if (method == null) {
            throw new BeanEditorException(108, propertyDescriptor.getName());
        }
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BeanEditorException(102, illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new BeanEditorException(104, invocationTargetException.getMessage());
        }
    }

    public static String getPropertyValueDisplayName(Object object, PropertyDescriptor propertyDescriptor) {
        if (object == null) {
            return "";
        }
        PropertyEditor propertyEditor = BeanEditor.getPropertyEditor(propertyDescriptor, null);
        if (propertyEditor != null) {
            if (propertyEditor instanceof ExtendedPropertyEditor) {
                BeanEditor.initializeExtendedPropertyEditor((ExtendedPropertyEditor)propertyEditor, propertyDescriptor);
            }
            propertyEditor.setValue(object);
            return propertyEditor.getAsText();
        }
        return object.toString();
    }

    private static void initializeExtendedPropertyEditor(ExtendedPropertyEditor extendedPropertyEditor, PropertyDescriptor propertyDescriptor) {
        String[] stringArray = extendedPropertyEditor.getExtendedAttributeNames();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                Object object = propertyDescriptor.getValue(stringArray[n]);
                if (object != null) {
                    extendedPropertyEditor.setExtendedAttributeValue(stringArray[n], object);
                }
                ++n;
            }
        }
    }

    public boolean isExtendedPropertiesSupported() {
        return this.epm != null;
    }

    public static boolean isPropertyEditable(BeanInfo beanInfo, String string) {
        PropertyDescriptor propertyDescriptor = BeanEditor.getPropertyDescriptor(beanInfo, string);
        return propertyDescriptor != null && BeanEditor.isPropertyEditable(propertyDescriptor);
    }

    public static boolean isPropertyEditable(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getWriteMethod() != null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n = 0;
        while (n < this.propertyListeners.size()) {
            ((PropertyChangeListener)this.propertyListeners.elementAt(n)).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public void removeBeanEditorListener(BeanEditorListener beanEditorListener) {
        this.beanEditorListeners.removeElement(beanEditorListener);
    }

    public void removeExtendedProperties(Object object) throws ExtendedPropertiesNotSupported {
        if (!(this.bean instanceof PropertiesExtendible)) {
            throw new ExtendedPropertiesNotSupported();
        }
        if (((PropertiesExtendible)this.bean).getExtendedProperties().remove(object) != null) {
            this.fireBeanChangedEvent();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners.removeElement(propertyChangeListener);
    }

    public void setBean(Object object) throws BeanEditorException {
        this.setBean(object, null);
    }

    public void setBean(Object object, BeanInfo beanInfo) throws BeanEditorException {
        this.bean = object;
        this.beanInfo = beanInfo;
        if (object != null && beanInfo == null) {
            try {
                this.beanInfo = ISIntrospector.getBeanInfo(object.getClass(), class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = BeanEditor.class$("java.lang.Object")));
            }
            catch (IntrospectionException introspectionException) {
                throw new BeanEditorException(101, introspectionException.getMessage());
            }
        }
        this.fireBeanChangedEvent();
    }

    public static PropertyChangeEvent setPropertyValue(Object object, BeanInfo beanInfo, String string, Object object2) throws BeanEditorException {
        PropertyDescriptor propertyDescriptor = BeanEditor.getPropertyDescriptor(beanInfo, string);
        if (propertyDescriptor == null) {
            throw new BeanEditorException(106, string);
        }
        return BeanEditor.setPropertyValue(object, propertyDescriptor, object2);
    }

    public static PropertyChangeEvent setPropertyValue(Object object, PropertyDescriptor propertyDescriptor, Object object2) throws BeanEditorException {
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            throw new BeanEditorException(107, propertyDescriptor.getName());
        }
        try {
            Object object3;
            try {
                object3 = BeanEditor.getPropertyValue(object, propertyDescriptor);
            }
            catch (BeanEditorException beanEditorException) {
                object3 = null;
            }
            method.invoke(object, object2);
            return new PropertyChangeEvent(class$com$installshield$beans$BeanEditor != null ? class$com$installshield$beans$BeanEditor : (class$com$installshield$beans$BeanEditor = BeanEditor.class$("com.installshield.beans.BeanEditor")), propertyDescriptor.getName(), object3, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BeanEditorException(102, illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new BeanEditorException(104, invocationTargetException.getMessage());
        }
    }

    private void verifyEpm() throws ExtendedPropertiesNotSupported {
        if (this.epm == null) {
            throw new ExtendedPropertiesNotSupported();
        }
    }
}

