/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans;

import com.installshield.beans.AbstractCustomizer;
import com.installshield.beans.AdvancedPropertyFilter;
import com.installshield.beans.BeanEditor;
import com.installshield.beans.BeanEditorEvent;
import com.installshield.beans.BeanEditorException;
import com.installshield.beans.BeanEditorListener;
import com.installshield.beans.BeanInfoAggregate;
import com.installshield.beans.BeanPropertyFilter;
import com.installshield.beans.ExtendedPropertiesNotSupported;
import com.installshield.beans.InitializedEvent;
import com.installshield.beans.InitializedListener;
import com.installshield.beans.NoSuchExtendedPropertiesException;
import com.installshield.beans.PropertiesExtendible;
import com.installshield.beans.PropertiesView;
import com.installshield.beans.PropertiesViewContainer;
import com.installshield.beans.PropertyFilter;
import com.installshield.beans.StandardPropertyFilter;
import com.installshield.swing.ColumnConstraints;
import com.installshield.swing.ColumnLayout;
import com.installshield.swing.IndentedBorder;
import java.awt.Component;
import java.awt.Container;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;

public class BeanEditorView
extends JPanel
implements ItemSelectable,
BeanEditorListener,
ItemListener,
InitializedListener,
FocusListener {
    private BeanEditor editor;
    private PropertiesViewContainer standardView;
    private PropertiesViewContainer advancedView;
    private Container extendedPropertiesContainer;
    private Container beanCustomizerContainer;
    private Vector extendedPropertiesViews = new Vector();
    private Vector itemListeners = new Vector();
    private JLabel labelNoProperties = null;
    private PropertiesView currentView = null;
    private boolean settingCheckbox = false;
    static /* synthetic */ Class class$java$lang$Object;

    public BeanEditorView(BeanEditor beanEditor) {
        super((LayoutManager)new ColumnLayout(2));
        this.editor = beanEditor;
        beanEditor.addBeanEditorListener(this);
        this.labelNoProperties = new JLabel("There are no properties for this item.");
        this.labelNoProperties.setForeground(SystemColor.textText);
        this.add((Component)this.labelNoProperties, new ColumnConstraints(2, 2));
        this.labelNoProperties.setVisible(false);
        this.beanCustomizerContainer = new JPanel((LayoutManager)new ColumnLayout(4));
        this.add((Component)this.beanCustomizerContainer, new ColumnConstraints(2, 2));
        this.standardView = this.createPropertiesView(beanEditor, new StandardPropertyFilter(), "Standard Properties", false, true);
        this.add((Component)this.standardView, new ColumnConstraints(2, 2));
        this.advancedView = this.createPropertiesView(beanEditor, new AdvancedPropertyFilter(), "Advanced Properties", false, true);
        this.add((Component)this.advancedView, new ColumnConstraints(2, 2));
        this.extendedPropertiesContainer = new JPanel((LayoutManager)new ColumnLayout(2));
        this.add((Component)this.extendedPropertiesContainer, new ColumnConstraints(2, 2));
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListeners.addElement(itemListener);
    }

    private void adjustHighlighting() {
        this.standardView.getView().setHighlighting(this.standardView.getView().hasFocus());
        this.standardView.getView().repaint();
        this.advancedView.getView().setHighlighting(this.advancedView.getView().hasFocus());
        this.advancedView.getView().repaint();
        Enumeration enumeration = this.extendedPropertiesViews.elements();
        while (enumeration.hasMoreElements()) {
            PropertiesView propertiesView = ((PropertiesViewContainer)enumeration.nextElement()).getView();
            propertiesView.setHighlighting(propertiesView.hasFocus());
            propertiesView.repaint();
        }
    }

    public void beanChanged(BeanEditorEvent beanEditorEvent) {
        JComponent jComponent;
        Constructor constructor;
        Object object;
        BeanInfo beanInfo;
        Object object2;
        this.extendedPropertiesContainer.removeAll();
        this.beanCustomizerContainer.removeAll();
        this.currentView = null;
        ((BeanPropertyFilter)this.advancedView.getView().getFilter()).setBeanInfo(this.editor.getBeanInfo());
        ((BeanPropertyFilter)this.standardView.getView().getFilter()).setBeanInfo(this.editor.getBeanInfo());
        if (this.editor.isExtendedPropertiesSupported() && this.editor.getBean() instanceof PropertiesExtendible) {
            try {
                int n = 0;
                object2 = this.editor.extendedPropertiesKeys();
                while (object2.hasMoreElements()) {
                    beanInfo = object2.nextElement();
                    try {
                        Object object3;
                        object = this.editor.getExtendedPropertiesManager().getExtendedPropertiesDisplayName(this.editor.getBean().getClass(), beanInfo);
                        constructor = this.editor.getExtendedPropertiesBean(beanInfo);
                        if (n < this.extendedPropertiesViews.size()) {
                            jComponent = (PropertiesViewContainer)this.extendedPropertiesViews.elementAt(n);
                        } else {
                            object3 = (PropertiesExtendible)this.editor.getBean();
                            boolean bl = object3.getExtendedProperties().get(beanInfo) != null;
                            jComponent = this.createPropertiesView(this.editor, new BeanPropertyFilter(), "", true, bl);
                            this.extendedPropertiesViews.addElement(jComponent);
                        }
                        this.extendedPropertiesContainer.add((Component)jComponent, new ColumnConstraints(2, 2));
                        ((PropertiesViewContainer)jComponent).getCheckbox().removeItemListener(this);
                        ((PropertiesViewContainer)jComponent).setUserObject(beanInfo);
                        ((PropertiesViewContainer)jComponent).setTitle((String)object);
                        ((PropertiesViewContainer)jComponent).getView().setEnabled(constructor != null);
                        ((PropertiesViewContainer)jComponent).getCheckbox().setSelected(constructor != null);
                        ((PropertiesViewContainer)jComponent).setUserObject(beanInfo);
                        ((PropertiesViewContainer)jComponent).getCheckbox().addItemListener(this);
                        object3 = this.editor.getExtendedPropertiesManager().getExtendedPropertiesType(this.editor.getBean().getClass(), beanInfo);
                        ((PropertiesViewContainer)jComponent).getView().setBeanClass((Class)object3);
                        BeanInfo beanInfo2 = this.editor.getExtendedPropertiesBeanInfo(beanInfo);
                        ((BeanPropertyFilter)((PropertiesViewContainer)jComponent).getView().getFilter()).setBeanInfo(beanInfo2);
                        ++n;
                    }
                    catch (NoSuchExtendedPropertiesException noSuchExtendedPropertiesException) {
                        System.err.println("WARNING: could not add extended property " + beanInfo);
                        noSuchExtendedPropertiesException.printStackTrace();
                    }
                }
                this.extendedPropertiesContainer.setVisible(n > 0);
            }
            catch (ExtendedPropertiesNotSupported extendedPropertiesNotSupported) {
                throw new Error();
            }
            catch (BeanEditorException beanEditorException) {
                beanEditorException.printStackTrace();
            }
        } else {
            this.extendedPropertiesContainer.setVisible(false);
        }
        boolean bl = false;
        object2 = new Stack();
        beanInfo = this.editor.getBeanInfo();
        while (beanInfo != null) {
            object = beanInfo.getBeanDescriptor();
            if (object != null && ((BeanDescriptor)object).getCustomizerClass() != null) {
                ((Stack)object2).push(((BeanDescriptor)object).getCustomizerClass());
            }
            beanInfo = beanInfo instanceof BeanInfoAggregate ? ((BeanInfoAggregate)beanInfo).getParentBeanInfo() : null;
        }
        while (!((Vector)object2).isEmpty()) {
            object = (Class)((Stack)object2).pop();
            try {
                constructor = ((Class)object).getConstructor(class$java$lang$Object != null ? class$java$lang$Object : BeanEditorView.class$("java.lang.Object"));
                jComponent = (JComponent)constructor.newInstance(this.editor.getBean());
                this.beanCustomizerContainer.add((Component)jComponent, new ColumnConstraints(2, 2));
                bl = true;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.beanCustomizerContainer.setVisible(bl);
        if (!(this.editor.getBean() == null || this.advancedView.isVisible() || this.standardView.isVisible() || this.extendedPropertiesContainer.isVisible() || this.beanCustomizerContainer.isVisible())) {
            this.labelNoProperties.setVisible(true);
        } else {
            this.labelNoProperties.setVisible(false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private PropertiesViewContainer createPropertiesView(BeanEditor beanEditor, PropertyFilter propertyFilter, String string, boolean bl, boolean bl2) {
        PropertiesView propertiesView = new PropertiesView(beanEditor, propertyFilter);
        propertiesView.setBorder((Border)new IndentedBorder(true));
        propertiesView.addFocusListener(this);
        propertiesView.addItemListener(this);
        propertiesView.addInitializedListener(this);
        return new PropertiesViewContainer(propertiesView, string, bl, bl2);
    }

    public void focusGained(FocusEvent focusEvent) {
        JTable jTable;
        if (focusEvent.getSource() instanceof JTable && (jTable = (JTable)focusEvent.getSource()).getParent() instanceof PropertiesView && jTable.getParent() != this.currentView) {
            this.currentView = (PropertiesView)jTable.getParent();
            this.currentView.clearSelected();
            this.adjustHighlighting();
            this.itemStateChanged(new ItemEvent(this.currentView, 701, this, 1));
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.adjustHighlighting();
    }

    public BeanEditor getBeanEditor() {
        return this.editor;
    }

    public String[] getBeanProperties(Class clazz) {
        Vector<String> vector = new Vector<String>();
        Object object = this.editor.getBean();
        if (object != null) {
            int n;
            if (object.getClass() == clazz) {
                int n2;
                Object object2;
                n = 0;
                while (n < this.beanCustomizerContainer.getComponentCount()) {
                    object2 = this.beanCustomizerContainer.getComponent(n);
                    if (object2 instanceof AbstractCustomizer) {
                        String[] stringArray = ((AbstractCustomizer)object2).getBeanProperties();
                        n2 = 0;
                        while (stringArray != null && n2 < stringArray.length) {
                            vector.addElement(stringArray[n2]);
                            ++n2;
                        }
                    }
                    ++n;
                }
                object2 = new PropertiesView[]{this.standardView.getView(), this.advancedView.getView()};
                int n3 = 0;
                while (n3 < ((PropertiesView[])object2).length) {
                    n2 = 0;
                    while (n2 < object2[n3].getPropertyCount()) {
                        vector.addElement(object2[n3].getPropertyName(n2));
                        ++n2;
                    }
                    ++n3;
                }
            } else {
                n = 0;
                while (n < this.extendedPropertiesContainer.getComponentCount()) {
                    PropertiesViewContainer propertiesViewContainer = (PropertiesViewContainer)this.extendedPropertiesContainer.getComponent(n);
                    if (propertiesViewContainer.getView().getBeanClass() == clazz) {
                        int n4 = 0;
                        while (n4 < propertiesViewContainer.getView().getPropertyCount()) {
                            vector.addElement(propertiesViewContainer.getView().getPropertyName(n4));
                            ++n4;
                        }
                    }
                    ++n;
                }
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object getSelectedBean() {
        return this.currentView != null ? this.currentView.getSelectedBean() : null;
    }

    public Class getSelectedBeanType() {
        return this.currentView != null ? this.currentView.getSelectedBeanType() : null;
    }

    public Object[] getSelectedObjects() {
        String string = this.getSelectedProperty();
        if (string != null) {
            return new Object[]{string};
        }
        return null;
    }

    public String getSelectedProperty() {
        return this.currentView != null ? this.currentView.getSelectedProperty() : null;
    }

    public void initialized(InitializedEvent initializedEvent) {
        if (initializedEvent.getSource() instanceof PropertiesView) {
            PropertiesViewContainer propertiesViewContainer = null;
            PropertiesView propertiesView = (PropertiesView)initializedEvent.getSource();
            if (this.standardView.getView() == propertiesView) {
                propertiesViewContainer = this.standardView;
            } else if (this.advancedView.getView() == propertiesView) {
                propertiesViewContainer = this.advancedView;
            } else {
                Enumeration enumeration = this.extendedPropertiesViews.elements();
                while (propertiesViewContainer == null && enumeration.hasMoreElements()) {
                    PropertiesViewContainer propertiesViewContainer2 = (PropertiesViewContainer)enumeration.nextElement();
                    if (propertiesViewContainer2.getView() != propertiesView) continue;
                    propertiesViewContainer = propertiesViewContainer2;
                }
            }
            if (propertiesViewContainer != null) {
                if (propertiesViewContainer == this.standardView || propertiesViewContainer == this.advancedView) {
                    propertiesViewContainer.setVisible(initializedEvent.isEmpty() ^ true);
                }
                propertiesViewContainer.refreshDisplay();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JCheckBox && !this.settingCheckbox) {
            int n = 0;
            while (n < this.extendedPropertiesViews.size()) {
                PropertiesViewContainer propertiesViewContainer = (PropertiesViewContainer)this.extendedPropertiesViews.elementAt(n);
                if (propertiesViewContainer.getCheckbox() == itemEvent.getSource()) {
                    try {
                        boolean bl = false;
                        if (propertiesViewContainer.getCheckbox().isSelected()) {
                            try {
                                this.editor.addExtendedProperties(propertiesViewContainer.getUserObject());
                                bl = true;
                            }
                            catch (NoSuchExtendedPropertiesException noSuchExtendedPropertiesException) {
                                noSuchExtendedPropertiesException.printStackTrace();
                            }
                        } else {
                            boolean bl2 = true;
                            if (propertiesViewContainer.getView().getPropertyCount() > 0) {
                                int n2 = JOptionPane.showOptionDialog(this, "Remove this option and lose its current settings?", "Confirm", -1, 2, null, new String[]{"Yes", "No"}, "No");
                                boolean bl3 = bl2 = n2 == 0;
                            }
                            if (bl2) {
                                this.editor.removeExtendedProperties(propertiesViewContainer.getUserObject());
                                bl = true;
                            } else {
                                this.settingCheckbox = true;
                                propertiesViewContainer.getCheckbox().setSelected(true);
                                this.settingCheckbox = false;
                            }
                        }
                        if (!bl) break;
                        propertiesViewContainer.getView().setEnabled(propertiesViewContainer.getCheckbox().isSelected());
                        propertiesViewContainer.setExpanded(propertiesViewContainer.getCheckbox().isSelected());
                        break;
                    }
                    catch (ExtendedPropertiesNotSupported extendedPropertiesNotSupported) {
                        throw new Error();
                    }
                    catch (BeanEditorException beanEditorException) {
                        beanEditorException.printStackTrace();
                        break;
                    }
                }
                ++n;
            }
        } else if (itemEvent.getSource() instanceof PropertiesView) {
            this.currentView = (PropertiesView)itemEvent.getSource();
            int n = 0;
            while (n < this.itemListeners.size()) {
                ((ItemListener)this.itemListeners.elementAt(n)).itemStateChanged(itemEvent);
                ++n;
            }
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListeners.removeElement(itemListener);
    }
}

