/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;

class ExpansionLabel
extends JComponent
implements ItemSelectable {
    private final int iconWidth = 10;
    private final int iconHeight = 10;
    private final int spacing = 4;
    private String text;
    private boolean expanded;
    private Insets insets;
    private boolean handleVisible = true;
    private boolean hasFocus = false;
    private Rectangle iconBounds = null;
    private Vector listeners = new Vector();

    public ExpansionLabel(String string, boolean bl) {
        this.text = string;
        this.expanded = bl;
        this.insets = new Insets(1, 0, 1, 0);
        this.setRequestFocusEnabled(true);
        this.enableEvents(28L);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listeners.addElement(itemListener);
    }

    private boolean clickedIcon(Point point) {
        if (this.iconBounds == null) {
            return false;
        }
        return this.iconBounds.contains(point);
    }

    void doClick() {
        this.expanded ^= true;
        this.repaint();
        this.fireItemEvent();
    }

    private void fireItemEvent() {
        ItemEvent itemEvent = new ItemEvent(this, 701, this.text, this.expanded ? 1 : 2);
        int n = 0;
        while (n < this.listeners.size()) {
            ((ItemListener)this.listeners.elementAt(n)).itemStateChanged(itemEvent);
            ++n;
        }
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.insets.left + 10 + 4 + fontMetrics.stringWidth(this.text) + this.insets.right, this.insets.top + Math.max(10, fontMetrics.getHeight() + this.insets.bottom));
    }

    public Object[] getSelectedObjects() {
        if (this.expanded) {
            return new Object[]{this.text};
        }
        return new Object[0];
    }

    String getText() {
        return this.text;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isFocusTraversable() {
        return this.isVisible();
    }

    boolean isHandleVisible() {
        return this.handleVisible;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.handleVisible) {
            this.paintIcon(graphics);
        }
        this.paintText(graphics);
    }

    private void paintIcon(Graphics graphics) {
        int n = 2;
        Rectangle rectangle = graphics.getClipBounds();
        this.iconBounds = new Rectangle(this.insets.left, (rectangle.height - 10) / 2, 10, 10);
        graphics.setColor(Color.white);
        graphics.fillRect(this.iconBounds.x, this.iconBounds.y, this.iconBounds.width, this.iconBounds.height);
        graphics.setColor(Color.black);
        graphics.drawRect(this.iconBounds.x, this.iconBounds.y, this.iconBounds.width, this.iconBounds.height);
        int n2 = this.iconBounds.y + this.iconBounds.height / 2;
        graphics.drawLine(this.iconBounds.x + 2, n2, this.iconBounds.x + this.iconBounds.width - 2, n2);
        int n3 = this.iconBounds.x + this.iconBounds.width / 2;
        if (!this.expanded) {
            graphics.drawLine(n3, this.iconBounds.y + 2, n3, this.iconBounds.y + this.iconBounds.height - 2);
        }
    }

    private void paintText(Graphics graphics) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        if (fontMetrics != null) {
            Rectangle rectangle = graphics.getClipBounds();
            int n = fontMetrics.getAscent();
            Rectangle rectangle2 = new Rectangle(this.insets.left + 10 + 4, 0, fontMetrics.stringWidth(this.text), rectangle.height);
            if (this.hasFocus()) {
                graphics.setColor(SystemColor.activeCaption);
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.setColor(SystemColor.activeCaptionText);
            } else {
                graphics.setColor(this.getForeground());
            }
            graphics.drawString(this.text, this.insets.left + 10 + 4, (rectangle.height - n) / 2 + n - 1);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.hasFocus = focusEvent.getID() == 1004;
            this.repaint();
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getModifiers() == 0 && (keyEvent.getKeyChar() == ' ' || keyEvent.getKeyChar() == '\n')) {
            this.doClick();
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            if (!this.hasFocus()) {
                this.requestFocus();
            }
            if (this.clickedIcon(mouseEvent.getPoint())) {
                this.doClick();
            } else if (mouseEvent.getClickCount() == 2) {
                this.doClick();
            }
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listeners.removeElement(itemListener);
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    void setHandleVisible(boolean bl) {
        this.handleVisible = bl;
    }

    void setText(String string) {
        this.text = string;
    }
}

