/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans;

import com.installshield.beans.BeanEditor;
import com.installshield.beans.BeanEditorException;
import com.installshield.beans.ExtendedPropertiesNotSupported;
import com.installshield.beans.InitializedEvent;
import com.installshield.beans.InitializedListener;
import com.installshield.beans.JTableInlineEditor;
import com.installshield.beans.NoSuchExtendedPropertiesException;
import com.installshield.beans.PropertiesExtendible;
import com.installshield.beans.PropertyFilter;
import com.installshield.beans.editors.AbstractEditor;
import com.installshield.beans.editors.EditorUI;
import com.installshield.beans.editors.EllipsesEditorUI;
import com.installshield.beans.editors.StringEditorUI;
import com.installshield.beans.editors.TagSelectionUI;
import com.installshield.util.ClassUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PropertiesView
extends JPanel
implements ItemSelectable,
InitializedListener {
    private PropertyFilter filter;
    private BeanEditor editor;
    private PropertiesTable table;
    private PropertiesModel model;
    private Vector itemListeners = new Vector();
    private Vector initializedListeners = new Vector();
    private boolean requestedVisibility = true;
    private Class beanClass = null;
    private Object[] selectedData = new Object[3];
    private StringBuffer buf = new StringBuffer();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public PropertiesView(BeanEditor beanEditor, PropertyFilter propertyFilter) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        if (beanEditor == null) {
            throw new NullPointerException("editor cannot be null");
        }
        this.editor = beanEditor;
        this.filter = propertyFilter;
        this.model = new PropertiesModel();
        this.model.setEditor(beanEditor);
        this.model.addInitializedListener(this);
        propertyFilter.addItemListener(this.model);
        this.table = new PropertiesTable(this.model);
        this.table.getSelectionModel().setSelectionMode(0);
        BeanTableCellEditor beanTableCellEditor = new BeanTableCellEditor(this.model);
        BeanTableCellRenderer beanTableCellRenderer = new BeanTableCellRenderer();
        this.add((Component)this.table, "Center");
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(1).setCellEditor(beanTableCellEditor);
        tableColumnModel.getColumn(1).setCellRenderer(beanTableCellRenderer);
    }

    public void addFocusListener(FocusListener focusListener) {
        if (this.table != null) {
            this.table.addFocusListener(focusListener);
        }
    }

    public void addInitializedListener(InitializedListener initializedListener) {
        this.initializedListeners.addElement(initializedListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListeners.addElement(itemListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearSelected() {
        this.selectedData[0] = null;
        this.selectedData[1] = null;
        this.selectedData[2] = null;
    }

    private void fireItemEvent(boolean bl) {
        ItemEvent itemEvent = new ItemEvent(this, 701, this.getSelectedProperty(), bl ? 2 : 1);
        int n = 0;
        while (n < this.itemListeners.size()) {
            ((ItemListener)this.itemListeners.elementAt(n)).itemStateChanged(itemEvent);
            ++n;
        }
    }

    private String formatPropertyName(String string) {
        if (string.indexOf(32) == -1) {
            return ClassUtils.createPropertyDisplayName(string);
        }
        return string;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public BeanEditor getBeanEditor() {
        return this.editor;
    }

    public PropertyFilter getFilter() {
        return this.filter;
    }

    public int getPropertyCount() {
        return this.table.getRowCount();
    }

    public String getPropertyName(int n) {
        return this.model.getPD(n).getName();
    }

    public Object getSelectedBean() {
        return this.selectedData[0];
    }

    public Class getSelectedBeanType() {
        return (Class)this.selectedData[1];
    }

    public Object[] getSelectedObjects() {
        String string = this.getSelectedProperty();
        if (string != null) {
            return new Object[]{string};
        }
        return new Object[0];
    }

    public String getSelectedProperty() {
        return (String)this.selectedData[2];
    }

    public boolean hasFocus() {
        return this.table != null ? this.table.hasFocus() : false;
    }

    public void initialized(InitializedEvent initializedEvent) {
        this.setVisible(false);
        this.setVisible(true);
        InitializedEvent initializedEvent2 = new InitializedEvent(this, initializedEvent.isEmpty());
        int n = 0;
        while (n < this.initializedListeners.size()) {
            ((InitializedListener)this.initializedListeners.elementAt(n)).initialized(initializedEvent2);
            ++n;
        }
    }

    public void removeFocusListener(FocusListener focusListener) {
        if (this.table != null) {
            this.table.removeFocusListener(focusListener);
        }
    }

    public void removeInitializedListener(InitializedListener initializedListener) {
        this.initializedListeners.removeElement(initializedListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListeners.removeElement(itemListener);
    }

    public void setBeanClass(Class clazz) {
        this.beanClass = clazz;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setHighlighting(this.hasFocus());
    }

    public void setHighlighting(boolean bl) {
        if (bl) {
            this.table.setSelectionBackground(SystemColor.textHighlight);
            this.table.setSelectionForeground(SystemColor.textHighlightText);
        } else {
            this.table.setSelectionBackground(SystemColor.window);
            this.table.setSelectionForeground(SystemColor.textText);
        }
    }

    public void setSelectedProperty(String string) {
        if (string != null) {
            int n = 0;
            while (n < this.table.getRowCount()) {
                if (this.model.getPD(n).getName().equals(string)) {
                    this.table.setRowSelectionInterval(n, n);
                    this.table.setColumnSelectionInterval(0, 1);
                }
                ++n;
            }
        } else {
            this.table.removeRowSelectionInterval(0, this.table.getRowCount() - 1);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl && this.model.getRowCount() > 0);
    }

    class PropertiesTable
    extends JTable {
        private boolean initialized = false;
        private boolean resizingColumn = false;
        private int columnBeingResized = -1;
        private Point resizingBeganAt = null;
        private int drawLineAtX = -1;
        private boolean processingKeyEvent = false;

        public PropertiesTable(PropertiesModel propertiesModel) {
            super(propertiesModel);
            this.enableEvents(8L);
            this.enableEvents(16L);
            this.enableEvents(32L);
            this.initialized = true;
            this.setRowHeight(20);
        }

        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            Component component;
            boolean bl = super.editCellAt(n, n2, eventObject);
            if (bl && (component = this.getEditorComponent()) != null) {
                component.requestFocus();
                component.repaint();
            }
            return bl;
        }

        private int getColumnDivider(Point point) {
            int n = -1;
            int n2 = 0;
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n3 = tableColumnModel.getColumnCount();
            int n4 = 0;
            while (n4 < n3 - 1 && n < 0) {
                TableColumn tableColumn = tableColumnModel.getColumn(n4);
                if (point.x >= (n2 += tableColumn.getWidth()) - 3 && point.x <= n2 + 3) {
                    n = n4;
                }
                ++n4;
            }
            return n;
        }

        public boolean isCellEditable(int n, int n2) {
            return this.isEnabled() && super.isCellEditable(n, n2);
        }

        public void paint(Graphics graphics) {
            if (this.hasFocus() && this.getSelectedRow() == -1 && this.getRowCount() > 0) {
                this.addRowSelectionInterval(0, 0);
            }
            super.paint(graphics);
            if (this.resizingColumn && this.drawLineAtX >= 0) {
                graphics.drawLine(this.drawLineAtX, 0, this.drawLineAtX, this.getHeight());
            }
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() != 401 || keyEvent.getKeyCode() != 9) {
                this.processingKeyEvent = true;
                try {
                    super.processKeyEvent(keyEvent);
                }
                catch (Throwable throwable) {}
                this.processingKeyEvent = false;
            }
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            boolean bl = false;
            if (!this.resizingColumn && mouseEvent.getID() == 501 && (mouseEvent.getModifiers() & 0x10) == 16) {
                this.columnBeingResized = this.getColumnDivider(mouseEvent.getPoint());
                if (this.columnBeingResized >= 0) {
                    this.resizingColumn = true;
                    this.resizingBeganAt = mouseEvent.getPoint();
                    bl = true;
                }
            } else if (this.resizingColumn && mouseEvent.getID() == 502 && (mouseEvent.getModifiers() & 0x10) == 16) {
                int n = mouseEvent.getPoint().x - this.resizingBeganAt.x;
                int n2 = this.getColumnModel().getColumn(this.columnBeingResized).getWidth();
                this.getColumnModel().getColumn(this.columnBeingResized).setWidth(n2 + n);
                n2 = this.getColumnModel().getColumn(this.columnBeingResized + 1).getWidth();
                this.getColumnModel().getColumn(this.columnBeingResized + 1).setWidth(n2 - n);
                this.invalidate();
                this.repaint();
                this.columnBeingResized = -1;
                this.resizingColumn = false;
                this.resizingBeganAt = null;
                this.drawLineAtX = -1;
                bl = true;
            }
            if (!bl) {
                super.processMouseEvent(mouseEvent);
            }
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            boolean bl = false;
            if (this.resizingColumn) {
                this.setCursor(Cursor.getPredefinedCursor(11));
                if (this.drawLineAtX != mouseEvent.getPoint().x) {
                    this.drawLineAtX = mouseEvent.getPoint().x;
                    this.invalidate();
                    this.repaint();
                }
                bl = true;
            } else {
                int n = this.getColumnDivider(mouseEvent.getPoint());
                if (n >= 0) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if (!bl) {
                super.processMouseMotionEvent(mouseEvent);
            }
        }

        public void setEnabled(boolean bl) {
            if (!bl && this.isEnabled()) {
                TableCellEditor tableCellEditor;
                int n = this.getSelectedRow();
                int n2 = this.getSelectedColumn();
                if (n >= 0 && n < this.getRowCount() && n2 >= 0 && n2 < this.getColumnCount() && (tableCellEditor = this.getCellEditor(this.getSelectedRow(), this.getSelectedColumn())) != null) {
                    tableCellEditor.cancelCellEditing();
                }
            }
            this.setForeground(SystemColor.textText);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            super.valueChanged(listSelectionEvent);
            if (this.initialized && !listSelectionEvent.getValueIsAdjusting()) {
                int n = this.getSelectedRow();
                if (n != -1) {
                    ((PropertiesView)PropertiesView.this).selectedData[0] = PropertiesView.this.model.getBean(n);
                    BeanDescriptor beanDescriptor = PropertiesView.this.model.getBeanInfo(n).getBeanDescriptor();
                    ((PropertiesView)PropertiesView.this).selectedData[1] = beanDescriptor != null ? beanDescriptor.getBeanClass() : null;
                    ((PropertiesView)PropertiesView.this).selectedData[2] = PropertiesView.this.model.getPD(n).getName();
                } else {
                    PropertiesView.this.clearSelected();
                }
                PropertiesView.this.fireItemEvent(false);
            }
        }
    }

    class PropertiesModel
    extends DefaultTableModel
    implements ItemListener {
        private BeanEditor editor = null;
        private Vector properties = new Vector();
        private Vector initializedListeners = new Vector();

        PropertiesModel() {
        }

        public void addInitializedListener(InitializedListener initializedListener) {
            this.initializedListeners.addElement(initializedListener);
        }

        private void addProperties(Object object, BeanInfo beanInfo, PropertyFilter propertyFilter) {
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (propertyFilter.accept(beanInfo, propertyDescriptorArray[n])) {
                    this.properties.addElement(new PropertiesModelItem(object, beanInfo, propertyDescriptorArray[n]));
                }
                ++n;
            }
        }

        Object getBean(int n) {
            return ((PropertiesModelItem)this.properties.elementAt(n)).getBean();
        }

        BeanInfo getBeanInfo(int n) {
            return ((PropertiesModelItem)this.properties.elementAt(n)).getBeanInfo();
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PropertiesView.class$("java.lang.String"));
                }
                case 1: {
                    return class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = PropertiesView.class$("java.lang.Object"));
                }
            }
            throw new Error();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Property";
                }
                case 1: {
                    return "Value";
                }
            }
            throw new Error();
        }

        PropertyDescriptor getPD(int n) {
            return ((PropertiesModelItem)this.properties.elementAt(n)).getPropertyDescriptor();
        }

        PropertyEditor getPropertyEditor(int n) {
            return BeanEditor.getPropertyEditor(this.getBeanInfo(n), this.getPD(n).getName());
        }

        public int getRowCount() {
            return this.properties != null ? this.properties.size() : 0;
        }

        public Object getValueAt(int n, int n2) {
            Object object = this.getBean(n);
            switch (n2) {
                case 0: {
                    return PropertiesView.this.formatPropertyName(this.getPD(n).getDisplayName());
                }
                case 1: {
                    if (object != null) {
                        try {
                            return BeanEditor.getPropertyValue(object, this.getPD(n));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    return "";
                }
            }
            throw new Error();
        }

        void initialize(BeanEditor beanEditor, PropertyFilter propertyFilter) {
            Object object;
            this.properties.removeAllElements();
            this.editor = beanEditor;
            if (beanEditor.getBean() != null) {
                this.addProperties(beanEditor.getBean(), beanEditor.getBeanInfo(), propertyFilter);
                if (beanEditor.isExtendedPropertiesSupported() && beanEditor.getBean() instanceof PropertiesExtendible) {
                    try {
                        object = beanEditor.getExtendedPropertiesManager();
                        Enumeration enumeration = object.extendedPropertiesKeys(beanEditor.getBean().getClass());
                        while (enumeration.hasMoreElements()) {
                            Object e = enumeration.nextElement();
                            this.addProperties(beanEditor.getExtendedPropertiesBean(e), beanEditor.getExtendedPropertiesBeanInfo(e), propertyFilter);
                        }
                    }
                    catch (ExtendedPropertiesNotSupported extendedPropertiesNotSupported) {
                        throw new Error();
                    }
                    catch (NoSuchExtendedPropertiesException noSuchExtendedPropertiesException) {
                        noSuchExtendedPropertiesException.printStackTrace();
                    }
                    catch (BeanEditorException beanEditorException) {
                        beanEditorException.printStackTrace();
                    }
                }
            }
            object = new InitializedEvent(this, this.getRowCount() <= 0);
            int n = 0;
            while (n < this.initializedListeners.size()) {
                ((InitializedListener)this.initializedListeners.elementAt(n)).initialized((InitializedEvent)object);
                ++n;
            }
        }

        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 0: {
                    return false;
                }
                case 1: {
                    return this.getBean(n) != null && BeanEditor.isPropertyEditable(this.getPD(n));
                }
            }
            throw new Error();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.initialize(this.editor, PropertiesView.this.filter);
        }

        public void removeInitializedListener(InitializedListener initializedListener) {
            this.initializedListeners.removeElement(initializedListener);
        }

        public void setEditor(BeanEditor beanEditor) {
            this.editor = beanEditor;
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2 = this.getBean(n);
            if (object2 == null) {
                return;
            }
            if (n2 != 1) {
                throw new Error();
            }
            try {
                PropertyDescriptor propertyDescriptor = this.getPD(n);
                Object object3 = BeanEditor.getPropertyValue(object2, propertyDescriptor);
                BeanEditor.setPropertyValue(object2, propertyDescriptor, object);
                this.editor.propertyChange(new PropertyChangeEvent(this, propertyDescriptor.getName(), object3, object));
            }
            catch (BeanEditorException beanEditorException) {
                beanEditorException.printStackTrace();
            }
        }
    }

    class PropertiesModelItem {
        private Object bean = null;
        private BeanInfo beanInfo = null;
        private PropertyDescriptor pd = null;

        public PropertiesModelItem(Object object, BeanInfo beanInfo, PropertyDescriptor propertyDescriptor) {
            this.bean = object;
            this.beanInfo = beanInfo;
            this.pd = propertyDescriptor;
        }

        public Object getBean() {
            return this.bean;
        }

        public BeanInfo getBeanInfo() {
            return this.beanInfo;
        }

        public PropertyDescriptor getPropertyDescriptor() {
            return this.pd;
        }
    }

    class BeanTableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private Component component = null;
        private PropertyEditor pe = null;
        private EllipsesEditorUI ellipsesEditorUI = null;
        private TagSelectionUI tagSelectionUI = null;
        private StringEditorUI stringEditorUI = null;

        public BeanTableCellEditor(PropertiesModel propertiesModel) {
            super(new JCheckBox());
            this.setClickCountToStart(1);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            block3: {
                bl = false;
                try {
                    bl = this.stopCellEditing();
                }
                catch (Throwable throwable) {
                    if (System.getProperty("is.debug") == null) break block3;
                    throwable.printStackTrace();
                }
            }
            if (!bl) {
                Toolkit.getDefaultToolkit().beep();
                this.cancelCellEditing();
            }
        }

        public Object getCellEditorValue() {
            if (this.component instanceof EditorUI) {
                ((EditorUI)this.component).writeToEditor(this.pe);
            }
            return this.pe.getValue();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.pe = PropertiesView.this.model.getPropertyEditor(n);
            this.pe.setValue(object);
            if (this.pe instanceof AbstractEditor) {
                ((AbstractEditor)this.pe).setBean(PropertiesView.this.model.getBean(n));
            }
            if (this.pe.supportsCustomEditor()) {
                this.component = this.pe.getCustomEditor();
                if (this.component instanceof JTableInlineEditor) {
                    ((JTableInlineEditor)((Object)this.component)).addActionListener(this);
                } else {
                    if (this.ellipsesEditorUI == null) {
                        this.ellipsesEditorUI = new EllipsesEditorUI();
                        this.ellipsesEditorUI.addActionListener((ActionListener)this);
                    }
                    this.ellipsesEditorUI.setup(PropertiesView.this.model.getBean(n), PropertiesView.this.model.getPD(n), this.pe, (TableCellEditor)this);
                    this.ellipsesEditorUI.readFromEditor(this.pe);
                    this.component = this.ellipsesEditorUI;
                }
            } else {
                String[] stringArray = this.pe.getTags();
                if (stringArray != null && stringArray.length > 0) {
                    if (this.tagSelectionUI == null) {
                        this.tagSelectionUI = new TagSelectionUI();
                        this.tagSelectionUI.addActionListener((ActionListener)this);
                    }
                    this.tagSelectionUI.setTags(stringArray);
                    this.tagSelectionUI.readFromEditor(this.pe);
                    this.component = this.tagSelectionUI;
                } else {
                    if (this.stringEditorUI == null) {
                        this.stringEditorUI = new StringEditorUI();
                        this.stringEditorUI.addActionListener((ActionListener)this);
                    }
                    this.stringEditorUI.readFromEditor(this.pe);
                    this.component = this.stringEditorUI;
                }
            }
            return this.component;
        }
    }

    class BeanTableCellRenderer
    extends DefaultTableCellRenderer {
        BeanTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Object object2 = ((PropertiesModel)jTable.getModel()).getBean(n);
            if (object2 != null) {
                jLabel.setText(BeanEditor.getPropertyValueDisplayName(object, ((PropertiesModel)jTable.getModel()).getPD(n)));
            }
            return jLabel;
        }
    }
}

