/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.beans.PropertiesExtendible;
import com.installshield.product.ProductTree;
import com.installshield.util.ClassUtils;
import com.installshield.util.GenericTreeNode;
import com.installshield.util.Log;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import java.util.Dictionary;
import java.util.Properties;

public abstract class ProductBean
implements PropertiesExtendible,
Log {
    private static int nextId = 1;
    private String beanId = "";
    private String displayName = "";
    private Properties extendedProperties = new Properties();
    private boolean active = true;
    private ProductBean parent = null;
    GenericTreeNode node = new GenericTreeNode();
    ProductTree tree = null;
    private WizardServices services = null;

    public ProductBean() {
        this.setBeanId(ProductBean.nextBeanId());
    }

    public String getBeanId() {
        return this.beanId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Dictionary getExtendedProperties() {
        return this.extendedProperties;
    }

    public ProductTree getProductTree() {
        return this.tree;
    }

    protected Service getService(String string) throws ServiceException {
        if (this.services == null) {
            throw new IllegalStateException("service manager not initialized");
        }
        return this.services.getService(string);
    }

    public WizardServices getServices() {
        return this.services;
    }

    public void initialize(WizardServices wizardServices) {
        this.services = wizardServices;
    }

    public boolean isActive() {
        return this.active;
    }

    protected boolean isEventLogged(String string) {
        return this.services != null && this.services.getWizardLog().isEventLogged(string);
    }

    public void logEvent(Object object, String string, Object object2) {
        if (this.services == null) {
            throw new IllegalStateException("services not initialized");
        }
        this.services.logEvent(object, string, object2);
    }

    private static String nextBeanId() {
        return "bean" + nextId++;
    }

    protected String resolveString(String string) {
        if (this.services == null) {
            throw new IllegalStateException("services not initialized");
        }
        return this.services.resolveString(string);
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setBeanId(String string) {
        this.beanId = string;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String toString() {
        return String.valueOf(ClassUtils.createObjectDisplayName(this)) + " (" + this.getBeanId() + ")";
    }
}

