/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanCondition;
import com.installshield.product.ProductBuilder;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.ProductTree;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.StandardProductTreeIterator;
import com.installshield.wizard.service.ServiceBuilderSupport;
import com.installshield.wizard.service.WizardServices;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public class ProductWriter {
    private ProductTree tree;
    private String defName;
    private WizardServices services;
    static /* synthetic */ Class class$com$installshield$product$i18n$ProductResources;
    static /* synthetic */ Class class$com$installshield$product$ProductTree;

    public ProductWriter(ProductTree productTree, String string, WizardServices wizardServices) {
        this.tree = productTree;
        this.defName = string;
        this.services = wizardServices;
    }

    public void build(ServiceBuilderSupport serviceBuilderSupport) {
        try {
            serviceBuilderSupport.putPackage("com.installshield.product");
            serviceBuilderSupport.putClass((class$com$installshield$product$i18n$ProductResources != null ? class$com$installshield$product$i18n$ProductResources : (class$com$installshield$product$i18n$ProductResources = ProductWriter.class$("com.installshield.product.i18n.ProductResources"))).getName());
            serviceBuilderSupport.putPackage("com.installshield.product.qjml");
            serviceBuilderSupport.putResourceBundles("com.installshield.product.i18n.ProductResources", serviceBuilderSupport.getSelectedLocales());
            serviceBuilderSupport.putDefinition(this.tree, class$com$installshield$product$ProductTree != null ? class$com$installshield$product$ProductTree : (class$com$installshield$product$ProductTree = ProductWriter.class$("com.installshield.product.ProductTree")), this.defName);
            serviceBuilderSupport.putRequiredService("productService");
            this.buildProductTree(this.tree, new ProductBuilderSupport(serviceBuilderSupport, this.tree.getUninstallerArchive()), this.services);
        }
        catch (Throwable throwable) {
            serviceBuilderSupport.logEvent(this, "err", throwable);
        }
    }

    private void buildConditions(ProductBuilderSupport productBuilderSupport, GenericSoftwareObject genericSoftwareObject) {
        Enumeration enumeration = genericSoftwareObject.conditionNames();
        while (enumeration.hasMoreElements()) {
            ProductBeanCondition productBeanCondition = genericSoftwareObject.getCondition((String)enumeration.nextElement());
            try {
                productBuilderSupport.putClass(productBeanCondition.getClass().getName());
                productBeanCondition.build(productBuilderSupport);
            }
            catch (IOException iOException) {
                productBuilderSupport.logEvent(this, "err", iOException);
            }
        }
    }

    private void buildProductBean(ProductBean productBean, ProductBuilderSupport productBuilderSupport, boolean bl, Hashtable hashtable, Hashtable hashtable2) {
        Object object;
        boolean bl2 = false;
        if (bl) {
            if (!this.checkForEmptyProperty(productBuilderSupport, productBean, productBean.getBeanId(), "beanId") && this.checkForNonUniqueProperty(productBuilderSupport, productBean, productBean.getBeanId(), "beanId", hashtable2)) {
                bl2 = true;
            }
            if (productBean instanceof GenericSoftwareObject) {
                object = ((GenericSoftwareObject)productBean).getName();
                if (!this.checkForEmptyProperty(productBuilderSupport, productBean, (String)object, "name") && this.checkForNonUniqueProperty(productBuilderSupport, productBean, (String)object, "name", hashtable)) {
                    bl2 = true;
                }
                if (this.validateRequired(productBuilderSupport, productBean)) {
                    bl2 = true;
                }
            } else if (productBean instanceof SoftwareObjectReference && !this.checkForEmptyProperty(productBuilderSupport, productBean, (String)(object = ((SoftwareObjectReference)productBean).getName()), "name") && this.checkForNonUniqueProperty(productBuilderSupport, productBean, (String)object, "name", hashtable)) {
                bl2 = true;
            }
        }
        if (!bl2) {
            try {
                productBuilderSupport.putClass(productBean.getClass().getName());
                object = productBean.getExtendedProperties();
                Enumeration enumeration = ((Dictionary)object).keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    Object v = ((Dictionary)object).get(k);
                    if (this.isNonJavaClass(v.getClass())) {
                        productBuilderSupport.putClass(v.getClass().getName());
                    }
                    if (!(v instanceof ProductBuilder)) continue;
                    ((ProductBuilder)v).build(productBuilderSupport);
                }
            }
            catch (IOException iOException) {
                productBuilderSupport.logEvent(this, "err", iOException);
                return;
            }
            productBean.initialize(this.services);
            if (productBean instanceof ProductBuilder) {
                ((ProductBuilder)((Object)productBean)).build(productBuilderSupport);
            }
            if (productBean instanceof GenericSoftwareObject) {
                this.buildConditions(productBuilderSupport, (GenericSoftwareObject)productBean);
            }
        }
    }

    private void buildProductTree(ProductTree productTree, ProductBuilderSupport productBuilderSupport, WizardServices wizardServices) throws ProductException {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        this.buildProductBean(productTree.getUninstallerArchive(), productBuilderSupport, false, null, null);
        this.buildProductBean(productTree.getUninstallerJVMResolution(), productBuilderSupport, false, null, null);
        this.buildProductBean(productTree.getUninstallerLauncher(), productBuilderSupport, false, null, null);
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree);
        ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (productBean != standardProductTreeIterator.end()) {
            this.buildProductBean(productBean, productBuilderSupport, true, hashtable, hashtable2);
            productBean = standardProductTreeIterator.getNext(productBean);
        }
    }

    private boolean checkForEmptyProperty(ProductBuilderSupport productBuilderSupport, ProductBean productBean, String string, String string2) {
        boolean bl = false;
        if (string == null || string.length() == 0) {
            bl = true;
            productBuilderSupport.logEvent(this, "err", "The " + string2 + " property of " + productBean.getDisplayName() + " cannot be null or empty");
        }
        return bl;
    }

    private boolean checkForNonUniqueProperty(ProductBuilderSupport productBuilderSupport, ProductBean productBean, String string, String string2, Hashtable hashtable) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            String string3 = productBean.getDisplayName();
            if (string3 == null) {
                string3 = new String();
            }
            if (hashtable.containsKey(string)) {
                bl = true;
                productBuilderSupport.logEvent(this, "err", "The " + string2 + " property of both " + hashtable.get(string) + " and " + string3 + " have the same value: " + string);
            } else {
                hashtable.put(string, string3);
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private boolean isNonJavaClass(Class clazz) {
        String string = clazz.getName();
        return !string.startsWith("java.") && !string.startsWith("javax.");
    }

    private boolean validateRequired(ProductBuilderSupport productBuilderSupport, ProductBean productBean) {
        boolean bl = false;
        SoftwareObjectReference[] softwareObjectReferenceArray = ((GenericSoftwareObject)productBean).getRequired();
        int n = 0;
        while (n < softwareObjectReferenceArray.length) {
            ProductBean productBean2 = productBean;
            while (productBean2 != null) {
                if (((GenericSoftwareObject)productBean2).getKey().equals(softwareObjectReferenceArray[n].getKey())) {
                    SoftwareObject softwareObject = productBean.getProductTree().resolveKey(softwareObjectReferenceArray[n].getKey());
                    productBuilderSupport.logEvent(this, "err", String.valueOf(productBean.getDisplayName()) + " cannot require " + softwareObject.getDisplayName());
                    bl = true;
                }
                productBean2 = productBean.getProductTree().getParent(productBean2);
            }
            ++n;
        }
        return bl;
    }
}

