/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.FileUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class RequiredBytesTable
implements PropertyAccessible {
    private Hashtable requiredBytes = new Hashtable();

    public void addBytes(RequiredBytesTable requiredBytesTable) {
        Enumeration enumeration = requiredBytesTable.locations();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.addBytes(string, requiredBytesTable.getBytes(string));
        }
    }

    public void addBytes(String string, long l) {
        this.requiredBytes.put(string, new Long(l + this.getBytes(string)));
    }

    public void clearLocation(String string) {
        this.requiredBytes.remove(string);
    }

    public RequiredBytesTable consolidate(String[] stringArray) {
        return this.consolidate(stringArray, "");
    }

    public RequiredBytesTable consolidate(String[] stringArray, String string) {
        RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
        int n = 0;
        while (n < stringArray.length) {
            requiredBytesTable.addBytes(stringArray[n], 0L);
            ++n;
        }
        Enumeration enumeration = this.requiredBytes.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = FileUtils.getPartitionName(string2, stringArray, string);
            requiredBytesTable.addBytes(string3, (Long)this.requiredBytes.get(string2));
        }
        return requiredBytesTable;
    }

    public long getBytes(String string) {
        Long l = (Long)this.requiredBytes.get(string);
        return l != null ? l : 0L;
    }

    public String getRequiredBytesAsString() {
        long l;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.requiredBytes.keys();
        if (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            l = this.getBytes(string);
            stringBuffer.append(String.valueOf(string) + "\t" + l);
        }
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            l = this.getBytes(string);
            stringBuffer.append("\n" + string + "\t" + l);
        }
        return stringBuffer.toString();
    }

    public long getTotalBytes() {
        long l = 0L;
        Enumeration enumeration = this.requiredBytes.keys();
        while (enumeration.hasMoreElements()) {
            l += ((Long)this.requiredBytes.get(enumeration.nextElement())).longValue();
        }
        return l;
    }

    public boolean locationExists(String string) {
        return this.requiredBytes.containsKey(string);
    }

    public Enumeration locations() {
        return this.requiredBytes.keys();
    }

    public void setRequiredBytesAsString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("\t");
            String string3 = string2.substring(0, n);
            long l = new Long(string2.substring(n + 1));
            this.addBytes(string3, l);
        }
    }

    public String toString() {
        return "RequiredBytesTable: {" + this.getRequiredBytesAsString() + "}";
    }
}

