/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.actions.DesktopIconExtra;
import com.installshield.product.service.desktop.DesktopService;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class DesktopIcon
extends ProductAction {
    private String folder = "";
    private String name = "";
    private String args = "";
    private String workingDirectory = "";
    private String target = "";
    private String itemOwner = "";
    private String itemGroup = "";
    private String folderOwner = "";
    private String folderGroup = "";
    private boolean relativeTarget = true;
    private boolean workingDirectoryRelative = true;
    static /* synthetic */ Class class$com$installshield$product$actions$DesktopIconBeanInfo;
    static /* synthetic */ Class class$com$installshield$product$actions$DesktopIconExtra;

    public void build(ProductBuilderSupport productBuilderSupport) {
        try {
            productBuilderSupport.putClass((class$com$installshield$product$actions$DesktopIconBeanInfo != null ? class$com$installshield$product$actions$DesktopIconBeanInfo : (class$com$installshield$product$actions$DesktopIconBeanInfo = DesktopIcon.class$("com.installshield.product.actions.DesktopIconBeanInfo"))).getName());
            productBuilderSupport.putClass((class$com$installshield$product$actions$DesktopIconExtra != null ? class$com$installshield$product$actions$DesktopIconExtra : (class$com$installshield$product$actions$DesktopIconExtra = DesktopIcon.class$("com.installshield.product.actions.DesktopIconExtra"))).getName());
            productBuilderSupport.putRequiredService("desktopService");
            productBuilderSupport.putRequiredService("fileService");
            Enumeration enumeration = this.getExtras();
            while (enumeration.hasMoreElements()) {
                DesktopIconExtra desktopIconExtra = (DesktopIconExtra)enumeration.nextElement();
                String string = desktopIconExtra.getIconFile();
                if (string == null || string.length() <= 0 || desktopIconExtra.getIconFileType() != 2) continue;
                String string2 = FileUtils.getName(string);
                String string3 = String.valueOf(this.getBeanId()) + "/" + desktopIconExtra.getPlatformId() + "/" + string2;
                productBuilderSupport.getWriter().putResource(string, string3);
            }
        }
        catch (IOException iOException) {
            this.logEvent(this, "err", iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private String createFileName(String string, String string2) {
        return new File(string, string2).getAbsolutePath().replace('\\', File.separatorChar).replace('/', File.separatorChar);
    }

    private String createFileNameRelativeToDestination(String string) {
        return new File(this.getProductTree().getInstallLocation(this), string).getAbsolutePath();
    }

    public String getArgs() {
        return this.args;
    }

    private DesktopIconExtra getExtra(String string) {
        DesktopIconExtra desktopIconExtra = null;
        Dictionary dictionary = this.getExtendedProperties();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements() && desktopIconExtra == null) {
                Object k = enumeration.nextElement();
                Object v = dictionary.get(k);
                if (v == null || !(v instanceof DesktopIconExtra) || !string.equals(((DesktopIconExtra)v).getPlatformId())) continue;
                desktopIconExtra = (DesktopIconExtra)v;
            }
        }
        return desktopIconExtra;
    }

    private Enumeration getExtras() {
        Vector<DesktopIconExtra> vector = new Vector<DesktopIconExtra>();
        Dictionary dictionary = this.getExtendedProperties();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!(dictionary.get(string) instanceof DesktopIconExtra)) continue;
            vector.addElement((DesktopIconExtra)dictionary.get(string));
        }
        return vector.elements();
    }

    public String getFolder() {
        return this.folder;
    }

    public String getFolderGroup() {
        return this.folderGroup;
    }

    public String getFolderOwner() {
        return this.folderOwner;
    }

    public String getItemGroup() {
        return this.itemGroup;
    }

    public String getItemOwner() {
        return this.itemOwner;
    }

    public String getName() {
        return this.name;
    }

    public RequiredBytesTable getRequiredBytes() throws ProductException {
        try {
            RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
            DesktopService desktopService = (DesktopService)this.getService("desktopService");
            DesktopIconExtra desktopIconExtra = this.getExtra(desktopService.getPlatformId());
            if (desktopIconExtra != null) {
                String string = desktopIconExtra.getIconFile();
                int n = desktopIconExtra.getIconFileType();
                if (string != null && string.trim().length() > 0 && n == 2) {
                    FileService fileService = (FileService)this.getService("fileService");
                    String[] stringArray = fileService.getPartitionNames();
                    String string2 = FileUtils.getName(string);
                    URL uRL = this.getResource(String.valueOf(this.getBeanId()) + "/" + desktopIconExtra.getPlatformId() + "/" + string2);
                    if (uRL != null) {
                        File file = new File(this.getProductTree().getInstallLocation(this), string2);
                        requiredBytesTable.addBytes(FileUtils.getPartitionName(file.getAbsolutePath(), stringArray), new File(uRL.getFile()).length());
                    } else {
                        throw new IOException(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DesktopIcon.iconResourceNotFound", new String[]{String.valueOf(this.getBeanId()) + "/" + string2}));
                    }
                }
            }
            return requiredBytesTable;
        }
        catch (Exception exception) {
            throw new ProductException(exception);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void install(ProductActionSupport productActionSupport) {
        try {
            String string;
            DesktopService desktopService = (DesktopService)this.getService("desktopService");
            DesktopIconExtra desktopIconExtra = this.getExtra(desktopService.getPlatformId());
            File file = new File(this.getProductTree().getInstallLocation(this));
            String string2 = this.getTarget();
            String string3 = null;
            String string4 = null;
            boolean bl = this.isRelativeTarget();
            if (desktopIconExtra != null) {
                string = desktopIconExtra.getPlatformSpecificTarget();
                if (string != null && string.trim().length() > 0) {
                    string2 = string;
                    bl = desktopIconExtra.isRelativePlatformSpecificTarget();
                }
                string3 = this.installIconFile(desktopIconExtra.getPlatformId(), desktopIconExtra.getIconFile(), desktopIconExtra.getIconFileType());
                string4 = desktopIconExtra.getFolderContext();
            }
            string = bl ? this.createFileName(file.getAbsolutePath(), this.resolveString(string2)) : FileUtils.normalizeFileName(this.resolveString(string2));
            String string5 = this.folder;
            if (string4 != null && string4.trim().length() > 0) {
                string5 = FileUtils.appendSeparator(string4);
                string5 = String.valueOf(string5) + this.resolveString(this.folder);
            }
            String string6 = "";
            string6 = this.isWorkingDirectoryRelative() ? FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.resolveString(this.getWorkingDirectory())) : FileUtils.normalizeFileName(this.resolveString(this.getWorkingDirectory()));
            desktopService.createDesktopItem(string5, this.resolveString(this.name), string, this.resolveString(this.args), string3, string6);
            if (this.itemGroup != null && this.itemGroup.length() > 0) {
                desktopService.setDesktopItemOwnerGroup(string5, this.name, this.itemGroup);
            }
            if (this.itemOwner != null && this.itemOwner.length() > 0) {
                desktopService.setDesktopItemOwner(string5, this.name, this.itemOwner);
            }
            if (this.folder != null && this.folder.length() > 0) {
                if (this.folderGroup != null && this.folderGroup.length() > 0) {
                    desktopService.setDesktopFolderOwnerGroup(string5, this.folderGroup);
                }
                if (this.folderOwner != null && this.folderOwner.length() > 0) {
                    desktopService.setDesktopFolderOwner(string5, this.folderOwner);
                }
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DesktopIcon.couldNotCreate", new String[]{this.name}));
        }
    }

    private String installIconFile(String string, String string2, int n) {
        try {
            if (string2 != null && string2.trim().length() > 0) {
                if (n == 2) {
                    String string3 = FileUtils.getName(string2);
                    URL uRL = this.getResource(String.valueOf(this.getBeanId()) + "/" + string + "/" + string3);
                    if (uRL != null) {
                        File file = new File(this.getProductTree().getInstallLocation(this), string3);
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        FileUtils.copy(uRL.openStream(), fileOutputStream);
                        fileOutputStream.close();
                        return file.getAbsolutePath();
                    }
                    throw new IOException(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DesktopIcon.iconResourceNotFound", new String[]{String.valueOf(this.getBeanId()) + "/" + string3}));
                }
                return this.createFileNameRelativeToDestination(string2);
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
        return null;
    }

    public boolean isRelativeTarget() {
        return this.relativeTarget;
    }

    public boolean isWorkingDirectoryRelative() {
        return this.workingDirectoryRelative;
    }

    public void setArgs(String string) {
        if (string == null) {
            throw new IllegalArgumentException("args can not be null. ");
        }
        this.args = string;
    }

    public void setFolder(String string) {
        if (string == null) {
            throw new IllegalArgumentException("folderName cannot be null");
        }
        this.folder = string;
    }

    public void setFolderGroup(String string) {
        this.folderGroup = string;
    }

    public void setFolderOwner(String string) {
        this.folderOwner = string;
    }

    public void setItemGroup(String string) {
        this.itemGroup = string;
    }

    public void setItemOwner(String string) {
        this.itemOwner = string;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = string;
    }

    public void setRelativeTarget(boolean bl) {
        this.relativeTarget = bl;
    }

    public void setTarget(String string) {
        if (string == null) {
            throw new IllegalArgumentException("action cannot be null");
        }
        this.target = string;
    }

    public void setWorkingDirectory(String string) {
        if (string == null) {
            throw new IllegalArgumentException("workingDirectory can not be null. ");
        }
        this.workingDirectory = string;
    }

    public void setWorkingDirectoryRelative(boolean bl) {
        this.workingDirectoryRelative = bl;
    }

    public void uninstall(ProductActionSupport productActionSupport) {
        try {
            DesktopService desktopService = (DesktopService)this.getService("desktopService");
            DesktopIconExtra desktopIconExtra = this.getExtra(desktopService.getPlatformId());
            if (desktopIconExtra != null) {
                String string;
                String string2;
                if (desktopIconExtra.getIconFile() != null && desktopIconExtra.getIconFile().trim().length() > 0 && desktopIconExtra.getIconFileType() == 2) {
                    string2 = FileUtils.getName(desktopIconExtra.getIconFile());
                    string = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), string2);
                    FileService fileService = (FileService)this.getService("fileService");
                    if (fileService.fileExists(string)) {
                        fileService.deleteFile(string);
                    }
                }
                string2 = this.folder;
                string = desktopIconExtra.getFolderContext();
                if (string != null && string.trim().length() > 0) {
                    string2 = FileUtils.appendSeparator(string);
                    string2 = String.valueOf(string2) + this.resolveString(this.folder);
                }
                desktopService.removeDesktopItem(string2, this.resolveString(this.name));
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DesktopIcon.couldNotRemove", new String[]{this.name}));
        }
    }
}

