/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.archive.BuildEvent;
import com.installshield.archive.BuildListener;
import com.installshield.archive.ijar.IJAR;
import com.installshield.archive.ijar.IJAREntry;
import com.installshield.archive.ijar.IJARReader;
import com.installshield.archive.ijar.IJARWriter;
import com.installshield.product.Locatable;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionEvent;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.actions.SourceFile;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.rex.RegExprSyntaxException;
import com.installshield.util.rex.Rex;
import com.installshield.wizard.service.MutableOperationState;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.file.FileService;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Files
extends ProductAction
implements BuildListener,
Locatable {
    public static final String CREATE_FILE = "createFile";
    public static final String DELETE_FILE = "deleteFile";
    protected static final String CANT_SET_ATTRIBUTES_FLAG = "cantSetAttributes";
    protected static final String CANT_SET_FILE_TIMES_FLAG = "cantSetFileTimes";
    protected static final String REPLACE_EXISTING = "replaceExistingResponse";
    protected static final String REPLACE_NEWER = "replaceNewerResponse";
    protected static final String REMOVE_EXISTING = "removeExistingResponse";
    protected static final String REMOVE_MODIFIED = "removeModifiedResponse";
    protected static final String YES = "$L(com.installshield.wizard.i18n.WizardResources, yes)";
    protected static final String YES_TO_ALL = "$L(com.installshield.wizard.i18n.WizardResources, yesToAll)";
    protected static final String NO = "$L(com.installshield.wizard.i18n.WizardResources, no)";
    protected static final String NO_TO_ALL = "$L(com.installshield.wizard.i18n.WizardResources, noToAll)";
    protected static final String CANCEL = "$L(com.installshield.wizard.i18n.WizardResources, cancel)";
    protected static final String YES_RESPONSE = "yes";
    protected static final String YES_TO_ALL_RESPONSE = "yesToAll";
    protected static final String NO_RESPONSE = "no";
    protected static final String NO_TO_ALL_RESPONSE = "noToAll";
    protected static final String defaultIJARName = "ijar/default";
    private String owner = "";
    private String group = "";
    private String installLocation = null;
    private Vector files = new Vector();
    protected long totalBytes = -1L;
    protected int ijarOffset = -1;
    protected int ijarLength = -1;
    private boolean building = false;
    protected InstalledFiles installed = null;
    private byte[] buf = new byte[10240];
    protected int timeToInstall = 0;
    private boolean nativeServicesAvailable = true;
    static /* synthetic */ Class class$com$installshield$product$actions$SourceFile;
    static /* synthetic */ Class class$com$installshield$product$actions$FilesBeanInfo;

    public void addFile(SourceFile sourceFile) {
        this.files.addElement(sourceFile);
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        this.buildImpl(null, productBuilderSupport);
    }

    protected final void buildFile(String string, SourceFile sourceFile, FileAttributes fileAttributes, IJARWriter iJARWriter, ProductBuilderSupport productBuilderSupport, String string2, Vector vector) {
        File file = new File(sourceFile.getFileName());
        String string3 = file.getAbsolutePath();
        if (file.isFile()) {
            try {
                String string4;
                String string5 = file.getName();
                String string6 = string;
                boolean bl = false;
                if (string != null && string.trim().length() != 0) {
                    bl = true;
                    if (!sourceFile.isUsingGNUPattern()) {
                        string6 = this.translateToGNUPattern(string);
                    }
                }
                String string7 = string4 = string2 != null ? string3.substring(string2.length()) : string5;
                if (vector == null) {
                    if (!bl || Rex.matches(string5, string6)) {
                        FileAttributes fileAttributes2 = this.initializeSourceFileForBuild(sourceFile, fileAttributes);
                        IJAREntry iJAREntry = iJARWriter.addFile(new URL("file", "", -1, file.getAbsolutePath()), sourceFile.getType(), string4.replace(File.separatorChar, '/'), fileAttributes2, file.lastModified(), new byte[0]);
                        this.totalBytes += iJAREntry.size;
                    }
                } else if (!bl || Rex.matches(string5, string6)) {
                    Properties properties = new Properties();
                    ((Hashtable)properties).put("sourceName", file.getAbsolutePath());
                    ((Hashtable)properties).put("targetName", string4);
                    ((Hashtable)properties).put("size", new Long(file.length()));
                    ((Hashtable)properties).put("lastModified", new Long(file.lastModified()));
                    ((Hashtable)properties).put("type", new Integer(sourceFile.getType()));
                    vector.addElement(properties);
                }
            }
            catch (RegExprSyntaxException regExprSyntaxException) {
                this.logEvent(productBuilderSupport, this, "wrn", "Invalid regular expression: " + regExprSyntaxException.getMessage());
            }
            catch (IOException iOException) {
                this.logEvent(productBuilderSupport, this, "err", iOException);
            }
        } else if (file.isDirectory()) {
            File file2;
            int n;
            String[] stringArray = file.list();
            if (stringArray != null && stringArray.length == 0 && productBuilderSupport != null) {
                this.logEvent(productBuilderSupport, this, "wrn", "Directory " + file.getAbsolutePath() + " does not contain any files");
            } else if (sourceFile.getType() != 4) {
                n = 0;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    file2 = new File(file, stringArray[n2]);
                    if (file2.isFile()) {
                        n = 1;
                    }
                    ++n2;
                }
                if (n == 0) {
                    this.logEvent(productBuilderSupport, this, "wrn", "Directory " + file.getAbsolutePath() + " does not contain any files");
                }
            }
            n = 0;
            while (stringArray != null && n < stringArray.length) {
                file2 = new File(file, stringArray[n]);
                SourceFile sourceFile2 = new SourceFile(file2.getAbsolutePath());
                sourceFile2.setUsingGNUPattern(sourceFile.isUsingGNUPattern());
                if (file2.isFile()) {
                    sourceFile2.setType(2);
                    this.buildFile(string, sourceFile2, fileAttributes, iJARWriter, productBuilderSupport, string2, vector);
                } else if (file.isDirectory() && sourceFile.getType() == 4) {
                    try {
                        if (vector == null) {
                            FileAttributes fileAttributes3 = new FileAttributes();
                            if (this.initializeSourceFileForBuild(sourceFile, fileAttributes) != null) {
                                fileAttributes3 = (FileAttributes)this.initializeSourceFileForBuild(sourceFile, fileAttributes).clone();
                            }
                            fileAttributes3.setAttributeState(4096, true);
                            String string8 = file2.getAbsolutePath();
                            String string9 = string2 != null ? string8.substring(string2.length()) : file2.getName();
                            IJAREntry iJAREntry = iJARWriter.addFile(new URL("file", "", -1, file2.getAbsolutePath()), sourceFile.getType(), string9.replace(File.separatorChar, '/'), fileAttributes3, file2.lastModified(), new byte[0]);
                            this.totalBytes += iJAREntry.size;
                        }
                    }
                    catch (IOException iOException) {
                        this.logEvent(productBuilderSupport, this, "err", iOException);
                    }
                    sourceFile2.setType(sourceFile.getType());
                    if (string2 == null) {
                        string2 = String.valueOf(string3) + (string3.endsWith(File.separator) ? "" : File.separator);
                    }
                    this.buildFile(string, sourceFile2, fileAttributes, iJARWriter, productBuilderSupport, string2, vector);
                }
                ++n;
            }
        } else {
            this.logEvent(productBuilderSupport, this, "err", "File does not exist: " + file.getAbsolutePath());
        }
    }

    public void buildFinished(BuildEvent buildEvent) {
        this.building = false;
        this.totalBytes = -1L;
        buildEvent.getSupport().removeBuildListener(this);
    }

    private void buildImpl(Vector vector, ProductBuilderSupport productBuilderSupport) {
        block11: {
            try {
                if (vector == null) {
                    this.building = true;
                    productBuilderSupport.addBuildListener(this);
                    this.nativeServicesAvailable = true;
                    productBuilderSupport.putClass((class$com$installshield$product$actions$SourceFile != null ? class$com$installshield$product$actions$SourceFile : (class$com$installshield$product$actions$SourceFile = Files.class$("com.installshield.product.actions.SourceFile"))).getName());
                    productBuilderSupport.putClass((class$com$installshield$product$actions$FilesBeanInfo != null ? class$com$installshield$product$actions$FilesBeanInfo : (class$com$installshield$product$actions$FilesBeanInfo = Files.class$("com.installshield.product.actions.FilesBeanInfo"))).getName());
                    productBuilderSupport.putClass("com.installshield.product.actions.Files$InstalledFile");
                    productBuilderSupport.putClass("com.installshield.product.actions.Files$InstalledFiles");
                    productBuilderSupport.putClass("com.installshield.product.actions.Files$NativeAsciiInputStream");
                    productBuilderSupport.putPackage("com.installshield.archive.ijar");
                    productBuilderSupport.putRequiredService("fileService");
                    this.totalBytes = 0L;
                    IJARWriter iJARWriter = IJAR.getWriter(productBuilderSupport, defaultIJARName);
                    productBuilderSupport.excludeUninstallerResource(defaultIJARName);
                    IJARWriter iJARWriter2 = iJARWriter;
                    synchronized (iJARWriter2) {
                        this.ijarOffset = iJARWriter.currentOffset();
                        Vector vector2 = this.files;
                        synchronized (vector2) {
                            int n = this.files.size();
                            int n2 = 0;
                            while (n2 < n) {
                                SourceFile sourceFile = (SourceFile)this.files.elementAt(n2);
                                this.buildFile(sourceFile.getPattern(), sourceFile, sourceFile.getAttributes(), iJARWriter, productBuilderSupport, null, null);
                                ++n2;
                            }
                        }
                        this.ijarLength = iJARWriter.currentOffset() - this.ijarOffset;
                        break block11;
                    }
                }
                int n = this.files.size();
                int n3 = 0;
                while (n3 < n) {
                    SourceFile sourceFile = (SourceFile)this.files.elementAt(n3);
                    this.buildFile(sourceFile.getPattern(), sourceFile, sourceFile.getAttributes(), null, productBuilderSupport, null, vector);
                    ++n3;
                }
            }
            catch (IOException iOException) {
                this.logEvent(this, "err", iOException);
            }
        }
    }

    public Enumeration buildList() {
        Vector vector = new Vector();
        this.buildImpl(vector, null);
        return vector.elements();
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    private int calculateTimeToInstall(int n, long l) {
        return Math.max(1, Math.round((float)n * 0.25f) + Math.round((float)l * 2.5E-7f));
    }

    protected boolean canCopyFile(File file, int n, long l, ProductActionSupport productActionSupport) throws ServiceException {
        if (this.getValue(REPLACE_EXISTING) == null) {
            this.setValue(REPLACE_EXISTING, "unspecified");
        }
        if (this.getValue(REPLACE_NEWER) == null) {
            this.setValue(REPLACE_NEWER, "unspecified");
        }
        if (!file.exists()) {
            return true;
        }
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return false;
        }
        if (n == 3) {
            return this.compareDates(l, file.lastModified()) > 0;
        }
        if (n == 4) {
            if (this.compareDates(l, file.lastModified()) < 0) {
                this.refreshReplaceNewerResponse(file);
                String string = (String)this.getValue(REPLACE_NEWER);
                return string.equals(YES_RESPONSE) || string.equals(YES_TO_ALL_RESPONSE);
            }
            return true;
        }
        if (n == 5) {
            if (this.compareDates(l, file.lastModified()) < 0) {
                this.refreshReplaceNewerResponse(file);
                String string = (String)this.getValue(REPLACE_NEWER);
                return string.equals(YES_RESPONSE) || string.equals(YES_TO_ALL_RESPONSE);
            }
            this.refreshReplaceExistingResponse(file, this.compareDates(l, file.lastModified()) > 0);
            String string = (String)this.getValue(REPLACE_EXISTING);
            return string.equals(YES_RESPONSE) || string.equals(YES_TO_ALL_RESPONSE);
        }
        productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.illegalReplaceOption", new String[]{String.valueOf(n)}));
        return false;
    }

    protected boolean canRemoveFile(File file, int n, long l, ProductActionSupport productActionSupport) throws ServiceException {
        if (this.getValue(REMOVE_EXISTING) == null) {
            this.setValue(REMOVE_EXISTING, "unspecified");
        }
        if (this.getValue(REMOVE_MODIFIED) == null) {
            this.setValue(REMOVE_MODIFIED, "unspecified");
        }
        if (!file.exists()) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return false;
        }
        if (n == 3) {
            return this.compareDates(l, file.lastModified()) == 0;
        }
        if (n == 4) {
            long l2 = file.lastModified();
            String string = file.getAbsolutePath();
            this.logDebugEvent(String.valueOf(string) + "internal last modified = " + l);
            this.logDebugEvent(String.valueOf(string) + " last modified = " + l2);
            if (this.compareDates(l, l2) != 0) {
                this.refreshRemoveModifiedResponse(file);
                String string2 = (String)this.getValue(REMOVE_MODIFIED);
                return string2.equals(YES_RESPONSE) || string2.equals(YES_TO_ALL_RESPONSE);
            }
            return true;
        }
        if (n == 5) {
            if (this.compareDates(l, file.lastModified()) != 0) {
                this.refreshRemoveModifiedResponse(file);
                String string = (String)this.getValue(REMOVE_MODIFIED);
                return string.equals(YES_RESPONSE) || string.equals(YES_TO_ALL_RESPONSE);
            }
            this.refreshRemoveExistingResponse(file);
            String string = (String)this.getValue(REMOVE_EXISTING);
            return string.equals(YES_RESPONSE) || string.equals(YES_TO_ALL_RESPONSE);
        }
        productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.illegalRemoveOption", new String[]{String.valueOf(n)}));
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected int compareDates(long l, long l2) {
        long l3 = l - l2;
        if (Math.abs(l - l2) <= 1000L) {
            return 0;
        }
        return l3 > 0L ? 1 : -1;
    }

    protected int copy(InputStream inputStream, String string, MutableOperationState mutableOperationState) throws IOException {
        int n = 0;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            int n2 = 0;
            while ((n2 = inputStream.read(this.buf)) != -1) {
                if (!this.checkOperationState(mutableOperationState)) {
                    return n;
                }
                fileOutputStream.write(this.buf, 0, n2);
                n += n2;
                mutableOperationState.updatePercentComplete(this.timeToInstall, n2, this.totalBytes);
            }
        }
        catch (IOException iOException) {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            throw iOException;
        }
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
        return n;
    }

    protected final void copyFileWithFileService(InputStream inputStream, File file, MutableOperationState mutableOperationState, FileService fileService, IJARReader iJARReader, int n, ProductActionSupport productActionSupport) throws IOException, ServiceException {
        String string = FileUtils.createTempFile();
        this.copy(inputStream, string, mutableOperationState);
        if (!mutableOperationState.isCanceled()) {
            this.setAttributes(string, iJARReader, n, fileService, productActionSupport);
            this.setFileTimes(string, iJARReader, n, fileService, productActionSupport);
        }
        fileService.moveFile(string, file.getAbsolutePath(), true);
        FileUtils.clearTempFile(string);
    }

    protected String[] createDirs(File file) throws IOException {
        Object object;
        Stack<File> stack = new Stack<File>();
        File file2 = file;
        while (file2 != null && !file2.exists()) {
            stack.push(file2);
            object = file2.getParent();
            File file3 = file2 = object != null ? new File((String)object) : null;
        }
        object = new Vector();
        while (!stack.isEmpty()) {
            file2 = (File)stack.pop();
            if (file2.exists()) continue;
            if (!file2.mkdir()) {
                throw new IOException(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.couldNotCreateDir", new String[]{file2.getAbsolutePath()}));
            }
            ((Vector)object).addElement(file2.getAbsolutePath());
        }
        Object[] objectArray = new String[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        return objectArray;
    }

    protected boolean deleteDirWithFileService(File file) {
        boolean bl = false;
        try {
            FileService fileService = (FileService)this.getService("fileService");
            if (fileService != null) {
                bl = fileService.deleteDirectory(file.getAbsolutePath()) == 0;
            }
        }
        catch (ServiceException serviceException) {}
        return bl;
    }

    protected boolean deleteFileWithFileService(File file) {
        boolean bl = false;
        try {
            FileService fileService = (FileService)this.getService("fileService");
            if (fileService != null) {
                fileService.deleteFile(file.getAbsolutePath());
                bl = true;
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "wrn", serviceException.getMessage());
        }
        return bl;
    }

    protected boolean deleteWithFile(File file) {
        return file.delete();
    }

    private String formatCaption(String string) {
        int n = 50;
        int n2 = 33;
        int n3 = 16;
        String string2 = string;
        String string3 = "...";
        if (string.length() <= n) {
            return string;
        }
        int n4 = string.lastIndexOf(File.separator);
        String string4 = "";
        String string5 = "";
        if (n4 > 0) {
            string4 = string.substring(n4 + 1);
            string5 = string.substring(0, n4);
            String string6 = "";
            String string7 = "";
            int n5 = 0;
            string6 = string4.length() <= n2 ? string4 : String.valueOf(string4.substring(0, n2 - 3)) + string3;
            n5 = n2 - string6.length();
            string7 = string5.length() <= n3 ? string5 : String.valueOf(string5.substring(0, n5 + n3 - 3)) + string3;
            string2 = String.valueOf(string7) + File.separator + string6;
        } else {
            string2 = String.valueOf(string.substring(0, 47)) + string3;
        }
        return string2;
    }

    protected final IJARReader getDefaultIJARReader() throws IOException {
        URL uRL = this.getResource(defaultIJARName);
        return IJAR.getReader(uRL);
    }

    public int getEstimatedTimeToInstall() {
        return this.calculateTimeToInstall(this.ijarLength, this.totalBytes);
    }

    public SourceFile getFile(int n) {
        return (SourceFile)this.files.elementAt(n);
    }

    public SourceFile[] getFiles() {
        if (this.building) {
            return null;
        }
        Object[] objectArray = new SourceFile[this.files.size()];
        this.files.copyInto(objectArray);
        return objectArray;
    }

    public int getFilesCount() {
        return this.files.size();
    }

    public String getGroup() {
        return this.group;
    }

    public String getIJAREntry() {
        if (this.ijarOffset >= 0 && this.ijarLength >= 0) {
            return String.valueOf(this.ijarOffset) + "/" + this.ijarLength;
        }
        return null;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public String getOwner() {
        return this.owner;
    }

    public RequiredBytesTable getRequiredBytes() throws ProductException {
        RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
        if (this.totalBytes != -1L) {
            String string = this.getProductTree().getInstallLocation(this);
            requiredBytesTable.addBytes(string, this.totalBytes);
        }
        return requiredBytesTable;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    protected Object getValue(String string) {
        return this.getServices().getValue(string);
    }

    protected final FileAttributes initializeSourceFileForBuild(SourceFile sourceFile, FileAttributes fileAttributes) throws IOException {
        block4: {
            if (this.nativeServicesAvailable) {
                try {
                    if (fileAttributes == null) {
                        FileService fileService = (FileService)this.getService("fileService");
                        return fileService.getFileAttributes(sourceFile.getFileName());
                    }
                }
                catch (ServiceException serviceException) {
                    this.nativeServicesAvailable = false;
                    if (serviceException.getErrorCode() == 305) break block4;
                    throw new IOException(serviceException.toString());
                }
            }
        }
        return fileAttributes;
    }

    /*
     * Unable to fully structure code
     */
    public void install(ProductActionSupport var1_1) throws ProductException {
        var2_2 = this.getProductTree().getInstallLocation(this);
        var3_3 = false;
        var4_4 = var1_1.getOperationState();
        this.timeToInstall = this.getEstimatedTimeToInstall();
        try {
            try {
                var7_5 = this.getProductTree().getReplaceOption(this);
                var8_8 = this.getDefaultIJARReader();
                var9_9 = (FileService)this.getService("fileService");
                this.installed = new InstalledFiles();
                var10_10 = String.valueOf(this.getBeanId()) + "/installed";
                var1_1.putUninstallerResource(this.installed.getIndexFileName(), var10_10);
                var1_1.removeUninstallerResourceExclusion(var10_10);
                var11_11 = this.ijarOffset + this.ijarLength;
                var12_12 = this.ijarOffset;
                while (!var4_4.isCanceled() && var12_12 < var11_11) {
                    var13_13 = var8_8.getAttributes(var12_12);
                    if (var13_13 != null && var13_13.getAttributeState(4096)) {
                        var14_15 = var8_8.getFileName(var12_12).replace('/', File.separatorChar);
                        var15_16 = new File(var2_2, (String)var14_15);
                        if (!var15_16.exists()) {
                            var16_17 = this.createDirs((File)var15_16);
                            var17_18 = 0;
                            while (var17_18 < var16_17.length) {
                                this.installed.add(var16_17[var17_18], -1L);
                                ++var17_18;
                            }
                        }
                        this.setAttributes(var15_16.getAbsolutePath(), var8_8, var12_12, var9_9, var1_1);
                        var4_4.updatePercentComplete(this.timeToInstall, var8_8.getSize(var12_12), this.totalBytes);
                    }
                    ++var12_12;
                }
                var13_14 = this.ijarOffset;
                while (!var4_4.isCanceled() && var13_14 < var11_11) {
                    var14_15 = var8_8.getAttributes(var13_14);
                    if (var14_15 == null || !var14_15.getAttributeState(4096)) {
                        var15_16 = var8_8.getFileName(var13_14).replace('/', File.separatorChar);
                        var16_17 = new File(var2_2, (String)var15_16);
                        if (this.canCopyFile((File)var16_17, var7_5, var8_8.getLastModified(var13_14), var1_1)) {
                            var4_4.setStatusDetail(this.formatCaption(var16_17.getAbsolutePath()));
                            var17_20 = new File(var16_17.getParent());
                            if (!var17_20.exists()) {
                                var18_21 = this.createDirs(var17_20);
                                var19_24 = 0;
                                while (var19_24 < var18_21.length) {
                                    this.installed.add(var18_21[var19_24], -1L);
                                    ++var19_24;
                                }
                            }
                            try {
                                var20_26 = var8_8.getInputStream(var13_14);
                                var21_27 = var8_8.getType(var13_14);
                                var22_28 = false;
                                try {
                                    var23_29 = var16_17.getAbsolutePath();
                                    if (var21_27 != 2) {
                                        var20_26 = new NativeAsciiInputStream(var20_26, var21_27);
                                    }
                                    this.copy(var20_26, var23_29, var4_4);
                                    var22_28 = true;
                                }
                                catch (IOException v0) {
                                    this.copyFileWithFileService(var20_26, (File)var16_17, var4_4, var9_9, var8_8, var13_14, var1_1);
                                }
                                var20_26.close();
                                if (var22_28 && !var4_4.isCanceled()) {
                                    this.setAttributes(var16_17.getAbsolutePath(), var8_8, var13_14, var9_9, var1_1);
                                    this.setFileTimes(var16_17.getAbsolutePath(), var8_8, var13_14, var9_9, var1_1);
                                }
                                if (this.group != null && this.group.length() > 0) {
                                    var9_9.setFileOwnerGroup(var16_17.getAbsolutePath(), this.group);
                                }
                                if (this.owner != null && this.owner.length() > 0) {
                                    var9_9.setFileOwner(var16_17.getAbsolutePath(), this.owner);
                                }
                                this.fireProductActionEvent(new ProductActionEvent(this, this.getParentComponent(), "createFile", var16_17));
                            }
                            finally {
                                var19_23 = null;
                                this.installed.add(var16_17.getAbsolutePath(), var16_17.lastModified());
                            }
                        }
                        var4_4.updatePercentComplete(this.timeToInstall, var8_8.getSize(var13_14), this.totalBytes);
                    }
                    ++var13_14;
                }
            }
            catch (IOException var7_6) {
                this.logEvent(this, "err", var7_6);
                var3_3 = true;
            }
            catch (ServiceException var7_7) {
                this.logEvent(this, "err", var7_7);
                var3_3 = true;
            }
            var6_30 = null;
            var1_1.getOperationState().setStatusDetail("");
            ** if (this.installed == null) goto lbl-1000
        }
        catch (Throwable var5_32) {
            var6_31 = null;
            var1_1.getOperationState().setStatusDetail("");
            if (this.installed != null) {
                try {
                    this.installed.close();
                }
                catch (IOException v2) {}
            }
            throw var5_32;
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.installed.close();
            }
            catch (IOException v1) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        if (var3_3) {
            var1_1.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.installError", new String[]{this.getBeanId()}));
        }
    }

    public boolean isBuilding() {
        return this.building;
    }

    protected boolean isDirectory(File file) {
        return file.isDirectory();
    }

    private void logDebugEvent(String string) {
        this.logEvent(this, WizardLog.subclassEvent("dbg", "files"), string);
    }

    private void logEvent(ProductBuilderSupport productBuilderSupport, Object object, String string, Object object2) {
        if (productBuilderSupport != null) {
            productBuilderSupport.logEvent(object, string, object2);
        }
    }

    private String mapResponse(String string) {
        String string2 = YES_RESPONSE;
        if (string.equals(this.resolveString(YES))) {
            string2 = YES_RESPONSE;
        } else if (string.equals(this.resolveString(YES_TO_ALL))) {
            string2 = YES_TO_ALL_RESPONSE;
        } else if (string.equals(this.resolveString(NO))) {
            string2 = NO_RESPONSE;
        } else if (string.equals(this.resolveString(NO_TO_ALL))) {
            string2 = NO_TO_ALL_RESPONSE;
        }
        return string2;
    }

    protected void refreshRemoveExistingResponse(File file) throws ServiceException {
        String string = (String)this.getValue(REMOVE_EXISTING);
        if (!string.equals(YES_TO_ALL_RESPONSE) && !string.equals(NO_TO_ALL_RESPONSE)) {
            string = (String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.removeExistingFile"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.fileExisting", new String[]{file.getAbsolutePath()}), new Object[]{this.resolveString(YES), this.resolveString(YES_TO_ALL), this.resolveString(NO), this.resolveString(NO_TO_ALL)}, this.resolveString(YES));
            string = this.mapResponse(string);
            this.setValue(REMOVE_EXISTING, string);
        }
    }

    protected void refreshRemoveModifiedResponse(File file) throws ServiceException {
        String string = (String)this.getValue(REMOVE_MODIFIED);
        if (!string.equals(YES_TO_ALL_RESPONSE) && !string.equals(NO_TO_ALL_RESPONSE)) {
            string = (String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.removeExistingFile"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.fileModified", new String[]{file.getAbsolutePath()}), new Object[]{this.resolveString(YES), this.resolveString(YES_TO_ALL), this.resolveString(NO), this.resolveString(NO_TO_ALL)}, this.resolveString(NO));
            string = this.mapResponse(string);
            this.setValue(REMOVE_MODIFIED, string);
        }
    }

    protected final void refreshReplaceExistingResponse(File file, boolean bl) throws ServiceException {
        String string = (String)this.getValue(REPLACE_EXISTING);
        if (!string.equals(YES_TO_ALL_RESPONSE) && !string.equals(NO_TO_ALL_RESPONSE)) {
            String string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.alreadyExist", new String[]{file.getAbsolutePath()});
            if (bl) {
                string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.olderVersionExists", new String[]{file.getAbsolutePath()});
            }
            string = (String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.replaceFile"), string2, new Object[]{this.resolveString(YES), this.resolveString(YES_TO_ALL), this.resolveString(NO), this.resolveString(NO_TO_ALL)}, this.resolveString(YES));
            string = this.mapResponse(string);
            this.setValue(REPLACE_EXISTING, string);
        }
    }

    protected final void refreshReplaceNewerResponse(File file) throws ServiceException {
        String string = (String)this.getValue(REPLACE_NEWER);
        if (!string.equals(YES_TO_ALL_RESPONSE) && !string.equals(NO_TO_ALL_RESPONSE)) {
            string = (String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.replaceExistingFile"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.newerVersionExist", new String[]{file.getAbsolutePath()}), new Object[]{this.resolveString(YES), this.resolveString(YES_TO_ALL), this.resolveString(NO), this.resolveString(NO_TO_ALL)}, this.resolveString(NO));
            string = this.mapResponse(string);
            this.setValue(REPLACE_NEWER, string);
        }
    }

    public void removeFile(int n) {
        this.files.removeElementAt(n);
    }

    public void removeFile(SourceFile sourceFile) {
        this.files.removeElement(sourceFile);
    }

    public void removeFiles(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            SourceFile[] sourceFileArray = new SourceFile[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                sourceFileArray[n] = this.getFile(nArray[n]);
                ++n;
            }
            int n2 = 0;
            while (n2 < sourceFileArray.length) {
                this.removeFile(sourceFileArray[n2]);
                ++n2;
            }
        }
    }

    private void setAttributes(String string, IJARReader iJARReader, int n, FileService fileService, ProductActionSupport productActionSupport) throws IOException {
        block3: {
            FileAttributes fileAttributes;
            if (this.getValue(CANT_SET_ATTRIBUTES_FLAG) != null || (fileAttributes = iJARReader.getAttributes(n)) == null) break block3;
            try {
                fileService.setFileAttributes(string, fileAttributes);
            }
            catch (ServiceException serviceException) {
                if (serviceException.getErrorCode() == 305) {
                    this.logEvent(this, "wrn", "Cannot set file attributes: operation is not supported by the current file service implementation.");
                    productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.fileAttributeError"));
                    this.setValue(CANT_SET_ATTRIBUTES_FLAG, "1");
                    break block3;
                }
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    protected final void setFileTimes(String string, IJARReader iJARReader, int n, FileService fileService, ProductActionSupport productActionSupport) throws IOException {
        block3: {
            long l;
            if (this.getValue(CANT_SET_FILE_TIMES_FLAG) != null || (l = iJARReader.getLastModified(n)) <= 0L) break block3;
            try {
                fileService.setFileModified(string, iJARReader.getLastModified(n));
            }
            catch (ServiceException serviceException) {
                if (serviceException.getErrorCode() == 305) {
                    this.logEvent(this, "wrn", "Cannot set file times: operation is not supported by the current file service implementation.");
                    productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.fileTimesError"));
                    this.setValue(CANT_SET_FILE_TIMES_FLAG, "1");
                    break block3;
                }
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    public void setFiles(SourceFile[] sourceFileArray) {
        this.files.removeAllElements();
        if (sourceFileArray != null) {
            int n = 0;
            while (n < sourceFileArray.length) {
                this.files.addElement(sourceFileArray[n]);
                ++n;
            }
        }
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setIJAREntry(String string) {
        block2: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            if (stringTokenizer.countTokens() != 2) break block2;
            try {
                this.ijarOffset = Integer.parseInt(stringTokenizer.nextToken());
                this.ijarLength = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                this.ijarOffset = -1;
                this.ijarLength = -1;
            }
        }
    }

    public void setInstallLocation(String string) {
        this.installLocation = string.trim().length() == 0 ? null : string;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public void setTotalBytes(long l) {
        this.totalBytes = l;
    }

    protected void setValue(String string, Object object) {
        this.getServices().setValue(string, object);
    }

    private String translateToGNUPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != '*' && string.charAt(n) != '?' && string.charAt(n) != '\\') {
                stringBuffer.append('\"');
                stringBuffer.append(string.charAt(n));
                stringBuffer.append('\"');
            } else if (string.charAt(n) == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append('\\');
            } else if (string.charAt(n) == '*') {
                stringBuffer.append('.');
                stringBuffer.append('*');
            } else if (string.charAt(n) == '?') {
                stringBuffer.append('.');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public void uninstall(ProductActionSupport var1_1) throws ProductException {
        var2_2 = false;
        var3_3 = false;
        var4_4 = new Vector<File>();
        try {
            try {
                var7_5 = this.getProductTree().getRemoveOption(this);
                if (this.installed != null) {
                    this.installed = new InstalledFiles(new URL("file", "", -1, this.installed.getIndexFileName()));
                } else if (this.installed == null) {
                    this.installed = new InstalledFiles(this.getResource(String.valueOf(this.getBeanId()) + "/installed"));
                }
                var8_9 = this.installed.read();
                while (var8_9 != null) {
                    block34: {
                        var9_10 = new File(var8_9.fileName);
                        if (this.isDirectory(var9_10)) {
                            var4_4.addElement(var9_10);
                        } else {
                            try {
                                if (!this.canRemoveFile(var9_10, var7_5, var8_9.lastModified, var1_1)) break block34;
                                var10_12 = false;
                                try {
                                    if (this.deleteWithFile(var9_10)) {
                                        var10_12 = true;
                                    }
                                }
                                catch (Throwable v0) {}
                                if (!var10_12) {
                                    if (!this.deleteFileWithFileService(var9_10)) {
                                        this.logEvent(this, "wrn", "Could not delete file " + var9_10.getAbsolutePath());
                                        var1_1.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.couldNotDeleteFile", new String[]{var9_10.getAbsolutePath()}));
                                        var3_3 = true;
                                    } else {
                                        var10_12 = true;
                                    }
                                }
                                if (var10_12) {
                                    this.fireProductActionEvent(new ProductActionEvent(this, this.getParentComponent(), "deleteFile", var8_9.fileName));
                                }
                            }
                            catch (ServiceException var10_13) {
                                this.logEvent(this, "err", var10_13);
                            }
                        }
                    }
                    var8_9 = this.installed.read();
                }
                var9_11 = -1;
                while (var9_11 != 0) {
                    var9_11 = 0;
                    var10_14 = 0;
                    while (var10_14 < var4_4.size()) {
                        var11_16 = (File)var4_4.elementAt(var10_14);
                        if (var11_16 != null && this.deleteWithFile(var11_16)) {
                            var4_4.setElementAt(null, var10_14);
                            ++var9_11;
                        }
                        ++var10_14;
                    }
                }
                do {
                    var10_15 = false;
                    var11_17 = 0;
                    while (var11_17 < var4_4.size()) {
                        var12_18 = (File)var4_4.elementAt(var11_17);
                        if (var12_18 != null && this.deleteDirWithFileService(var12_18)) {
                            var10_15 = true;
                            var4_4.setElementAt(null, var11_17);
                        }
                        ++var11_17;
                    }
                } while (var10_15);
                var11_17 = 0;
                while (var11_17 < var4_4.size()) {
                    var12_18 = (File)var4_4.elementAt(var11_17);
                    if (var12_18 != null) {
                        var1_1.putInstalledDirectory(var12_18.getAbsolutePath());
                    }
                    ++var11_17;
                }
            }
            catch (IOException var7_6) {
                this.logEvent(this, "err", var7_6);
                var2_2 = true;
            }
            var6_19 = null;
            ** if (this.installed == null) goto lbl-1000
        }
        catch (Throwable var5_21) {
            var6_20 = null;
            if (this.installed != null) {
                try {
                    this.installed.close();
                    var7_8 = String.valueOf(this.getBeanId()) + "/installed";
                    var1_1.putUninstallerResourceExclusion(var7_8);
                }
                catch (IOException v2) {}
            }
            throw var5_21;
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.installed.close();
                var7_7 = String.valueOf(this.getBeanId()) + "/installed";
                var1_1.putUninstallerResourceExclusion(var7_7);
            }
            catch (IOException v1) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        if (var2_2) {
            var1_1.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.uninstallError", new String[]{this.getBeanId()}));
        }
        if (var3_3) {
            var1_1.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.couldNotUninstallFiles", new String[]{this.getBeanId()}));
        }
    }

    public void writeFinished(BuildEvent buildEvent) {
    }

    public void writeStarting(BuildEvent buildEvent) {
    }

    protected class InstalledFiles {
        private final int READ = 1;
        private final int WRITE = 2;
        private final byte EOF = (byte)-128;
        private int mode;
        private String indexFileName;
        private DataOutputStream out;
        private DataInputStream in;

        protected InstalledFiles() throws IOException {
            this.mode = 2;
            this.indexFileName = FileUtils.createTempFile();
            FileOutputStream fileOutputStream = new FileOutputStream(this.indexFileName);
            this.out = new DataOutputStream(fileOutputStream);
        }

        protected InstalledFiles(URL uRL) throws IOException {
            this.mode = 1;
            this.in = new DataInputStream(uRL.openStream());
        }

        protected void add(String string, long l) throws IOException {
            if (this.mode != 2) {
                throw new Error();
            }
            this.out.writeByte(0);
            this.out.writeUTF(string);
            this.out.writeLong(l);
        }

        protected void close() throws IOException {
            if (this.mode == 2) {
                this.out.writeByte(-128);
                this.out.flush();
                this.out.close();
            } else if (this.mode == 1) {
                this.in.close();
            } else {
                throw new Error();
            }
        }

        protected String getIndexFileName() {
            return this.indexFileName;
        }

        protected InstalledFile read() throws IOException {
            if (this.mode != 1) {
                throw new Error();
            }
            if (this.in.readByte() == -128) {
                return null;
            }
            String string = this.in.readUTF();
            long l = this.in.readLong();
            return new InstalledFile(string, l);
        }
    }

    protected class InstalledFile {
        final String fileName;
        final long lastModified;

        protected InstalledFile(String string, long l) {
            this.fileName = string;
            this.lastModified = l;
        }
    }

    private class NativeAsciiInputStream
    extends InputStream {
        private String lineSeparator;
        private InputStream in;
        private int lineDelimiter;
        private ByteArrayOutputStream translateBuffer = new ByteArrayOutputStream(5120);
        private byte[] readBuffer = new byte[5120];

        NativeAsciiInputStream(InputStream inputStream, int n) {
            this.lineSeparator = System.getProperty("line.separator");
            if (this.lineSeparator == null) {
                this.lineSeparator = "\r\n";
            }
            this.in = inputStream;
            this.lineDelimiter = n;
        }

        public void close() throws IOException {
            this.translateBuffer.close();
            this.in.close();
            super.close();
        }

        private int fillBuffer() throws IOException {
            int n = 0;
            int n2 = this.in.read(this.readBuffer);
            while (n < n2) {
                if (this.lineDelimiter == 0 && this.readBuffer[n] == 10) {
                    this.translateBuffer.write(this.lineSeparator.getBytes());
                } else if (this.lineDelimiter == 1 && this.readBuffer[n] == 13) {
                    if (n < n2 - 1) {
                        if (this.readBuffer[n + 1] == 10) {
                            this.translateBuffer.write(this.lineSeparator.getBytes());
                            ++n;
                        }
                    } else {
                        int n3 = this.in.read();
                        if (n3 != -1) {
                            if ((char)n3 == '\n') {
                                this.translateBuffer.write(this.lineSeparator.getBytes());
                            } else {
                                this.translateBuffer.write(n3);
                            }
                        }
                    }
                } else {
                    this.translateBuffer.write(this.readBuffer[n]);
                }
                ++n;
            }
            return n2;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray) != -1) {
                return byArray[0];
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 != -1 && this.translateBuffer.size() < n2) {
                n3 = this.fillBuffer();
            }
            byte[] byArray2 = this.translateBuffer.toByteArray();
            int n4 = Math.min(byArray2.length, n2);
            if (n4 > 0) {
                System.arraycopy(byArray2, 0, byArray, n, n4);
                this.translateBuffer.reset();
                if (byArray2.length > n2) {
                    this.translateBuffer.write(byArray2, n2, byArray2.length - n2);
                }
                return n4;
            }
            return -1;
        }
    }
}

