/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.Locatable;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.actions.JVMResolutionExtra;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.jvm.JVMFile;
import com.installshield.util.jvm.LauncherEntry;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.jvm.JVMService;
import com.installshield.wizard.service.system.SystemUtilService;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class JVMResolution
extends ProductAction
implements Locatable {
    public static final int CURRENT_SEARCH_INSTALL = 1;
    public static final int SEARCH_CURRENT_INSTALL = 2;
    public static final String UNSPECIFIED = "unspecified";
    public static final String YES = "$L(com.installshield.wizard.i18n.WizardResources, yes)";
    public static final String NO = "$L(com.installshield.wizard.i18n.WizardResources, no)";
    public static final String CANCEL = "$L(com.installshield.wizard.i18n.WizardResources, cancel)";
    private static final int EST_COPY_TIME = 10;
    private static final int EST_INSTALL_TIME = 20;
    private static final int EST_SEARCH_TIME = 40;
    private String jvmId = "jvm";
    private String installLocation = "_jvm";
    private String replaceJVMResponse = "unspecified";
    private boolean useInstalledJVM = true;
    private String installedDirectory = null;
    static /* synthetic */ Class class$com$installshield$util$jvm$JVMInstaller;
    static /* synthetic */ Class class$com$installshield$product$actions$JVMResolutionExtra;

    public void build(ProductBuilderSupport productBuilderSupport) {
        try {
            productBuilderSupport.putRequiredService("jvmService");
            productBuilderSupport.putRequiredService("fileService");
            productBuilderSupport.putRequiredService("systemUtilService");
            productBuilderSupport.putClass((class$com$installshield$util$jvm$JVMInstaller != null ? class$com$installshield$util$jvm$JVMInstaller : (class$com$installshield$util$jvm$JVMInstaller = JVMResolution.class$("com.installshield.util.jvm.JVMInstaller"))).getName());
            productBuilderSupport.putClass((class$com$installshield$product$actions$JVMResolutionExtra != null ? class$com$installshield$product$actions$JVMResolutionExtra : (class$com$installshield$product$actions$JVMResolutionExtra = JVMResolution.class$("com.installshield.product.actions.JVMResolutionExtra"))).getName());
            boolean bl = false;
            Dictionary dictionary = this.getExtendedProperties();
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string = (String)enumeration.nextElement();
                if (!(dictionary.get(string) instanceof JVMResolutionExtra)) continue;
                JVMResolutionExtra jVMResolutionExtra = (JVMResolutionExtra)dictionary.get(string);
                JVMFile[] jVMFileArray = jVMResolutionExtra.getJVMFileSources();
                String[] stringArray = new String[jVMFileArray.length];
                int n = 0;
                while (n < jVMFileArray.length) {
                    object = jVMFileArray[n];
                    stringArray[n] = this.createJVMResourceName(string, ((LauncherEntry)object).getName());
                    productBuilderSupport.putResource(((JVMFile)object).getInputStream(), stringArray[n]);
                    if (stringArray[n] != null && !stringArray[n].equals("")) {
                        productBuilderSupport.excludeUninstallerResource(stringArray[n]);
                    }
                    ++n;
                }
                jVMResolutionExtra.setJVMFileResources(stringArray);
                object = jVMResolutionExtra.getBundledJVMSource();
                if (object != null && ((String)object).length() > 0) {
                    String string2 = this.createJVMResourceName(string, FileUtils.getName((String)object));
                    jVMResolutionExtra.setBundledJVMResource(string2);
                    productBuilderSupport.putResource((String)object, string2);
                    if (string2 != null && !string2.equals("")) {
                        productBuilderSupport.excludeUninstallerResource(string2);
                    }
                }
                bl = true;
            }
            if (this.isActive() && !bl) {
                productBuilderSupport.logEvent(this, "err", "No platform specific JVM resolution properties included -- will not resolve at runtime");
            }
        }
        catch (Exception exception) {
            productBuilderSupport.logEvent(this, "err", exception);
        }
    }

    protected boolean checkTarget(String string, ProductActionSupport productActionSupport) {
        try {
            FileService fileService = (FileService)this.getService("fileService");
            String[] stringArray = fileService.getDirectoryList(string, 2);
            if (stringArray != null && stringArray.length > 0) {
                return this.promptToInstall(string, productActionSupport) && !productActionSupport.getOperationState().isCanceled();
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", "Cannot verify that JVM target \"" + string + "\" is empty -- JVM will not be installed");
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private String createJVMResourceName(String string, String string2) {
        return String.valueOf(this.getBeanId()) + "/" + string + "/" + string2;
    }

    public int getEstimatedTimeToInstall() {
        try {
            String string;
            JVMService jVMService = (JVMService)this.getService("jvmService");
            String string2 = jVMService.getPlatformId();
            JVMResolutionExtra jVMResolutionExtra = this.getExtra(string2);
            if (jVMResolutionExtra == null) {
                return 0;
            }
            int n = 0;
            int n2 = 0;
            if (jVMResolutionExtra.getUseCurrentJVM()) {
                n += jVMService.isCurrentJVMTemporary() ? 10 : 0;
                ++n2;
            }
            if ((string = jVMResolutionExtra.getBundledJVMResource()) != null && string.trim().length() > 0) {
                n += 20;
                ++n2;
            }
            if (jVMResolutionExtra.getJVMFileResources().length > 0) {
                n += 40;
                ++n2;
            }
            return n2 > 0 ? n / n2 : 0;
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return 0;
        }
    }

    private JVMResolutionExtra getExtra(String string) {
        Dictionary dictionary = this.getExtendedProperties();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Object v = dictionary.get(string2);
                if (v == null || !(v instanceof JVMResolutionExtra) || !string.equals(((JVMResolutionExtra)v).getPlatformId())) continue;
                return (JVMResolutionExtra)dictionary.get(string2);
            }
        }
        return null;
    }

    private Enumeration getExtras() {
        Vector<JVMResolutionExtra> vector = new Vector<JVMResolutionExtra>();
        Dictionary dictionary = this.getExtendedProperties();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!(dictionary.get(string) instanceof JVMResolutionExtra)) continue;
            vector.addElement((JVMResolutionExtra)dictionary.get(string));
        }
        return vector.elements();
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public String getInstalledDirectory() {
        return this.installedDirectory;
    }

    public String getJVMId() {
        return this.jvmId;
    }

    public String getReplaceJVMResponse() {
        return this.replaceJVMResponse;
    }

    public boolean getUseInstalledJVM() {
        return this.useInstalledJVM;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void install(ProductActionSupport productActionSupport) throws ProductException {
        int n = this.getEstimatedTimeToInstall();
        productActionSupport.getOperationState().resetUpdateCounter();
        boolean bl = false;
        try {
            Object object;
            Object object2;
            JVMService jVMService = (JVMService)this.getService("jvmService");
            if (this.getUseInstalledJVM() && this.getInstalledDirectory() != null && (object2 = (FileService)this.getService("fileService")).fileExists((String)(object = FileUtils.createFileName(this.getInstalledDirectory(), "jvm")))) {
                this.logDebugEvent("resolved to " + (String)object);
                jVMService.associateJVM(this.getJVMId(), (String)object);
                bl = true;
            }
            if (!bl) {
                object2 = jVMService.getPlatformId();
                object = this.getExtra((String)object2);
                if (object != null) {
                    if (((JVMResolutionExtra)object).getJVMResolution() == 1) {
                        bl = this.useCurrentJVM((JVMResolutionExtra)object, jVMService, productActionSupport, n) || this.searchForJVM((JVMResolutionExtra)object, jVMService, productActionSupport, n) || this.installJVM((JVMResolutionExtra)object, jVMService, productActionSupport, n);
                    } else {
                        if (((JVMResolutionExtra)object).getJVMResolution() != 2) throw new ProductException(601, "Unknown JVMResolution property " + ((JVMResolutionExtra)object).getJVMResolution() + " -- unable to resolve JVM");
                        bl = this.searchForJVM((JVMResolutionExtra)object, jVMService, productActionSupport, n) || this.useCurrentJVM((JVMResolutionExtra)object, jVMService, productActionSupport, n) || this.installJVM((JVMResolutionExtra)object, jVMService, productActionSupport, n);
                    }
                } else {
                    this.logEvent(this, "wrn", "Cannot find JVM resolution information for platform key \"" + (String)object2 + "\" -- unable to resolve JVM");
                }
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException.toString());
        }
        long l = (long)n - productActionSupport.getOperationState().getUpdateCounter();
        productActionSupport.getOperationState().updatePercentComplete(n, l, n);
        if (bl) return;
        throw new ProductException(601, "Failed to resolve JVM");
    }

    protected boolean installJVM(JVMResolutionExtra jVMResolutionExtra, JVMService jVMService, ProductActionSupport productActionSupport, int n) {
        block13: {
            if (productActionSupport.getOperationState().isCanceled()) {
                return false;
            }
            if (jVMResolutionExtra.getBundledJVMResource() == null || jVMResolutionExtra.getBundledJVMResource().trim().length() == 0) {
                return false;
            }
            this.logDebugEvent("installing the bundled JVM");
            try {
                boolean bl;
                String string = this.getProductTree().getInstallLocation(this);
                if (!this.checkTarget(string, productActionSupport)) break block13;
                OperationKey operationKey = jVMService.installJVM(this.jvmId, jVMResolutionExtra.getBundledJVMResource(), jVMResolutionExtra.getBundledJVMArguments(), string);
                int n2 = jVMResolutionExtra.getTimeout() * 1000;
                long l = System.currentTimeMillis() + (long)n2;
                boolean bl2 = false;
                int n3 = 0;
                while (!bl2 && !jVMService.isOperationEnded(operationKey)) {
                    OperationKey operationKey2 = operationKey;
                    synchronized (operationKey2) {
                        try {
                            operationKey.wait(1000L);
                            if (n3 < 20) {
                                productActionSupport.getOperationState().updatePercentComplete(n, 10L, n);
                                n3 += 10;
                            }
                            bl2 = System.currentTimeMillis() >= l;
                        }
                        catch (InterruptedException interruptedException) {
                            this.logEvent(this, "wrn", "JVM install operation timed out after " + n2 / 1000 + " seconds");
                        }
                    }
                }
                if (bl2) {
                    this.logEvent(this, "err", "JVM resolution timed out");
                }
                boolean bl3 = bl = !bl2 && jVMService.getJVMFile(this.jvmId) != null;
                if (bl) {
                    this.setInstalledDirectory(string);
                }
                return bl;
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "wrn", "Install current JVM failed: " + serviceException.getMessage());
            }
        }
        return false;
    }

    private void logDebugEvent(String string) {
        this.logEvent(this, WizardLog.subclassEvent("dbg", "jvm"), string);
    }

    protected boolean promptToInstall(String string, ProductActionSupport productActionSupport) {
        try {
            String string2 = this.resolveString(YES);
            String string3 = this.resolveString(NO);
            String string4 = this.resolveString(CANCEL);
            Object object = this.resolveString(this.getReplaceJVMResponse());
            if (object == null || object.equals(UNSPECIFIED)) {
                object = this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "JVMResolution.installJVM"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "JVMResolution.installJVMWarning", new String[]{string}), new Object[]{string2, string3, string4}, string3);
            }
            if (object.equals(string2)) {
                return true;
            }
            if (object.equals(string4)) {
                productActionSupport.getOperationState().cancel();
                this.logEvent(this, "wrn", "copy/install JVM canceled by user");
                return false;
            }
            productActionSupport.logEvent(this, "wrn", "copy/install JVM declined by user");
            return false;
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", "unable to prompt user for JVM replacement -- cannot copy/install JVM");
            return false;
        }
    }

    protected boolean searchForJVM(JVMResolutionExtra jVMResolutionExtra, JVMService jVMService, ProductActionSupport productActionSupport, int n) {
        this.logDebugEvent("searching for a JVM");
        if (productActionSupport.getOperationState().isCanceled()) {
            return false;
        }
        if (jVMResolutionExtra.getJVMFileResources().length == 0) {
            return false;
        }
        try {
            OperationKey operationKey = jVMService.findJVM(this.jvmId, jVMResolutionExtra.getJVMFileResources());
            int n2 = jVMResolutionExtra.getTimeout() * 1000;
            long l = System.currentTimeMillis() + (long)n2;
            boolean bl = false;
            int n3 = 0;
            while (!bl && !jVMService.isOperationEnded(operationKey)) {
                OperationKey operationKey2 = operationKey;
                synchronized (operationKey2) {
                    try {
                        operationKey.wait(1000L);
                        if (n3 < 40) {
                            productActionSupport.getOperationState().updatePercentComplete(n, 10L, n);
                            n3 += 10;
                        }
                        bl = System.currentTimeMillis() >= l;
                    }
                    catch (InterruptedException interruptedException) {
                        this.logEvent(this, "wrn", "JVM search operation timed out after " + n2 / 1000 + " seconds");
                    }
                }
            }
            if (bl) {
                this.logEvent(this, "err", "JVM resolution timed out");
            }
            this.logDebugEvent("resolved to JVM file: " + jVMService.getJVMFile(this.jvmId) + " with JVM_HOME = " + jVMService.getJVMHome(this.jvmId));
            return !bl && jVMService.getJVMFile(this.jvmId) != null;
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "wrn", "an error occurred while searching for JVM: " + serviceException);
            return false;
        }
    }

    public void setInstallLocation(String string) {
        this.installLocation = string;
    }

    public void setInstalledDirectory(String string) {
        this.installedDirectory = string;
    }

    public void setJVMId(String string) {
        this.jvmId = string;
    }

    public void setReplaceJVMResponse(String string) {
        this.replaceJVMResponse = string;
    }

    public void setUseInstalledJVM(boolean bl) {
        this.useInstalledJVM = bl;
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        if (this.getInstalledDirectory() != null) {
            try {
                SystemUtilService systemUtilService = (SystemUtilService)this.getService("systemUtilService");
                systemUtilService.deleteDirectoryOnExit(this.getInstalledDirectory(), true);
            }
            catch (Exception exception) {
                throw new ProductException(exception);
            }
        }
    }

    protected boolean useCurrentJVM(JVMResolutionExtra jVMResolutionExtra, JVMService jVMService, ProductActionSupport productActionSupport, int n) {
        if (productActionSupport.getOperationState().isCanceled()) {
            return false;
        }
        if (!jVMResolutionExtra.getUseCurrentJVM()) {
            return false;
        }
        this.logDebugEvent("attempting to use the current JVM");
        boolean bl = false;
        try {
            if (jVMService.isCurrentJVMDefined()) {
                if (jVMService.isCurrentJVMTemporary()) {
                    String string = this.getProductTree().getInstallLocation(this);
                    if (this.checkTarget(string, productActionSupport)) {
                        this.logDebugEvent("copying the current JVM");
                        jVMService.copyCurrentJVM(this.jvmId, string);
                        this.setInstalledDirectory(string);
                        productActionSupport.getOperationState().updatePercentComplete(n, 10L, n);
                        bl = true;
                    }
                } else {
                    this.logDebugEvent("resolved to the current jvm file: " + jVMService.getJVMFile(this.jvmId) + " with JVM_HOME = " + jVMService.getJVMHome(this.jvmId));
                    jVMService.associateCurrentJVM(this.jvmId);
                    bl = true;
                }
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "wrn", "An error occurred attempting to copy the current JVM: " + serviceException);
        }
        return bl;
    }
}

