/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;

public class SourceFile
implements PropertyAccessible {
    public static final int UNKNOWN = 0;
    public static final int ASCII = 1;
    public static final int BINARY = 2;
    public static final int DIRECTORY = 3;
    public static final int DIRECTORY_TREE = 4;
    private String fileName = "";
    private boolean resolveRuntimeFileName = false;
    private String pattern = null;
    private boolean usingGNUPattern = false;
    private FileAttributes attributes = null;
    private int type = 0;

    public SourceFile() {
    }

    public SourceFile(SourceFile sourceFile) {
        this.fileName = sourceFile.fileName;
        this.resolveRuntimeFileName = sourceFile.resolveRuntimeFileName;
        this.pattern = sourceFile.pattern;
        this.usingGNUPattern = sourceFile.usingGNUPattern;
        if (sourceFile.attributes != null) {
            this.attributes = (FileAttributes)sourceFile.attributes.clone();
        }
        this.type = sourceFile.type;
    }

    public SourceFile(String string) {
        this.setFileName(string);
    }

    public SourceFile(String string, String string2) {
        this.setFileName(string);
        this.setType(4);
        this.setPattern(string2);
    }

    public FileAttributes getAttributes() {
        return this.attributes;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean getResolveRuntimeFileName() {
        return this.resolveRuntimeFileName;
    }

    public int getType() {
        return this.type;
    }

    public boolean isUsingGNUPattern() {
        return this.usingGNUPattern;
    }

    public void setAttributes(FileAttributes fileAttributes) {
        this.attributes = fileAttributes;
    }

    public void setFileName(String string) {
        if (string != null) {
            string = FileUtils.normalizeFileName(string);
        }
        this.fileName = string;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setResolveRuntimeFileName(boolean bl) {
        this.resolveRuntimeFileName = bl;
    }

    public void setType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("type: " + n);
        }
        this.type = n;
    }

    public void setUsingGNUPattern(boolean bl) {
        this.usingGNUPattern = bl;
    }
}

