/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.archive.AllArchiveFilter;
import com.installshield.archive.ArchiveEntry;
import com.installshield.archive.ArchiveFilter;
import com.installshield.archive.ArchiveReader;
import com.installshield.archive.ArchiveWriter;
import com.installshield.archive.ResourceReader;
import com.installshield.archive.ResourceReaderFactory;
import com.installshield.archive.ResourceWriterFactory;
import com.installshield.archive.StandardResourceReaderFactory;
import com.installshield.archive.ZipResourceWriterFactory;
import com.installshield.product.Locatable;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.ProductTree;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.SoftwareObject;
import com.installshield.qjml.QJML;
import com.installshield.util.CommandLineTokenizer;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.rex.RegExprSyntaxException;
import com.installshield.util.rex.Rex;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardInf;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.WizardServicesImpl;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class UninstallerArchive
extends ProductAction
implements Locatable {
    private static final String SERVICES_DEF = "/services.xml";
    private static final String WIZARD_DEF = "/wizard.xml";
    private static final String WIZARDTREE_DEF = "/wizardTree.xml";
    private static final String PRODUCT_DEF = "/product.xml";
    private static final long RESOURCE_ARCHIVE_DEFAULT_SIZE = 100000L;
    private static final double DEFAULT_COMPRESSION_ESTIMATE = 0.7;
    private String installLocation = "_uninst";
    private String archiveName = "uninstall.jar";
    private String resourcesFileName = "uninstall.dat";
    private Vector resourceExclusions = new Vector();
    private Vector installedFiles = new Vector();
    private String uninstallerWizardId = null;
    private String uninstallerWizard = null;
    private String uninstallerWizardTree = null;
    private long uninstallerSize = -1L;
    private String uninstallResources = null;
    static /* synthetic */ Class class$com$installshield$wizard$Wizard;
    static /* synthetic */ Class class$com$installshield$product$ProductTree;
    static /* synthetic */ Class class$com$installshield$wizard$service$ServicesDefinition;

    public void build(ProductBuilderSupport productBuilderSupport) {
        try {
            productBuilderSupport.putClass("com.installshield.product.actions.UninstallerArchive$UninstallerFilterUtils");
            productBuilderSupport.putClass("com.installshield.product.actions.UninstallerArchive$UpdateUninstallerFilter");
            productBuilderSupport.putClass("com.installshield.product.actions.UninstallerArchive$CreateUninstallerFilter");
            productBuilderSupport.putClass("com.installshield.product.actions.UninstallerArchive$UninstallerArchiveWriter");
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private UninstallerArchiveWriter createClassWriter(String string) throws IOException {
        String string2 = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getArchiveName());
        UninstallerArchiveWriter uninstallerArchiveWriter = new UninstallerArchiveWriter(string2, string);
        uninstallerArchiveWriter.putClassResource(this.createManifest(), "META-INF/MANIFEST.MF");
        uninstallerArchiveWriter.putClassResource(this.createWizardInf(string), "/wizard.inf");
        String string3 = this.getServices().getHome();
        CreateUninstallerFilter createUninstallerFilter = new CreateUninstallerFilter(string, WIZARD_DEF, WIZARDTREE_DEF, this, PRODUCT_DEF, SERVICES_DEF);
        uninstallerArchiveWriter.putArchive(string3, createUninstallerFilter);
        ServicesDefinition servicesDefinition = new ServicesDefinition(((WizardServicesImpl)this.getServices()).getServicesDefinition());
        servicesDefinition.putResourceLocation(this.getResourcesFileName());
        uninstallerArchiveWriter.putDefinition(servicesDefinition, class$com$installshield$wizard$service$ServicesDefinition != null ? class$com$installshield$wizard$service$ServicesDefinition : (class$com$installshield$wizard$service$ServicesDefinition = UninstallerArchive.class$("com.installshield.wizard.service.ServicesDefinition")), SERVICES_DEF);
        return uninstallerArchiveWriter;
    }

    private InputStream createManifest() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Wizard.createManifest().write(byteArrayOutputStream);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private UninstallerArchiveWriter createResourceWriter(String string, String string2) throws IOException {
        UninstallerArchiveWriter uninstallerArchiveWriter = new UninstallerArchiveWriter(string, string2);
        uninstallerArchiveWriter.putDefinition(this.getProductTree(), class$com$installshield$product$ProductTree != null ? class$com$installshield$product$ProductTree : (class$com$installshield$product$ProductTree = UninstallerArchive.class$("com.installshield.product.ProductTree")), PRODUCT_DEF);
        uninstallerArchiveWriter.putArchive(this.getUninstallResources(), new AllArchiveFilter());
        return uninstallerArchiveWriter;
    }

    private InputStream createWizardInf(String string) throws IOException {
        WizardInf wizardInf = new WizardInf();
        wizardInf.setResId(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        wizardInf.write(byteArrayOutputStream);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private void deleteUninstaller(ProductActionSupport productActionSupport) {
        Object object;
        Service service;
        try {
            service = (FileService)this.getService("fileService");
            object = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getResourcesFileName());
            ((WizardServicesImpl)this.getServices()).closeResourceArchive((String)object);
            service.deleteFile((String)object);
        }
        catch (Exception exception) {
            productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotDeleteUninstallerResources"));
            this.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotDeleteUninstallerResources"));
        }
        try {
            service = (SystemUtilService)this.getService("systemUtilService");
            service.deleteFileOnExit(FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getArchiveName()));
            object = this.installedFiles.elements();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                this.logEvent(this, WizardLog.subclassEvent("dbg", "uninstaller"), "attempting to delete " + string + " on exit");
                service.deleteFileOnExit(string);
            }
            service.deleteDirectoryOnExit(this.getProductTree().getInstallLocation(this), true);
        }
        catch (ServiceException serviceException) {
            productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotDeleteUninstaller"));
            this.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotDeleteUninstaller"));
        }
    }

    private boolean ensureResources() {
        try {
            this.getServices().ensureResources("", CommandLineTokenizer.createSpaceDelimitedString(this.getResourceExclusions()));
            return true;
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return false;
        }
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public String[] getInstalledFiles() {
        Object[] objectArray = new String[this.installedFiles.size()];
        this.installedFiles.copyInto(objectArray);
        return objectArray;
    }

    private ProductTree getPersistentProductTree(String string) throws IOException {
        URL uRL = new URL("archive", "", -1, String.valueOf(string) + "+" + PRODUCT_DEF);
        ProductTree productTree = (ProductTree)QJML.read(uRL, class$com$installshield$product$ProductTree != null ? class$com$installshield$product$ProductTree : (class$com$installshield$product$ProductTree = UninstallerArchive.class$("com.installshield.product.ProductTree")));
        return productTree;
    }

    public RequiredBytesTable getRequiredBytes() throws ProductException {
        Object object;
        String string = this.getProductTree().getInstallLocation(this);
        if (this.uninstallerSize == -1L && !this.uninstallerExists()) {
            this.uninstallerSize = 100000L;
            object = this.getServices().getHome();
            CreateUninstallerFilter createUninstallerFilter = new CreateUninstallerFilter(this.getServices().getId(), WIZARD_DEF, WIZARDTREE_DEF, this, PRODUCT_DEF, SERVICES_DEF);
            try {
                ArchiveReader archiveReader = new ArchiveReader((String)object);
                Enumeration enumeration = archiveReader.entries();
                while (enumeration.hasMoreElements()) {
                    ArchiveEntry archiveEntry = (ArchiveEntry)enumeration.nextElement();
                    if (!createUninstallerFilter.filterInactively(archiveEntry)) continue;
                    ResourceReader resourceReader = archiveEntry.getReader();
                    long l = resourceReader.getSize();
                    this.uninstallerSize += Math.round(0.7 * (double)l);
                }
                archiveReader.close();
            }
            catch (IOException iOException) {
                throw new ProductException(iOException);
            }
        }
        object = new RequiredBytesTable();
        ((RequiredBytesTable)object).addBytes(string, this.uninstallerSize);
        return object;
    }

    public String[] getResourceExclusions() {
        Object[] objectArray = new String[this.resourceExclusions.size()];
        this.resourceExclusions.copyInto(objectArray);
        return objectArray;
    }

    public String getResourcesFileName() {
        return this.resourcesFileName;
    }

    public String getUninstallResources() {
        return this.uninstallResources;
    }

    public String getUninstallerWizard() {
        return this.uninstallerWizard;
    }

    public String getUninstallerWizardId() {
        return this.uninstallerWizardId;
    }

    public String getUninstallerWizardTree() {
        return this.uninstallerWizardTree;
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        if (!this.ensureResources()) {
            productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Uninstaller.resourcesNotEnsured"));
        }
        if (this.uninstallerExists()) {
            this.updateUninstaller(productActionSupport);
        } else {
            this.writeUninstaller(productActionSupport);
        }
    }

    private boolean isProductUninstalled() {
        SoftwareObject softwareObject = (SoftwareObject)((Object)this.getProductTree().getRoot());
        return softwareObject.getInstallStatus() == 4;
    }

    private Wizard loadWizard(String string) throws IOException {
        URL uRL = this.getResource(string);
        Wizard wizard = (Wizard)QJML.read(uRL, class$com$installshield$wizard$Wizard != null ? class$com$installshield$wizard$Wizard : (class$com$installshield$wizard$Wizard = UninstallerArchive.class$("com.installshield.wizard.Wizard")));
        return wizard;
    }

    public void logEvent(Object object, String string, Object object2) {
        super.logEvent(object, string, object2);
    }

    public void putInstalledFile(String string) {
        if (!this.installedFiles.contains(string)) {
            this.installedFiles.addElement(string);
        }
    }

    public void putResourceExclusion(String string) {
        if (!this.resourceExclusions.contains(string)) {
            this.resourceExclusions.addElement(string);
        }
    }

    public void removeInstalledFile(String string) {
        this.installedFiles.removeElement(string);
    }

    public void removeResourceExclusion(String string) {
        this.resourceExclusions.removeElement(string);
    }

    private void replaceResourceArchive(String string, String string2) throws ServiceException, IOException {
        ((WizardServicesImpl)this.getServices()).closeResourceArchive(string2);
        FileService fileService = (FileService)this.getServices().getService("fileService");
        fileService.moveFile(string, string2, true);
    }

    public void setArchiveName(String string) {
        this.archiveName = string;
    }

    public void setInstallLocation(String string) {
        this.installLocation = string.trim().length() == 0 ? null : string;
    }

    public void setInstalledFiles(String[] stringArray) {
        this.installedFiles.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.installedFiles.addElement(stringArray[n]);
            ++n;
        }
    }

    public void setResourceExclusions(String[] stringArray) {
        this.resourceExclusions.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.resourceExclusions.addElement(stringArray[n]);
            ++n;
        }
    }

    public void setResourcesFileName(String string) {
        this.resourcesFileName = string;
    }

    public void setUninstallResources(String string) {
        this.uninstallResources = string;
    }

    public void setUninstallerWizard(String string) {
        this.uninstallerWizard = string;
    }

    public void setUninstallerWizardId(String string) {
        this.uninstallerWizardId = string;
    }

    public void setUninstallerWizardTree(String string) {
        this.uninstallerWizardTree = string;
    }

    public String toString() {
        String string = this.getArchiveName();
        if (FileUtils.isAbsolute(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getInstallLocation();
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(String.valueOf(string2) + File.separatorChar);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        if (!this.ensureResources()) {
            productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Uninstaller.resourcesNotEnsured"));
        }
        if (this.isProductUninstalled()) {
            this.deleteUninstaller(productActionSupport);
        } else {
            this.updateUninstaller(productActionSupport);
        }
    }

    public boolean uninstallerExists() {
        String string = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getResourcesFileName());
        return new File(string).exists();
    }

    public void unload() {
        String string = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getResourcesFileName());
        this.getServices().removeResourceLocation(string);
    }

    private void updateUninstaller(ProductActionSupport productActionSupport) {
        try {
            UninstallerArchiveWriter uninstallerArchiveWriter = this.createResourceWriter(FileUtils.createTempFile(), this.getServices().getId());
            UpdateUninstallerFilter updateUninstallerFilter = new UpdateUninstallerFilter(this, this.getServices().getId(), PRODUCT_DEF);
            String string = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getResourcesFileName());
            uninstallerArchiveWriter.putArchive(string, updateUninstallerFilter);
            uninstallerArchiveWriter.write();
            uninstallerArchiveWriter.close();
            try {
                this.replaceResourceArchive(uninstallerArchiveWriter.getArchiveFileName(), string);
            }
            catch (Exception exception) {
                productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotUpdateUninstallerResources"));
                this.logEvent(this, "err", exception);
                this.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.couldNotUpdateUninstallerResources"));
            }
        }
        catch (IOException iOException) {
            productActionSupport.logEvent(this, "err", iOException);
            this.logEvent(this, "err", iOException);
        }
    }

    private void updateUninstallerInformation(UninstallerArchive uninstallerArchive, UninstallerArchive uninstallerArchive2) {
        String[] stringArray = uninstallerArchive.getResourceExclusions();
        int n = 0;
        while (n < stringArray.length) {
            uninstallerArchive2.putResourceExclusion(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = uninstallerArchive.getInstalledFiles();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            uninstallerArchive2.putInstalledFile(stringArray2[n2]);
            ++n2;
        }
    }

    private void writeUninstaller(ProductActionSupport productActionSupport) {
        try {
            this.putInstalledFile(FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getArchiveName()));
            this.putInstalledFile(FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getResourcesFileName()));
            UninstallerArchiveWriter uninstallerArchiveWriter = this.createClassWriter(this.getServices().getId());
            uninstallerArchiveWriter.write();
            uninstallerArchiveWriter.close();
            String string = FileUtils.createFileName(this.getProductTree().getInstallLocation(this), this.getResourcesFileName());
            UninstallerArchiveWriter uninstallerArchiveWriter2 = this.createResourceWriter(string, this.getServices().getId());
            uninstallerArchiveWriter2.write();
            uninstallerArchiveWriter2.close();
        }
        catch (IOException iOException) {
            productActionSupport.logEvent(this, "err", iOException);
            this.logEvent(this, "err", iOException);
        }
    }

    private static class UninstallerFilterUtils {
        UninstallerFilterUtils() {
        }

        public static String createResourcePath(String string, String string2) {
            string = string.replace(File.separatorChar, '/');
            string2 = string2.replace(File.separatorChar, '/');
            StringBuffer stringBuffer = new StringBuffer();
            if (!string.startsWith("/")) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string);
            if (!string.endsWith("/") && !string2.startsWith("/")) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }

        public static String stripId(String string, String string2) {
            String string3 = "/" + string + "/";
            if (string2.startsWith(string3)) {
                return string2.substring(string3.length());
            }
            return string2;
        }
    }

    private class CreateUninstallerFilter
    implements ArchiveFilter {
        private String resId;
        private String installerDef;
        private String installerTreeDef;
        private String uninstallerId;
        private String uninstaller;
        private String uninstallerTreeDef;
        private Vector exclusions;
        private String productDef;
        private String servicesDef;

        CreateUninstallerFilter(String string, String string2, String string3, UninstallerArchive uninstallerArchive2, String string4, String string5) {
            this.resId = string;
            this.installerDef = UninstallerFilterUtils.createResourcePath(string, string2);
            this.installerTreeDef = UninstallerFilterUtils.createResourcePath(string, string3);
            this.uninstallerId = uninstallerArchive2.getUninstallerWizardId();
            this.uninstaller = UninstallerFilterUtils.createResourcePath(string, uninstallerArchive2.getUninstallerWizard());
            this.uninstallerTreeDef = UninstallerFilterUtils.createResourcePath(string, uninstallerArchive2.getUninstallerWizardTree());
            this.exclusions = new Vector();
            String[] stringArray = uninstallerArchive2.getResourceExclusions();
            int n = 0;
            while (n < stringArray.length) {
                String string6 = UninstallerFilterUtils.createResourcePath(string, stringArray[n]);
                if (!this.exclusions.contains(string6)) {
                    this.exclusions.addElement(string6);
                }
                ++n;
            }
            this.productDef = UninstallerFilterUtils.createResourcePath(string, string4);
            this.servicesDef = UninstallerFilterUtils.createResourcePath(string, string5);
        }

        public boolean filter(ArchiveEntry archiveEntry, ResourceWriterFactory resourceWriterFactory) throws IOException {
            String string = archiveEntry.getName().replace(File.separatorChar, '/');
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (string.equals(this.installerDef)) {
                return false;
            }
            if (string.equals(this.installerTreeDef)) {
                return false;
            }
            if (string.equals(this.uninstaller)) {
                archiveEntry.setWriter(resourceWriterFactory.createDefinitionWriter(UninstallerFilterUtils.stripId(this.resId, this.installerDef)));
                return true;
            }
            if (string.equals(this.uninstallerTreeDef)) {
                archiveEntry.setWriter(resourceWriterFactory.createDefinitionWriter(UninstallerFilterUtils.stripId(this.resId, this.installerTreeDef)));
                return true;
            }
            if (string.equals(this.productDef)) {
                return false;
            }
            if (string.equals(this.servicesDef)) {
                return false;
            }
            if (string.startsWith("/" + this.resId)) {
                int n = 0;
                while (n < this.exclusions.size()) {
                    try {
                        if (this.exclusions.elementAt(n) != null && Rex.matches(string, (String)this.exclusions.elementAt(n))) {
                            return false;
                        }
                    }
                    catch (RegExprSyntaxException regExprSyntaxException) {
                        this.exclusions.setElementAt(null, n);
                    }
                    ++n;
                }
            }
            return true;
        }

        public boolean filterInactively(ArchiveEntry archiveEntry) throws IOException {
            String string = archiveEntry.getName().replace(File.separatorChar, '/');
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (string.equals(this.installerDef)) {
                return false;
            }
            if (string.equals(this.installerTreeDef)) {
                return false;
            }
            if (string.equals(this.productDef)) {
                return false;
            }
            if (string.startsWith("/" + this.resId)) {
                int n = 0;
                while (n < this.exclusions.size()) {
                    try {
                        if (this.exclusions.elementAt(n) != null && Rex.matches(string, (String)this.exclusions.elementAt(n))) {
                            return false;
                        }
                    }
                    catch (RegExprSyntaxException regExprSyntaxException) {
                        this.exclusions.setElementAt(null, n);
                    }
                    ++n;
                }
            }
            return true;
        }
    }

    private class UpdateUninstallerFilter
    implements ArchiveFilter {
        private String productDef;
        private Vector exclusions;
        private String resId;

        public UpdateUninstallerFilter(UninstallerArchive uninstallerArchive2, String string, String string2) {
            this.productDef = UninstallerFilterUtils.createResourcePath(string, string2);
            this.resId = string;
            this.exclusions = new Vector();
            String[] stringArray = uninstallerArchive2.getResourceExclusions();
            int n = 0;
            while (n < stringArray.length) {
                String string3 = UninstallerFilterUtils.createResourcePath(string, stringArray[n]);
                if (!this.exclusions.contains(string3)) {
                    this.exclusions.addElement(string3);
                }
                ++n;
            }
        }

        public boolean filter(ArchiveEntry archiveEntry, ResourceWriterFactory resourceWriterFactory) throws IOException {
            String string = archiveEntry.getName().replace(File.separatorChar, '/');
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (string.equals(this.productDef)) {
                return false;
            }
            if (string.startsWith("/" + this.resId)) {
                int n = 0;
                while (n < this.exclusions.size()) {
                    try {
                        if (this.exclusions.elementAt(n) != null && Rex.matches(string, (String)this.exclusions.elementAt(n))) {
                            return false;
                        }
                    }
                    catch (RegExprSyntaxException regExprSyntaxException) {
                        this.exclusions.setElementAt(null, n);
                    }
                    ++n;
                }
            }
            return true;
        }
    }

    private class UninstallerArchiveWriter
    extends ArchiveWriter {
        private String archiveFileName;
        private FileOutputStream fileOut;
        private ZipOutputStream zipOut;
        private ResourceReaderFactory readerFactory;

        UninstallerArchiveWriter(String string, String string2) throws IOException {
            File file = new File(string);
            String[] stringArray = FileUtils.createDirs(new File(file.getParent()));
            int n = 0;
            while (n < stringArray.length) {
                UninstallerArchive.this.putInstalledFile(stringArray[n]);
                ++n;
            }
            this.archiveFileName = string;
            this.fileOut = new FileOutputStream(string);
            this.zipOut = new ZipOutputStream(this.fileOut);
            this.readerFactory = new StandardResourceReaderFactory(UninstallerArchive.this.getServices().getHome());
            this.initialize(this.readerFactory, new ZipResourceWriterFactory(this.zipOut, string2));
        }

        void close() throws IOException {
            try {
                block4: {
                    try {
                        this.zipOut.finish();
                        this.zipOut.close();
                    }
                    catch (ZipException zipException) {
                        if (zipException.getMessage().startsWith("ZIP file must have at least one entry")) break block4;
                        throw zipException;
                    }
                }
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fileOut.close();
                throw throwable;
            }
            this.fileOut.close();
            this.readerFactory.close();
        }

        String getArchiveFileName() {
            return this.archiveFileName;
        }

        public void write() {
            this.setCalculateProgress(false);
            super.write();
        }
    }
}

