/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.service.product;

import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductComponent;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.ProductTreeIteratorFactory;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.StandardProductTreeIterator;
import com.installshield.product.iterators.ActiveProductTreeIterator;
import com.installshield.product.iterators.ProductActionTreeIterator;
import com.installshield.product.service.product.ProductTreeSource;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.Log;
import com.installshield.wizard.service.ServiceException;
import java.util.Vector;

public abstract class InstallableObjectVisitor {
    private Vector visitedKeys = new Vector();

    boolean actionsFailed(Object object) {
        return false;
    }

    boolean checkInstalledInstance(int n, SoftwareObject softwareObject, boolean bl) throws ServiceException {
        boolean bl2 = false;
        if (n > 0 && !bl) {
            bl2 = true;
        } else {
            this.visitedKeys.addElement(softwareObject.getKey());
        }
        return bl2;
    }

    abstract Object getDefaultResult();

    abstract boolean getResolveProductReferences();

    abstract Object getResultForProductAction(ProductAction var1, ProductActionSupport var2) throws ServiceException;

    void postVisitComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
    }

    boolean preVisitComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        return true;
    }

    void processActionsFailed(ProductBean productBean, ProductActionSupport productActionSupport, ProductTreeIterator productTreeIterator) throws ServiceException {
    }

    abstract Object processNewResult(Object var1, Object var2);

    boolean reVisit(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        return true;
    }

    boolean shouldContinue(Object object) {
        return true;
    }

    void updateSoftwareObject(ProductBean productBean, SoftwareObjectKey softwareObjectKey) throws ServiceException {
    }

    Object visitComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        Object object = this.getDefaultResult();
        if (this.preVisitComponent(productBean, productActionSupport)) {
            StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean);
            ActiveProductTreeIterator activeProductTreeIterator = new ActiveProductTreeIterator(standardProductTreeIterator);
            ProductActionTreeIterator productActionTreeIterator = new ProductActionTreeIterator(activeProductTreeIterator);
            ProductBean productBean2 = productActionTreeIterator.getNext(productActionTreeIterator.begin());
            while (!this.actionsFailed(object) && productBean2 != productActionTreeIterator.end()) {
                Object object2 = this.getResultForProductAction((ProductAction)productBean2, productActionSupport);
                object = this.processNewResult(object, object2);
                productBean2 = productActionTreeIterator.getNext(productBean2);
            }
            if (this.actionsFailed(object)) {
                this.processActionsFailed(productBean, productActionSupport, productActionTreeIterator);
            }
            this.postVisitComponent(productBean, productActionSupport);
        }
        return object;
    }

    Object visitProductBean(ProductBean productBean, ProductTreeSource productTreeSource, ProductActionSupport productActionSupport, RegistryService registryService, Log log) throws ServiceException {
        Object object = this.getDefaultResult();
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createInstallableComponentIterator(productBean, registryService, productTreeSource, log, this.getResolveProductReferences());
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (this.shouldContinue(object) && productBean2 != productTreeIterator.end()) {
            Object object2 = this.visitSoftwareObject(productBean2, productTreeSource, productActionSupport, registryService, log);
            object = this.processNewResult(object, object2);
            productBean2 = productTreeIterator.getNext(productBean2);
        }
        return object;
    }

    Object visitSoftwareObject(ProductBean productBean, ProductTreeSource productTreeSource, ProductActionSupport productActionSupport, RegistryService registryService, Log log) throws ServiceException {
        Object object;
        Object object2 = this.getDefaultResult();
        SoftwareObject softwareObject = null;
        SoftwareObjectKey softwareObjectKey = null;
        if (productBean instanceof SoftwareObject) {
            softwareObject = (SoftwareObject)((Object)productBean);
            softwareObjectKey = softwareObject.getKey();
        } else if (productBean instanceof SoftwareObjectReference) {
            SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean;
            softwareObjectKey = softwareObjectReference.getKey();
            softwareObject = productBean.getProductTree().resolveKey(softwareObjectKey);
            if (softwareObject != null && !this.wasVisited(softwareObjectKey = softwareObject.getKey())) {
                object = this.visitProductBean((ProductBean)((Object)softwareObject), productTreeSource, productActionSupport, registryService, log);
                object2 = this.processNewResult(object2, object);
                softwareObjectKey = softwareObject.getKey();
            }
        }
        if (this.shouldContinue(object2) && softwareObjectKey != null) {
            boolean bl = this.wasVisited(softwareObjectKey);
            if (!bl && softwareObject != null) {
                int n = -1;
                SoftwareObject softwareObject2 = null;
                if (softwareObject.isPubliclyShareable() && (softwareObject2 = registryService.getSoftwareObject(softwareObjectKey)) != null) {
                    n = softwareObject2.getKey().getInstance();
                } else if (softwareObject instanceof GenericSoftwareObject) {
                    GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)softwareObject;
                    n = registryService.getInstalledInstance(softwareObjectKey, productBean.getProductTree().getInstallLocation(genericSoftwareObject));
                }
                bl = this.checkInstalledInstance(n, softwareObject, this.reVisit(productBean, productActionSupport));
            }
            this.updateSoftwareObject(productBean, softwareObjectKey);
            if (!bl && softwareObject != null && softwareObject instanceof ProductComponent) {
                object = this.visitComponent((ProductComponent)softwareObject, productActionSupport);
                object2 = this.processNewResult(object2, object);
            }
        }
        return object2;
    }

    boolean wasVisited(SoftwareObjectKey softwareObjectKey) {
        return this.visitedKeys.contains(softwareObjectKey);
    }
}

