/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.service.product.ProductService;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.InsetsPanel;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizardx.panels.ExtendedWizardPanel;
import com.installshield.wizardx.ui.ChoiceComponent;
import com.installshield.wizardx.ui.ChoiceComponentEvent;
import com.installshield.wizardx.ui.ChoiceComponentListener;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class FeaturePanel
extends ExtendedWizardPanel
implements ChoiceComponentListener {
    private String productURL = "/product.xml";
    private Container featureListContainer = null;
    private ChoiceComponent choiceComponent = null;
    private Properties[] features = null;
    private String[] featureNames = new String[0];
    private String[] tempFeatureNames = new String[0];
    private int[] selectedIndexes = new int[0];
    private int[] requiredIndexes = new int[0];
    private Hashtable productRequiredFeatureList = new Hashtable();
    private String[] featureBeanIds = new String[0];
    private Vector selectedFeatureList = new Vector();
    static /* synthetic */ Class class$com$installshield$product$ProductFeature;

    public FeaturePanel() {
        String string = "$L(com.installshield.product.i18n.ProductResources, FeaturePanel.description, $P(displayName))";
        this.setDescription(string);
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        wizardBuilderSupport.putRequiredService("productService");
    }

    private void checkForFeaturesRequired(String string) {
        try {
            int n = this.getFeatureIndex(string);
            if (!this.selectedFeatureList.contains(new Integer(n))) {
                this.selectedFeatureList.addElement(new Integer(n));
            }
            this.updateFeatureActiveState(string, true);
            ProductService productService = (ProductService)this.getService("productService");
            Properties[] propertiesArray = productService.getRequiredFeatures(this.productURL, string, false);
            int n2 = 0;
            while (n2 < propertiesArray.length) {
                Boolean bl = (Boolean)productService.getProductBeanProperty(this.productURL, propertiesArray[n2].getProperty("beanId"), "installed");
                boolean bl2 = bl;
                if (!bl2) {
                    this.checkForFeaturesRequired(propertiesArray[n2].getProperty("beanId"));
                }
                ++n2;
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    private void checkForRequiredByFeatures(String string) {
        try {
            int n = this.getFeatureIndex(string);
            ProductService productService = (ProductService)this.getService("productService");
            Properties[] propertiesArray = productService.getRequiredByFeatures(this.productURL, string, false);
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            while (n2 < propertiesArray.length) {
                if (((Boolean)((Hashtable)propertiesArray[n2]).get("active")).booleanValue()) {
                    bl = true;
                    vector.addElement(this.tempFeatureNames[this.getFeatureIndex(propertiesArray[n2].getProperty("beanId"))]);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < vector.size()) {
                stringBuffer.append("\"" + (String)vector.elementAt(n3) + "\"");
                if (n3 < vector.size() - 1) {
                    stringBuffer.append(", ");
                }
                ++n3;
            }
            if (bl) {
                this.getWizard().getServices().displayUserMessage(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.updateStatus"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.requiredBy", new String[]{this.tempFeatureNames[n], stringBuffer.toString()}), 1);
            } else {
                this.selectedFeatureList.removeElement(new Integer(n));
                this.updateFeatureActiveState(string, false);
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    public void choiceComponentStateChanged(ChoiceComponentEvent choiceComponentEvent) {
        boolean bl;
        boolean bl2 = choiceComponentEvent.getState();
        int n = this.getFeatureIndex((Object)choiceComponentEvent.getItem());
        if (n != -1 && !(bl = this.isProductRequiredFeature(n, bl2))) {
            String string = this.featureBeanIds[n];
            if (bl2) {
                this.checkForFeaturesRequired(string);
            } else {
                this.checkForRequiredByFeatures(string);
            }
            this.refreshSelectedFeatureIndexes();
            this.choiceComponent.setSelectedIndexes(this.selectedIndexes);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void createUI(WizardBeanEvent wizardBeanEvent) {
        super.createUI(wizardBeanEvent);
        ((InsetsPanel)this.featureListContainer).setInsets(new Insets(10, 10, 10, 10));
        ScrollPane scrollPane = new ScrollPane(0);
        Adjustable adjustable = scrollPane.getVAdjustable();
        if (adjustable.getUnitIncrement() < 5) {
            adjustable.setUnitIncrement(15);
        }
        this.choiceComponent.createComponentUI();
        this.featureListContainer.add((Component)this.choiceComponent, new ColumnConstraints(1, 1));
        this.getContentPane().remove(this.featureListContainer);
        scrollPane.add(this.featureListContainer);
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        this.retrieveFeatureInformation();
        this.refreshFeatureInformation();
        return true;
    }

    private void fillProductRequiredFeaturesList(ProductService productService, String string, Hashtable hashtable, String string2) throws ServiceException {
        Properties[] propertiesArray = productService.getRequiredFeatures(string, string2, false);
        int n = 0;
        while (n < propertiesArray.length) {
            Properties properties = propertiesArray[n];
            Boolean bl = (Boolean)productService.getProductBeanProperty(string, string2, "installed");
            boolean bl2 = bl;
            if (!bl2) {
                hashtable.put(properties.getProperty("beanId"), (Boolean)((Hashtable)properties).get("active"));
                this.fillProductRequiredFeaturesList(productService, string, hashtable, properties.getProperty("beanId"));
            }
            ++n;
        }
    }

    private int getFeatureIndex(Object object) {
        if (object != null) {
            String string = (String)object;
            int n = 0;
            while (n < this.featureNames.length) {
                if (this.featureNames[n].equals(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private int getFeatureIndex(String string) {
        if (this.features != null) {
            int n = 0;
            while (n < this.features.length) {
                if (this.features[n].getProperty("beanId").equals(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    protected void initialize() {
        super.initialize();
        this.retrieveFeatureInformation();
        this.choiceComponent = new ChoiceComponent();
        this.choiceComponent.setComponentType(2);
        this.choiceComponent.setOptions(this.featureNames);
        this.choiceComponent.setMultipleSelection(true);
        this.choiceComponent.setSelectedIndexes(this.selectedIndexes);
        this.choiceComponent.addChoiceComponentListener(this);
        this.featureListContainer = this.getPane();
        this.featureListContainer.setLayout(new ColumnLayout());
        this.featureListContainer.add(this.choiceComponent);
        this.getContentPane().add((Component)this.featureListContainer, "Center");
    }

    private boolean isProductRequiredFeature(int n, boolean bl) {
        String string = this.featureBeanIds[n];
        if (this.productRequiredFeatureList.containsKey(string)) {
            if (!bl) {
                try {
                    this.getWizard().getServices().displayUserMessage(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.updateStatus"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.requiredByProduct", new String[]{this.tempFeatureNames[n]}), 1);
                }
                catch (ServiceException serviceException) {
                    this.logEvent(this, "err", serviceException);
                }
                if (!this.selectedFeatureList.contains(new Integer(n))) {
                    this.selectedFeatureList.addElement(new Integer(n));
                }
                this.refreshSelectedFeatureIndexes();
                this.choiceComponent.setSelectedIndexes(this.selectedIndexes);
            }
            return true;
        }
        return false;
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        return true;
    }

    private void refreshFeatureInformation() {
        if (this.choiceComponent != null) {
            this.choiceComponent.setOptions(this.featureNames);
            this.choiceComponent.setMultipleSelection(true);
            this.choiceComponent.setSelectedIndexes(this.selectedIndexes);
        }
    }

    private void refreshSelectedFeatureIndexes() {
        this.selectedIndexes = new int[this.selectedFeatureList.size()];
        int n = 0;
        Enumeration enumeration = this.selectedFeatureList.elements();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            this.selectedIndexes[n++] = n2;
        }
    }

    private void retrieveFeatureInformation() {
        this.selectedFeatureList.removeAllElements();
        Properties properties = new Properties();
        ((Hashtable)properties).put("filter.condition", new Boolean(true));
        ((Hashtable)properties).put("filter.class", (class$com$installshield$product$ProductFeature != null ? class$com$installshield$product$ProductFeature : (class$com$installshield$product$ProductFeature = FeaturePanel.class$("com.installshield.product.ProductFeature"))).getName());
        try {
            Object object;
            ProductService productService = (ProductService)this.getService("productService");
            this.productRequiredFeatureList = new Hashtable();
            this.fillProductRequiredFeaturesList(productService, this.productURL, this.productRequiredFeatureList, productService.getProductTreeRoot(this.productURL));
            Enumeration enumeration = this.productRequiredFeatureList.keys();
            while (enumeration.hasMoreElements()) {
                boolean bl;
                String string = (String)enumeration.nextElement();
                object = this.productRequiredFeatureList.get(string);
                if (object == null || (bl = ((Boolean)object).booleanValue())) continue;
                this.updateFeatureActiveState(string, true);
            }
            this.features = productService.getProductBeanChildren(this.productURL, null, new String[]{"beanId", "displayName", "active"}, properties);
            this.featureNames = new String[this.features.length];
            this.tempFeatureNames = new String[this.features.length];
            this.featureBeanIds = new String[this.features.length];
            int n = 0;
            while (n < this.features.length) {
                String string;
                object = this.resolveString(this.features[n].getProperty("displayName"));
                this.tempFeatureNames[n] = object;
                this.featureBeanIds[n] = string = this.features[n].getProperty("beanId");
                String string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "featureAlreadyInstalled");
                Boolean bl = (Boolean)productService.getProductBeanProperty(this.productURL, string, "installed");
                boolean bl2 = bl;
                boolean bl3 = (Boolean)((Hashtable)this.features[n]).get("active");
                try {
                    this.featureNames[n] = bl2 ? String.valueOf(object) + " (" + string2 + ")" : String.valueOf(object) + " (" + FileUtils.formatSizeAsBytes(productService.getRequiredBytes(this.productURL, string).getTotalBytes()) + ")";
                }
                catch (ServiceException serviceException) {
                    if (serviceException.getErrorCode() == 305) {
                        this.logEvent(this, "wrn", "Feature size required is not supported by current file service implementation");
                    } else {
                        this.logEvent(this, "err", serviceException);
                    }
                    this.featureNames[n] = object;
                }
                if (bl3 && !bl2) {
                    this.selectedFeatureList.addElement(new Integer(n));
                } else if (bl3 && bl2) {
                    this.updateFeatureActiveState(string, false);
                }
                ++n;
            }
            this.refreshSelectedFeatureIndexes();
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    private void updateFeatureActiveState(String string, boolean bl) {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            productService.setProductBeanProperty(this.productURL, string, "active", new Boolean(bl));
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }
}

