/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.service.product.ProductService;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizardx.panels.ExtendedWizardPanel;
import com.installshield.wizardx.ui.TextDisplayComponent;
import java.awt.Component;
import java.util.Properties;

public class SummaryPanel
extends ExtendedWizardPanel {
    private int type = 1;
    private final String productURL = "/product.xml";
    private TextDisplayComponent textArea;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        wizardBuilderSupport.putRequiredService("productService");
    }

    protected void createUI(WizardBeanEvent wizardBeanEvent) {
        super.createUI(wizardBeanEvent);
        this.textArea.createComponentUI();
    }

    private String getSummary() {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            Properties properties = productService.getProductSummary("/product.xml", this.type, "html");
            return properties.getProperty("summary.msg");
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return String.valueOf(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "errorOccured")) + serviceException.getMessage();
        }
    }

    public int getType() {
        return this.type;
    }

    protected void initialize() {
        super.initialize();
        this.textArea = new TextDisplayComponent(this.resolveString(this.getSummary()), false);
        this.textArea.setDisplayType(1);
        this.getContentPane().add((Component)this.textArea, "Center");
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        if (this.isComponentInitialized()) {
            this.textArea.setText(this.resolveString(this.getSummary()));
        }
        return true;
    }

    private void setPanelDescription() {
        switch (this.getType()) {
            case 1: {
                this.setDescription("$L(com.installshield.product.i18n.ProductResources, SummaryPanel.preInstallDescription)");
                break;
            }
            case 2: {
                this.setDescription("$L(com.installshield.product.i18n.ProductResources, SummaryPanel.postInstallDescription)");
                break;
            }
            case 3: {
                this.setDescription("$L(com.installshield.product.i18n.ProductResources, SummaryPanel.preUninstallDescription)");
                break;
            }
            case 4: {
                this.setDescription("$L(com.installshield.product.i18n.ProductResources, SummaryPanel.postUninstallDescription)");
                break;
            }
        }
    }

    public void setType(int n) {
        this.type = n;
    }
}

