/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.service.product.ProductService;
import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.OperationRejectedException;
import com.installshield.wizard.RunnableWizardBeanState;
import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.ServiceException;

public class UninstallAction
extends WizardAction {
    private String productURL = "/product.xml";
    private OperationKey key = null;
    private WizardUI ui = null;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        wizardBuilderSupport.putRequiredService("productService");
    }

    public void cancel() throws OperationRejectedException {
        block2: {
            super.cancel();
            if (this.key == null) break block2;
            try {
                ProductService productService = (ProductService)this.getService("productService");
                productService.cancelOperation(this.key);
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        this.getState().setStatusDescription(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "UninstallAction.unInstallProduct"));
        this.ui = wizardBeanEvent.getUserInterface();
        try {
            ProductService productService = (ProductService)this.getService("productService");
            this.key = productService.uninstallProduct(this.productURL);
            while (!productService.isOperationEnded(this.key)) {
                PropertyAccessible propertyAccessible;
                RunnableWizardBeanState runnableWizardBeanState = this.getState();
                if (runnableWizardBeanState.isSuspended()) {
                    runnableWizardBeanState.setStatusDescription(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "UninstallAction.operationSuspended"));
                    propertyAccessible = runnableWizardBeanState;
                    synchronized (propertyAccessible) {
                        try {
                            runnableWizardBeanState.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.getState().update(productService.getOperationProgress(this.key));
                propertyAccessible = this;
                synchronized (propertyAccessible) {
                    try {
                        this.wait(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new Error();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }

    public void resume() {
        block2: {
            super.resume();
            if (this.key == null) break block2;
            try {
                ProductService productService = (ProductService)this.getService("productService");
                productService.resumeOperation(this.key);
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    public void suspend() throws OperationRejectedException {
        block2: {
            super.suspend();
            if (this.key == null) break block2;
            try {
                ProductService productService = (ProductService)this.getService("productService");
                productService.suspendOperation(this.key);
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
    }
}

