/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import java.util.Enumeration;
import java.util.Vector;

public class CommandLineTokenizer
implements Enumeration {
    private Enumeration tokens;

    public CommandLineTokenizer(String string) {
        this.tokens = CommandLineTokenizer.parse(string).elements();
    }

    private static int consumeToken(String string, int n, Vector vector) {
        if (n < string.length()) {
            char c;
            char c2 = string.charAt(n);
            if (c2 == '\"' || c2 == '\'') {
                c = c2;
                ++n;
            } else {
                c = '\u0000';
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            while (n < string.length() && !bl) {
                c2 = string.charAt(n++);
                if (c != '\uffffffff' && c2 == c) {
                    bl = true;
                    continue;
                }
                if (c == '\u0000' && Character.isWhitespace(c2)) {
                    bl = true;
                    continue;
                }
                if (c2 == '\\' && n < string.length()) {
                    c2 = string.charAt(n++);
                }
                stringBuffer.append(c2);
            }
            if (stringBuffer.length() > 0) {
                vector.addElement(stringBuffer.toString());
            }
        }
        return n;
    }

    public static String createSpaceDelimitedString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            String string = CommandLineTokenizer.insertDoubleSlashes(stringArray[n]);
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean hasMoreElements() {
        return this.tokens.hasMoreElements();
    }

    private static String insertDoubleSlashes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\\') {
                stringBuffer.append("\\");
            }
            stringBuffer.append(string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object nextElement() {
        return this.tokens.nextElement();
    }

    private static Vector parse(String string) {
        if (string == null) {
            return new Vector();
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < string.length()) {
            n = CommandLineTokenizer.skipws(string, n);
            n = CommandLineTokenizer.consumeToken(string, n, vector);
        }
        return vector;
    }

    private static int skipws(String string, int n) {
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }
}

