/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.jvm;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.FileUtils;
import com.installshield.util.jvm.LauncherEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class JVMFile
extends LauncherEntry
implements PropertyAccessible {
    private String fileName = "";
    private boolean fullSearch = false;
    private String home = null;
    private String displayName = null;
    private String key = null;

    public JVMFile() {
    }

    public JVMFile(String string) {
        this.setFileName(string);
    }

    public String getDisplayName() {
        if (this.displayName == null && this.fileName.length() > 0) {
            this.displayName = JVMFile.getTagValue(this.fileName, "DESC:");
        }
        return this.displayName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean getFullSearch() {
        return this.fullSearch;
    }

    public String getHome() {
        if (this.home == null && this.fileName.length() > 0) {
            this.home = JVMFile.getTagValue(this.fileName, "JVM_HOME:");
        }
        return this.home;
    }

    public InputStream getInputStream() throws IOException {
        FileReader fileReader = new FileReader(this.fileName);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(byteArrayOutputStream));
        String string = bufferedReader.readLine();
        while (string != null) {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            string = bufferedReader.readLine();
        }
        fileReader.close();
        bufferedWriter.write("SEARCH_ALL: " + (this.fullSearch ? "1" : "0"));
        bufferedWriter.newLine();
        bufferedWriter.flush();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        bufferedWriter.close();
        return byteArrayInputStream;
    }

    public String getKey() {
        return this.key;
    }

    private static String getTagValue(String string, String string2) {
        String string3 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string4 = bufferedReader.readLine();
            while (string3 == null && string4 != null) {
                if ((string4 = string4.trim()).startsWith(string2)) {
                    string3 = string4.substring(string2.length()).trim();
                }
                string4 = bufferedReader.readLine();
            }
            bufferedReader.close();
            fileInputStream.close();
            if (string3 != null && string3.startsWith("\"") && string3.endsWith("\"")) {
                string3 = string3.substring(1, string3.length() - 1);
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                int n2 = string3.indexOf("\"\"");
                while (n2 >= 0) {
                    stringBuffer.append(string3.substring(n, n2));
                    n = n2 + 1;
                    n2 = string3.indexOf("\"\"", n);
                }
                stringBuffer.append(string3.substring(n));
                string3 = stringBuffer.toString();
            }
        }
        catch (IOException iOException) {}
        return string3;
    }

    public int getType() {
        return 1;
    }

    public void setFileName(String string) {
        if (super.getName() == null) {
            super.setName(FileUtils.getName(string));
        }
        this.fileName = string;
        this.displayName = null;
        this.home = null;
    }

    public void setFullSearch(boolean bl) {
        this.fullSearch = bl;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

