/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

import com.installshield.archive.ArchiveURLStreamHandler;
import com.installshield.beans.ObjectArrayDictionary;
import com.installshield.beans.PropertiesExtendible;
import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.ClassUtils;
import com.installshield.util.FileUtils;
import com.installshield.util.LibraryLoader;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.ResponseFilesParser;
import com.installshield.util.UID;
import com.installshield.util.UserInputRequest;
import com.installshield.util.UserInputResponse;
import com.installshield.wizard.ActiveWizardTreeIterator;
import com.installshield.wizard.CommandLineBean;
import com.installshield.wizard.ConditionalWizardTreeIterator;
import com.installshield.wizard.Manifest;
import com.installshield.wizard.MultiWizardTreeIterator;
import com.installshield.wizard.StandardWizardTreeIterator;
import com.installshield.wizard.StartupBean;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanCondition;
import com.installshield.wizard.WizardBeansPropertiesMethod;
import com.installshield.wizard.WizardBuilder;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardEvent;
import com.installshield.wizard.WizardException;
import com.installshield.wizard.WizardInf;
import com.installshield.wizard.WizardListener;
import com.installshield.wizard.WizardLoader;
import com.installshield.wizard.WizardTree;
import com.installshield.wizard.WizardTreeIterator;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.StringResolverMethodDef;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.WizardServicesFactory;
import com.installshield.wizard.service.WizardServicesImpl;
import com.installshield.wizard.service.WizardServicesUI;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipFile;

public class Wizard
implements Runnable,
PropertyAccessible,
WizardServicesUI,
WizardBuilder,
PropertiesExtendible,
URLStreamHandlerFactory {
    public static final int DO_NOTHING = 0;
    public static final int SYSTEM_LOCALE_THEN_PROMPT = 1;
    public static final int SYSTEM_LOCALE_THEN_DEFAULT = 2;
    public static final int PROMPT_FOR_LOCALE = 3;
    public static final int DEFAULT_LOCALE = 4;
    public static final int EARLY_EXECUTION = 1;
    public static final int NORMAL_EXECUTION = 2;
    public static final String REMOTE_HOST_VALUE = "remote.host";
    public static final String REMOTE_PORT_VALUE = "remote.port";
    private static Wizard wizard;
    private static Thread thread;
    private static URLStreamHandler urlStreamHandler;
    public static final String ITERATOR_KEY = "iterator";
    private String id;
    private String name = "";
    private String title = "";
    private String purpose = "";
    private String listenerClassName = "com.installshield.wizard.StandardWizardListener";
    private ObjectArrayDictionary interfaces;
    private StartupBean[] startupBeans = new StartupBean[0];
    private String interfaceName = "none";
    private WizardLog log = null;
    private String availableLocales = null;
    private String defaultLocale = null;
    private int localeSelectOption = 0;
    private String[] commandLineArgs = new String[0];
    private WizardTree wizardTree = null;
    private WizardTreeIterator iterator = null;
    private WizardListener listener = null;
    private WizardInf wizardInf = new WizardInf();
    private WizardBean currentBean = null;
    private LibraryLoader libraryLoader = null;
    private WizardUI ui = null;
    private int exitCode = -1;
    private boolean finished = false;
    private boolean servicesShutdown = false;
    private String home = null;
    private ServicesDefinition servicesDef = null;
    private Vector propertyChangeListeners = new Vector();
    private WizardServicesImpl services = null;
    private Hashtable wizards = new Hashtable();
    private boolean earlyStartupBeanResult = true;
    static /* synthetic */ Class class$com$installshield$wizard$Wizard;
    static /* synthetic */ Class class$com$installshield$wizard$WizardUI;
    static /* synthetic */ Class class$com$installshield$wizard$JavaPropertiesMethod;
    static /* synthetic */ Class class$com$installshield$util$LocalizedStringResolver;
    static /* synthetic */ Class class$com$installshield$wizard$WizardTree;
    static /* synthetic */ Class class$com$installshield$wizard$i18n$WizardResources;
    static /* synthetic */ Class class$com$installshield$wizard$WizardBean;

    static {
        urlStreamHandler = null;
    }

    public Wizard() {
        this.setId(UID.createUIDAsString());
        try {
            this.interfaces = new ObjectArrayDictionary(class$com$installshield$wizard$WizardUI != null ? class$com$installshield$wizard$WizardUI : (class$com$installshield$wizard$WizardUI = Wizard.class$("com.installshield.wizard.WizardUI")), "name");
        }
        catch (IntrospectionException introspectionException) {
            throw new Error();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.addElement(propertyChangeListener);
    }

    public void addStartupBean(StartupBean startupBean) {
        if (this.startupBeans == null) {
            this.startupBeans = new StartupBean[0];
        }
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.startupBeans.length) {
            bl = startupBean.getClass() == this.startupBeans[n].getClass();
            ++n;
        }
        if (!bl) {
            StartupBean[] startupBeanArray = new StartupBean[this.startupBeans.length + 1];
            System.arraycopy(this.startupBeans, 0, startupBeanArray, 0, this.startupBeans.length);
            startupBeanArray[startupBeanArray.length - 1] = startupBean;
            this.setStartupBeans(startupBeanArray);
        }
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            if (this.wizardInf == null) {
                wizardBuilderSupport.logEvent(this, "err", "Wizard inf not set -- cannot build");
                return;
            }
            wizardBuilderSupport.putDefinition(this, class$com$installshield$wizard$Wizard != null ? class$com$installshield$wizard$Wizard : (class$com$installshield$wizard$Wizard = Wizard.class$("com.installshield.wizard.Wizard")), this.wizardInf.getWizard());
            this.buildStartupBeans(this.getStartupBeans(), wizardBuilderSupport);
            wizardBuilderSupport.putStringResolverMethod(new StringResolverMethodDef((class$com$installshield$wizard$JavaPropertiesMethod != null ? class$com$installshield$wizard$JavaPropertiesMethod : (class$com$installshield$wizard$JavaPropertiesMethod = Wizard.class$("com.installshield.wizard.JavaPropertiesMethod"))).getName(), 3));
            wizardBuilderSupport.putStringResolverMethod(new StringResolverMethodDef((class$com$installshield$util$LocalizedStringResolver != null ? class$com$installshield$util$LocalizedStringResolver : (class$com$installshield$util$LocalizedStringResolver = Wizard.class$("com.installshield.util.LocalizedStringResolver"))).getName(), 3));
            wizardBuilderSupport.putRequiredService("logService");
            wizardBuilderSupport.putRequiredService("exitCodeService");
            wizardBuilderSupport.putRequiredService("wizardInitializeService");
            wizardBuilderSupport.putRequiredService("systemUtilService");
            if (wizardBuilderSupport.isBuildCanceled()) {
                return;
            }
            try {
                this.addStartupBean((StartupBean)Class.forName("com.installshield.wizard.service.system.SystemUtilServiceInitialize").newInstance());
            }
            catch (Exception exception) {
                wizardBuilderSupport.logEvent(this, "wrn", "Cannot add SystemUtilServiceInitialize startup bean -- this may prevent locked files from being deleted during runtime");
            }
            if (wizardBuilderSupport.isBuildCanceled()) {
                return;
            }
            if (this.wizardTree == null) {
                wizardBuilderSupport.logEvent(this, "err", "Wizard tree not set -- cannot build");
                return;
            }
            wizardBuilderSupport.putDefinition(this.wizardTree, class$com$installshield$wizard$WizardTree != null ? class$com$installshield$wizard$WizardTree : (class$com$installshield$wizard$WizardTree = Wizard.class$("com.installshield.wizard.WizardTree")), this.wizardInf.getWizardTree());
            this.buildWizardTree(this.wizardTree, wizardBuilderSupport);
            WizardUI[] wizardUIArray = this.getInterfaces();
            int n = 0;
            while (n < wizardUIArray.length) {
                if (wizardBuilderSupport.isBuildCanceled()) {
                    return;
                }
                WizardUI wizardUI = wizardUIArray[n];
                if (wizardUI instanceof WizardBuilder) {
                    ((WizardBuilder)((Object)wizardUI)).build(wizardBuilderSupport);
                } else {
                    wizardBuilderSupport.logEvent(this, "wrn", "Interface " + wizardUI.getName() + " is not an archive builder -- cannot include in archive");
                }
                ++n;
            }
            if (wizardBuilderSupport.isBuildCanceled()) {
                return;
            }
            wizardBuilderSupport.putPackage("com.installshield.wizard");
            wizardBuilderSupport.putClass((class$com$installshield$wizard$i18n$WizardResources != null ? class$com$installshield$wizard$i18n$WizardResources : (class$com$installshield$wizard$i18n$WizardResources = Wizard.class$("com.installshield.wizard.i18n.WizardResources"))).getName());
            wizardBuilderSupport.putPackage("com.installshield.archive");
            wizardBuilderSupport.putPackage("com.installshield.wizard.qjml");
            wizardBuilderSupport.putPackage("com.installshield.wizard.service");
            wizardBuilderSupport.putPackage("com.installshield.util", true);
            wizardBuilderSupport.putPackage("com.installshield.qjml");
            wizardBuilderSupport.putPackage("com.installshield.beans");
            wizardBuilderSupport.putPackage("com.jxml", true);
            wizardBuilderSupport.putPackage("com.sun.xml", true);
            wizardBuilderSupport.putPackage("org.w3c.dom");
            wizardBuilderSupport.putPackage("org.xml.sax", true);
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    private void buildStartupBeans(StartupBean[] startupBeanArray, WizardBuilderSupport wizardBuilderSupport) {
        int n = 0;
        while (n < startupBeanArray.length) {
            if (wizardBuilderSupport.isBuildCanceled()) {
                return;
            }
            StartupBean startupBean = startupBeanArray[n];
            try {
                wizardBuilderSupport.putClass(startupBean.getClass().getName());
            }
            catch (IOException iOException) {
                wizardBuilderSupport.logEvent(this, "err", iOException);
            }
            startupBean.build(wizardBuilderSupport);
            ++n;
        }
    }

    private void buildWizardTree(WizardTree wizardTree, WizardBuilderSupport wizardBuilderSupport) {
        StandardWizardTreeIterator standardWizardTreeIterator = new StandardWizardTreeIterator(wizardTree);
        WizardBean wizardBean = standardWizardTreeIterator.getNext(standardWizardTreeIterator.begin());
        while (wizardBean != standardWizardTreeIterator.end()) {
            if (wizardBuilderSupport.isBuildCanceled()) {
                return;
            }
            try {
                this.putWizardBeanClasses(wizardBean, wizardBuilderSupport);
            }
            catch (IOException iOException) {
                wizardBuilderSupport.logEvent(this, "err", iOException);
            }
            wizardBean.build(wizardBuilderSupport);
            Enumeration enumeration = wizardBean.conditionNames();
            while (enumeration.hasMoreElements()) {
                WizardBeanCondition wizardBeanCondition = wizardBean.getCondition((String)enumeration.nextElement());
                try {
                    wizardBuilderSupport.putClass(wizardBeanCondition.getClass().getName());
                    wizardBeanCondition.build(wizardBuilderSupport);
                }
                catch (IOException iOException) {
                    wizardBuilderSupport.logEvent(this, "err", iOException);
                }
            }
            wizardBean = standardWizardTreeIterator.getNext(wizardBean);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    WizardTreeIterator createIterator() {
        return this.createIterator(null, false);
    }

    WizardTreeIterator createIterator(String string, boolean bl) {
        Object object;
        StandardWizardTreeIterator standardWizardTreeIterator;
        WizardTree wizardTree = this.getWizardTree();
        if (wizardTree == null) {
            throw new IllegalArgumentException("wizard must be initialized with wizard tree");
        }
        if (string == null) {
            standardWizardTreeIterator = new StandardWizardTreeIterator(wizardTree);
        } else {
            object = wizardTree.getBean(string);
            if (object == null) {
                throw new IllegalArgumentException("rootBeanId must reference a bean in the wizard tree");
            }
            standardWizardTreeIterator = new StandardWizardTreeIterator((WizardBean)object);
        }
        object = new MultiWizardTreeIterator(this, new ConditionalWizardTreeIterator(new ActiveWizardTreeIterator(standardWizardTreeIterator)));
        if (bl) {
            standardWizardTreeIterator.begin().setValue(ITERATOR_KEY, object);
            WizardBean wizardBean = standardWizardTreeIterator.getNext(standardWizardTreeIterator.begin());
            while (wizardBean != standardWizardTreeIterator.end()) {
                wizardBean.setValue(ITERATOR_KEY, object);
                wizardBean = standardWizardTreeIterator.getNext(wizardBean);
            }
            standardWizardTreeIterator.end().setValue(ITERATOR_KEY, object);
        }
        return object;
    }

    private static Locale createLocale(String string) {
        if (string == null || string.equals("")) {
            return Locale.getDefault();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        if (stringTokenizer.countTokens() >= 3) {
            return new Locale(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        if (stringTokenizer.countTokens() == 2) {
            return new Locale(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        if (stringTokenizer.countTokens() == 1) {
            return new Locale(stringTokenizer.nextToken(), "");
        }
        return null;
    }

    private static Locale[] createLocales(String string) {
        if (string == null || string.equals("")) {
            return new Locale[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Locale[] localeArray = new Locale[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            localeArray[n++] = Wizard.createLocale(stringTokenizer.nextToken());
        }
        return localeArray;
    }

    public static Manifest createManifest() {
        return new Manifest("1.0", "InstallShield", "run");
    }

    public URLStreamHandler createURLStreamHandler(String string) {
        if (string.equals("archive")) {
            if (urlStreamHandler == null) {
                urlStreamHandler = new ArchiveURLStreamHandler();
            }
            return urlStreamHandler;
        }
        return null;
    }

    private WizardListener createWizardListener() throws WizardException {
        if (this.listenerClassName != null) {
            try {
                return (WizardListener)Class.forName(this.listenerClassName).newInstance();
            }
            catch (Throwable throwable) {
                throw new WizardException(102, this.listenerClassName);
            }
        }
        return null;
    }

    public boolean executeStartupBeans(int n) throws WizardException {
        Object object;
        String[] stringArray;
        int n2;
        boolean bl = false;
        String[] stringArray2 = this.getCommandLineArgs();
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = new Vector();
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray2.length) {
            if (!stringArray2[n4].startsWith("-")) {
                this.setExitCode(1001);
                throw new WizardException(403, "Invalid command line option: " + stringArray2[n4] + " is not a valid command line option", new Integer(1001));
            }
            n2 = n4 + 1;
            while (n2 < stringArray2.length && !stringArray2[n2].startsWith("-")) {
                ++n2;
            }
            stringArray = new String[n2 - n4 + 1];
            stringArray[0] = stringArray2[n4].substring(1);
            int n5 = 1;
            while (n5 < n2 - n4) {
                stringArray[n5] = stringArray2[n4 + n5];
                ++n5;
            }
            if (stringArray[0].equals("options")) {
                Vector vector3 = ResponseFilesParser.gatherOptions(stringArray);
                int n6 = 0;
                while (n6 < vector3.size()) {
                    vector2.addElement(vector3.elementAt(n6));
                    ++n6;
                }
            } else {
                stringArray[stringArray.length - 1] = "0";
                vector.addElement(stringArray);
            }
            n4 = n2;
        }
        n2 = 0;
        while (n2 < vector2.size()) {
            vector.addElement(vector2.elementAt(n2));
            ++n2;
        }
        stringArray = new Hashtable();
        StartupBean[] startupBeanArray = this.getStartupBeans();
        int n7 = 0;
        while (n7 < startupBeanArray.length) {
            StartupBean startupBean;
            if (startupBeanArray[n7] instanceof CommandLineBean) {
                startupBean = (CommandLineBean)startupBeanArray[n7];
                object = ((CommandLineBean)startupBean).getOption().getValue();
                boolean bl2 = false;
                int n8 = 0;
                while (n8 < vector.size()) {
                    String[] stringArray3 = (String[])vector.elementAt(n8);
                    if (stringArray3[stringArray3.length - 1].equals("0") && stringArray3[0].equals(object)) {
                        if (stringArray.containsKey(object)) {
                            this.setExitCode(1001);
                            throw new WizardException(403, "Invalid command line option: " + (String)object + " cannot be used when " + stringArray.get(object) + " is also used", new Integer(1001));
                        }
                        if (bl2 && !((CommandLineBean)startupBean).isRepeatable()) {
                            this.setExitCode(1001);
                            throw new WizardException(403, "Invalid command line option: " + (String)object + " cannot be used more than once", new Integer(1001));
                        }
                        String[] stringArray4 = new String[stringArray3.length - 2];
                        System.arraycopy(stringArray3, 1, stringArray4, 0, stringArray3.length - 2);
                        try {
                            if (n == 1 && startupBean.getEarlyExecution()) {
                                bl |= ((CommandLineBean)startupBean).execute(null, stringArray4);
                                ++n3;
                            } else if (n == 2 && !startupBean.getEarlyExecution()) {
                                bl |= ((CommandLineBean)startupBean).execute(this, stringArray4);
                                ++n3;
                            }
                        }
                        catch (Throwable throwable) {
                            System.err.println("WARNING: an unhandled error occurred during the processing of command line option " + (String)object + ": " + throwable);
                        }
                        String[] stringArray5 = ((CommandLineBean)startupBean).getIllegalOptions();
                        int n9 = 0;
                        while (n9 < stringArray5.length) {
                            stringArray.put(stringArray5[n9], object);
                            ++n9;
                        }
                        stringArray3[stringArray3.length - 1] = "1";
                        bl2 = true;
                    }
                    ++n8;
                }
                if (!((CommandLineBean)startupBean).isOptional() && !bl2) {
                    this.setExitCode(1002);
                    throw new WizardException(403, "Missing required command line option: " + (String)object, new Integer(1002));
                }
            } else {
                startupBean = startupBeanArray[n7];
                try {
                    if (n == 1 && startupBean.getEarlyExecution()) {
                        startupBean.execute(null);
                    } else if (n == 2 && !startupBean.getEarlyExecution()) {
                        startupBean.execute(this);
                    }
                }
                catch (Throwable throwable) {
                    System.err.println("WARNING: an unhandled error occurred during the processing of startup bean " + startupBean.getClass().getName() + ": " + throwable);
                }
            }
            ++n7;
        }
        int n10 = 0;
        while (n10 < vector.size()) {
            object = (String[])vector.elementAt(n10);
            if (object[((String[])object).length - 1].equals("0")) {
                this.setExitCode(1001);
                throw new WizardException(403, "Invalid command line option: " + object[0] + " is not supported", new Integer(1001));
            }
            ++n10;
        }
        return n == 1 || n3 == 0 || bl;
    }

    private void executeWizardInitializeService() throws WizardException {
        block9: {
            boolean bl = false;
            try {
                bl = this.getServices().isServiceAvailable("wizardInitializeService");
            }
            catch (ServiceException serviceException) {
                this.getServices().logEvent(this, "err", serviceException);
            }
            if (bl) {
                try {
                    Service service = this.getServices().getService("wizardInitializeService");
                    Class<?> clazz = Class.forName("com.installshield.wizard.service.initialize.WizardInitializeService");
                    Method method = clazz.getMethod("wizardInitializing", new Class[0]);
                    method.invoke((Object)service, new Object[0]);
                }
                catch (ServiceException serviceException) {
                    this.getServices().logEvent(null, "err", serviceException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    ServiceException serviceException;
                    if (!(invocationTargetException.getTargetException() instanceof ServiceException) || (serviceException = (ServiceException)invocationTargetException.getTargetException()).getSeverity() != 3) break block9;
                    try {
                        this.getServices().displayUserMessage(this.getServices().resolveString(this.getTitle()), LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "Wizard.badCondition", new String[]{serviceException.getMessage()}), 1);
                    }
                    catch (ServiceException serviceException2) {
                        this.getServices().logEvent(this, "err", serviceException2);
                    }
                    throw new WizardException(403, serviceException.getMessage(), new Integer(1004));
                }
                catch (Throwable throwable) {
                    this.getServices().logEvent(this, "err", throwable);
                }
            }
        }
    }

    public void exit(int n) {
        this.exit(n, null);
    }

    public void exit(int n, String string) {
        this.exitCode = this.translateExitCode(n);
        this.shutdownServices();
        this.unloadWizardResources();
        if (string != null && string.trim().length() > 0) {
            if (n == 0) {
                System.out.println(string);
            } else {
                System.err.print(string);
            }
        }
        this.finished = true;
        Wizard wizard = this;
        synchronized (wizard) {
            this.notifyAll();
        }
    }

    private static String findWizardHome() {
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (string == null && stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            if (file.isFile()) {
                try {
                    ZipFile zipFile = new ZipFile(file);
                    if (zipFile.getEntry("com/installshield/wizard/Wizard.class") != null && zipFile.getEntry("wizard.inf") != null) {
                        string = file.getAbsolutePath();
                    }
                    zipFile.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            if (!file.isDirectory() || !new File(file, ClassUtils.getClassFileName(class$com$installshield$wizard$Wizard != null ? class$com$installshield$wizard$Wizard : Wizard.class$("com.installshield.wizard.Wizard"))).isFile() || !new File(file, "wizard.inf").isFile()) continue;
            string = file.getAbsolutePath();
        }
        return string;
    }

    public String getAvailableLocales() {
        return this.availableLocales;
    }

    public String[] getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public WizardBean getCurrentBean() {
        return this.currentBean;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    private static Locale getDefaultLocale(Wizard wizard) {
        Locale locale = Wizard.createLocale(wizard.getDefaultLocale());
        Locale[] localeArray = Wizard.createLocales(wizard.getAvailableLocales());
        switch (wizard.getLocaleSelectOption()) {
            case 3: {
                return Wizard.promptForLocale(wizard, localeArray, locale);
            }
            case 2: {
                if (Wizard.inList(Locale.getDefault(), localeArray)) {
                    return Locale.getDefault();
                }
                return locale;
            }
            case 1: {
                if (Wizard.inList(Locale.getDefault(), localeArray)) {
                    return Locale.getDefault();
                }
                return Wizard.promptForLocale(wizard, localeArray, locale);
            }
            case 4: {
                return locale;
            }
        }
        return Locale.getDefault();
    }

    public int getExitCode() {
        if (this.isServicesShutdown()) {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Wizard.getExitCode(): called after WizardServices is shutdown.");
            }
            return this.exitCode;
        }
        try {
            Service service = this.getServices().getService("exitCodeService");
            Method method = service.getClass().getMethod("getExitCode", new Class[0]);
            return (Integer)method.invoke((Object)service, new Object[0]);
        }
        catch (Exception exception) {
            return this.exitCode;
        }
    }

    public Dictionary getExtendedProperties() {
        return this.interfaces;
    }

    public Wizard getExternalWizard(String string) throws WizardException {
        Wizard wizard = (Wizard)this.wizards.get(string);
        if (wizard == null) {
            String string2 = FileUtils.createFileName(FileUtils.getParent(this.getHome()), string);
            try {
                wizard = Wizard.loadWizard(string2, new String[0]);
                wizard.setUI(this.getUI());
                WizardServices wizardServices = this.getServices().getWizardServices(string);
                if (wizardServices instanceof WizardServicesImpl) {
                    wizard.services = (WizardServicesImpl)wizardServices;
                } else {
                    ((WizardServicesImpl)this.getServices()).setWizardServices(string, wizard.getServices());
                }
                this.wizards.put(string, wizard);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable instanceof InvocationTargetException) {
                    throwable2 = ((InvocationTargetException)throwable).getTargetException();
                }
                if (System.getProperty("is.debug") != null) {
                    throwable2.printStackTrace();
                }
                throw new WizardException(404, throwable2.getMessage());
            }
        }
        return wizard;
    }

    public String getHome() {
        return this.home;
    }

    public String getId() {
        return this.id;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public WizardUI[] getInterfaces() {
        return (WizardUI[])this.interfaces.getObjects();
    }

    public synchronized WizardTreeIterator getIterator() {
        return this.iterator;
    }

    public String getListenerClassName() {
        return this.listenerClassName;
    }

    public int getLocaleSelectOption() {
        return this.localeSelectOption;
    }

    public String getName() {
        return this.name;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public URL getResource(String string) throws IOException {
        return this.getServices().getResource(string);
    }

    public WizardServices getServices() {
        if (this.isServicesShutdown()) {
            throw new IllegalStateException("WizardService have already been shutdown and cannot be utilized.");
        }
        if (this.services == null) {
            String string;
            if (this.servicesDef == null) {
                this.servicesDef = new ServicesDefinition();
            }
            if ((string = System.getProperty(REMOTE_HOST_VALUE)) != null && !string.equals("localhost")) {
                String string2 = string;
                int n = Integer.parseInt(System.getProperty(REMOTE_PORT_VALUE));
                try {
                    this.services = WizardServicesFactory.createRemoteWizardServices(this.wizardInf.getResId(), this.getHome(), this.servicesDef, this, this.log, string2, n);
                }
                catch (ServiceException serviceException) {
                    System.out.println("Could not create RemoteWizardServices for \"" + string2 + ":" + n + "\":  Defaulting to LocalWizardServices...");
                    this.services = WizardServicesFactory.createLocalWizardServices(this.wizardInf.getResId(), this.getHome(), this.servicesDef, this, this.log);
                }
            } else {
                this.services = WizardServicesFactory.createLocalWizardServices(this.wizardInf.getResId(), this.getHome(), this.servicesDef, this, this.log);
            }
        }
        return this.services;
    }

    public ServicesDefinition getServicesDefinition() {
        return this.servicesDef;
    }

    public StartupBean[] getStartupBeans() {
        return this.startupBeans;
    }

    public String getTitle() {
        return this.title;
    }

    public WizardUI getUI() {
        return this.ui;
    }

    public WizardInf getWizardInf() {
        return this.wizardInf;
    }

    public WizardListener getWizardListener() {
        return this.listener;
    }

    public WizardLog getWizardLog() {
        if (this.log == null) {
            this.setWizardLog(new WizardLog());
        }
        return this.log;
    }

    public WizardTree getWizardTree() {
        return this.wizardTree;
    }

    private static boolean inList(Locale locale, Locale[] localeArray) {
        int n = 0;
        while (n < localeArray.length) {
            if (localeArray[n].getLanguage().equals(locale.getLanguage()) && (localeArray[n].getCountry().length() <= 0 || locale.getCountry().length() <= 0 || localeArray[n].getCountry().equals(locale.getCountry()))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void initializeWizardPropertyValues(Wizard wizard) {
        wizard.setValue("wizard.id", wizard.getId());
        wizard.setValue("wizard.name", wizard.getName());
        wizard.setValue("wizard.title", wizard.getTitle());
        wizard.setValue("wizard.purpose", wizard.getPurpose());
        wizard.setValue("wizard.commandline", wizard.getCommandLineArgs());
    }

    private void initializeWizardTree(WizardTree wizardTree) {
        StandardWizardTreeIterator standardWizardTreeIterator = new StandardWizardTreeIterator(wizardTree);
        WizardBean wizardBean = standardWizardTreeIterator.getNext(standardWizardTreeIterator.begin());
        while (wizardBean != standardWizardTreeIterator.end()) {
            wizardBean.setWizard(this);
            wizardBean = standardWizardTreeIterator.getNext(wizardBean);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isServicesShutdown() {
        return this.servicesShutdown;
    }

    public static Wizard loadWizard(String string, String[] stringArray) throws WizardException {
        Wizard wizard = new WizardLoader().load(string, stringArray);
        return wizard;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        int n;
        String[] stringArray2;
        Throwable throwable2;
        block18: {
            String[] stringArray3;
            int n2 = -1;
            String string = null;
            if (stringArray.length >= 2 && stringArray[0].equals("-home")) {
                string = stringArray[1];
                stringArray = Wizard.stripHome(stringArray);
            }
            try {
                block17: {
                    try {
                        if (string == null) {
                            string = Wizard.findWizardHome();
                        }
                        if (string == null) {
                            throw new WizardException(101);
                        }
                        wizard = Wizard.loadWizard(string, stringArray);
                        wizard.executeStartupBeans(1);
                        Wizard.initializeWizardPropertyValues(wizard);
                        URL.setURLStreamHandlerFactory(wizard);
                        stringArray3 = new Thread((Runnable)wizard, "wizard.main");
                        stringArray3.start();
                        Wizard wizard = Wizard.wizard;
                        synchronized (wizard) {
                            try {
                                while (!Wizard.wizard.isFinished()) {
                                    Wizard.wizard.wait();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                throw new Error();
                            }
                        }
                        n2 = Wizard.wizard.getExitCode();
                    }
                    catch (WizardException wizardException) {
                        System.err.println("The wizard cannot continue because of the following error: " + wizardException.getMessage() + (wizardException.getData() != null ? " (" + wizardException.getData() + ")" : "") + " (" + wizardException.getErrorCode() + ")");
                        n2 = wizardException.getErrorCode();
                        if (wizard == null) break block17;
                        n2 = wizard.translateExitCode(n2);
                    }
                }
                Object var4_9 = null;
            }
            catch (Throwable throwable2) {
                Object var4_10 = null;
                stringArray2 = FileUtils.deleteTempFiles();
                n = 0;
                break block18;
            }
            stringArray3 = FileUtils.deleteTempFiles();
            int n3 = 0;
            while (true) {
                if (n3 >= stringArray3.length) {
                    System.exit(n2);
                    return;
                }
                System.err.println("WARNING: could not delete temporary file " + stringArray3[n3]);
                ++n3;
            }
        }
        while (true) {
            if (n >= stringArray2.length) {
                throw throwable2;
            }
            System.err.println("WARNING: could not delete temporary file " + stringArray2[n]);
            ++n;
        }
    }

    private void notifyPropertyChangeListeners(String string, Object object, Object object2) {
        if (this.propertyChangeListeners.size() > 0) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            int n = 0;
            while (n < this.propertyChangeListeners.size()) {
                ((PropertyChangeListener)this.propertyChangeListeners.elementAt(n)).propertyChange(propertyChangeEvent);
                ++n;
            }
        }
    }

    private static Locale promptForLocale(Wizard wizard, Locale[] localeArray, Locale locale) {
        if (wizard.getInterfaceName() != null && wizard.getInterfaces() != null) {
            WizardUI[] wizardUIArray = wizard.getInterfaces();
            int n = 0;
            while (n < wizardUIArray.length) {
                if (wizard.getInterfaceName().equals(wizardUIArray[n].getName())) {
                    WizardUI wizardUI = wizardUIArray[n];
                    return wizardUI.getDefaultLocale(localeArray, locale);
                }
                ++n;
            }
        }
        return Locale.getDefault();
    }

    private void putWizardBeanClasses(WizardBean wizardBean, WizardBuilderSupport wizardBuilderSupport) throws IOException {
        Class<?> clazz = wizardBean.getClass();
        while ((class$com$installshield$wizard$WizardBean != null ? class$com$installshield$wizard$WizardBean : Wizard.class$("com.installshield.wizard.WizardBean")).isAssignableFrom(clazz)) {
            wizardBuilderSupport.putClass(clazz.getName());
            clazz = clazz.getSuperclass();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.removeElement(propertyChangeListener);
    }

    public void run() {
        RunThread runThread = new RunThread();
        runThread.start();
        while (this.getExitCode() < 0) {
            Wizard wizard = this;
            synchronized (wizard) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new Error();
                }
            }
        }
    }

    public void setAvailableLocales(String string) {
        this.availableLocales = string;
    }

    public void setBuildtimeServices(WizardServicesImpl wizardServicesImpl) {
        this.services = wizardServicesImpl;
    }

    public void setCommandLineArgs(String[] stringArray) {
        this.commandLineArgs = stringArray;
    }

    public void setCurrentBean(WizardBean wizardBean) {
        this.currentBean = wizardBean;
    }

    public void setDefaultLocale(String string) {
        this.defaultLocale = string;
    }

    public void setExitCode(int n) {
        if (this.isServicesShutdown()) {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Wizard.setExitCode(): called after WizardServices is shutdown.");
            }
            this.exitCode = n;
        }
        try {
            Service service = this.getServices().getService("exitCodeService");
            Method method = service.getClass().getMethod("setExitCode", Integer.TYPE);
            method.invoke((Object)service, new Integer(n));
        }
        catch (Exception exception) {
            this.exitCode = n;
        }
    }

    public void setHome(String string) {
        this.home = string;
    }

    public void setId(String string) {
        if (string == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.id = string;
    }

    public void setInterfaceName(String string) {
        this.interfaceName = string;
    }

    public void setInterfaces(WizardUI[] wizardUIArray) {
        this.interfaces.setObjects(wizardUIArray);
    }

    public synchronized void setIterator(WizardTreeIterator wizardTreeIterator) {
        this.iterator = wizardTreeIterator;
    }

    public void setListenerClassName(String string) {
        this.listenerClassName = string;
    }

    public void setLocaleSelectOption(int n) {
        this.localeSelectOption = n;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = string;
    }

    public void setPurpose(String string) {
        this.purpose = string;
    }

    public void setServices(WizardServicesImpl wizardServicesImpl) {
        this.services = wizardServicesImpl;
    }

    public void setServicesDefinition(ServicesDefinition servicesDefinition) {
        this.servicesDef = servicesDefinition;
    }

    public void setStartupBeans(StartupBean[] startupBeanArray) {
        this.startupBeans = startupBeanArray;
    }

    public void setTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("title cannot be null");
        }
        String string2 = string;
        this.title = string;
        this.notifyPropertyChangeListeners("title", string2, string);
    }

    public void setUI(WizardUI wizardUI) {
        this.ui = wizardUI;
    }

    public void setValue(String string, Object object) {
        this.getServices().setValue(string, object);
    }

    public void setWizardInf(WizardInf wizardInf) {
        this.wizardInf = wizardInf;
    }

    public void setWizardListener(WizardListener wizardListener) {
        this.listener = wizardListener;
    }

    public void setWizardLog(WizardLog wizardLog) {
        this.log = wizardLog;
        String string = this.log.getLoggingContext();
        if (string == null || string.length() == 0) {
            this.log.setLoggingContext(String.valueOf(this.getName()) + "." + this.getPurpose());
        }
    }

    public void setWizardTree(WizardTree wizardTree) {
        this.wizardTree = wizardTree;
        if (this.wizardTree != null) {
            this.initializeWizardTree(this.wizardTree);
        }
    }

    private void shutdownServices() {
        if (this.services != null && !this.isServicesShutdown()) {
            this.services.shutdown();
        }
        this.servicesShutdown = true;
    }

    private static String[] stripHome(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length - 2];
        System.arraycopy(stringArray, 2, stringArray2, 0, stringArray2.length);
        return stringArray2;
    }

    private int translateExitCode(int n) {
        if (this.isServicesShutdown()) {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Wizard.translateExitCode(): called after WizardServices is shutdown.");
            }
            return n;
        }
        try {
            Service service = this.getServices().getService("exitCodeService");
            Method method = service.getClass().getMethod("getTranslatedExitCode", new Class[0]);
            if (this.getExitCode() < 0) {
                this.setExitCode(n);
            }
            return (Integer)method.invoke((Object)service, new Object[0]);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private void unloadWizardResources() {
        if (this.wizardTree != null) {
            this.wizardTree.setRoot(null);
        }
        this.wizardTree = null;
        this.iterator = null;
        this.listener = null;
        this.currentBean = null;
        this.libraryLoader = null;
        this.servicesDef = null;
        this.services = null;
        System.gc();
    }

    public UserInputResponse userInputRequested(UserInputRequest userInputRequest) throws ServiceException {
        if (this.ui == null) {
            throw new ServiceException(317);
        }
        try {
            return this.ui.userInputRequested(userInputRequest);
        }
        catch (WizardException wizardException) {
            throw new ServiceException(317, wizardException.getMessage());
        }
    }

    private class RunThread
    extends Thread {
        RunThread() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            String string;
            int n;
            block24: {
                block23: {
                    block22: {
                        n = 0;
                        string = null;
                        try {
                            try {
                                if (Wizard.this.listener == null) {
                                    Wizard.this.listener = Wizard.this.createWizardListener();
                                }
                                if (Wizard.this.wizardTree == null) {
                                    throw new WizardException(402);
                                }
                                Wizard.this.getServices().addStringResolverMethod(new WizardBeansPropertiesMethod(Wizard.this));
                                if (!Wizard.this.executeStartupBeans(2)) {
                                    Object var4_3 = null;
                                    break block22;
                                }
                                Locale locale = Wizard.getDefaultLocale(wizard);
                                if (locale == null) {
                                    wizard.exit(-1);
                                    break block23;
                                }
                                Locale.setDefault(locale);
                                if (Wizard.this.listener != null) {
                                    WizardListenerInitializer wizardListenerInitializer = new WizardListenerInitializer(Wizard.this.listener, Wizard.this);
                                    Thread thread = new Thread((Runnable)wizardListenerInitializer, "wizard.initialize");
                                    thread.start();
                                }
                                Wizard.this.iterator = Wizard.this.createIterator();
                                if (Wizard.this.listener != null) {
                                    Wizard.this.listener.wizardStarted(new WizardEvent(Wizard.this));
                                }
                                Wizard.this.executeWizardInitializeService();
                                if (Wizard.this.currentBean == null) {
                                    Wizard.this.currentBean = Wizard.this.iterator.getNext(Wizard.this.iterator.begin());
                                }
                                while (true) {
                                    if (Wizard.this.currentBean == Wizard.this.iterator.end()) {
                                        Wizard.this.currentBean = null;
                                        break block24;
                                    }
                                    if (Wizard.this.listener != null) {
                                        try {
                                            Wizard.this.listener.currentBeanChanged(new WizardEvent(Wizard.this));
                                        }
                                        catch (Throwable throwable) {
                                            System.err.println("An error occurred during wizard bean change notification:");
                                            throwable.printStackTrace();
                                        }
                                    }
                                    Wizard.this.currentBean = Wizard.this.iterator.getNext(Wizard.this.currentBean);
                                }
                            }
                            catch (WizardException wizardException) {
                                if (wizardException.getErrorCode() == 403) {
                                    n = (Integer)wizardException.getData();
                                    string = wizardException.getMessage();
                                }
                                break block24;
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                break block24;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            if (Wizard.this.listener != null) {
                                Wizard.this.listener.wizardFinished(new WizardEvent(Wizard.this));
                            }
                            Wizard.this.exit(n, string);
                            throw throwable;
                        }
                    }
                    if (Wizard.this.listener != null) {
                        Wizard.this.listener.wizardFinished(new WizardEvent(Wizard.this));
                    }
                    Wizard.this.exit(n, string);
                    return;
                }
                Object var4_4 = null;
                if (Wizard.this.listener != null) {
                    Wizard.this.listener.wizardFinished(new WizardEvent(Wizard.this));
                }
                Wizard.this.exit(n, string);
                return;
            }
            Object var4_5 = null;
            if (Wizard.this.listener != null) {
                Wizard.this.listener.wizardFinished(new WizardEvent(Wizard.this));
            }
            Wizard.this.exit(n, string);
        }
    }

    private class WizardListenerInitializer
    implements Runnable {
        private WizardListener listener;
        private Wizard wizard;

        WizardListenerInitializer(WizardListener wizardListener, Wizard wizard2) {
            this.listener = wizardListener;
            this.wizard = wizard2;
        }

        public void run() {
            this.listener.wizardInitializing(new WizardEvent(this.wizard));
        }
    }
}

