/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

import com.installshield.beans.PropertiesExtendible;
import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.ClassUtils;
import com.installshield.util.ConditionSet;
import com.installshield.util.GenericTreeNode;
import com.installshield.util.Log;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBeanCondition;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilder;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardTree;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class WizardBean
implements WizardBuilder,
PropertyAccessible,
Log,
PropertiesExtendible {
    private static int nextId = 1;
    private String beanId = "";
    private String displayName = "";
    private boolean active = true;
    private ConditionSet conditionSet = new ConditionSet();
    private Properties extendedProperties = new Properties();
    private WizardBean parent = null;
    GenericTreeNode node = new GenericTreeNode();
    WizardTree tree = null;
    private Wizard wizard = null;
    private Hashtable values = new Hashtable();

    public WizardBean() {
        this.setBeanId(WizardBean.nextBeanId());
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
    }

    public Enumeration conditionNames() {
        return this.conditionSet.names();
    }

    public boolean conditionsMet() {
        return this.conditionSet.isMet();
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
    }

    public String getBeanId() {
        return this.beanId;
    }

    public WizardBeanCondition getCondition(String string) {
        return (WizardBeanCondition)this.conditionSet.get(string);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Dictionary getExtendedProperties() {
        return this.extendedProperties;
    }

    public URL getResource(String string) throws IOException {
        if (this.wizard == null) {
            throw new IllegalStateException("wizard not initialized -- cannot call getResource");
        }
        return this.wizard.getResource(string);
    }

    protected Service getService(String string) throws ServiceException {
        if (this.wizard == null) {
            throw new IllegalStateException("services used before wizard tree is initialized");
        }
        return this.wizard.getServices().getService(string);
    }

    public WizardServices getServices() {
        if (this.wizard == null) {
            throw new IllegalStateException("wizard not initialized -- cannot call getResource");
        }
        return this.wizard.getServices();
    }

    public Object getValue(String string) {
        return this.values.get(string);
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public WizardTree getWizardTree() {
        return this.tree;
    }

    public boolean isActive() {
        return this.active;
    }

    protected boolean isEventLogged(String string) {
        if (this.wizard != null) {
            return this.wizard.getWizardLog().isEventLogged(string);
        }
        return false;
    }

    public void logEvent(Object object, String string, Object object2) {
        if (this.wizard != null) {
            this.wizard.getServices().logEvent(object, string, object2);
        } else {
            System.err.println("ERROR: log used before wizard tree is initialized: " + object2);
        }
    }

    private static String nextBeanId() {
        return "bean" + nextId++;
    }

    public void putCondition(String string, WizardBeanCondition wizardBeanCondition) {
        this.conditionSet.put(string, wizardBeanCondition);
        wizardBeanCondition.setWizardBean(this);
    }

    public void removeCondition(String string) {
        this.conditionSet.remove(string);
    }

    protected String resolveString(String string) {
        if (this.wizard == null) {
            throw new IllegalStateException("string resolver used before wizard tree is initialized");
        }
        return this.wizard.getServices().resolveString(string);
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setBeanId(String string) {
        this.beanId = string;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setValue(String string, Object object) {
        this.values.put(string, object);
    }

    public void setWizard(Wizard wizard) {
        this.wizard = wizard;
    }

    public String toString() {
        return String.valueOf(ClassUtils.createObjectDisplayName(this)) + " (" + this.getBeanId() + ")";
    }
}

