/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

import com.installshield.util.GenericTreeNode;
import com.installshield.util.OperationRejectedException;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardRoot;
import com.installshield.wizard.WizardSequence;
import java.util.Enumeration;
import java.util.Vector;

public class WizardTree {
    private WizardRoot root = new WizardRoot();

    public WizardTree() {
        this.root.setBeanId("_root");
        this.updateBean(this.root, new GenericTreeNode());
    }

    public void add(WizardSequence wizardSequence, WizardBean wizardBean) throws OperationRejectedException {
        if (wizardSequence.tree != this) {
            throw new OperationRejectedException("cannot add -- parent not in tree");
        }
        GenericTreeNode genericTreeNode = wizardSequence.node;
        genericTreeNode.addChild(this.getNode(wizardBean));
    }

    public Enumeration children(WizardBean wizardBean) {
        Vector<Object> vector = new Vector<Object>();
        GenericTreeNode genericTreeNode = this.getNode(wizardBean);
        if (genericTreeNode != null) {
            Enumeration enumeration = genericTreeNode.children();
            while (enumeration.hasMoreElements()) {
                vector.addElement(((GenericTreeNode)enumeration.nextElement()).getUserObject());
            }
        }
        return vector.elements();
    }

    public WizardBean findWizardBean(WizardBean wizardBean, String string) {
        String string2;
        if (wizardBean == null) {
            wizardBean = this.getRoot();
        }
        if ((string2 = wizardBean.getBeanId()) != null && string2.equals(string)) {
            return wizardBean;
        }
        Enumeration enumeration = this.children(wizardBean);
        while (enumeration.hasMoreElements()) {
            WizardBean wizardBean2 = this.findWizardBean((WizardBean)enumeration.nextElement(), string);
            if (wizardBean2 == null) continue;
            return wizardBean2;
        }
        return null;
    }

    public WizardBean findWizardBean(String string) {
        return this.findWizardBean(null, string);
    }

    public WizardBean getBean(String string) {
        return this.findWizardBean(this.getRoot(), string);
    }

    public WizardBean getChild(WizardSequence wizardSequence, int n) {
        return (WizardBean)((GenericTreeNode)wizardSequence.node.getChildAt(n)).getUserObject();
    }

    public int getChildCount(WizardBean wizardBean) {
        return wizardBean.node.getChildCount();
    }

    public int getChildIndex(WizardBean wizardBean) {
        GenericTreeNode genericTreeNode = (GenericTreeNode)wizardBean.node.getParent();
        int n = 0;
        while (genericTreeNode != null && n < genericTreeNode.getChildCount()) {
            if (((GenericTreeNode)genericTreeNode.getChildAt(n)).getUserObject().equals(wizardBean)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public WizardBean getFirstChild(WizardBean wizardBean) {
        GenericTreeNode genericTreeNode = wizardBean.node.getFirstChild();
        return genericTreeNode != null ? (WizardBean)genericTreeNode.getUserObject() : null;
    }

    public WizardBean getLastChild(WizardBean wizardBean) {
        GenericTreeNode genericTreeNode = wizardBean.node.getLastChild();
        return genericTreeNode != null ? (WizardBean)genericTreeNode.getUserObject() : null;
    }

    public WizardBean getNextSibling(WizardBean wizardBean) {
        GenericTreeNode genericTreeNode = wizardBean.node.getNextSibling();
        return genericTreeNode != null ? (WizardBean)genericTreeNode.getUserObject() : null;
    }

    private GenericTreeNode getNode(WizardBean wizardBean) {
        GenericTreeNode genericTreeNode = wizardBean.node;
        if (genericTreeNode == null) {
            genericTreeNode = new GenericTreeNode();
        }
        this.updateBean(wizardBean, genericTreeNode);
        return genericTreeNode;
    }

    public WizardSequence getParent(WizardBean wizardBean) {
        GenericTreeNode genericTreeNode = (GenericTreeNode)wizardBean.node.getParent();
        return genericTreeNode != null ? (WizardSequence)genericTreeNode.getUserObject() : null;
    }

    public WizardBean getPreviousSibling(WizardBean wizardBean) {
        GenericTreeNode genericTreeNode = wizardBean.node.getPreviousSibling();
        return genericTreeNode != null ? (WizardBean)genericTreeNode.getUserObject() : null;
    }

    public WizardRoot getRoot() {
        return this.root;
    }

    public void insert(WizardSequence wizardSequence, int n, WizardBean wizardBean) throws OperationRejectedException {
        if (wizardSequence.tree != this) {
            throw new OperationRejectedException("cannot insert -- parent not in tree");
        }
        GenericTreeNode genericTreeNode = wizardSequence.node;
        genericTreeNode.insertChild(this.getNode(wizardBean), n);
    }

    public void remove(WizardBean wizardBean) throws OperationRejectedException {
        this.removeImpl(wizardBean);
    }

    private void removeImpl(WizardBean wizardBean) {
        GenericTreeNode genericTreeNode = (GenericTreeNode)wizardBean.node.getParent();
        if (genericTreeNode != null) {
            genericTreeNode.removeChild(wizardBean.node);
        }
        wizardBean.node.setParent(null);
        this.updateTree(wizardBean, null);
    }

    public void setChild(WizardSequence wizardSequence, int n, WizardBean wizardBean) throws OperationRejectedException {
        GenericTreeNode genericTreeNode = wizardSequence.node;
        this.updateBean(wizardBean, (GenericTreeNode)genericTreeNode.getChildAt(n));
    }

    public void setRoot(WizardRoot wizardRoot) {
        if (this.root != null) {
            this.removeImpl(this.root);
        }
        this.root = wizardRoot;
        if (wizardRoot != null) {
            this.getNode(wizardRoot);
        }
    }

    private void updateBean(WizardBean wizardBean, GenericTreeNode genericTreeNode) {
        genericTreeNode.setUserObject(wizardBean);
        wizardBean.node = genericTreeNode;
        this.updateTree(wizardBean, this);
    }

    private void updateTree(WizardBean wizardBean, WizardTree wizardTree) {
        WizardBean wizardBean2 = this.getFirstChild(wizardBean);
        while (wizardBean2 != null) {
            this.updateTree(wizardBean2, wizardTree);
            wizardBean2 = this.getNextSibling(wizardBean2);
        }
        wizardBean.tree = wizardTree;
    }
}

