/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.FileUtils;
import com.installshield.util.FontDef;
import com.installshield.util.LocaleUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.OperationRejectedException;
import com.installshield.util.PropertyUtils;
import com.installshield.util.UserInputRequest;
import com.installshield.util.UserInputResponse;
import com.installshield.util.sort.LocaleCompare;
import com.installshield.util.sort.SortUtils;
import com.installshield.wizard.CancelableProgressRenderer;
import com.installshield.wizard.NavigatableWizardBean;
import com.installshield.wizard.RunnableWizardBean;
import com.installshield.wizard.RunnableWizardBeanEvent;
import com.installshield.wizard.RunnableWizardBeanListener;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBeanPlaceHolder;
import com.installshield.wizard.WizardBuilder;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardEvent;
import com.installshield.wizard.WizardSequence;
import com.installshield.wizard.WizardTree;
import com.installshield.wizard.WizardTreeIterator;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.awt.AWTMode;
import com.installshield.wizard.awt.AWTProgressRenderer;
import com.installshield.wizard.awt.AWTWizardBean;
import com.installshield.wizard.awt.AWTWizardUIPaneDef;
import com.installshield.wizard.awt.ButtonPanel;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.ErrorMessagePanel;
import com.installshield.wizard.awt.FlowLabel;
import com.installshield.wizard.awt.ISBranding;
import com.installshield.wizard.awt.ImagePanel;
import com.installshield.wizard.awt.InsetsPanel;
import com.installshield.wizard.awt.MessageDialog;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizard.awt.StandardAWTProgressRenderer;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;

public class AWTWizardUI
implements RunnableWizardBeanListener,
WizardUI,
WindowListener,
ActionListener,
PropertyAccessible,
WizardBuilder,
PropertyChangeListener {
    public static final int LEFT = 1;
    public static final int TOP_CENTER = 2;
    public static final int TOP_LEFT = 3;
    private String name = "awt";
    private String navigationControllerType = null;
    private String wizardImage = "";
    private String wizardImageSource = "";
    private int wizardImageOrientation = 1;
    private int width = 640;
    private int height = 420;
    private String backgroundColor = "SystemColor.window";
    private String foregroundColor = "SystemColor.windowText";
    private AWTWizardUIPaneDef layout = null;
    private boolean useCloseOnExit = true;
    private String splashImageSource = "";
    private String splashImage = "";
    private int splashDuration = 0;
    private FontDef defaultFont = new FontDef("Dialog", 0, 12);
    private String wizardIconSource = "";
    private String wizardIcon = "";
    private Wizard wizard;
    private Frame frame = null;
    private Container currentPane = null;
    private NavigationController controller;
    private boolean initialized = false;
    private boolean exitWithoutPrompting = false;
    private AWTWizardBean currentAWTBean = null;
    private WizardBeanEvent currentBeanEvent = null;
    private boolean waitingOnPanel = false;
    private AWTProgressRenderer currentProgressRenderer = null;
    private RunnableWizardBean currentRunnableWizardBean = null;
    private Vector skipped = new Vector();
    private boolean isSplashEnabled = false;
    private boolean isSplashDisplayed = false;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$com$installshield$wizard$awt$AWTProgressRenderer;

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.controller.back()) {
            this.doPrevious();
        } else if (actionEvent.getSource() == this.controller.next()) {
            this.doNext();
        } else if (actionEvent.getSource() == this.controller.cancel()) {
            this.doCancel();
        } else if (actionEvent.getSource() instanceof CancelableProgressRenderer) {
            if (this.currentRunnableWizardBean == null) {
                throw new Error();
            }
            if (this.suspendCurrentOperation()) {
                UserInputResponse userInputResponse = this.userInputRequested(this.currentRunnableWizardBean.getCancelConfirmation());
                if (this.currentRunnableWizardBean.isCancelConfirmed(userInputResponse)) {
                    try {
                        this.currentRunnableWizardBean.cancel();
                    }
                    catch (OperationRejectedException operationRejectedException) {
                        this.userInputRequested(new UserInputRequest(this.frame.getTitle(), LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AWTWizardUI.cannotCancelOperation")));
                        this.currentRunnableWizardBean.resume();
                    }
                } else {
                    this.currentRunnableWizardBean.resume();
                }
            } else {
                this.userInputRequested(new UserInputRequest(this.frame.getTitle(), LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AWTWizardUI.cannotSuspendOperation")));
            }
        }
    }

    private void addUIPane(Container container, AWTWizardUIPaneDef aWTWizardUIPaneDef, Object object) {
        Component component = this.createAWTWizardUIPane(aWTWizardUIPaneDef);
        if (component != null) {
            container.add(component, object);
            if (aWTWizardUIPaneDef.getContentType() == 0) {
                if (aWTWizardUIPaneDef.getNorth() != null) {
                    this.addUIPane((Container)component, aWTWizardUIPaneDef.getNorth(), "North");
                }
                if (aWTWizardUIPaneDef.getWest() != null) {
                    this.addUIPane((Container)component, aWTWizardUIPaneDef.getWest(), "West");
                }
                if (aWTWizardUIPaneDef.getSouth() != null) {
                    this.addUIPane((Container)component, aWTWizardUIPaneDef.getSouth(), "South");
                }
                if (aWTWizardUIPaneDef.getEast() != null) {
                    this.addUIPane((Container)component, aWTWizardUIPaneDef.getEast(), "East");
                }
                if (aWTWizardUIPaneDef.getCenter() != null) {
                    this.addUIPane((Container)component, aWTWizardUIPaneDef.getCenter(), "Center");
                }
            }
        }
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        block16: {
            try {
                Serializable serializable;
                wizardBuilderSupport.putPackage("com.installshield.wizard.awt");
                wizardBuilderSupport.getWizard().addStartupBean(new AWTMode());
                String string = null;
                if (this.wizardImageSource != null && this.wizardImageSource.trim().length() > 0) {
                    try {
                        serializable = new URL(this.wizardImageSource);
                        string = FileUtils.getName(((URL)serializable).getFile());
                        wizardBuilderSupport.putResource((URL)serializable, string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        serializable = new File(FileUtils.normalizeFileName(this.wizardImageSource));
                        if (((File)serializable).isFile()) {
                            string = ((File)serializable).getName();
                            wizardBuilderSupport.putResource(((File)serializable).getAbsolutePath(), string);
                        }
                        wizardBuilderSupport.logEvent(this, "err", "Cannot build wizard image: file does not exist or is not a valid URL");
                    }
                    if (string != null) {
                        this.setWizardImage(string);
                    }
                }
                if (this.splashImageSource != null && this.splashImageSource.trim().length() > 0) {
                    try {
                        serializable = new URL(this.splashImageSource);
                        string = FileUtils.getName(((URL)serializable).getFile());
                        wizardBuilderSupport.putResource((URL)serializable, string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        serializable = new File(FileUtils.normalizeFileName(this.splashImageSource));
                        if (((File)serializable).exists() && ((File)serializable).isFile()) {
                            string = ((File)serializable).getName();
                            wizardBuilderSupport.putResource(((File)serializable).getAbsolutePath(), string);
                        }
                        wizardBuilderSupport.logEvent(this, "err", "Cannot build splash image: file does not exist or is not a valid URL");
                    }
                    if (string != null) {
                        this.setSplashImage(string);
                    }
                }
                if (this.wizardIconSource == null || this.wizardIconSource.trim().length() <= 0) break block16;
                try {
                    serializable = new URL(this.wizardIconSource);
                    string = FileUtils.getName(((URL)serializable).getFile());
                    wizardBuilderSupport.putResource((URL)serializable, string);
                }
                catch (MalformedURLException malformedURLException) {
                    serializable = new File(FileUtils.normalizeFileName(this.wizardIconSource));
                    if (((File)serializable).isFile()) {
                        string = ((File)serializable).getName();
                        wizardBuilderSupport.putResource(((File)serializable).getAbsolutePath(), string);
                    }
                    wizardBuilderSupport.logEvent(this, "err", "Cannot build wizard icon: file does not exist or is not a valid URL");
                }
                if (string != null) {
                    this.setWizardIcon(string);
                }
            }
            catch (IOException iOException) {
                wizardBuilderSupport.logEvent(this, "err", iOException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void clearCurrent() {
        this.currentPane.removeAll();
    }

    protected boolean confirmExit() {
        String string = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "yes");
        String string2 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "no");
        boolean bl = this.suspendCurrentOperation();
        UserInputRequest userInputRequest = new UserInputRequest(this.getFrame().getTitle(), LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AWTWizardUI.wantToExit"), 2, new String[]{string, string2}, string2);
        boolean bl2 = this.userInputRequested(userInputRequest).getResponse().equals(string);
        if (bl && !bl2) {
            this.resumeCurrentOperation();
        }
        return bl2;
    }

    private Component createAWTWizardUIPane(AWTWizardUIPaneDef aWTWizardUIPaneDef) {
        if (aWTWizardUIPaneDef.getContentType() == 0) {
            return new InsetsPanel(aWTWizardUIPaneDef.decodeInsets());
        }
        if (aWTWizardUIPaneDef.getContentType() == 1) {
            return this.currentPane;
        }
        if (aWTWizardUIPaneDef.getContentType() == 2) {
            return this.controller.getComponent();
        }
        if (aWTWizardUIPaneDef.getContentType() == 4) {
            return this.createImagePane((String)aWTWizardUIPaneDef.getContent());
        }
        if (aWTWizardUIPaneDef.getContentType() == 5 && aWTWizardUIPaneDef.getContent() instanceof Component) {
            return (Component)aWTWizardUIPaneDef.getContent();
        }
        return new Panel();
    }

    private Container createImagePane(String string) {
        block3: {
            if (string == null || string.trim().length() <= 0) break block3;
            ImagePanel imagePanel = new ImagePanel();
            try {
                URL uRL = this.getWizard().getResource(string);
                Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                if (image != null) {
                    imagePanel.setImage(image);
                    return imagePanel;
                }
            }
            catch (IOException iOException) {
                System.out.println("WARNING: cannot load image URL: " + string);
            }
        }
        return null;
    }

    private NavigationController createNavigationController() {
        if (this.navigationControllerType != null && this.navigationControllerType.length() > 0) {
            try {
                return (NavigationController)Class.forName(this.navigationControllerType).newInstance();
            }
            catch (Throwable throwable) {
                System.out.println("WARNING: could not create navigation controller from class: " + this.navigationControllerType);
            }
        }
        return new DefaultNavigationController();
    }

    public synchronized boolean currentBeanChanged(WizardEvent wizardEvent) {
        WizardBean wizardBean = wizardEvent.getWizard().getCurrentBean();
        try {
            if (wizardBean instanceof WizardBeanPlaceHolder) {
                throw new Exception(((WizardBeanPlaceHolder)wizardBean).getPlaceHolderMessage());
            }
            if (wizardBean instanceof AWTWizardBean) {
                this.waitUntilInitialized();
                this.currentAWTBean = (AWTWizardBean)((Object)wizardBean);
                this.currentBeanEvent = new WizardBeanEvent(wizardEvent, this);
                if (this.currentAWTBean.queryEnter(this.currentBeanEvent)) {
                    Component component;
                    if (!this.currentAWTBean.isComponentInitialized()) {
                        this.currentAWTBean.initializeComponent(this.currentBeanEvent);
                    }
                    if ((component = this.currentAWTBean.getComponent()) != null) {
                        this.refreshButtonStates();
                        this.setCurrent(component);
                    }
                    if (!this.isNavigationControllerVisible()) {
                        this.setNavigationControllerVisible(true);
                    }
                    this.setDefaultCursor();
                    this.skipped.removeElement(this.currentAWTBean);
                    if (this.currentAWTBean.entered(this.currentBeanEvent)) {
                        this.setWaitingOnPanel(true);
                        while (this.isWaitingOnPanel()) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    } else {
                        this.skipped.addElement(this.currentAWTBean);
                    }
                } else {
                    this.skipped.addElement(this.currentAWTBean);
                }
                this.currentAWTBean = null;
                this.currentBeanEvent = null;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            this.wizard.getServices().logEvent(this, "err", throwable);
            if (!(wizardBean instanceof ErrorMessagePanel) && this.replaceCurBeanWithError(wizardEvent.getWizard(), wizardBean, throwable)) {
                return this.currentBeanChanged(wizardEvent);
            }
            this.wizard.getServices().logEvent(this, "err", "could not display error message panel -- exiting wizard");
            this.wizard.exit(1005);
            AWTWizardUI aWTWizardUI = this;
            synchronized (aWTWizardUI) {
                try {
                    this.wait(120000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            throw new Error("wizard failed to exit within timeout period");
        }
    }

    public void destroy() {
        if (this.controller != null) {
            this.controller.removeActionListener(this);
        }
        if (this.frame != null) {
            this.frame.removeWindowListener(this);
            this.frame.dispose();
        }
    }

    public void doCancel() {
        this.setWaitCursor();
        if (this.controller.getCancelType() == 2) {
            this.currentAWTBean.exited(this.currentBeanEvent);
        }
        this.getFrame().dispatchEvent(new WindowEvent(this.getFrame(), 201));
    }

    private void doCustomLayout(AWTWizardUIPaneDef aWTWizardUIPaneDef) {
        if (aWTWizardUIPaneDef.getContentType() != 0) {
            System.out.println("ERROR: layout content type must be AWTWizardUIPaneDef.LAYOUT");
            this.getFrame().removeAll();
            this.doDefaultLayout();
            return;
        }
        this.addUIPane(this.getFrame(), aWTWizardUIPaneDef, "Center");
        if (this.currentPane.getParent() == null || this.controller.getComponent().getParent() == null) {
            System.out.println("ERROR: layout must include pane defs of AWTWizardUIPaneDef.CURRENT and AWTWizardUIPaneDef.NAVIGATION content types -- ignoring custom layout");
            this.getFrame().removeAll();
            this.doDefaultLayout();
            return;
        }
    }

    private void doDefaultLayout() {
        InsetsPanel insetsPanel = new InsetsPanel(10, 10, 10, 10);
        this.getFrame().add((Component)insetsPanel, "Center");
        insetsPanel.setLayout(new BorderLayout(8, 8));
        Container container = this.createImagePane(this.getWizardImage());
        if (container != null) {
            Panel panel = new Panel();
            if (this.wizardImageOrientation == 2) {
                panel.setLayout(new FlowLayout(1));
                insetsPanel.add((Component)panel, "North");
            } else if (this.wizardImageOrientation == 3) {
                panel.setLayout(new FlowLayout(0));
                insetsPanel.add((Component)panel, "North");
            } else {
                panel.setLayout(new FlowLayout(1));
                insetsPanel.add((Component)panel, "West");
            }
            panel.add(container);
        }
        insetsPanel.add((Component)this.currentPane, "Center");
        insetsPanel.add(this.controller.getComponent(), "South");
    }

    public void doNext() {
        this.setWaitCursor();
        if (this.currentAWTBean.queryExit(this.currentBeanEvent)) {
            this.currentAWTBean.exited(this.currentBeanEvent);
            this.setWaitingOnPanel(false);
        } else {
            this.setDefaultCursor();
        }
    }

    public void doPrevious() {
        this.setWaitCursor();
        if (this.wizard == null) {
            return;
        }
        WizardTreeIterator wizardTreeIterator = this.wizard.getIterator();
        WizardBean wizardBean = wizardTreeIterator.getPrevious(this.wizard.getCurrentBean());
        while (wizardBean != wizardTreeIterator.begin() && !(wizardBean instanceof AWTWizardBean) || this.skipped.contains(wizardBean)) {
            wizardBean = wizardTreeIterator.getPrevious(wizardBean);
        }
        if (wizardBean == wizardTreeIterator.begin()) {
            this.wizard.setCurrentBean(wizardTreeIterator.getNext(wizardBean));
        } else {
            this.wizard.setCurrentBean(wizardTreeIterator.getPrevious(wizardBean));
        }
        this.setWaitingOnPanel(false);
        if (this.isStopped()) {
            this.setStopped(false);
        }
    }

    public void exit(int n) {
        if (this.exitWithoutPrompting || this.confirmExit()) {
            this.exitImpl(n);
        } else {
            this.setDefaultCursor();
        }
    }

    private void exitImpl(int n) {
        if (this.wizard != null) {
            this.wizard.exit(n);
        }
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public FontDef getDefaultFont() {
        return this.defaultFont;
    }

    public Locale getDefaultLocale(Locale[] localeArray, Locale locale) {
        class Com_installshield_wizard_awt_AWTWizardUI$1 {
            /* synthetic */ Com_installshield_wizard_awt_AWTWizardUI$1() {
            }
        }
        LocaleDialog localeDialog = new LocaleDialog(null, this.frame, localeArray, locale);
        localeDialog.setVisible(true);
        return localeDialog.getSelectedLocale();
    }

    public String getForegroundColor() {
        return this.foregroundColor;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public int getHeight() {
        return this.height;
    }

    public AWTWizardUIPaneDef getLayout() {
        return this.layout;
    }

    public String getName() {
        return this.name;
    }

    public NavigationController getNavigationController() {
        return this.controller;
    }

    public String getNavigationControllerType() {
        return this.navigationControllerType;
    }

    public int getSplashDuration() {
        return this.splashDuration;
    }

    public String getSplashImage() {
        return this.splashImage;
    }

    public String getSplashImageSource() {
        return this.splashImageSource;
    }

    public boolean getUseCloseOnExit() {
        return this.useCloseOnExit;
    }

    public int getWidth() {
        return this.width;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public String getWizardIcon() {
        return this.wizardIcon;
    }

    public String getWizardIconSource() {
        return this.wizardIconSource;
    }

    public String getWizardImage() {
        return this.wizardImage;
    }

    public int getWizardImageOrientation() {
        return this.wizardImageOrientation;
    }

    public String getWizardImageSource() {
        return this.wizardImageSource;
    }

    public void initialize(Wizard wizard) {
        Object object;
        Object object2;
        if (wizard == null) {
            throw new IllegalArgumentException("wizard cannot be null");
        }
        this.wizard = wizard;
        wizard.addPropertyChangeListener(this);
        boolean bl = this.splashImageSource != null && this.splashImageSource.trim().length() > 0;
        this.isSplashEnabled = bl & this.splashDuration > 0;
        if (this.isSplashEnabled) {
            this.isSplashDisplayed = true;
            object2 = new SplashScreenController();
            object = new Thread((Runnable)object2);
            ((Thread)object).start();
        }
        this.frame = new Frame();
        this.initializeFont(this.frame, this.defaultFont);
        this.refreshTitle();
        this.frame.addNotify();
        this.frame.setLayout(new BorderLayout());
        ((Component)this.frame).setBackground(PropertyUtils.createColor(this.getBackgroundColor(), SystemColor.window));
        this.frame.setForeground(PropertyUtils.createColor(this.getForegroundColor(), SystemColor.windowText));
        this.initializeBrowserBackground(((Component)this.frame).getBackground());
        this.setupWizardIcon(this.wizardIcon);
        this.currentPane = new InsetsPanel(0, 0, 0, 0);
        this.controller = this.createNavigationController();
        this.controller.addActionListener(this);
        this.setNavigationControllerVisible(false);
        this.layoutFrame();
        if (!this.isSplashEnabled) {
            this.currentPane.setLayout(new BorderLayout());
            object2 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AWTWizardUI.initializeWizard");
            object = new Label((String)object2, 1);
            this.currentPane.add((Component)object, "Center");
            if (this.defaultFont != null) {
                ((Component)object).setFont(new Font(this.defaultFont.getName(), 1, Math.max(14, this.defaultFont.getSize())));
            } else {
                ((Component)object).setFont(new Font("Dialog", 1, 14));
            }
        }
        ((Component)this.frame).setSize(this.width, this.height);
        this.positionFrame(this.getWizard());
        this.frame.addWindowListener(this);
        this.setInitialized(true);
        if (this.isSplashEnabled) {
            while (this.isSplashDisplayed) {
                object2 = this;
                synchronized (object2) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new Error();
                    }
                }
            }
        }
        ((Component)this.frame).setVisible(true);
    }

    private void initializeBrowserBackground(Color color) {
        try {
            Class<?> clazz = Class.forName("ice.htmlbrowser.Browser");
            Method method = clazz.getMethod("setDefaultBackground", class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = AWTWizardUI.class$("java.awt.Color")));
            method.invoke(null, color);
        }
        catch (Throwable throwable) {}
    }

    private void initializeFont(Component component, FontDef fontDef) {
        if (fontDef != null) {
            component.setFont(new Font(fontDef.getName(), fontDef.getStyle(), fontDef.getSize()));
        }
    }

    private synchronized boolean isInitialized() {
        return this.initialized;
    }

    public boolean isNavigationControllerVisible() {
        return this.controller.getComponent().isVisible();
    }

    public boolean isStopped() {
        return this.controller.next().isEnabled() ^ true;
    }

    private synchronized boolean isWaitingOnPanel() {
        return this.waitingOnPanel;
    }

    private void layoutFrame() {
        if (this.getLayout() == null) {
            this.doDefaultLayout();
        } else {
            this.doCustomLayout(this.getLayout());
        }
    }

    private void positionFrame(Wizard wizard) {
        Dimension dimension = this.frame.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this.frame).setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.wizard && propertyChangeEvent.getPropertyName().equals("title")) {
            this.refreshTitle();
        }
    }

    private void refreshButtonStates() {
        WizardBean wizardBean;
        boolean bl;
        WizardTreeIterator wizardTreeIterator = this.wizard.getIterator();
        this.exitWithoutPrompting = bl = wizardTreeIterator.getNext(wizardBean = this.wizard.getCurrentBean()) == wizardTreeIterator.end();
        this.controller.setCancelType(bl && this.useCloseOnExit ? 2 : 1);
        int n = 0;
        if (this.wizard.getCurrentBean() instanceof NavigatableWizardBean) {
            n = ((NavigatableWizardBean)((Object)wizardBean)).getNavigationOptions();
        }
        if (n == 0) {
            this.controller.next().setVisible(bl ^ true);
            this.controller.cancel().setVisible(true);
            if (!bl) {
                WizardBean wizardBean2 = wizardTreeIterator.getPrevious(wizardBean);
                while (wizardBean2 != wizardTreeIterator.begin() && !(wizardBean2 instanceof AWTWizardBean)) {
                    wizardBean2 = wizardTreeIterator.getPrevious(wizardBean2);
                }
                this.controller.back().setVisible(wizardBean2 != wizardTreeIterator.begin());
            } else {
                this.controller.back().setVisible(false);
            }
        } else {
            this.controller.back().setVisible((n & 1) != 0);
            this.controller.next().setVisible((n & 2) != 0);
            this.controller.cancel().setVisible((n & 4) != 0);
        }
    }

    private void refreshTitle() {
        this.frame.setTitle(this.wizard.getServices().resolveString(this.wizard.getTitle()));
    }

    private boolean replaceCurBeanWithError(Wizard wizard, WizardBean wizardBean, Throwable throwable) {
        WizardTree wizardTree = wizard.getWizardTree();
        WizardSequence wizardSequence = wizardTree.getParent(wizardBean);
        int n = wizardTree.getChildCount(wizardSequence);
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < n) {
            if (wizardTree.getChild(wizardSequence, n2) == wizardBean) {
                ErrorMessagePanel errorMessagePanel = new ErrorMessagePanel();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("An unhandled error occurred that has prevented ");
                stringBuffer.append("wizard bean \"");
                stringBuffer.append(wizardBean.getBeanId());
                stringBuffer.append("\" from displaying:\n\n\n\n");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
                throwable.printStackTrace(printWriter);
                stringBuffer.append(new String(byteArrayOutputStream.toByteArray()));
                errorMessagePanel.setErrorMessage(stringBuffer.toString());
                try {
                    wizardTree.setChild(wizardSequence, n2, errorMessagePanel);
                    wizard.setCurrentBean(errorMessagePanel);
                    bl = true;
                }
                catch (OperationRejectedException operationRejectedException) {}
            }
            ++n2;
        }
        return bl;
    }

    private void resumeCurrentOperation() {
        WizardBean wizardBean = this.wizard.getCurrentBean();
        if (!(wizardBean instanceof RunnableWizardBean)) {
            throw new IllegalStateException("expected current bean to be suspended");
        }
        ((RunnableWizardBean)((Object)wizardBean)).resume();
    }

    public void runnableBeanStarted(RunnableWizardBean runnableWizardBean) {
        this.currentRunnableWizardBean = runnableWizardBean;
        this.currentProgressRenderer = null;
        try {
            this.currentProgressRenderer = (AWTProgressRenderer)runnableWizardBean.getProgressRendererImpl(class$com$installshield$wizard$awt$AWTProgressRenderer != null ? class$com$installshield$wizard$awt$AWTProgressRenderer : (class$com$installshield$wizard$awt$AWTProgressRenderer = AWTWizardUI.class$("com.installshield.wizard.awt.AWTProgressRenderer")));
        }
        catch (Exception exception) {}
        if (this.currentProgressRenderer == null) {
            this.currentProgressRenderer = new StandardAWTProgressRenderer();
        }
        if (this.currentProgressRenderer instanceof CancelableProgressRenderer) {
            ((CancelableProgressRenderer)((Object)this.currentProgressRenderer)).setCancelable(runnableWizardBean.isCancelable());
            ((CancelableProgressRenderer)((Object)this.currentProgressRenderer)).addActionListener(this);
        }
        runnableWizardBean.getState().setWizardRunnableListener(this);
        this.setNavigationControllerVisible(false);
        this.setCurrent(this.currentProgressRenderer.getComponent());
        this.currentProgressRenderer.startProgress();
    }

    public void runnableBeanStopped(RunnableWizardBean runnableWizardBean) {
        if (this.currentProgressRenderer == null) {
            throw new IllegalStateException("currentProgressRenderer is null");
        }
        this.currentProgressRenderer.endProgress();
        if (this.currentProgressRenderer instanceof CancelableProgressRenderer) {
            ((CancelableProgressRenderer)((Object)this.currentProgressRenderer)).removeActionListener(this);
        }
        this.currentProgressRenderer = null;
        this.clearCurrent();
        this.currentRunnableWizardBean = null;
    }

    public void runnableWizardBeanStateChanged(RunnableWizardBeanEvent runnableWizardBeanEvent) {
        if (this.currentProgressRenderer == null) {
            throw new IllegalStateException("currentProgressRenderer is null");
        }
        this.currentProgressRenderer.updateProgress(runnableWizardBeanEvent.getBean().getState());
    }

    public void setBackgroundColor(String string) {
        this.backgroundColor = string;
    }

    private void setCurrent(Component component) {
        this.currentPane.removeAll();
        component.setVisible(false);
        this.currentPane.add(component, "Center");
        component.setVisible(true);
        this.currentPane.validate();
    }

    public void setDefaultCursor() {
        if (this.getFrame() != null && this.getFrame().getComponentCount() > 0) {
            this.getFrame().getComponent(0).setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setDefaultFont(FontDef fontDef) {
        this.defaultFont = fontDef;
    }

    public void setForegroundColor(String string) {
        this.foregroundColor = string;
    }

    public void setFrame(Frame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("frame cannot be null");
        }
        this.frame = frame;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    private synchronized void setInitialized(boolean bl) {
        this.initialized = bl;
        this.notifyAll();
    }

    public void setLayout(AWTWizardUIPaneDef aWTWizardUIPaneDef) {
        this.layout = aWTWizardUIPaneDef;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNavigationControllerType(String string) {
        this.navigationControllerType = string;
    }

    public void setNavigationControllerVisible(boolean bl) {
        this.controller.getComponent().setVisible(bl);
        if (bl) {
            this.controller.getComponent().getParent().validate();
        }
    }

    private synchronized void setSplashDisplayed(boolean bl) {
        this.isSplashDisplayed = bl;
        this.notify();
    }

    public void setSplashDuration(int n) {
        this.splashDuration = n;
    }

    public void setSplashImage(String string) {
        this.splashImage = string;
    }

    public void setSplashImageSource(String string) {
        this.splashImageSource = string;
    }

    public void setStopped(boolean bl) {
        this.controller.next().setEnabled(bl ^ true);
    }

    public void setUseCloseOnExit(boolean bl) {
        this.useCloseOnExit = bl;
    }

    public void setWaitCursor() {
        if (this.getFrame() != null && this.getFrame().getComponentCount() > 0) {
            this.getFrame().getComponent(0).setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private synchronized void setWaitingOnPanel(boolean bl) {
        this.waitingOnPanel = bl;
        this.notify();
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setWizardIcon(String string) {
        this.wizardIcon = string;
    }

    public void setWizardIconSource(String string) {
        this.wizardIconSource = string;
    }

    public void setWizardImage(String string) {
        this.wizardImage = string;
    }

    public void setWizardImageOrientation(int n) {
        this.wizardImageOrientation = n;
    }

    public void setWizardImageSource(String string) {
        this.wizardImageSource = string;
    }

    private void setupWizardIcon(String string) {
        block3: {
            if (string == null || string.trim().length() <= 0) break block3;
            try {
                URL uRL = this.getWizard().getResource(string);
                Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                if (this.frame != null && image != null) {
                    this.frame.setIconImage(image);
                }
            }
            catch (IOException iOException) {
                System.out.println("WARNING: cannot load image URL: " + string);
            }
        }
    }

    private boolean suspendCurrentOperation() {
        if (this.currentRunnableWizardBean != null) {
            try {
                this.currentRunnableWizardBean.suspend();
                return true;
            }
            catch (OperationRejectedException operationRejectedException) {
            }
        }
        return false;
    }

    public UserInputResponse userInputRequested(UserInputRequest userInputRequest) {
        if (this.initialized) {
            String[] stringArray = null;
            if (userInputRequest.getResponseOptions() != null) {
                stringArray = new String[userInputRequest.getResponseOptions().length];
                int n = 0;
                while (n < stringArray.length) {
                    String string = userInputRequest.getResponseOptions()[n].toString();
                    if (userInputRequest.getResponseOptions()[n].equals(userInputRequest.getDefaultResponse())) {
                        string = "*" + string;
                    }
                    stringArray[n] = string;
                    ++n;
                }
            }
            if (stringArray == null) {
                stringArray = new String[]{LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ok")};
            }
            MessageDialog messageDialog = new MessageDialog(this.getFrame(), userInputRequest.getPrompt(), userInputRequest.getTitle(), stringArray);
            ((Component)messageDialog).setVisible(true);
            int n = messageDialog.getResult();
            Object object = n == -1 ? userInputRequest.getDefaultResponse() : (userInputRequest.getResponseOptions() != null ? userInputRequest.getResponseOptions()[n] : stringArray[n]);
            return new UserInputResponse(object);
        }
        this.waitUntilInitialized();
        return this.userInputRequested(userInputRequest);
    }

    private void waitForWizardInitialization() {
        AWTWizardUI aWTWizardUI = this;
        synchronized (aWTWizardUI) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private synchronized void waitUntilInitialized() {
        while (!this.isInitialized()) {
            try {
                System.out.println("-----------------waiting in waitUniltInitialized ---------------------");
                Thread.currentThread();
                Thread.dumpStack();
                this.wait();
                System.out.println(String.valueOf(String.valueOf(Thread.currentThread())) + " finished waiting ");
            }
            catch (InterruptedException interruptedException) {
                throw new Error();
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.controller.getCancelType() == 2) {
            this.exit(0);
        } else {
            this.exit(1000);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public static interface NavigationController {
        public static final int CANCEL = 1;
        public static final int CLOSE = 2;

        public void addActionListener(ActionListener var1);

        public Component back();

        public Component cancel();

        public int getCancelType();

        public Component getComponent();

        public Component next();

        public void removeActionListener(ActionListener var1);

        public void setCancelType(int var1);
    }

    public class DefaultNavigationController
    extends Panel
    implements NavigationController,
    ActionListener {
        private Button back;
        private Button next;
        private Button cancel;
        private Vector listeners = new Vector();
        private int cancelType = 1;
        private final int captionWidth = 14;
        private final Insets insets = new Insets(0, 4, 4, 4);

        public DefaultNavigationController() {
            super(new BorderLayout(2, 2));
            ISBranding iSBranding = new ISBranding("InstallShield");
            this.add((Component)iSBranding, "North");
            ButtonPanel buttonPanel = new ButtonPanel(1);
            this.add((Component)buttonPanel, "Center");
            this.back = new Button(this.pad(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "back")));
            buttonPanel.addButton(this.back);
            this.back.addActionListener(this);
            this.next = new Button(this.pad(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "next")));
            buttonPanel.addButton(this.next);
            this.next.addActionListener(this);
            this.cancel = new Button();
            buttonPanel.addButton(this.cancel);
            this.refreshCancelCaption();
            this.cancel.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.notifyListeners(actionEvent);
        }

        public void addActionListener(ActionListener actionListener) {
            this.listeners.addElement(actionListener);
        }

        public Component back() {
            return this.back;
        }

        public Component cancel() {
            return this.cancel;
        }

        public int getCancelType() {
            return this.cancelType;
        }

        public Component getComponent() {
            return this;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width, (int)((double)dimension.height * 1.15));
        }

        public Component next() {
            return this.next;
        }

        private void notifyListeners(ActionEvent actionEvent) {
            int n = 0;
            while (n < this.listeners.size()) {
                ((ActionListener)this.listeners.elementAt(n)).actionPerformed(actionEvent);
                ++n;
            }
        }

        private String pad(String string) {
            int n = 14 - string.length();
            if (n > 0) {
                n /= 2;
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(' ');
                    ++n2;
                }
                stringBuffer.append(string);
                int n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(' ');
                    ++n3;
                }
                return stringBuffer.toString();
            }
            return string;
        }

        void refreshCancelCaption() {
            String string = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "cancel");
            String string2 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "finish");
            this.cancel.setLabel(this.cancelType == 1 ? this.pad(string) : this.pad(string2));
        }

        public void removeActionListener(ActionListener actionListener) {
            this.listeners.removeElement(actionListener);
        }

        public void setCancelType(int n) {
            this.cancelType = n;
            this.refreshCancelCaption();
        }
    }

    public class SplashScreenController
    implements Runnable {
        private Window splash = null;

        private void hideSplashScreen() {
            this.splash.dispose();
        }

        public void run() {
            this.showSplashScreen();
            try {
                Thread.sleep(AWTWizardUI.this.getSplashDuration() * 1000);
                if (!AWTWizardUI.this.isInitialized()) {
                    AWTWizardUI.this.waitForWizardInitialization();
                }
            }
            catch (InterruptedException interruptedException) {}
            this.hideSplashScreen();
            AWTWizardUI.this.setSplashDisplayed(false);
        }

        private void showSplashScreen() {
            Frame frame = new Frame("Splash Screen");
            URL uRL = null;
            try {
                uRL = AWTWizardUI.this.getWizard().getResource(AWTWizardUI.this.getSplashImage());
            }
            catch (IOException iOException) {
                AWTWizardUI.this.wizard.getServices().logEvent(this, "err", iOException);
            }
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            this.splash = new Window(frame);
            ImagePanel imagePanel = new ImagePanel();
            imagePanel.setImage(image);
            this.splash.add(imagePanel);
            this.splash.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.splash.getSize();
            ((Component)this.splash).setSize(dimension2);
            int n = dimension.width / 2 - dimension2.width / 2;
            int n2 = dimension.height / 2 - dimension2.height / 2;
            ((Component)this.splash).setLocation(n, n2);
            this.splash.show();
        }
    }

    private class LocaleDialog
    extends Dialog
    implements ActionListener {
        private Locale[] available;
        private Choice locales;
        private Button ok;
        private Button cancel;
        private boolean parentSet;
        private Locale selectedLocale;

        /* synthetic */ LocaleDialog(1 var2_2, Frame frame, Locale[] localeArray, Locale locale) {
            this(frame, localeArray, locale);
        }

        private LocaleDialog(Frame frame, Locale[] localeArray, Locale locale) {
            super(frame != null ? frame : new Frame(), true);
            this.available = localeArray;
            this.parentSet = frame != null;
            this.enableEvents(64L);
            this.setTitle(AWTWizardUI.this.wizard != null ? AWTWizardUI.this.wizard.getTitle() : "InstallShield Wizard");
            this.setLayout(new BorderLayout());
            InsetsPanel insetsPanel = new InsetsPanel(10, 10, 10, 10);
            this.add((Component)insetsPanel, "Center");
            insetsPanel.setLayout(new ColumnLayout(15));
            FlowLabel flowLabel = new FlowLabel();
            insetsPanel.add((Component)flowLabel, ColumnConstraints.createHorizontalFill());
            flowLabel.setText(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AWTWizardUI.selectLanguage"));
            this.locales = new Choice();
            insetsPanel.add((Component)this.locales, ColumnConstraints.createCenterAlign());
            SortUtils.qsort(localeArray, new LocaleCompare());
            int n = 0;
            int n2 = 0;
            while (n2 < localeArray.length) {
                this.locales.addItem(LocaleUtils.getLocaleDisplayName(localeArray[n2]));
                if (localeArray[n2].equals(locale)) {
                    n = n2;
                }
                ++n2;
            }
            if (this.locales.getItemCount() > 0) {
                this.locales.select(n);
            }
            insetsPanel.add(Spacing.createVerticalSpacing(3));
            Panel panel = new Panel(new GridLayout(1, 2, 10, 0));
            insetsPanel.add((Component)panel, ColumnConstraints.createCenterAlign());
            this.ok = new Button(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ok"));
            panel.add(this.ok);
            this.ok.addActionListener(this);
            this.cancel = new Button(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "cancel"));
            panel.add(this.cancel);
            this.cancel.addActionListener(this);
            this.pack();
            this.setResizable(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.selectedLocale = actionEvent.getSource() == this.ok ? (this.locales.getSelectedIndex() != -1 ? this.available[this.locales.getSelectedIndex()] : Locale.getDefault()) : null;
            this.setVisible(false);
        }

        Locale getSelectedLocale() {
            return this.selectedLocale;
        }

        protected void processWindowEvent(WindowEvent windowEvent) {
            if (windowEvent.getID() == 201) {
                this.selectedLocale = null;
                this.setVisible(false);
            }
        }

        public void setVisible(boolean bl) {
            if (bl && !this.isVisible()) {
                Point point;
                Dimension dimension;
                Dimension dimension2 = this.getSize();
                if (this.parentSet) {
                    dimension = this.getParent().getSize();
                    point = this.getParent().getLocation();
                } else {
                    dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    point = new Point(0, 0);
                }
                ((Component)this).setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
            }
            super.setVisible(bl);
        }
    }
}

