/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.product.service.registry.PureJavaRegistryServiceImpl;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;

public class Win32PPKRegistryServiceImpl
extends PureJavaRegistryServiceImpl {
    public int getSystemCompatibility() {
        int n = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                n = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public String getVPDFileName() throws ServiceException {
        FileService fileService = (FileService)this.getServices().getService("fileService");
        String string = fileService.getNamedDirectory("os_main");
        String string2 = FileUtils.appendSeparator(string);
        string2 = String.valueOf(string2) + "vpd.properties";
        return string2;
    }

    protected void initialized() {
        super.initialized();
        try {
            Win32Utils.loadDLL(this.getResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{"registryService", Win32Utils.getJNIDLLName()}));
            exception.printStackTrace();
        }
    }
}

